/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIOImage {
    protected RenderedImage image;
    protected IIOMetadata metadata;
    protected Raster raster;
    protected List<? extends BufferedImage> thumbnails;

    public IIOImage(Raster raster, List<? extends BufferedImage> thumbnails, IIOMetadata metadata) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.raster = raster;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }

    public IIOImage(RenderedImage image, List<? extends BufferedImage> thumbnails, IIOMetadata metadata) {
        if (image == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = image;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public int getNumThumbnails() {
        return this.thumbnails == null ? 0 : this.thumbnails.size();
    }

    public Raster getRaster() {
        return this.raster;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public BufferedImage getThumbnail(int index) {
        return this.thumbnails.get(index);
    }

    public List<? extends BufferedImage> getThumbnails() {
        return this.thumbnails;
    }

    public boolean hasRaster() {
        return this.raster != null;
    }

    public void setMetadata(IIOMetadata metadata) {
        this.metadata = metadata;
    }

    public void setRaster(Raster raster) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.image = null;
        this.raster = raster;
    }

    public void setRenderedImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = image;
        this.raster = null;
    }

    public void setThumbnails(List<? extends BufferedImage> thumbnails) {
        this.thumbnails = thumbnails;
    }
}

