/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private static final long serialVersionUID = 353853209832607592L;
    private static final Action[] actions = new Action[1];
    public static final String notifyAction = "notify-field-accept";
    private int columns;
    private int align;
    private Action action;
    private String actionCommand;
    private PropertyChangeListener actionPropertyChangeListener;
    private BoundedRangeModel horizontalVisibility;

    static {
        JTextField.actions[0] = new TextAction(notifyAction){

            public void actionPerformed(ActionEvent event) {
                JTextField textField = (JTextField)event.getSource();
                textField.fireActionPerformed();
            }
        };
    }

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String text) {
        this(null, text, 0);
    }

    public JTextField(int columns) {
        this(null, null, columns);
    }

    public JTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JTextField(Document doc, String text, int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.horizontalVisibility = new DefaultBoundedRangeModel();
        this.setDocument(doc == null ? this.createDefaultModel() : doc);
        if (text != null) {
            this.setText(text);
        }
        this.align = 10;
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public void setDocument(Document doc) {
        doc.putProperty("filterNewlines", Boolean.TRUE);
        super.setDocument(doc);
    }

    public String getUIClassID() {
        return "TextFieldUI";
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 0, this.actionCommand == null ? this.getText() : this.actionCommand);
        ActionListener[] listeners = this.getActionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].actionPerformed(event);
            ++index;
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public void setHorizontalAlignment(int newAlign) {
        if (this.align == newAlign) {
            return;
        }
        int oldAlign = this.align;
        this.align = newAlign;
        this.firePropertyChange("horizontalAlignment", oldAlign, newAlign);
        this.invalidate();
        this.repaint();
    }

    public void setFont(Font newFont) {
        super.setFont(newFont);
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets i = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + i.left + i.right;
        }
        return size;
    }

    public int getScrollOffset() {
        return this.horizontalVisibility.getValue();
    }

    public void setScrollOffset(int offset) {
        this.horizontalVisibility.setValue(Math.min(this.horizontalVisibility.getMaximum() - this.horizontalVisibility.getExtent(), offset));
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), actions);
    }

    public void postActionEvent() {
        String command = this.actionCommand != null ? this.actionCommand : this.getText();
        ActionEvent event = new ActionEvent(this, 0, command);
        ActionListener[] listeners = this.getActionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].actionPerformed(event);
            ++index;
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) {
        if (this.action == newAction) {
            return;
        }
        if (this.action != null) {
            this.removeActionListener(this.action);
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.actionPropertyChangeListener = null;
        }
        Action oldAction = this.action;
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(this.action);
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
        }
        this.firePropertyChange("horizontalAlignment", oldAction, newAction);
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String name = event.getPropertyName();
                if (name.equals("enabled")) {
                    boolean enabled = (Boolean)event.getNewValue();
                    JTextField.this.setEnabled(enabled);
                } else if (name.equals("ShortDescription")) {
                    JTextField.this.setToolTipText((String)event.getNewValue());
                }
            }
        };
    }

    protected void configurePropertiesFromAction(Action action) {
        if (action != null) {
            this.setEnabled(action.isEnabled());
            this.setToolTipText((String)action.getValue("ShortDescription"));
        } else {
            this.setEnabled(true);
            this.setToolTipText(null);
        }
    }

    protected int getColumnWidth() {
        FontMetrics metrics = this.getToolkit().getFontMetrics(this.getFont());
        return metrics.charWidth('m');
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.horizontalVisibility;
    }

    public boolean isValidateRoot() {
        return !(this.getParent() instanceof JViewport);
    }

    public void scrollRectToVisible(Rectangle r) {
        int v = this.horizontalVisibility.getValue();
        int e = this.horizontalVisibility.getExtent();
        Insets i = this.getInsets();
        if (r.x < i.left) {
            this.setScrollOffset(v + r.x - i.left);
        } else if (r.x > e + i.left) {
            this.setScrollOffset(r.x + v - e - i.left);
        }
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        private static final long serialVersionUID = 8255147276740453036L;

        protected AccessibleJTextField() {
            super(JTextField.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            return state;
        }
    }
}

