/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    static int SCROLL_NON_SCROLLABLES = 10;
    static int ROWS_PER_WHEEL_CLICK = 3;
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;
    ContainerListener containerListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane p) {
        this.scrollpane = p;
        LookAndFeel.installColorsAndFont(p, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(p, "ScrollPane.border");
        Border vpBorder = p.getViewportBorder();
        if (vpBorder == null || vpBorder instanceof UIResource) {
            vpBorder = UIManager.getBorder("ScrollPane.viewportBorder");
            p.setViewportBorder(vpBorder);
        }
        p.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane p) {
        LookAndFeel.uninstallBorder(p);
        Border vpBorder = p.getViewportBorder();
        if (vpBorder != null && vpBorder instanceof UIResource) {
            p.setViewportBorder(null);
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults((JScrollPane)c);
        this.installListeners((JScrollPane)c);
        this.installKeyboardActions((JScrollPane)c);
    }

    protected void installListeners(JScrollPane sp) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        sp.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        sp.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        sp.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        if (this.containerListener == null) {
            this.containerListener = new ViewportContainerListener();
        }
        JViewport v = sp.getViewport();
        v.addChangeListener(this.viewportChangeListener);
        v.addContainerListener(this.containerListener);
        int i = 0;
        while (i < v.getComponentCount()) {
            v.getComponent(i).addMouseWheelListener(this.mouseWheelListener);
            ++i;
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.put("ScrollPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("scrollLeft", new AbstractAction("scrollLeft"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getHorizontalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getBlockIncrement(-1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("scrollEnd", new AbstractAction("scrollEnd"){

            public void actionPerformed(ActionEvent event) {
                JScrollBar sb2;
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb1 = sp.getHorizontalScrollBar();
                if (sb1.isVisible()) {
                    sb1.setValue(sb1.getMaximum());
                }
                if ((sb2 = sp.getVerticalScrollBar()).isVisible()) {
                    sb2.setValue(sb2.getMaximum());
                }
            }
        });
        map.put("unitScrollUp", new AbstractAction("unitScrollUp"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getVerticalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getUnitIncrement(-1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("unitScrollLeft", new AbstractAction("unitScrollLeft"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getHorizontalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getUnitIncrement(-1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("scrollUp", new AbstractAction("scrollUp"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getVerticalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getBlockIncrement(-1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("scrollRight", new AbstractAction("scrollRight"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getHorizontalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getBlockIncrement(1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("scrollHome", new AbstractAction("scrollHome"){

            public void actionPerformed(ActionEvent event) {
                JScrollBar sb2;
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb1 = sp.getHorizontalScrollBar();
                if (sb1.isVisible()) {
                    sb1.setValue(sb1.getMinimum());
                }
                if ((sb2 = sp.getVerticalScrollBar()).isVisible()) {
                    sb2.setValue(sb2.getMinimum());
                }
            }
        });
        map.put("scrollDown", new AbstractAction("scrollDown"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getVerticalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getBlockIncrement(1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("unitScrollDown", new AbstractAction("unitScrollDown"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getVerticalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getUnitIncrement(1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        map.put("unitScrollRight", new AbstractAction("unitScrollRight"){

            public void actionPerformed(ActionEvent event) {
                JScrollPane sp = (JScrollPane)event.getSource();
                JScrollBar sb = sp.getHorizontalScrollBar();
                if (sb.isVisible()) {
                    int delta = sb.getUnitIncrement(1);
                    sb.setValue(sb.getValue() + delta);
                }
            }
        });
        return map;
    }

    protected void installKeyboardActions(JScrollPane sp) {
        InputMap keyMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(sp, 1, keyMap);
        ActionMap map = this.getActionMap();
        SwingUtilities.replaceUIActionMap(sp, map);
    }

    protected void uninstallKeyboardActions(JScrollPane sp) {
        SwingUtilities.replaceUIActionMap(sp, null);
        SwingUtilities.replaceUIInputMap(sp, 1, null);
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults((JScrollPane)c);
        this.uninstallListeners(c);
        this.installKeyboardActions((JScrollPane)c);
    }

    protected void uninstallListeners(JComponent c) {
        JScrollPane sp = (JScrollPane)c;
        sp.removePropertyChangeListener(this.spPropertyChangeListener);
        sp.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        sp.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        JViewport v = sp.getViewport();
        v.removeChangeListener(this.viewportChangeListener);
        v.removeContainerListener(this.containerListener);
        int i = 0;
        while (i < v.getComponentCount()) {
            v.getComponent(i).removeMouseWheelListener(this.mouseWheelListener);
            ++i;
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        JScrollPane p = (JScrollPane)c;
        ScrollPaneLayout sl = (ScrollPaneLayout)p.getLayout();
        return sl.minimumLayoutSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        Border vpBorder = this.scrollpane.getViewportBorder();
        if (vpBorder != null) {
            Rectangle r = this.scrollpane.getViewportBorderBounds();
            vpBorder.paintBorder(this.scrollpane, g, r.x, r.y, r.width, r.height);
        }
    }

    protected void syncScrollPaneWithViewport() {
        JViewport vp = this.scrollpane.getViewport();
        if (vp != null) {
            JViewport colHeader;
            JViewport rowHeader;
            JScrollBar hsb;
            Dimension extentSize = vp.getExtentSize();
            Point viewPos = vp.getViewPosition();
            Dimension viewSize = vp.getViewSize();
            JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
            if (vsb != null) {
                int extent = extentSize.height;
                int max = viewSize.height;
                int val = Math.max(0, Math.min(viewPos.y, max - extent));
                vsb.setValues(val, extent, 0, max);
            }
            if ((hsb = this.scrollpane.getHorizontalScrollBar()) != null) {
                int extent = extentSize.width;
                int max = viewSize.width;
                int val = Math.max(0, Math.min(viewPos.x, max - extent));
                hsb.setValues(val, extent, 0, max);
            }
            if ((rowHeader = this.scrollpane.getRowHeader()) != null) {
                Point p = new Point(0, viewPos.y);
                rowHeader.setViewPosition(p);
            }
            if ((colHeader = this.scrollpane.getColumnHeader()) != null) {
                Point p = new Point(viewPos.x, 0);
                colHeader.setViewPosition(p);
            }
        }
    }

    protected void updateColumnHeader(PropertyChangeEvent ev) {
    }

    protected void updateRowHeader(PropertyChangeEvent ev) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent ev) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void updateViewport(PropertyChangeEvent ev) {
        JViewport oldViewport = (JViewport)ev.getOldValue();
        oldViewport.removeChangeListener(this.viewportChangeListener);
        JViewport newViewport = (JViewport)ev.getNewValue();
        newViewport.addChangeListener(this.viewportChangeListener);
        this.syncScrollPaneWithViewport();
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JScrollBar hsb = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point viewPosition = vp.getViewPosition();
            viewPosition.x = hsb.getValue();
            vp.setViewPosition(viewPosition);
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        final Rectangle rect = new Rectangle();

        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar scrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                if (scrollBar == null || !scrollBar.isVisible()) {
                    scrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                }
                if (scrollBar != null && scrollBar.isVisible()) {
                    int direction = e.getWheelRotation() < 0 ? -1 : 1;
                    int scrollType = e.getScrollType();
                    if (scrollType == 0) {
                        BasicScrollBarUI.scrollByUnits(scrollBar, direction, e.getScrollAmount());
                    } else if (scrollType == 1) {
                        BasicScrollBarUI.scrollByBlock(scrollBar, direction);
                    }
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if (propName.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(e);
            } else if (propName.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(e);
            } else if (propName.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(e);
            } else if (propName.equals("horizontalScrollBarPolicy") || e.getPropertyName().equals("verticalScrollBarPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propName.equals("verticalScrollBar")) {
                JScrollBar oldSb = (JScrollBar)e.getOldValue();
                oldSb.getModel().removeChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
                JScrollBar newSb = (JScrollBar)e.getNewValue();
                newSb.getModel().addChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
            } else if (propName.equals("horizontalScrollBar")) {
                JScrollBar oldSb = (JScrollBar)e.getOldValue();
                oldSb.getModel().removeChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
                JScrollBar newSb = (JScrollBar)e.getNewValue();
                newSb.getModel().addChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
            }
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JScrollBar vsb = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            JViewport vp = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point viewPosition = vp.getViewPosition();
            viewPosition.y = vsb.getValue();
            vp.setViewPosition(viewPosition);
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    class ViewportContainerListener
    implements ContainerListener {
        ViewportContainerListener() {
        }

        public void componentAdded(ContainerEvent e) {
            e.getChild().addMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }

        public void componentRemoved(ContainerEvent e) {
            e.getChild().removeMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }
    }
}

