/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.lang.CPStringBuilder;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow = -1;
    private transient HashSet<TreePath> selectedPaths;
    private transient HashSet<TreePath> tmpPaths;

    public DefaultTreeSelectionModel() {
        this.setSelectionMode(4);
        this.listSelectionModel = new DefaultListSelectionModel();
        this.listenerList = new EventListenerList();
        this.leadIndex = -1;
        this.tmpPaths = new HashSet();
        this.selectedPaths = new HashSet();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel cloned = (DefaultTreeSelectionModel)super.clone();
        cloned.changeSupport = null;
        cloned.selection = (TreePath[])this.selection.clone();
        cloned.listenerList = new EventListenerList();
        cloned.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        cloned.selectedPaths = new HashSet();
        cloned.tmpPaths = new HashSet();
        return cloned;
    }

    public String toString() {
        if (this.isSelectionEmpty()) {
            return "[selection empty]";
        }
        CPStringBuilder b = new CPStringBuilder("selected rows: [");
        int i = 0;
        while (i < this.selection.length) {
            b.append(this.getRow(this.selection[i]));
            b.append(' ');
            ++i;
        }
        b.append(", lead " + this.getLeadSelectionRow());
        return b.toString();
    }

    private void writeObject(ObjectOutputStream value0) throws IOException {
    }

    private void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setRowMapper(RowMapper mapper) {
        this.rowMapper = mapper;
        this.resetRowSelection();
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (oldMode != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, oldMode, this.selectionMode);
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        TreePath[] paths = null;
        if (path != null) {
            paths = new TreePath[]{path};
        }
        this.setSelectionPaths(paths);
    }

    int getRow(TreePath path) {
        RowMapper mapper = this.getRowMapper();
        if (mapper instanceof AbstractLayoutCache) {
            AbstractLayoutCache ama = (AbstractLayoutCache)mapper;
            return ama.getRowForPath(path);
        }
        if (mapper != null) {
            int[] rows = mapper.getRowsForPaths(new TreePath[]{path});
            if (rows.length == 0) {
                return -1;
            }
            return rows[0];
        }
        return -1;
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        int oldLength = 0;
        if (this.selection != null) {
            oldLength = this.selection.length;
        }
        int newLength = 0;
        if (paths != null) {
            newLength = paths.length;
        }
        if (newLength > 0 || oldLength > 0) {
            if (this.selectionMode == 1 && newLength > 1 || this.selectionMode == 2 && newLength > 0 && !this.arePathsContiguous(paths)) {
                paths = new TreePath[]{paths[0]};
                newLength = 1;
            }
            Vector<PathPlaceHolder> changedPaths = null;
            this.tmpPaths.clear();
            int validPaths = 0;
            TreePath oldLeadPath = this.leadPath;
            int i = 0;
            while (i < newLength) {
                if (paths[i] != null && !this.tmpPaths.contains(paths[i])) {
                    ++validPaths;
                    this.tmpPaths.add(paths[i]);
                    if (!this.selectedPaths.contains(paths[i])) {
                        if (changedPaths == null) {
                            changedPaths = new Vector();
                        }
                        changedPaths.add(new PathPlaceHolder(paths[i], true));
                    }
                    this.leadPath = paths[i];
                }
                ++i;
            }
            TreePath[] newSelection = null;
            if (validPaths != 0) {
                if (validPaths != newLength) {
                    newSelection = new TreePath[validPaths];
                    Iterator<TreePath> newPaths = this.tmpPaths.iterator();
                    validPaths = 0;
                    int i2 = 0;
                    while (newPaths.hasNext()) {
                        newSelection[i2] = newPaths.next();
                        ++i2;
                    }
                } else {
                    newSelection = new TreePath[paths.length];
                    System.arraycopy(paths, 0, newSelection, 0, paths.length);
                }
            }
            int i3 = 0;
            while (i3 < oldLength) {
                if (this.selection[i3] != null && !this.tmpPaths.contains(this.selection[i3])) {
                    if (changedPaths == null) {
                        changedPaths = new Vector<PathPlaceHolder>();
                    }
                    changedPaths.add(new PathPlaceHolder(this.selection[i3], false));
                }
                ++i3;
            }
            this.selection = newSelection;
            HashSet<TreePath> tmp = this.selectedPaths;
            this.selectedPaths = this.tmpPaths;
            this.tmpPaths = tmp;
            this.tmpPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (changedPaths != null && changedPaths.size() > 0) {
                this.notifyPathChange(changedPaths, oldLeadPath);
            }
        }
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (path != null) {
            TreePath[] add = new TreePath[]{path};
            this.addSelectionPaths(add);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        int length;
        int n = length = paths != null ? paths.length : 0;
        if (length > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(paths);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(paths)) {
                if (this.arePathsContiguous(paths)) {
                    this.setSelectionPaths(paths);
                } else {
                    this.setSelectionPaths(new TreePath[]{paths[0]});
                }
            } else {
                Vector<PathPlaceHolder> changedPaths = null;
                this.tmpPaths.clear();
                int validPaths = 0;
                TreePath oldLeadPath = this.leadPath;
                int oldPaths = 0;
                if (this.selection != null) {
                    oldPaths = this.selection.length;
                }
                int i = 0;
                while (i < length) {
                    if (paths[i] != null) {
                        if (!this.selectedPaths.contains(paths[i])) {
                            ++validPaths;
                            if (changedPaths == null) {
                                changedPaths = new Vector<PathPlaceHolder>();
                            }
                            changedPaths.add(new PathPlaceHolder(paths[i], true));
                            this.selectedPaths.add(paths[i]);
                            this.tmpPaths.add(paths[i]);
                        }
                        this.leadPath = paths[i];
                    }
                    ++i;
                }
                if (validPaths > 0) {
                    TreePath[] newSelection = new TreePath[oldPaths + validPaths];
                    if (oldPaths > 0) {
                        System.arraycopy(this.selection, 0, newSelection, 0, oldPaths);
                    }
                    if (validPaths != paths.length) {
                        Iterator<TreePath> newPaths = this.tmpPaths.iterator();
                        i = oldPaths;
                        while (newPaths.hasNext()) {
                            newSelection[i] = newPaths.next();
                            ++i;
                        }
                    } else {
                        System.arraycopy(paths, 0, newSelection, oldPaths, validPaths);
                    }
                    this.selection = newSelection;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    if (changedPaths != null && changedPaths.size() > 0) {
                        this.notifyPathChange(changedPaths, oldLeadPath);
                    }
                } else {
                    this.leadPath = oldLeadPath;
                }
                this.tmpPaths.clear();
            }
        }
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (path != null) {
            this.removeSelectionPaths(new TreePath[]{path});
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (paths != null && this.selection != null && paths.length > 0) {
            if (!this.canPathsBeRemoved(paths)) {
                this.clearSelection();
            } else {
                Vector<PathPlaceHolder> pathsToRemove = null;
                int i = paths.length - 1;
                while (i >= 0) {
                    if (paths[i] != null && this.selectedPaths.contains(paths[i])) {
                        if (pathsToRemove == null) {
                            pathsToRemove = new Vector<PathPlaceHolder>();
                        }
                        this.selectedPaths.remove(paths[i]);
                        pathsToRemove.add(new PathPlaceHolder(paths[i], false));
                    }
                    --i;
                }
                if (pathsToRemove != null) {
                    int numRemove = pathsToRemove.size();
                    TreePath oldLead = this.leadPath;
                    if (numRemove == this.selection.length) {
                        this.selection = null;
                    } else {
                        this.selection = new TreePath[this.selection.length - numRemove];
                        Iterator<TreePath> keep = this.selectedPaths.iterator();
                        int valid = 0;
                        while (keep.hasNext()) {
                            this.selection[valid] = keep.next();
                            ++valid;
                        }
                    }
                    this.leadPath = this.leadPath != null && !this.selectedPaths.contains(this.leadPath) ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(pathsToRemove, oldLead);
                }
            }
        }
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    @Override
    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        if (this.selection == null) {
            return false;
        }
        int i = 0;
        while (i < this.selection.length) {
            if (this.selection[i].equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null || this.selection.length == 0;
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            int selectionLength = this.selection.length;
            boolean[] news = new boolean[selectionLength];
            Arrays.fill(news, false);
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, this.selection, news, this.leadPath, null);
            this.leadPath = null;
            this.leadIndex = 0;
            this.leadRow = 0;
            this.selectedPaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(event);
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.listenerList.add(TreeSelectionListener.class, listener);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.listenerList.remove(TreeSelectionListener.class, listener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent event) {
        TreeSelectionListener[] listeners = this.getTreeSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(event);
            ++i;
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public int[] getSelectionRows() {
        int[] rows = null;
        if (this.rowMapper != null && this.selection != null && (rows = this.rowMapper.getRowsForPaths(this.selection)) != null) {
            int invisible = 0;
            int i = rows.length - 1;
            while (i >= 0) {
                if (rows[i] == -1) {
                    ++invisible;
                }
                --i;
            }
            if (invisible > 0) {
                if (invisible == rows.length) {
                    rows = null;
                } else {
                    int[] newRows = new int[rows.length - invisible];
                    int visCount = 0;
                    int i2 = rows.length - 1;
                    while (i2 >= 0) {
                        if (rows[i2] != -1) {
                            newRows[visCount] = rows[i2];
                            ++visCount;
                        }
                        --i2;
                    }
                    rows = newRows;
                }
            }
        }
        return rows;
    }

    @Override
    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.listSelectionModel.isSelectedIndex(row);
    }

    @Override
    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            TreePath[] tmp;
            int[] rows = this.rowMapper.getRowsForPaths(this.selection);
            int i = 0;
            while (i < rows.length) {
                int row = rows[i];
                if (row != -1) {
                    this.listSelectionModel.addSelectionInterval(row, row);
                }
                ++i;
            }
            this.leadRow = this.leadIndex != -1 && rows != null ? rows[this.leadIndex] : (this.leadPath != null ? ((rows = this.rowMapper.getRowsForPaths(tmp = new TreePath[]{this.leadPath})) != null ? rows[0] : -1) : -1);
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    @Override
    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeListener[] listeners = null;
        listeners = this.changeSupport != null ? this.changeSupport.getPropertyChangeListeners() : new PropertyChangeListener[]{};
        return listeners;
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            int min = this.listSelectionModel.getMinSelectionIndex();
            if (min != -1) {
                int max = this.listSelectionModel.getMaxSelectionIndex();
                int i = min;
                while (i <= max) {
                    if (!this.listSelectionModel.isSelectedIndex(i)) {
                        if (i != min) {
                            TreePath[] newSelection = new TreePath[i - min];
                            int[] rows = this.rowMapper.getRowsForPaths(this.selection);
                            int j = 0;
                            while (j < rows.length) {
                                if (rows[j] < i) {
                                    newSelection[rows[j] - min] = this.selection[j];
                                }
                                ++j;
                            }
                            this.setSelectionPaths(newSelection);
                            break;
                        }
                        this.clearSelection();
                    }
                    ++i;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] paths) {
        if (this.rowMapper == null || paths.length < 2) {
            return true;
        }
        int length = paths.length;
        TreePath[] tmp = new TreePath[]{paths[0]};
        int min = this.rowMapper.getRowsForPaths(tmp)[0];
        BitSet selected = new BitSet();
        int valid = 0;
        int i = 0;
        while (i < length) {
            if (paths[i] != null) {
                tmp[0] = paths[i];
                int[] rows = this.rowMapper.getRowsForPaths(tmp);
                if (rows == null) {
                    return false;
                }
                int row = rows[0];
                if (row == -1 || row < min - length || row > min + length) {
                    return false;
                }
                min = Math.min(min, row);
                if (!selected.get(row)) {
                    selected.set(row);
                    ++valid;
                }
            }
            ++i;
        }
        int max = valid + min;
        int i2 = min;
        while (i2 < max) {
            if (!selected.get(i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] paths) {
        int i;
        if (paths == null || paths.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet selected = new BitSet();
        int min = this.listSelectionModel.getMinSelectionIndex();
        int max = this.listSelectionModel.getMaxSelectionIndex();
        TreePath[] tmp = new TreePath[1];
        if (min != -1) {
            i = min;
            while (i <= max) {
                selected.set(i);
                ++i;
            }
        } else {
            tmp[0] = paths[0];
            max = min = this.rowMapper.getRowsForPaths(tmp)[0];
        }
        i = paths.length - 1;
        while (i >= 0) {
            if (paths[i] != null) {
                tmp[0] = paths[i];
                int[] rows = this.rowMapper.getRowsForPaths(tmp);
                if (rows == null) {
                    return false;
                }
                int row = rows[0];
                if (row == -1) {
                    return false;
                }
                min = Math.min(min, row);
                max = Math.max(max, row);
                selected.set(row);
            }
            --i;
        }
        i = min;
        while (i <= max) {
            if (!selected.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] paths) {
        if (this.rowMapper == null || this.isSelectionEmpty() || this.selectionMode == 4) {
            return true;
        }
        HashSet<TreePath> set = new HashSet<TreePath>();
        int i = 0;
        while (i < this.selection.length) {
            set.add(this.selection[i]);
            ++i;
        }
        i = 0;
        while (i < paths.length) {
            set.remove(paths[i]);
            ++i;
        }
        TreePath[] remaining = new TreePath[set.size()];
        Iterator iter = set.iterator();
        int i2 = 0;
        while (i2 < remaining.length) {
            remaining[i2] = (TreePath)iter.next();
            ++i2;
        }
        return this.arePathsContiguous(remaining);
    }

    protected void notifyPathChange(Vector<PathPlaceHolder> vPaths, TreePath oldLeadSelection) {
        int numChangedPaths = vPaths.size();
        boolean[] news = new boolean[numChangedPaths];
        TreePath[] paths = new TreePath[numChangedPaths];
        int i = 0;
        while (i < numChangedPaths) {
            PathPlaceHolder p = vPaths.get(i);
            news[i] = p.isNew;
            paths[i] = p.path;
            ++i;
        }
        TreeSelectionEvent event = new TreeSelectionEvent((Object)this, paths, news, oldLeadSelection, this.leadPath);
        this.fireValueChanged(event);
    }

    protected void updateLeadIndex() {
        this.leadIndex = -1;
        if (this.leadPath != null) {
            this.leadRow = -1;
            if (this.selection == null) {
                this.leadPath = null;
            } else {
                int i = this.selection.length - 1;
                while (i >= 0 && this.leadIndex == -1) {
                    if (this.selection[i] == this.leadPath) {
                        this.leadIndex = i;
                    }
                    --i;
                }
            }
        }
    }

    protected void insureUniqueness() {
    }

    private static class PathPlaceHolder {
        TreePath path;
        boolean isNew;

        PathPlaceHolder(TreePath p, boolean n) {
            this.path = p;
            this.isNew = n;
        }
    }
}

