/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Extension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionList
implements Builder,
Iterable<Extension> {
    private final ByteBuffer buffer;
    private int modCount;

    public ExtensionList(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.modCount = 0;
    }

    public ExtensionList(List<Extension> extensions) {
        int length = 2;
        for (Extension extension : extensions) {
            length += extension.length();
        }
        this.buffer = ByteBuffer.allocate(length);
        this.buffer.putShort((short)(length - 2));
        for (Extension extension : extensions) {
            this.buffer.put(extension.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public Extension get(int index) {
        int length = this.length();
        int n = 0;
        int i = 2;
        while (i < length && n < index) {
            int l = this.buffer.getShort(i + 2) & 0xFFFF;
            i += l + 4;
            ++n;
        }
        if (n < index) {
            throw new IndexOutOfBoundsException("no elemenet at " + index);
        }
        int el = this.buffer.getShort(i + 2) & 0xFFFF;
        ByteBuffer b = (ByteBuffer)this.buffer.duplicate().position(i).limit(i + el + 4);
        return new Extension(b.slice());
    }

    public int size() {
        int length = this.length();
        if (length == 0) {
            return 0;
        }
        int n = 0;
        int i = 2;
        while (i < length) {
            int len = this.buffer.getShort(i + 2) & 0xFFFF;
            i += len + 4;
            ++n;
        }
        return n;
    }

    @Override
    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public void set(int index, Extension e) {
        int length = this.length();
        int n = 0;
        int i = 2;
        while (i < length && n < index) {
            int len = this.buffer.getShort(i + 2) & 0xFFFF;
            i += len + 4;
            ++n;
        }
        if (n < index) {
            throw new IllegalArgumentException("nothing set at index " + (index - 1) + " or insufficient space");
        }
        if (i + e.length() + 2 > length) {
            throw new IllegalArgumentException("adding this element will exceed the list length");
        }
        this.buffer.putShort(i, (short)e.type().getValue());
        this.buffer.putShort(i + 2, (short)e.length());
        ((ByteBuffer)this.buffer.duplicate().position(i + 4)).put(e.valueBuffer());
        ++this.modCount;
    }

    public void set(int index, Extension.Type t, int eLength) {
        int length = this.length();
        int n = 0;
        int i = 2;
        while (i < length && n < index) {
            int len = this.buffer.getShort(i + 2) & 0xFFFF;
            i += len + 4;
            ++n;
        }
        if (n < index) {
            throw new IllegalArgumentException("nothing set at index " + (index - 1) + " or insufficient space");
        }
        if (i + eLength + 2 > length) {
            throw new IllegalArgumentException("adding this element will exceed the list length");
        }
        this.buffer.putShort(i, (short)t.getValue());
        this.buffer.putShort(i + 2, (short)eLength);
        ++this.modCount;
    }

    public void setLength(int newLength) {
        if (newLength < 0 || newLength > 65535) {
            throw new IllegalArgumentException("invalid length");
        }
        this.buffer.putShort(0, (short)newLength);
        ++this.modCount;
    }

    @Override
    public Iterator<Extension> iterator() {
        return new ExtensionsIterator();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("ExtensionList {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  length = ");
        out.print(this.length());
        out.println(";");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        for (Extension e : this) {
            out.println(e.toString(subprefix));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("};");
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExtensionsIterator
    implements ListIterator<Extension> {
        private final int modCount;
        private int index;
        private final int size;

        public ExtensionsIterator() {
            this.modCount = ExtensionList.this.modCount;
            this.index = 0;
            this.size = ExtensionList.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Extension next() throws NoSuchElementException {
            if (this.modCount != ExtensionList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ExtensionList.this.get(this.index++);
        }

        @Override
        public Extension previous() throws NoSuchElementException {
            if (this.modCount != ExtensionList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ExtensionList.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return this.index;
        }

        @Override
        public int previousIndex() {
            if (this.hasPrevious()) {
                return this.index - 1;
            }
            return -1;
        }

        @Override
        public void add(Extension e) {
            throw new UnsupportedOperationException("cannot add items to this iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from this iterator");
        }

        @Override
        public void set(Extension e) {
            ExtensionList.this.set(this.index, e);
        }
    }
}

