/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.CairoSurfaceGraphics;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;

public class ComponentGraphicsCopy
extends CairoSurfaceGraphics {
    private GtkComponentPeer component;
    private GtkImage gtkimage;
    private int width;
    private int height;

    native void getPixbuf(GtkComponentPeer var1, GtkImage var2);

    native void copyPixbuf(GtkComponentPeer var1, GtkImage var2, int var3, int var4, int var5, int var6);

    public ComponentGraphicsCopy(int width, int height, GtkComponentPeer component) {
        super(new CairoSurface(width, height));
        this.component = component;
        this.width = width;
        this.height = height;
        this.gtkimage = this.surface.getGtkImage();
        this.getPixbuf(component, this.gtkimage);
    }

    public void draw(Shape s) {
        super.draw(s);
        Rectangle r = s.getBounds();
        this.copyPixbuf(this.component, this.gtkimage, r.x, r.y, r.width, r.height);
    }

    public void fill(Shape s) {
        super.fill(s);
        Rectangle r = s.getBounds();
        this.copyPixbuf(this.component, this.gtkimage, r.x, r.y, r.width, r.height);
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        super.drawRenderedImage(image, xform);
        this.copyPixbuf(this.component, this.gtkimage, 0, 0, this.width, this.height);
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        boolean rv = super.drawImage(img, xform, bgcolor, obs);
        this.copyPixbuf(this.component, this.gtkimage, 0, 0, this.width, this.height);
        return rv;
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        super.drawGlyphVector(gv, x, y);
        Rectangle r = gv.getPixelBounds(this.getFontRenderContext(), x, y);
        this.copyPixbuf(this.component, this.gtkimage, r.x, r.y, r.width, r.height);
    }
}

