/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.IIOInputStream;
import gnu.javax.imageio.png.PNGFile;
import gnu.javax.imageio.png.PNGImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class PNGImageReader
extends ImageReader {
    private PNGFile pngFile;
    private BufferedImage image;
    private ArrayList imageTypes;

    public PNGImageReader(PNGImageReaderSpi spi) {
        super(spi);
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        return this.image.getHeight();
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        return this.image.getWidth();
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        if (this.imageTypes == null) {
            this.imageTypes = new ArrayList();
            this.imageTypes.add(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
        }
        return this.imageTypes.iterator();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        return this.image;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (!(input instanceof InputStream) && !(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream");
        }
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private void checkIndex(int index) {
        if (index > 0) {
            throw new IndexOutOfBoundsException("Image index out of bounds");
        }
    }

    private void readImage() throws IOException {
        if (this.pngFile == null) {
            if (this.input instanceof InputStream) {
                this.pngFile = new PNGFile((InputStream)this.input);
            } else if (this.input instanceof ImageInputStream) {
                this.pngFile = new PNGFile(new IIOInputStream((ImageInputStream)this.input));
            } else assert (false) : "Must not happen";
        }
        if (this.pngFile != null && this.image == null) {
            this.image = this.pngFile.getBufferedImage();
        }
    }
}

