/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.CPStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Float
extends Number
implements Comparable<Float> {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class<Float> TYPE = VMClassLoader.getPrimitiveClass('F');
    public static final int SIZE = 32;
    private static final Float ZERO = new Float(0.0f);
    private static final Float ONE = new Float(1.0f);
    private final float value;

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) {
        this.value = Float.parseFloat(s);
    }

    public static String toString(float f) {
        return VMFloat.toString(f);
    }

    public static String toHexString(float f) {
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-Infinity" : "Infinity";
        }
        int bits = Float.floatToIntBits(f);
        CPStringBuilder result = new CPStringBuilder();
        if (bits < 0) {
            result.append('-');
        }
        result.append("0x");
        int mantMask = 0x7FFFFF;
        int mantissa = bits & mantMask;
        int expMask = 255;
        int exponent = bits >>> 23 & expMask;
        result.append(exponent == 0 ? (char)'0' : '1');
        result.append('.');
        result.append(Integer.toHexString(mantissa <<= 1));
        if (exponent == 0 && mantissa != 0) {
            int offset = 4 + (bits < 0 ? 1 : 0);
            int desiredLength = offset + 6;
            while (result.length() < desiredLength) {
                result.insert(offset, '0');
            }
        }
        result.append('p');
        if (exponent != 0 || mantissa != 0) {
            boolean denormal = exponent == 0;
            exponent -= 127;
            if (denormal) {
                ++exponent;
            }
        }
        result.append(Integer.toString(exponent));
        return result.toString();
    }

    public static Float valueOf(String s) {
        return Float.valueOf(Float.parseFloat(s));
    }

    public static Float valueOf(float val) {
        if ((double)val == 0.0 && Float.floatToRawIntBits(val) == 0) {
            return ZERO;
        }
        if ((double)val == 1.0) {
            return ONE;
        }
        return new Float(val);
    }

    public static float parseFloat(String str) {
        return VMFloat.parseFloat(str);
    }

    public static boolean isNaN(float v) {
        return v != v;
    }

    public static boolean isInfinite(float v) {
        return v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Float) {
            float f = ((Float)obj).value;
            return Float.floatToRawIntBits(this.value) == Float.floatToRawIntBits(f) || Float.isNaN(this.value) && Float.isNaN(f);
        }
        return false;
    }

    public static int floatToIntBits(float value) {
        if (Float.isNaN(value)) {
            return 2143289344;
        }
        return VMFloat.floatToRawIntBits(value);
    }

    public static int floatToRawIntBits(float value) {
        return VMFloat.floatToRawIntBits(value);
    }

    public static float intBitsToFloat(int bits) {
        return VMFloat.intBitsToFloat(bits);
    }

    @Override
    public int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public static int compare(float x, float y) {
        int iy;
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        int ix = Float.floatToRawIntBits(x);
        if (ix == (iy = Float.floatToRawIntBits(y))) {
            return 0;
        }
        if (x != x) {
            return y != y ? 0 : 1;
        }
        if (y != y) {
            return -1;
        }
        return ix < iy ? -1 : 1;
    }
}

