//-< CONFIG.H >------------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     21-Jan-2004  K.A. Knizhnik  * / [] \ *
//                          Last update: 21-Jan-2004  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// GigaBASE configuration definitions
//-------------------------------------------------------------------*--------*

#ifndef __CONFIG_H__
#define __CONFIG_H__

#if (defined(_WIN32) || defined(_WINCE)) && (!defined(_CRT_SECURE_NO_DEPRECATE))
#define _CRT_SECURE_NO_DEPRECATE true
#endif

#ifdef USE_CONFDEFS
// Use configuration file generated by configure script
#include "confdefs.h"
#else

// USE_LOCALE_SETTINGS - use C locale for string comparison operations
#ifndef _WIN32_WCE
#define USE_LOCALE_SETTINGS 1
#endif

// GIGABASE_DEBUG - debug level
//    - DEBUG_NONE - disable any checking and tracing (except asserts)
//    - DEBUG_CHECK - disable trace message
//    - DEBUG_TRACE - enable trace messages 
//#define GIGABASE_DEBUG DEBUG_TRACE

// USE_NAMESPACES - place GigaBASE classes in separate namespace  
//#define USE_NAMESPACES 1


// SECURE_SERVER - enable authentication for remote logins: keep user/password table, 
//   check password for remote logins
//#define SECURE_SERVER 1

// USE_QUEUE_MANAGER - use queue manager for internal HTTP server. 
//   This manager will manage pool of threads assigned for client connections. 
//   Otherwise all requests will be executed sequnetially in the main loop.
//#define USE_QUEUE_MANAGER 1


// GIGABASE_DLL - create gigabase.dll
//#define GIGABASE_DLL 1


// THROW_EXCEPTION_ON_ERROR - throw C++ exception in case of database error instead of abort()
#ifndef _WINCE
#define THROW_EXCEPTION_ON_ERROR 1
#endif

//UNICODE - use wide character strings
//#define UNICODE 1

#if defined(_UNICODE) && !defined(UNICODE) && !defined(__SYMBIAN32__)
#define UNICODE
#endif


//USE_STD_STRING - accept std::string class as table field type
//#if (defined(_WIN32) && !defined(__SYMBIAN32__)) || defined(__linux__)
#if !defined(USE_STD_STRING)
#define USE_STD_STRING 1
#endif

//AUTOINCREMENT_SUPPORT - support autoincrement fields 
//  (database built with this flag will be incompatible with database built without it)
#define AUTOINCREMENT_SUPPORT 1

//CLONE_IDENTIFIERS - do not storef addresses of string constants in symbol table.
//  This option is needed if DLL library using GigaBASE can be unloaded.
//#define CLONE_IDENTIFIERS 1 

// RECTANGLE_DIMENSION - dimension of built-in rectangle type
#define RECTANGLE_DIMENSION 2

// RECTANGLE_COORDINATE_TYPE - type of rectanlge's coordinates
#define RECTANGLE_COORDINATE_TYPE int
//#define RECTANGLE_COORDINATE_TYPE double

// RECTANGLE_AREA_TYPE - type of rectanlge's area
#define RECTANGLE_AREA_TYPE db_int8
//#define RECTANGLE_AREA_TYPE double

//SET_NULL_DACL - use NULL DACL security descriptor for all synchronization objects.
//#define SET_NULL_DACL 1

//INT8_IS_DEFINED - int8 type is defined at your system, in this case you should use db_int8 type instead
//#define INT8_IS_DEFINED 1

//USE_MFC - use MFC (include "afx.h" instead of "windows.h")
//#define USE_MFC 1

//USE_ATL - use Microsoft ATL 
//#define USE_ATL 1

//USE_MFC_STRING - accept MVC CString class as table field type
//#define USE_MFC_STRING


// LARGE_DATABASE_SUPPORT - support databases with size larger than 4Gb.
// If this macro is defined GigaBASE maximal database size is limited by 1 terrabyte.
// Defnining this macro increase iniitial database size and object index size (because
// 64-bit offsetss are used instead fo 4-byte offsets). Also GigaBASE library compiled with 
// LARGE_DATABASE_SUPPOR will not be able to work with database created by library
// built without LARGE_DATABASE_SUPPOR and visa versa. 
#define LARGE_DATABASE_SUPPORT 

// dbDatabaseOidBits number of bits used to represent object identifier. 
// So the number of objects in database is limited by 2**dbDatabaseOidBits.
// Default value of this parameter is 32, so maximal number of objects is limited by 2**32.
// The value of this parameter is used to estimate size of bitmap, so do not assign unnecessarily 
// large values (for example 64)
//#define dbDatabaseOidBits 33

// SPARSE_FILE_OPTIMIZATION use optimization of sparse files at Windows. In a sparse file, 
// large ranges of zeroes may not require disk allocation. Space for nonzero data will be allocated 
// as needed as the file is written.
//#define SPARSE_FILE_OPTIMIZATION true

// ALIGN_HEADER - align each field of dbHeader class on its page boundary
// to make it possible to transfer file between systems with different alignment 
// strategies.
//#define ALIGN_HEADER true

// USE_REGEX - use regex library. When this macro is defined GigaBASE provides
// MATCH command. GNU regex or compatible library and headers should be available.
//#define USE_REGEX true

// SOCK_LINGER - set SO_LINGER option. Value of SO_LINGER is specified using LINGER_TIME
// #define SOCK_LINGER 1


// Use reentrant version of localtime
#if !defined(HAVE_LOCALTIME_R)
#if !defined(__APPLE__) && !defined(_WIN32)
#define HAVE_LOCALTIME_R 1
#else
#define HAVE_LOCALTIME_R 0
#endif
#endif

// Use reentrant version of localtime
#if !defined(__APPLE__) && !defined(_WIN32) && !defined(_AIX) && !defined(HAVE_GETHOSTBYNAME_R) && !defined(__NetBSD__) && !defined(VXWORKS)
#define HAVE_GETHOSTBYNAME_R
#endif

// DO_NOT_REUSE_OID_WITHIN_SESSION - do not reuse OID of deallocated objects in the current session
//#define DO_NOT_REUSE_OID_WITHIN_SESSION true

// Profile query execution
//#define PROFILE

//
// Support increment raw level backup
//
#define INCREMENTAL_BACKUP 1

#endif

#endif
