/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

public class FFT {
    protected static void bitreverse(double[] dArray) {
        int n = dArray.length / 2;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = n3 << 1;
            int n6 = n4 << 1;
            int n7 = n >> 1;
            if (n3 < n4) {
                double d = dArray[n5];
                double d2 = dArray[n5 + 1];
                dArray[n5] = dArray[n6];
                dArray[n5 + 1] = dArray[n6 + 1];
                dArray[n6] = d;
                dArray[n6 + 1] = d2;
            }
            while (n7 <= n4) {
                n4 -= n7;
                n7 >>= 1;
            }
            n4 += n7;
            ++n3;
        }
    }

    public static void inverse(double[] dArray) {
        FFT.transform_internal(dArray, 1);
        int n = dArray.length;
        int n2 = n / 2;
        double d = 1.0 / (double)n2;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] * d;
        }
    }

    protected static int log2(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            n3 *= 2;
            ++n2;
        }
        if (n != 1 << n2) {
            throw new Error("FFT: Data length is not a power of 2!: " + n);
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            n = 1024;
            System.out.println("n=" + n + " => RMS Error=" + FFT.test(FFT.makeRandom(n)));
        }
        n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            System.out.println("n=" + n2 + " => RMS Error=" + FFT.test(FFT.makeRandom(n2)));
            ++n;
        }
    }

    public static double[] makeRandom(int n) {
        int n2 = 2 * n;
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = Math.random();
            ++n3;
        }
        return dArray;
    }

    public static final double num_flops(int n) {
        double d = n;
        double d2 = FFT.log2(n);
        return (5.0 * d - 2.0) * d2 + 2.0 * (d + 1.0);
    }

    public static double test(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        FFT.transform(dArray);
        FFT.inverse(dArray);
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray[n2] - dArray2[n2];
            d += d2 * d2;
            ++n2;
        }
        return Math.sqrt(d / (double)n);
    }

    public static void transform(double[] dArray) {
        FFT.transform_internal(dArray, -1);
    }

    protected static void transform_internal(double[] dArray, int n) {
        if (dArray.length == 0) {
            return;
        }
        int n2 = dArray.length / 2;
        if (n2 == 1) {
            return;
        }
        int n3 = FFT.log2(n2);
        FFT.bitreverse(dArray);
        int n4 = 0;
        int n5 = 1;
        while (n4 < n3) {
            int n6;
            double d = 1.0;
            double d2 = 0.0;
            double d3 = 2.0 * (double)n * Math.PI / (2.0 * (double)n5);
            double d4 = Math.sin(d3);
            double d5 = Math.sin(d3 / 2.0);
            double d6 = 2.0 * d5 * d5;
            int n7 = 0;
            while (n7 < n2) {
                n6 = 2 * n7;
                int n8 = 2 * (n7 + n5);
                double d7 = dArray[n8];
                double d8 = dArray[n8 + 1];
                dArray[n8] = dArray[n6] - d7;
                dArray[n8 + 1] = dArray[n6 + 1] - d8;
                int n9 = n6;
                dArray[n9] = dArray[n9] + d7;
                int n10 = n6 + 1;
                dArray[n10] = dArray[n10] + d8;
                n7 += 2 * n5;
            }
            n6 = 1;
            while (n6 < n5) {
                double d9 = d - d4 * d2 - d6 * d;
                double d10 = d2 + d4 * d - d6 * d2;
                d = d9;
                d2 = d10;
                int n11 = 0;
                while (n11 < n2) {
                    int n12 = 2 * (n11 + n6);
                    int n13 = 2 * (n11 + n6 + n5);
                    double d11 = dArray[n13];
                    double d12 = dArray[n13 + 1];
                    double d13 = d * d11 - d2 * d12;
                    double d14 = d * d12 + d2 * d11;
                    dArray[n13] = dArray[n12] - d13;
                    dArray[n13 + 1] = dArray[n12 + 1] - d14;
                    int n14 = n12;
                    dArray[n14] = dArray[n14] + d13;
                    int n15 = n12 + 1;
                    dArray[n15] = dArray[n15] + d14;
                    n11 += 2 * n5;
                }
                ++n6;
            }
            ++n4;
            n5 *= 2;
        }
    }
}

