// Copyright 2011-, Aon Cyber Solutions. All Rights Reserved.

#ifndef LIGHTGREP_C_ENCODINGS_H_
#define LIGHTGREP_C_ENCODINGS_H_

#include "util.h"

#ifdef __cplusplus
extern "C" {
#endif

static const LG_TRANS LG_ENCODINGS[] = {
  { "037",                                           115 },
  { "1006",                                          107 },
  { "1025",                                          133 },
  { "1026",                                          134 },
  { "1047",                                          135 },
  { "1089",                                           13 },
  { "1097",                                          136 },
  { "1098",                                          108 },
  { "1112",                                          137 },
  { "1122",                                          138 },
  { "1123",                                          139 },
  { "1124",                                          109 },
  { "1383",                                           38 },
  { "273",                                           116 },
  { "277",                                           117 },
  { "278",                                           118 },
  { "280",                                           119 },
  { "284",                                           120 },
  { "285",                                           121 },
  { "297",                                           123 },
  { "33722",                                          28 },
  { "420",                                           124 },
  { "424",                                           125 },
  { "437",                                            52 },
  { "500",                                           126 },
  { "5601",                                           44 },
  { "646",                                             7 },
  { "737",                                            54 },
  { "775",                                            55 },
  { "813",                                            15 },
  { "819",                                             6 },
  { "838",                                           128 },
  { "850",                                            56 },
  { "851",                                            57 },
  { "852",                                            58 },
  { "855",                                            59 },
  { "856",                                            60 },
  { "857",                                            61 },
  { "860",                                            63 },
  { "861",                                            64 },
  { "862",                                            65 },
  { "863",                                            66 },
  { "865",                                            68 },
  { "866",                                            69 },
  { "868",                                            71 },
  { "869",                                            72 },
  { "871",                                           130 },
  { "875",                                           131 },
  { "8859_1",                                          6 },
  { "8859_13",                                        21 },
  { "8859_15",                                        23 },
  { "8859_2",                                          9 },
  { "8859_3",                                         10 },
  { "8859_4",                                         11 },
  { "8859_5",                                         12 },
  { "8859_6",                                         13 },
  { "8859_7",                                         14 },
  { "8859_8",                                         16 },
  { "8859_9",                                         18 },
  { "912",                                             9 },
  { "913",                                            10 },
  { "914",                                            11 },
  { "915",                                            12 },
  { "916",                                            17 },
  { "920",                                            18 },
  { "921",                                            21 },
  { "922",                                            76 },
  { "923",                                            23 },
  { "943",                                            26 },
  { "949",                                            42 },
  { "950",                                            33 },
  { "964",                                            41 },
  { "970",                                            44 },
  { "ANSI1251",                                       80 },
  { "ANSI_X3.4-1968",                                  7 },
  { "ANSI_X3.4-1986",                                  7 },
  { "ASCII",                                           7 },
  { "ASMO-708",                                       13 },
  { "Adobe-Standard-Encoding",                       106 },
  { "Big5",                                           32 },
  { "Big5-HKSCS",                                     34 },
  { "CCSID00858",                                     62 },
  { "CCSID01140",                                    144 },
  { "CCSID01141",                                    145 },
  { "CCSID01142",                                    146 },
  { "CCSID01143",                                    147 },
  { "CCSID01144",                                    148 },
  { "CCSID01145",                                    149 },
  { "CCSID01146",                                    150 },
  { "CCSID01147",                                    151 },
  { "CCSID01148",                                    152 },
  { "CCSID01149",                                    153 },
  { "CESU-8",                                          5 },
  { "CP00858",                                        62 },
  { "CP01140",                                       144 },
  { "CP01141",                                       145 },
  { "CP01142",                                       146 },
  { "CP01143",                                       147 },
  { "CP01144",                                       148 },
  { "CP01145",                                       149 },
  { "CP01146",                                       150 },
  { "CP01147",                                       151 },
  { "CP01148",                                       152 },
  { "CP01149",                                       153 },
  { "CP1026",                                        134 },
  { "CP273",                                         116 },
  { "CP280",                                         119 },
  { "CP284",                                         120 },
  { "CP285",                                         121 },
  { "CP500",                                         126 },
  { "CP868",                                          71 },
  { "CP870",                                         129 },
  { "CP871",                                         130 },
  { "CP918",                                         132 },
  { "CP936",                                          37 },
  { "DOS-720",                                        53 },
  { "DOS-862",                                        65 },
  { "EBCDIC-CP-DK",                                  117 },
  { "EBCDIC-CP-NO",                                  117 },
  { "EBCDIC-JP-kana",                                122 },
  { "ECMA-114",                                       13 },
  { "ECMA-118",                                       14 },
  { "ECMA-128",                                       18 },
  { "ELOT_928",                                       14 },
  { "EUC-CN",                                         38 },
  { "EUC-JP",                                         30 },
  { "EUC-KR",                                         44 },
  { "EUC-TW",                                         40 },
  { "Extended_UNIX_Code_Packed_Format_for_Japanese",  30 },
  { "GB18030",                                         8 },
  { "GB2312",                                         38 },
  { "GB2312.1980-0",                                  39 },
  { "GBK",                                            37 },
  { "GB_2312-80",                                     39 },
  { "GSM0338",                                       114 },
  { "HKSCS-BIG5",                                     34 },
  { "IBM-943C",                                       25 },
  { "IBM-949C",                                       43 },
  { "IBM-Thai",                                      128 },
  { "IBM-eucJP",                                      27 },
  { "IBM00858",                                       62 },
  { "IBM01140",                                      144 },
  { "IBM01141",                                      145 },
  { "IBM01142",                                      146 },
  { "IBM01143",                                      147 },
  { "IBM01144",                                      148 },
  { "IBM01145",                                      149 },
  { "IBM01146",                                      150 },
  { "IBM01147",                                      151 },
  { "IBM01148",                                      152 },
  { "IBM01149",                                      153 },
  { "IBM037",                                        115 },
  { "IBM1006",                                       107 },
  { "IBM1026",                                       134 },
  { "IBM1047",                                       135 },
  { "IBM1047_LF",                                    170 },
  { "IBM1098",                                       108 },
  { "IBM1141_LF",                                    172 },
  { "IBM1153",                                       154 },
  { "IBM273",                                        116 },
  { "IBM277",                                        117 },
  { "IBM278",                                        118 },
  { "IBM280",                                        119 },
  { "IBM284",                                        120 },
  { "IBM285",                                        121 },
  { "IBM290",                                        122 },
  { "IBM297",                                        123 },
  { "IBM367",                                          7 },
  { "IBM420",                                        124 },
  { "IBM424",                                        125 },
  { "IBM437",                                         52 },
  { "IBM500",                                        126 },
  { "IBM737",                                         54 },
  { "IBM775",                                         55 },
  { "IBM819",                                          6 },
  { "IBM838",                                        128 },
  { "IBM850",                                         56 },
  { "IBM851",                                         57 },
  { "IBM852",                                         58 },
  { "IBM855",                                         59 },
  { "IBM856",                                         60 },
  { "IBM857",                                         61 },
  { "IBM860",                                         63 },
  { "IBM861",                                         64 },
  { "IBM862",                                         65 },
  { "IBM863",                                         66 },
  { "IBM864",                                         67 },
  { "IBM865",                                         68 },
  { "IBM866",                                         69 },
  { "IBM868",                                         71 },
  { "IBM869",                                         72 },
  { "IBM870",                                        129 },
  { "IBM871",                                        130 },
  { "IBM875",                                        131 },
  { "IBM918",                                        132 },
  { "IBM922",                                         76 },
  { "ISO-8859-1",                                      6 },
  { "ISO-8859-10",                                    19 },
  { "ISO-8859-11",                                    20 },
  { "ISO-8859-13",                                    21 },
  { "ISO-8859-14",                                    22 },
  { "ISO-8859-15",                                    23 },
  { "ISO-8859-2",                                      9 },
  { "ISO-8859-3",                                     10 },
  { "ISO-8859-4",                                     11 },
  { "ISO-8859-5",                                     12 },
  { "ISO-8859-6",                                     13 },
  { "ISO-8859-6-E",                                   13 },
  { "ISO-8859-6-I",                                   13 },
  { "ISO-8859-7",                                     14 },
  { "ISO-8859-8",                                     16 },
  { "ISO-8859-8-E",                                   16 },
  { "ISO-8859-8-I",                                   16 },
  { "ISO-8859-9",                                     18 },
  { "ISO646-US",                                       7 },
  { "ISO_646.irv:1991",                                7 },
  { "ISO_8859-10:1992",                               19 },
  { "ISO_8859-14:1998",                               22 },
  { "ISO_8859-1:1987",                                 6 },
  { "ISO_8859-2:1987",                                 9 },
  { "ISO_8859-3:1988",                                10 },
  { "ISO_8859-4:1988",                                11 },
  { "ISO_8859-5:1988",                                12 },
  { "ISO_8859-6:1987",                                13 },
  { "ISO_8859-7:1987",                                14 },
  { "ISO_8859-8:1988",                                16 },
  { "ISO_8859-9:1989",                                18 },
  { "KOI8-R",                                         73 },
  { "KOI8-U",                                         77 },
  { "KSC_5601",                                       44 },
  { "KS_C_5601-1987",                                 44 },
  { "KS_C_5601-1989",                                 46 },
  { "Latin-9",                                        23 },
  { "MS874",                                          49 },
  { "MS936",                                          37 },
  { "MS950_HKSCS",                                    35 },
  { "MS_Kanji",                                       25 },
  { "PC-Multilingual-850+euro",                       62 },
  { "Shift_JIS",                                      25 },
  { "TIS-620",                                        49 },
  { "US-ASCII",                                        7 },
  { "UTF-16BE",                                        1 },
  { "UTF-16LE",                                        2 },
  { "UTF-32BE",                                        3 },
  { "UTF-32LE",                                        4 },
  { "UTF-8",                                           0 },
  { "UTF16_BigEndian",                                 1 },
  { "UTF16_LittleEndian",                              2 },
  { "UTF32_BigEndian",                                 3 },
  { "UTF32_LittleEndian",                              4 },
  { "UnicodeBigUnmarked",                              1 },
  { "UnicodeLittleUnmarked",                           2 },
  { "X-EUC-JP",                                       30 },
  { "arabic",                                         13 },
  { "ascii7",                                          7 },
  { "big5-hkscs:unicode3.0",                          35 },
  { "big5hk",                                         34 },
  { "chinese",                                        39 },
  { "cns11643",                                       41 },
  { "cp-ar",                                          71 },
  { "cp-gr",                                          72 },
  { "cp-is",                                          64 },
  { "cp037",                                         115 },
  { "cp1006",                                        107 },
  { "cp1025",                                        133 },
  { "cp1047",                                        135 },
  { "cp1089",                                         13 },
  { "cp1097",                                        136 },
  { "cp1098",                                        108 },
  { "cp1112",                                        137 },
  { "cp1122",                                        138 },
  { "cp1123",                                        139 },
  { "cp1124",                                        109 },
  { "cp1125",                                        110 },
  { "cp1131",                                        112 },
  { "cp1140",                                        144 },
  { "cp1141",                                        145 },
  { "cp1142",                                        146 },
  { "cp1143",                                        147 },
  { "cp1144",                                        148 },
  { "cp1145",                                        149 },
  { "cp1146",                                        150 },
  { "cp1147",                                        151 },
  { "cp1148",                                        152 },
  { "cp1149",                                        153 },
  { "cp1200",                                          1 },
  { "cp1201",                                          1 },
  { "cp1208",                                          0 },
  { "cp1250",                                         79 },
  { "cp1251",                                         80 },
  { "cp1252",                                         81 },
  { "cp1253",                                         82 },
  { "cp1254",                                         83 },
  { "cp1255",                                         84 },
  { "cp1256",                                         85 },
  { "cp1257",                                         86 },
  { "cp1258",                                         87 },
  { "cp1363",                                         46 },
  { "cp1383",                                         38 },
  { "cp1386",                                         36 },
  { "cp277",                                         117 },
  { "cp278",                                         118 },
  { "cp290",                                         122 },
  { "cp297",                                         123 },
  { "cp33722",                                        28 },
  { "cp367",                                           7 },
  { "cp37",                                          115 },
  { "cp420",                                         124 },
  { "cp424",                                         125 },
  { "cp437",                                          52 },
  { "cp737",                                          54 },
  { "cp775",                                          55 },
  { "cp803",                                         127 },
  { "cp813",                                          15 },
  { "cp819",                                           6 },
  { "cp838",                                         128 },
  { "cp850",                                          56 },
  { "cp851",                                          57 },
  { "cp852",                                          58 },
  { "cp855",                                          59 },
  { "cp856",                                          60 },
  { "cp857",                                          61 },
  { "cp858",                                          62 },
  { "cp860",                                          63 },
  { "cp861",                                          64 },
  { "cp862",                                          65 },
  { "cp863",                                          66 },
  { "cp864",                                          67 },
  { "cp865",                                          68 },
  { "cp866",                                          69 },
  { "cp869",                                          72 },
  { "cp874",                                          50 },
  { "cp875",                                         131 },
  { "cp878",                                          73 },
  { "cp912",                                           9 },
  { "cp913",                                          10 },
  { "cp914",                                          11 },
  { "cp915",                                          12 },
  { "cp916",                                          17 },
  { "cp920",                                          18 },
  { "cp921",                                          21 },
  { "cp922",                                          76 },
  { "cp923",                                          23 },
  { "cp932",                                          24 },
  { "cp943",                                          26 },
  { "cp943c",                                         25 },
  { "cp949",                                          42 },
  { "cp949c",                                         43 },
  { "cp950",                                          33 },
  { "cp964",                                          41 },
  { "cp970",                                          44 },
  { "cpibm284",                                      120 },
  { "cpibm285",                                      121 },
  { "cpibm297",                                      123 },
  { "cpibm37",                                       115 },
  { "csASCII",                                         7 },
  { "csAdobeStandardEncoding",                       106 },
  { "csBig5",                                         32 },
  { "csEUCKR",                                        44 },
  { "csEUCPkdFmtJapanese",                            30 },
  { "csGB2312",                                       38 },
  { "csHPRoman8",                                    105 },
  { "csIBM037",                                      115 },
  { "csIBM1026",                                     134 },
  { "csIBM273",                                      116 },
  { "csIBM277",                                      117 },
  { "csIBM278",                                      118 },
  { "csIBM280",                                      119 },
  { "csIBM284",                                      120 },
  { "csIBM285",                                      121 },
  { "csIBM290",                                      122 },
  { "csIBM297",                                      123 },
  { "csIBM420",                                      124 },
  { "csIBM424",                                      125 },
  { "csIBM500",                                      126 },
  { "csIBM855",                                       59 },
  { "csIBM857",                                       61 },
  { "csIBM860",                                       63 },
  { "csIBM861",                                       64 },
  { "csIBM863",                                       66 },
  { "csIBM864",                                       67 },
  { "csIBM865",                                       68 },
  { "csIBM866",                                       69 },
  { "csIBM868",                                       71 },
  { "csIBM869",                                       72 },
  { "csIBM870",                                      129 },
  { "csIBM871",                                      130 },
  { "csIBM918",                                      132 },
  { "csIBMThai",                                     128 },
  { "csISO58GB231280",                                39 },
  { "csISOLatin1",                                     6 },
  { "csISOLatin2",                                     9 },
  { "csISOLatin3",                                    10 },
  { "csISOLatin4",                                    11 },
  { "csISOLatin5",                                    18 },
  { "csISOLatin6",                                    19 },
  { "csISOLatinArabic",                               13 },
  { "csISOLatinCyrillic",                             12 },
  { "csISOLatinGreek",                                14 },
  { "csISOLatinHebrew",                               16 },
  { "csKOI8R",                                        73 },
  { "csKSC56011987",                                  46 },
  { "csMacintosh",                                   100 },
  { "csPC775Baltic",                                  55 },
  { "csPC850Multilingual",                            56 },
  { "csPC851",                                        57 },
  { "csPC862LatinHebrew",                             65 },
  { "csPC8CodePage437",                               52 },
  { "csPCp852",                                       58 },
  { "csPCp855",                                       59 },
  { "csShiftJIS",                                     25 },
  { "csWindows31J",                                   25 },
  { "csisolatin0",                                    23 },
  { "csisolatin9",                                    23 },
  { "cyrillic",                                       12 },
  { "ebcdic-ar",                                     168 },
  { "ebcdic-cp-ar1",                                 124 },
  { "ebcdic-cp-ar2",                                 132 },
  { "ebcdic-cp-be",                                  126 },
  { "ebcdic-cp-ca",                                  115 },
  { "ebcdic-cp-ch",                                  126 },
  { "ebcdic-cp-es",                                  120 },
  { "ebcdic-cp-fi",                                  118 },
  { "ebcdic-cp-fr",                                  123 },
  { "ebcdic-cp-gb",                                  121 },
  { "ebcdic-cp-he",                                  125 },
  { "ebcdic-cp-is",                                  130 },
  { "ebcdic-cp-it",                                  119 },
  { "ebcdic-cp-nl",                                  115 },
  { "ebcdic-cp-roece",                               129 },
  { "ebcdic-cp-se",                                  118 },
  { "ebcdic-cp-us",                                  115 },
  { "ebcdic-cp-wt",                                  115 },
  { "ebcdic-cp-yu",                                  129 },
  { "ebcdic-de",                                     116 },
  { "ebcdic-de-273+euro",                            145 },
  { "ebcdic-dk",                                     117 },
  { "ebcdic-dk-277+euro",                            146 },
  { "ebcdic-es-284+euro",                            149 },
  { "ebcdic-fi-278+euro",                            147 },
  { "ebcdic-fr-297+euro",                            151 },
  { "ebcdic-gb",                                     121 },
  { "ebcdic-gb-285+euro",                            150 },
  { "ebcdic-he",                                     167 },
  { "ebcdic-international-500+euro",                 152 },
  { "ebcdic-is",                                     130 },
  { "ebcdic-is-871+euro",                            153 },
  { "ebcdic-it-280+euro",                            148 },
  { "ebcdic-no-277+euro",                            146 },
  { "ebcdic-se-278+euro",                            147 },
  { "ebcdic-sv",                                     118 },
  { "ebcdic-us-37+euro",                             144 },
  { "ebcdic-xml-us",                                 184 },
  { "euc-jp-2007",                                    30 },
  { "euc-tw-2014",                                    40 },
  { "eucTH",                                          50 },
  { "eucjis",                                         30 },
  { "gb18030-2022",                                    8 },
  { "gb2312-1980",                                    39 },
  { "greek",                                          14 },
  { "greek8",                                         14 },
  { "gsm-03.38-2009",                                114 },
  { "hebrew",                                         16 },
  { "hebrew8",                                        16 },
  { "hkbig5",                                         35 },
  { "hp-roman8",                                     105 },
  { "hp15CN",                                         38 },
  { "ibm-037",                                       115 },
  { "ibm-1006",                                      107 },
  { "ibm-1006_P100-1995",                            107 },
  { "ibm-1025",                                      133 },
  { "ibm-1025_P100-1995",                            133 },
  { "ibm-1026",                                      134 },
  { "ibm-1026_P100-1995",                            134 },
  { "ibm-1047",                                      135 },
  { "ibm-1047-s390",                                 170 },
  { "ibm-1047_P100-1995",                            135 },
  { "ibm-1047_P100-1995,swaplfnl",                   170 },
  { "ibm-1051",                                      105 },
  { "ibm-1051_P100-1995",                            105 },
  { "ibm-1089",                                       13 },
  { "ibm-1089_P100-1995",                             13 },
  { "ibm-1097",                                      136 },
  { "ibm-1097_P100-1995",                            136 },
  { "ibm-1098",                                      108 },
  { "ibm-1098_P100-1995",                            108 },
  { "ibm-1112",                                      137 },
  { "ibm-1112_P100-1995",                            137 },
  { "ibm-1122",                                      138 },
  { "ibm-1122_P100-1999",                            138 },
  { "ibm-1123",                                      139 },
  { "ibm-1123_P100-1995",                            139 },
  { "ibm-1124",                                      109 },
  { "ibm-1124_P100-1996",                            109 },
  { "ibm-1125",                                      110 },
  { "ibm-1125_P100-1997",                            110 },
  { "ibm-1129",                                      111 },
  { "ibm-1129_P100-1997",                            111 },
  { "ibm-1130",                                      140 },
  { "ibm-1130_P100-1997",                            140 },
  { "ibm-1131",                                      112 },
  { "ibm-1131_P100-1997",                            112 },
  { "ibm-1132",                                      141 },
  { "ibm-1132_P100-1998",                            141 },
  { "ibm-1133",                                      113 },
  { "ibm-1133_P100-1997",                            113 },
  { "ibm-1137",                                      142 },
  { "ibm-1137_P100-1999",                            142 },
  { "ibm-1140",                                      144 },
  { "ibm-1140-s390",                                 171 },
  { "ibm-1140_P100-1997",                            144 },
  { "ibm-1140_P100-1997,swaplfnl",                   171 },
  { "ibm-1141",                                      145 },
  { "ibm-1141-s390",                                 172 },
  { "ibm-1141_P100-1997",                            145 },
  { "ibm-1141_P100-1997,swaplfnl",                   172 },
  { "ibm-1142",                                      146 },
  { "ibm-1142-s390",                                 173 },
  { "ibm-1142_P100-1997",                            146 },
  { "ibm-1142_P100-1997,swaplfnl",                   173 },
  { "ibm-1143",                                      147 },
  { "ibm-1143-s390",                                 174 },
  { "ibm-1143_P100-1997",                            147 },
  { "ibm-1143_P100-1997,swaplfnl",                   174 },
  { "ibm-1144",                                      148 },
  { "ibm-1144-s390",                                 175 },
  { "ibm-1144_P100-1997",                            148 },
  { "ibm-1144_P100-1997,swaplfnl",                   175 },
  { "ibm-1145",                                      149 },
  { "ibm-1145-s390",                                 176 },
  { "ibm-1145_P100-1997",                            149 },
  { "ibm-1145_P100-1997,swaplfnl",                   176 },
  { "ibm-1146",                                      150 },
  { "ibm-1146-s390",                                 177 },
  { "ibm-1146_P100-1997",                            150 },
  { "ibm-1146_P100-1997,swaplfnl",                   177 },
  { "ibm-1147",                                      151 },
  { "ibm-1147-s390",                                 178 },
  { "ibm-1147_P100-1997",                            151 },
  { "ibm-1147_P100-1997,swaplfnl",                   178 },
  { "ibm-1148",                                      152 },
  { "ibm-1148-s390",                                 179 },
  { "ibm-1148_P100-1997",                            152 },
  { "ibm-1148_P100-1997,swaplfnl",                   179 },
  { "ibm-1149",                                      153 },
  { "ibm-1149-s390",                                 180 },
  { "ibm-1149_P100-1997",                            153 },
  { "ibm-1149_P100-1997,swaplfnl",                   180 },
  { "ibm-1153",                                      154 },
  { "ibm-1153-s390",                                 181 },
  { "ibm-1153_P100-1999",                            154 },
  { "ibm-1153_P100-1999,swaplfnl",                   181 },
  { "ibm-1154",                                      155 },
  { "ibm-1154_P100-1999",                            155 },
  { "ibm-1155",                                      156 },
  { "ibm-1155_P100-1999",                            156 },
  { "ibm-1156",                                      157 },
  { "ibm-1156_P100-1999",                            157 },
  { "ibm-1157",                                      158 },
  { "ibm-1157_P100-1999",                            158 },
  { "ibm-1158",                                      159 },
  { "ibm-1158_P100-1999",                            159 },
  { "ibm-1160",                                      160 },
  { "ibm-1160_P100-1999",                            160 },
  { "ibm-1162",                                       51 },
  { "ibm-1162_P100-1999",                             51 },
  { "ibm-1164",                                      161 },
  { "ibm-1164_P100-1999",                            161 },
  { "ibm-1168",                                       77 },
  { "ibm-1168_P100-2002",                             77 },
  { "ibm-1200",                                        1 },
  { "ibm-1201",                                        1 },
  { "ibm-1202",                                        2 },
  { "ibm-1203",                                        2 },
  { "ibm-1208",                                        0 },
  { "ibm-1209",                                        0 },
  { "ibm-1232",                                        3 },
  { "ibm-1233",                                        3 },
  { "ibm-1234",                                        4 },
  { "ibm-1235",                                        4 },
  { "ibm-1250",                                       88 },
  { "ibm-1250_P100-1995",                             88 },
  { "ibm-1251",                                       89 },
  { "ibm-1251_P100-1995",                             89 },
  { "ibm-1252",                                       90 },
  { "ibm-1252_P100-2000",                             90 },
  { "ibm-1253",                                       91 },
  { "ibm-1253_P100-1995",                             91 },
  { "ibm-1254",                                       92 },
  { "ibm-1254_P100-1995",                             92 },
  { "ibm-1255",                                       93 },
  { "ibm-1255_P100-1995",                             93 },
  { "ibm-1256",                                       95 },
  { "ibm-1256_P110-1997",                             95 },
  { "ibm-1257",                                       97 },
  { "ibm-1257_P100-1995",                             97 },
  { "ibm-1258",                                       99 },
  { "ibm-1258_P100-1997",                             99 },
  { "ibm-12712",                                     167 },
  { "ibm-12712-s390",                                182 },
  { "ibm-12712_P100-1998",                           167 },
  { "ibm-12712_P100-1998,swaplfnl",                  182 },
  { "ibm-1276",                                      106 },
  { "ibm-1276_P100-1995",                            106 },
  { "ibm-13488",                                       1 },
  { "ibm-13489",                                       1 },
  { "ibm-13490",                                       2 },
  { "ibm-13491",                                       2 },
  { "ibm-13496",                                       0 },
  { "ibm-13497",                                       0 },
  { "ibm-1363",                                       46 },
  { "ibm-1363_P110-1997",                             47 },
  { "ibm-1363_P11B-1998",                             46 },
  { "ibm-1363_VASCII_VSUB_VPUA",                      47 },
  { "ibm-1363_VSUB_VPUA",                             46 },
  { "ibm-1373",                                       31 },
  { "ibm-1373_P100-2002",                             31 },
  { "ibm-1375",                                       34 },
  { "ibm-1375_P100-2008",                             34 },
  { "ibm-1383",                                       38 },
  { "ibm-1383_P110-1999",                             38 },
  { "ibm-1383_VPUA",                                  38 },
  { "ibm-1386",                                       36 },
  { "ibm-1386_P100-2001",                             36 },
  { "ibm-1386_VSUB_VPUA",                             36 },
  { "ibm-1392",                                        8 },
  { "ibm-16804",                                     168 },
  { "ibm-16804-s390",                                183 },
  { "ibm-16804_X110-1999",                           168 },
  { "ibm-16804_X110-1999,swaplfnl",                  183 },
  { "ibm-17584",                                       1 },
  { "ibm-17585",                                       1 },
  { "ibm-17586",                                       2 },
  { "ibm-17587",                                       2 },
  { "ibm-17592",                                       0 },
  { "ibm-17593",                                       0 },
  { "ibm-21680",                                       1 },
  { "ibm-21681",                                       1 },
  { "ibm-21682",                                       2 },
  { "ibm-21683",                                       2 },
  { "ibm-25776",                                       1 },
  { "ibm-25777",                                       1 },
  { "ibm-25778",                                       2 },
  { "ibm-25779",                                       2 },
  { "ibm-273",                                       116 },
  { "ibm-273_P100-1995",                             116 },
  { "ibm-277",                                       117 },
  { "ibm-277_P100-1995",                             117 },
  { "ibm-278",                                       118 },
  { "ibm-278_P100-1995",                             118 },
  { "ibm-280",                                       119 },
  { "ibm-280_P100-1995",                             119 },
  { "ibm-284",                                       120 },
  { "ibm-284_P100-1995",                             120 },
  { "ibm-285",                                       121 },
  { "ibm-285_P100-1995",                             121 },
  { "ibm-290",                                       122 },
  { "ibm-290_P100-1995",                             122 },
  { "ibm-297",                                       123 },
  { "ibm-297_P100-1995",                             123 },
  { "ibm-29872",                                       1 },
  { "ibm-29873",                                       1 },
  { "ibm-29874",                                       2 },
  { "ibm-29875",                                       2 },
  { "ibm-33722",                                      27 },
  { "ibm-33722_P120-1999",                            28 },
  { "ibm-33722_P12A_P12A-2009_U2",                    27 },
  { "ibm-33722_VASCII_VPUA",                          28 },
  { "ibm-33722_VPUA",                                 27 },
  { "ibm-367",                                         7 },
  { "ibm-37",                                        115 },
  { "ibm-37-s390",                                   169 },
  { "ibm-37_P100-1995",                              115 },
  { "ibm-37_P100-1995,swaplfnl",                     169 },
  { "ibm-420",                                       124 },
  { "ibm-420_X120-1999",                             124 },
  { "ibm-424",                                       125 },
  { "ibm-424_P100-1995",                             125 },
  { "ibm-437",                                        52 },
  { "ibm-437_P100-1995",                              52 },
  { "ibm-4517",                                      143 },
  { "ibm-4517_P100-2005",                            143 },
  { "ibm-4899",                                      164 },
  { "ibm-4899_P100-1998",                            164 },
  { "ibm-4909",                                       78 },
  { "ibm-4909_P100-1999",                             78 },
  { "ibm-4971",                                      165 },
  { "ibm-4971_P100-1999",                            165 },
  { "ibm-500",                                       126 },
  { "ibm-500_P100-1995",                             126 },
  { "ibm-5012",                                       16 },
  { "ibm-5012_P100-1999",                             16 },
  { "ibm-5050",                                       27 },
  { "ibm-5123",                                      162 },
  { "ibm-5123_P100-1999",                            162 },
  { "ibm-5304",                                        0 },
  { "ibm-5305",                                        0 },
  { "ibm-5346",                                       79 },
  { "ibm-5346_P100-1998",                             79 },
  { "ibm-5347",                                       80 },
  { "ibm-5347_P100-1998",                             80 },
  { "ibm-5348",                                       81 },
  { "ibm-5348_P100-1997",                             81 },
  { "ibm-5349",                                       82 },
  { "ibm-5349_P100-1998",                             82 },
  { "ibm-5350",                                       83 },
  { "ibm-5350_P100-1998",                             83 },
  { "ibm-5351",                                       94 },
  { "ibm-5351_P100-1998",                             94 },
  { "ibm-5352",                                       96 },
  { "ibm-5352_P100-1998",                             96 },
  { "ibm-5353",                                       98 },
  { "ibm-5353_P100-1998",                             98 },
  { "ibm-5354",                                       87 },
  { "ibm-5354_P100-1998",                             87 },
  { "ibm-5471",                                       35 },
  { "ibm-5471_P100-2006",                             35 },
  { "ibm-5478",                                       39 },
  { "ibm-5478_P100-1995",                             39 },
  { "ibm-61955",                                       1 },
  { "ibm-61956",                                       1 },
  { "ibm-720",                                        53 },
  { "ibm-720_P100-1997",                              53 },
  { "ibm-737",                                        54 },
  { "ibm-737_P100-1997",                              54 },
  { "ibm-775",                                        55 },
  { "ibm-775_P100-1996",                              55 },
  { "ibm-803",                                       127 },
  { "ibm-803_P100-1999",                             127 },
  { "ibm-813",                                        15 },
  { "ibm-813_P100-1995",                              15 },
  { "ibm-819",                                         6 },
  { "ibm-838",                                       128 },
  { "ibm-838_P100-1995",                             128 },
  { "ibm-8482",                                      163 },
  { "ibm-8482_P100-1999",                            163 },
  { "ibm-850",                                        56 },
  { "ibm-850_P100-1995",                              56 },
  { "ibm-851",                                        57 },
  { "ibm-851_P100-1995",                              57 },
  { "ibm-852",                                        58 },
  { "ibm-852_P100-1995",                              58 },
  { "ibm-855",                                        59 },
  { "ibm-855_P100-1995",                              59 },
  { "ibm-856",                                        60 },
  { "ibm-856_P100-1995",                              60 },
  { "ibm-857",                                        61 },
  { "ibm-857_P100-1995",                              61 },
  { "ibm-858",                                        62 },
  { "ibm-858_P100-1997",                              62 },
  { "ibm-860",                                        63 },
  { "ibm-860_P100-1995",                              63 },
  { "ibm-861",                                        64 },
  { "ibm-861_P100-1995",                              64 },
  { "ibm-862",                                        65 },
  { "ibm-862_P100-1995",                              65 },
  { "ibm-863",                                        66 },
  { "ibm-863_P100-1995",                              66 },
  { "ibm-864",                                        67 },
  { "ibm-864_X110-1999",                              67 },
  { "ibm-865",                                        68 },
  { "ibm-865_P100-1995",                              68 },
  { "ibm-866",                                        69 },
  { "ibm-866_P100-1995",                              69 },
  { "ibm-867",                                        70 },
  { "ibm-867_P100-1998",                              70 },
  { "ibm-868",                                        71 },
  { "ibm-868_P100-1995",                              71 },
  { "ibm-869",                                        72 },
  { "ibm-869_P100-1995",                              72 },
  { "ibm-870",                                       129 },
  { "ibm-870_P100-1995",                             129 },
  { "ibm-871",                                       130 },
  { "ibm-871_P100-1995",                             130 },
  { "ibm-874",                                        50 },
  { "ibm-874_P100-1995",                              50 },
  { "ibm-875",                                       131 },
  { "ibm-875_P100-1995",                             131 },
  { "ibm-878",                                        73 },
  { "ibm-878_P100-1996",                              73 },
  { "ibm-9005",                                       14 },
  { "ibm-9005_X110-2007",                             14 },
  { "ibm-901",                                        74 },
  { "ibm-901_P100-1999",                              74 },
  { "ibm-902",                                        75 },
  { "ibm-902_P100-1999",                              75 },
  { "ibm-9030",                                      128 },
  { "ibm-9066",                                       50 },
  { "ibm-9067",                                      166 },
  { "ibm-9067_X100-2005",                            166 },
  { "ibm-912",                                         9 },
  { "ibm-912_P100-1995",                               9 },
  { "ibm-913",                                        10 },
  { "ibm-913_P100-2000",                              10 },
  { "ibm-914",                                        11 },
  { "ibm-914_P100-1995",                              11 },
  { "ibm-915",                                        12 },
  { "ibm-915_P100-1995",                              12 },
  { "ibm-916",                                        17 },
  { "ibm-916_P100-1995",                              17 },
  { "ibm-918",                                       132 },
  { "ibm-918_P100-1995",                             132 },
  { "ibm-920",                                        18 },
  { "ibm-920_P100-1995",                              18 },
  { "ibm-921",                                        21 },
  { "ibm-921_P100-1995",                              21 },
  { "ibm-922",                                        76 },
  { "ibm-922_P100-1999",                              76 },
  { "ibm-923",                                        23 },
  { "ibm-923_P100-1998",                              23 },
  { "ibm-932",                                        24 },
  { "ibm-932_VSUB_VPUA",                              24 },
  { "ibm-9400",                                        5 },
  { "ibm-942",                                        24 },
  { "ibm-9424",                                        3 },
  { "ibm-942_P12A-1999",                              24 },
  { "ibm-942_VSUB_VPUA",                              24 },
  { "ibm-943",                                        25 },
  { "ibm-943_P130-1999",                              26 },
  { "ibm-943_P15A-2003",                              25 },
  { "ibm-943_VASCII_VSUB_VPUA",                       26 },
  { "ibm-943_VSUB_VPUA",                              25 },
  { "ibm-9447",                                       84 },
  { "ibm-9447_P100-2002",                             84 },
  { "ibm-9448",                                       85 },
  { "ibm-9448_X100-2005",                             85 },
  { "ibm-9449",                                       86 },
  { "ibm-9449_P100-2002",                             86 },
  { "ibm-949",                                        42 },
  { "ibm-949_P110-1999",                              42 },
  { "ibm-949_P11A-1999",                              43 },
  { "ibm-949_VASCII_VSUB_VPUA",                       42 },
  { "ibm-949_VSUB_VPUA",                              43 },
  { "ibm-950",                                        33 },
  { "ibm-950_P110-1999",                              33 },
  { "ibm-954",                                        29 },
  { "ibm-954_P101-2007",                              29 },
  { "ibm-964",                                        41 },
  { "ibm-964_P110-1999",                              41 },
  { "ibm-964_VPUA",                                   41 },
  { "ibm-970",                                        44 },
  { "ibm-970_P110_P110-2006_U2",                      44 },
  { "ibm-970_VPUA",                                   44 },
  { "ibm-971",                                        45 },
  { "ibm-971_P100-1995",                              45 },
  { "ibm-971_VPUA",                                   45 },
  { "ibm-eucCN",                                      38 },
  { "ibm-eucKR",                                      44 },
  { "ibm-eucTW",                                      41 },
  { "iso-8859_10-1998",                               19 },
  { "iso-8859_11-2001",                               20 },
  { "iso-8859_14-1998",                               22 },
  { "iso-celtic",                                     22 },
  { "iso-ir-100",                                      6 },
  { "iso-ir-101",                                      9 },
  { "iso-ir-109",                                     10 },
  { "iso-ir-110",                                     11 },
  { "iso-ir-126",                                     14 },
  { "iso-ir-127",                                     13 },
  { "iso-ir-138",                                     16 },
  { "iso-ir-144",                                     12 },
  { "iso-ir-148",                                     18 },
  { "iso-ir-149",                                     46 },
  { "iso-ir-157",                                     19 },
  { "iso-ir-199",                                     22 },
  { "iso-ir-58",                                      39 },
  { "iso-ir-6",                                        7 },
  { "iso8859_15_fdis",                                23 },
  { "iso_646.irv:1983",                                7 },
  { "koi8",                                           73 },
  { "korean",                                         46 },
  { "ksc",                                            46 },
  { "l1",                                              6 },
  { "l2",                                              9 },
  { "l3",                                             10 },
  { "l4",                                             11 },
  { "l5",                                             18 },
  { "l6",                                             19 },
  { "l8",                                             22 },
  { "l9",                                             23 },
  { "latin0",                                         23 },
  { "latin1",                                          6 },
  { "latin2",                                          9 },
  { "latin3",                                         10 },
  { "latin4",                                         11 },
  { "latin5",                                         18 },
  { "latin6",                                         19 },
  { "latin8",                                         22 },
  { "mac",                                           100 },
  { "mac-cyrillic",                                  102 },
  { "macce",                                         103 },
  { "maccentraleurope",                              103 },
  { "maccy",                                         102 },
  { "macgr",                                         101 },
  { "macintosh",                                     100 },
  { "macos-0_2-10.2",                                100 },
  { "macos-29-10.2",                                 103 },
  { "macos-35-10.2",                                 104 },
  { "macos-6_2-10.4",                                101 },
  { "macos-7_3-10.2",                                102 },
  { "macroman",                                      100 },
  { "mactr",                                         104 },
  { "ms932",                                          25 },
  { "ms949",                                          48 },
  { "ms950",                                          32 },
  { "pck",                                            25 },
  { "r8",                                            105 },
  { "roman8",                                        105 },
  { "shift_jis78",                                    24 },
  { "sjis",                                           25 },
  { "sjis78",                                         24 },
  { "sun_eu_greek",                                   14 },
  { "thai8",                                          20 },
  { "tis620.2533",                                    50 },
  { "turkish",                                        18 },
  { "turkish8",                                       18 },
  { "ujis",                                           30 },
  { "unicode-1-1-utf-8",                               0 },
  { "unicode-2-0-utf-8",                               0 },
  { "us",                                              7 },
  { "windows-10000",                                 100 },
  { "windows-10006",                                 101 },
  { "windows-10007",                                 102 },
  { "windows-10029",                                 103 },
  { "windows-10081",                                 104 },
  { "windows-1200",                                    2 },
  { "windows-1201",                                    1 },
  { "windows-1250",                                   79 },
  { "windows-1251",                                   80 },
  { "windows-1252",                                   81 },
  { "windows-1253",                                   82 },
  { "windows-1254",                                   83 },
  { "windows-1255",                                   84 },
  { "windows-1256",                                   85 },
  { "windows-1257",                                   86 },
  { "windows-1258",                                   87 },
  { "windows-20127",                                   7 },
  { "windows-20866",                                  73 },
  { "windows-21866",                                  77 },
  { "windows-28592",                                   9 },
  { "windows-28593",                                  10 },
  { "windows-28594",                                  11 },
  { "windows-28595",                                  12 },
  { "windows-28596",                                  13 },
  { "windows-28597",                                  14 },
  { "windows-28598",                                  16 },
  { "windows-28599",                                  18 },
  { "windows-28603",                                  21 },
  { "windows-28605",                                  23 },
  { "windows-31j",                                    25 },
  { "windows-437",                                    52 },
  { "windows-51949",                                  44 },
  { "windows-54936",                                   8 },
  { "windows-65001",                                   0 },
  { "windows-720",                                    53 },
  { "windows-737",                                    54 },
  { "windows-775",                                    55 },
  { "windows-850",                                    56 },
  { "windows-852",                                    58 },
  { "windows-855",                                    59 },
  { "windows-857",                                    61 },
  { "windows-858",                                    62 },
  { "windows-861",                                    64 },
  { "windows-862",                                    65 },
  { "windows-866",                                    69 },
  { "windows-869",                                    72 },
  { "windows-874",                                    49 },
  { "windows-874-2000",                               49 },
  { "windows-932",                                    25 },
  { "windows-936",                                    36 },
  { "windows-936-2000",                               37 },
  { "windows-949",                                    46 },
  { "windows-949-2000",                               48 },
  { "windows-950",                                    31 },
  { "windows-950-2000",                               32 },
  { "x-IBM1006",                                     107 },
  { "x-IBM1025",                                     133 },
  { "x-IBM1097",                                     136 },
  { "x-IBM1098",                                     108 },
  { "x-IBM1112",                                     137 },
  { "x-IBM1122",                                     138 },
  { "x-IBM1123",                                     139 },
  { "x-IBM1124",                                     109 },
  { "x-IBM1153",                                     154 },
  { "x-IBM1363",                                      47 },
  { "x-IBM1363C",                                     46 },
  { "x-IBM33722",                                     28 },
  { "x-IBM33722A",                                    28 },
  { "x-IBM33722C",                                    28 },
  { "x-IBM720",                                       53 },
  { "x-IBM737",                                       54 },
  { "x-IBM856",                                       60 },
  { "x-IBM867",                                       70 },
  { "x-IBM874",                                       50 },
  { "x-IBM875",                                      131 },
  { "x-IBM921",                                       21 },
  { "x-IBM922",                                       76 },
  { "x-IBM942",                                       24 },
  { "x-IBM942C",                                      24 },
  { "x-IBM943",                                       26 },
  { "x-IBM949",                                       42 },
  { "x-IBM949C",                                      43 },
  { "x-IBM950",                                       33 },
  { "x-IBM954",                                       29 },
  { "x-IBM954C",                                      29 },
  { "x-IBM964",                                       41 },
  { "x-IBM970",                                       44 },
  { "x-IBM971",                                       45 },
  { "x-ISO-8859-6S",                                  13 },
  { "x-JISAutoDetect",                                25 },
  { "x-KSC5601",                                      48 },
  { "x-MS932_0213",                                   25 },
  { "x-MS950-HKSCS",                                  35 },
  { "x-MacCentralEurope",                            103 },
  { "x-MacCyrillic",                                 102 },
  { "x-MacGreek",                                    101 },
  { "x-MacTurkish",                                  104 },
  { "x-MacUkraine",                                  102 },
  { "x-UTF_8J",                                        0 },
  { "x-big5",                                         32 },
  { "x-iso-8859-11",                                  20 },
  { "x-mac-ce",                                      103 },
  { "x-mac-centraleurroman",                         103 },
  { "x-mac-cyrillic",                                102 },
  { "x-mac-greek",                                   101 },
  { "x-mac-turkish",                                 104 },
  { "x-macroman",                                    100 },
  { "x-ms-cp932",                                     25 },
  { "x-roman8",                                      105 },
  { "x-sjis",                                         25 },
  { "x-utf-16be",                                      1 },
  { "x-utf-16le",                                      2 },
  { "x-windows-1256S",                                85 },
  { "x-windows-874",                                  49 },
  { "x-windows-950",                                  32 }
};

static const char* const LG_CANONICAL_ENCODINGS[] = {
  "UTF-8",                        //   0
  "UTF-16BE",                     //   1
  "UTF-16LE",                     //   2
  "UTF-32BE",                     //   3
  "UTF-32LE",                     //   4
  "CESU-8",                       //   5
  "ISO-8859-1",                   //   6
  "US-ASCII",                     //   7
  "gb18030-2022",                 //   8
  "ibm-912_P100-1995",            //   9
  "ibm-913_P100-2000",            //  10
  "ibm-914_P100-1995",            //  11
  "ibm-915_P100-1995",            //  12
  "ibm-1089_P100-1995",           //  13
  "ibm-9005_X110-2007",           //  14
  "ibm-813_P100-1995",            //  15
  "ibm-5012_P100-1999",           //  16
  "ibm-916_P100-1995",            //  17
  "ibm-920_P100-1995",            //  18
  "iso-8859_10-1998",             //  19
  "iso-8859_11-2001",             //  20
  "ibm-921_P100-1995",            //  21
  "iso-8859_14-1998",             //  22
  "ibm-923_P100-1998",            //  23
  "ibm-942_P12A-1999",            //  24
  "ibm-943_P15A-2003",            //  25
  "ibm-943_P130-1999",            //  26
  "ibm-33722_P12A_P12A-2009_U2",  //  27
  "ibm-33722_P120-1999",          //  28
  "ibm-954_P101-2007",            //  29
  "euc-jp-2007",                  //  30
  "ibm-1373_P100-2002",           //  31
  "windows-950-2000",             //  32
  "ibm-950_P110-1999",            //  33
  "ibm-1375_P100-2008",           //  34
  "ibm-5471_P100-2006",           //  35
  "ibm-1386_P100-2001",           //  36
  "windows-936-2000",             //  37
  "ibm-1383_P110-1999",           //  38
  "ibm-5478_P100-1995",           //  39
  "euc-tw-2014",                  //  40
  "ibm-964_P110-1999",            //  41
  "ibm-949_P110-1999",            //  42
  "ibm-949_P11A-1999",            //  43
  "ibm-970_P110_P110-2006_U2",    //  44
  "ibm-971_P100-1995",            //  45
  "ibm-1363_P11B-1998",           //  46
  "ibm-1363_P110-1997",           //  47
  "windows-949-2000",             //  48
  "windows-874-2000",             //  49
  "ibm-874_P100-1995",            //  50
  "ibm-1162_P100-1999",           //  51
  "ibm-437_P100-1995",            //  52
  "ibm-720_P100-1997",            //  53
  "ibm-737_P100-1997",            //  54
  "ibm-775_P100-1996",            //  55
  "ibm-850_P100-1995",            //  56
  "ibm-851_P100-1995",            //  57
  "ibm-852_P100-1995",            //  58
  "ibm-855_P100-1995",            //  59
  "ibm-856_P100-1995",            //  60
  "ibm-857_P100-1995",            //  61
  "ibm-858_P100-1997",            //  62
  "ibm-860_P100-1995",            //  63
  "ibm-861_P100-1995",            //  64
  "ibm-862_P100-1995",            //  65
  "ibm-863_P100-1995",            //  66
  "ibm-864_X110-1999",            //  67
  "ibm-865_P100-1995",            //  68
  "ibm-866_P100-1995",            //  69
  "ibm-867_P100-1998",            //  70
  "ibm-868_P100-1995",            //  71
  "ibm-869_P100-1995",            //  72
  "ibm-878_P100-1996",            //  73
  "ibm-901_P100-1999",            //  74
  "ibm-902_P100-1999",            //  75
  "ibm-922_P100-1999",            //  76
  "ibm-1168_P100-2002",           //  77
  "ibm-4909_P100-1999",           //  78
  "ibm-5346_P100-1998",           //  79
  "ibm-5347_P100-1998",           //  80
  "ibm-5348_P100-1997",           //  81
  "ibm-5349_P100-1998",           //  82
  "ibm-5350_P100-1998",           //  83
  "ibm-9447_P100-2002",           //  84
  "ibm-9448_X100-2005",           //  85
  "ibm-9449_P100-2002",           //  86
  "ibm-5354_P100-1998",           //  87
  "ibm-1250_P100-1995",           //  88
  "ibm-1251_P100-1995",           //  89
  "ibm-1252_P100-2000",           //  90
  "ibm-1253_P100-1995",           //  91
  "ibm-1254_P100-1995",           //  92
  "ibm-1255_P100-1995",           //  93
  "ibm-5351_P100-1998",           //  94
  "ibm-1256_P110-1997",           //  95
  "ibm-5352_P100-1998",           //  96
  "ibm-1257_P100-1995",           //  97
  "ibm-5353_P100-1998",           //  98
  "ibm-1258_P100-1997",           //  99
  "macos-0_2-10.2",               // 100
  "macos-6_2-10.4",               // 101
  "macos-7_3-10.2",               // 102
  "macos-29-10.2",                // 103
  "macos-35-10.2",                // 104
  "ibm-1051_P100-1995",           // 105
  "ibm-1276_P100-1995",           // 106
  "ibm-1006_P100-1995",           // 107
  "ibm-1098_P100-1995",           // 108
  "ibm-1124_P100-1996",           // 109
  "ibm-1125_P100-1997",           // 110
  "ibm-1129_P100-1997",           // 111
  "ibm-1131_P100-1997",           // 112
  "ibm-1133_P100-1997",           // 113
  "gsm-03.38-2009",               // 114
  "ibm-37_P100-1995",             // 115
  "ibm-273_P100-1995",            // 116
  "ibm-277_P100-1995",            // 117
  "ibm-278_P100-1995",            // 118
  "ibm-280_P100-1995",            // 119
  "ibm-284_P100-1995",            // 120
  "ibm-285_P100-1995",            // 121
  "ibm-290_P100-1995",            // 122
  "ibm-297_P100-1995",            // 123
  "ibm-420_X120-1999",            // 124
  "ibm-424_P100-1995",            // 125
  "ibm-500_P100-1995",            // 126
  "ibm-803_P100-1999",            // 127
  "ibm-838_P100-1995",            // 128
  "ibm-870_P100-1995",            // 129
  "ibm-871_P100-1995",            // 130
  "ibm-875_P100-1995",            // 131
  "ibm-918_P100-1995",            // 132
  "ibm-1025_P100-1995",           // 133
  "ibm-1026_P100-1995",           // 134
  "ibm-1047_P100-1995",           // 135
  "ibm-1097_P100-1995",           // 136
  "ibm-1112_P100-1995",           // 137
  "ibm-1122_P100-1999",           // 138
  "ibm-1123_P100-1995",           // 139
  "ibm-1130_P100-1997",           // 140
  "ibm-1132_P100-1998",           // 141
  "ibm-1137_P100-1999",           // 142
  "ibm-4517_P100-2005",           // 143
  "ibm-1140_P100-1997",           // 144
  "ibm-1141_P100-1997",           // 145
  "ibm-1142_P100-1997",           // 146
  "ibm-1143_P100-1997",           // 147
  "ibm-1144_P100-1997",           // 148
  "ibm-1145_P100-1997",           // 149
  "ibm-1146_P100-1997",           // 150
  "ibm-1147_P100-1997",           // 151
  "ibm-1148_P100-1997",           // 152
  "ibm-1149_P100-1997",           // 153
  "ibm-1153_P100-1999",           // 154
  "ibm-1154_P100-1999",           // 155
  "ibm-1155_P100-1999",           // 156
  "ibm-1156_P100-1999",           // 157
  "ibm-1157_P100-1999",           // 158
  "ibm-1158_P100-1999",           // 159
  "ibm-1160_P100-1999",           // 160
  "ibm-1164_P100-1999",           // 161
  "ibm-5123_P100-1999",           // 162
  "ibm-8482_P100-1999",           // 163
  "ibm-4899_P100-1998",           // 164
  "ibm-4971_P100-1999",           // 165
  "ibm-9067_X100-2005",           // 166
  "ibm-12712_P100-1998",          // 167
  "ibm-16804_X110-1999",          // 168
  "ibm-37_P100-1995,swaplfnl",    // 169
  "ibm-1047_P100-1995,swaplfnl",  // 170
  "ibm-1140_P100-1997,swaplfnl",  // 171
  "ibm-1141_P100-1997,swaplfnl",  // 172
  "ibm-1142_P100-1997,swaplfnl",  // 173
  "ibm-1143_P100-1997,swaplfnl",  // 174
  "ibm-1144_P100-1997,swaplfnl",  // 175
  "ibm-1145_P100-1997,swaplfnl",  // 176
  "ibm-1146_P100-1997,swaplfnl",  // 177
  "ibm-1147_P100-1997,swaplfnl",  // 178
  "ibm-1148_P100-1997,swaplfnl",  // 179
  "ibm-1149_P100-1997,swaplfnl",  // 180
  "ibm-1153_P100-1999,swaplfnl",  // 181
  "ibm-12712_P100-1998,swaplfnl", // 182
  "ibm-16804_X110-1999,swaplfnl", // 183
  "ebcdic-xml-us",                // 184
};

// UTF-8
static const int LG_ENCODING_UTF_8 = 0; // IANA* MIME* WINDOWS JAVA*
static const int LG_ENCODING_CP1208 = 0;
static const int LG_ENCODING_IBM_1208 = 0; // IBM*
static const int LG_ENCODING_IBM_1209 = 0; // IBM
static const int LG_ENCODING_IBM_13496 = 0; // IBM
static const int LG_ENCODING_IBM_13497 = 0; // IBM
static const int LG_ENCODING_IBM_17592 = 0; // IBM
static const int LG_ENCODING_IBM_17593 = 0; // IBM
static const int LG_ENCODING_IBM_5304 = 0; // IBM
static const int LG_ENCODING_IBM_5305 = 0; // IBM
static const int LG_ENCODING_UNICODE_1_1_UTF_8 = 0;
static const int LG_ENCODING_UNICODE_2_0_UTF_8 = 0;
static const int LG_ENCODING_WINDOWS_65001 = 0; // WINDOWS*
static const int LG_ENCODING_X_UTF_8J = 0;

// UTF-16BE
static const int LG_ENCODING_UTF_16BE = 1; // IANA* MIME* JAVA*
static const int LG_ENCODING_UTF16_BIGENDIAN = 1;
static const int LG_ENCODING_UNICODEBIGUNMARKED = 1; // JAVA
static const int LG_ENCODING_CP1200 = 1;
static const int LG_ENCODING_CP1201 = 1;
static const int LG_ENCODING_IBM_1200 = 1; // IBM*
static const int LG_ENCODING_IBM_1201 = 1; // IBM
static const int LG_ENCODING_IBM_13488 = 1; // IBM
static const int LG_ENCODING_IBM_13489 = 1; // IBM
static const int LG_ENCODING_IBM_17584 = 1; // IBM
static const int LG_ENCODING_IBM_17585 = 1; // IBM
static const int LG_ENCODING_IBM_21680 = 1; // IBM
static const int LG_ENCODING_IBM_21681 = 1; // IBM
static const int LG_ENCODING_IBM_25776 = 1; // IBM
static const int LG_ENCODING_IBM_25777 = 1; // IBM
static const int LG_ENCODING_IBM_29872 = 1; // IBM
static const int LG_ENCODING_IBM_29873 = 1; // IBM
static const int LG_ENCODING_IBM_61955 = 1; // IBM
static const int LG_ENCODING_IBM_61956 = 1; // IBM
static const int LG_ENCODING_WINDOWS_1201 = 1; // WINDOWS*
static const int LG_ENCODING_X_UTF_16BE = 1; // JAVA

// UTF-16LE
static const int LG_ENCODING_UTF_16LE = 2; // IANA* MIME* JAVA*
static const int LG_ENCODING_UTF16_LITTLEENDIAN = 2;
static const int LG_ENCODING_UNICODELITTLEUNMARKED = 2; // JAVA
static const int LG_ENCODING_IBM_1202 = 2; // IBM*
static const int LG_ENCODING_IBM_1203 = 2; // IBM
static const int LG_ENCODING_IBM_13490 = 2; // IBM
static const int LG_ENCODING_IBM_13491 = 2; // IBM
static const int LG_ENCODING_IBM_17586 = 2; // IBM
static const int LG_ENCODING_IBM_17587 = 2; // IBM
static const int LG_ENCODING_IBM_21682 = 2; // IBM
static const int LG_ENCODING_IBM_21683 = 2; // IBM
static const int LG_ENCODING_IBM_25778 = 2; // IBM
static const int LG_ENCODING_IBM_25779 = 2; // IBM
static const int LG_ENCODING_IBM_29874 = 2; // IBM
static const int LG_ENCODING_IBM_29875 = 2; // IBM
static const int LG_ENCODING_WINDOWS_1200 = 2; // WINDOWS*
static const int LG_ENCODING_X_UTF_16LE = 2; // JAVA

// UTF-32BE
static const int LG_ENCODING_UTF_32BE = 3; // IANA*
static const int LG_ENCODING_UTF32_BIGENDIAN = 3;
static const int LG_ENCODING_IBM_1232 = 3; // IBM*
static const int LG_ENCODING_IBM_1233 = 3; // IBM
static const int LG_ENCODING_IBM_9424 = 3; // IBM

// UTF-32LE
static const int LG_ENCODING_UTF_32LE = 4; // IANA*
static const int LG_ENCODING_UTF32_LITTLEENDIAN = 4;
static const int LG_ENCODING_IBM_1234 = 4; // IBM*
static const int LG_ENCODING_IBM_1235 = 4; // IBM

// CESU-8
static const int LG_ENCODING_CESU_8 = 5; // IANA*
static const int LG_ENCODING_IBM_9400 = 5; // IBM*

// ISO-8859-1
static const int LG_ENCODING_819 = 6; // JAVA
static const int LG_ENCODING_8859_1 = 6; // JAVA
static const int LG_ENCODING_IBM819 = 6; // IANA
static const int LG_ENCODING_ISO_8859_1 = 6; // IANA MIME* JAVA*
static const int LG_ENCODING_ISO_8859_1_1987 = 6; // IANA* JAVA
static const int LG_ENCODING_CP819 = 6; // IANA JAVA
static const int LG_ENCODING_CSISOLATIN1 = 6; // IANA JAVA
static const int LG_ENCODING_IBM_819 = 6; // IBM* JAVA
static const int LG_ENCODING_ISO_IR_100 = 6; // IANA JAVA
static const int LG_ENCODING_L1 = 6; // IANA JAVA
static const int LG_ENCODING_LATIN1 = 6; // IANA JAVA

// US-ASCII
static const int LG_ENCODING_646 = 7; // JAVA
static const int LG_ENCODING_ANSI_X3_4_1968 = 7; // IANA* WINDOWS
static const int LG_ENCODING_ANSI_X3_4_1986 = 7; // IANA WINDOWS
static const int LG_ENCODING_ASCII = 7; // IANA WINDOWS JAVA*
static const int LG_ENCODING_IBM367 = 7; // IANA WINDOWS
static const int LG_ENCODING_ISO646_US = 7; // IANA WINDOWS JAVA
static const int LG_ENCODING_ISO_646_IRV_1991 = 7; // IANA WINDOWS
static const int LG_ENCODING_US_ASCII = 7; // IANA MIME* WINDOWS JAVA
static const int LG_ENCODING_ASCII7 = 7; // JAVA
static const int LG_ENCODING_CP367 = 7; // IANA WINDOWS
static const int LG_ENCODING_CSASCII = 7; // IANA WINDOWS
static const int LG_ENCODING_IBM_367 = 7; // IBM*
static const int LG_ENCODING_ISO_IR_6 = 7; // IANA
static const int LG_ENCODING_ISO_646_IRV_1983 = 7; // JAVA
static const int LG_ENCODING_US = 7; // IANA
static const int LG_ENCODING_WINDOWS_20127 = 7; // WINDOWS*

// gb18030-2022
static const int LG_ENCODING_GB18030 = 8; // IANA* MIME*
static const int LG_ENCODING_GB18030_2022 = 8;
static const int LG_ENCODING_IBM_1392 = 8; // IBM*
static const int LG_ENCODING_WINDOWS_54936 = 8; // WINDOWS*

// ibm-912_P100-1995
static const int LG_ENCODING_8859_2 = 9; // JAVA
static const int LG_ENCODING_912 = 9; // JAVA
static const int LG_ENCODING_ISO_8859_2 = 9; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_2_1987 = 9; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP912 = 9; // JAVA
static const int LG_ENCODING_CSISOLATIN2 = 9; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_912 = 9; // IBM* JAVA
static const int LG_ENCODING_IBM_912_P100_1995 = 9; // UTR22*
static const int LG_ENCODING_ISO_IR_101 = 9; // IANA WINDOWS JAVA
static const int LG_ENCODING_L2 = 9; // IANA WINDOWS JAVA
static const int LG_ENCODING_LATIN2 = 9; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28592 = 9; // WINDOWS*

// ibm-913_P100-2000
static const int LG_ENCODING_8859_3 = 10; // JAVA
static const int LG_ENCODING_913 = 10; // JAVA
static const int LG_ENCODING_ISO_8859_3 = 10; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_3_1988 = 10; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP913 = 10; // JAVA
static const int LG_ENCODING_CSISOLATIN3 = 10; // IANA WINDOWS
static const int LG_ENCODING_IBM_913 = 10; // IBM* JAVA
static const int LG_ENCODING_IBM_913_P100_2000 = 10; // UTR22*
static const int LG_ENCODING_ISO_IR_109 = 10; // IANA WINDOWS JAVA
static const int LG_ENCODING_L3 = 10; // IANA WINDOWS JAVA
static const int LG_ENCODING_LATIN3 = 10; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28593 = 10; // WINDOWS*

// ibm-914_P100-1995
static const int LG_ENCODING_8859_4 = 11; // JAVA
static const int LG_ENCODING_914 = 11; // JAVA
static const int LG_ENCODING_ISO_8859_4 = 11; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_4_1988 = 11; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP914 = 11; // JAVA
static const int LG_ENCODING_CSISOLATIN4 = 11; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_914 = 11; // IBM* JAVA
static const int LG_ENCODING_IBM_914_P100_1995 = 11; // UTR22*
static const int LG_ENCODING_ISO_IR_110 = 11; // IANA WINDOWS JAVA
static const int LG_ENCODING_L4 = 11; // IANA WINDOWS JAVA
static const int LG_ENCODING_LATIN4 = 11; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28594 = 11; // WINDOWS*

// ibm-915_P100-1995
static const int LG_ENCODING_8859_5 = 12; // JAVA
static const int LG_ENCODING_915 = 12; // JAVA
static const int LG_ENCODING_ISO_8859_5 = 12; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_5_1988 = 12; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP915 = 12; // JAVA
static const int LG_ENCODING_CSISOLATINCYRILLIC = 12; // IANA WINDOWS JAVA
static const int LG_ENCODING_CYRILLIC = 12; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_915 = 12; // IBM* JAVA
static const int LG_ENCODING_IBM_915_P100_1995 = 12; // UTR22*
static const int LG_ENCODING_ISO_IR_144 = 12; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28595 = 12; // WINDOWS*

// ibm-1089_P100-1995
static const int LG_ENCODING_1089 = 13; // JAVA
static const int LG_ENCODING_8859_6 = 13; // JAVA
static const int LG_ENCODING_ASMO_708 = 13; // IANA JAVA
static const int LG_ENCODING_ECMA_114 = 13; // IANA JAVA
static const int LG_ENCODING_ISO_8859_6 = 13; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_6_E = 13; // IANA MIME
static const int LG_ENCODING_ISO_8859_6_I = 13; // IANA MIME
static const int LG_ENCODING_ISO_8859_6_1987 = 13; // IANA* WINDOWS JAVA
static const int LG_ENCODING_ARABIC = 13; // IANA WINDOWS JAVA
static const int LG_ENCODING_CP1089 = 13; // JAVA
static const int LG_ENCODING_CSISOLATINARABIC = 13; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_1089 = 13; // IBM* JAVA
static const int LG_ENCODING_IBM_1089_P100_1995 = 13; // UTR22*
static const int LG_ENCODING_ISO_IR_127 = 13; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28596 = 13; // WINDOWS*
static const int LG_ENCODING_X_ISO_8859_6S = 13; // JAVA

// ibm-9005_X110-2007
static const int LG_ENCODING_8859_7 = 14; // JAVA
static const int LG_ENCODING_ECMA_118 = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_ELOT_928 = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_ISO_8859_7 = 14; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_7_1987 = 14; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CSISOLATINGREEK = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_GREEK = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_GREEK8 = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_9005 = 14; // IBM*
static const int LG_ENCODING_IBM_9005_X110_2007 = 14; // UTR22*
static const int LG_ENCODING_ISO_IR_126 = 14; // IANA WINDOWS JAVA
static const int LG_ENCODING_SUN_EU_GREEK = 14;
static const int LG_ENCODING_WINDOWS_28597 = 14; // WINDOWS*

// ibm-813_P100-1995
static const int LG_ENCODING_813 = 15; // JAVA
static const int LG_ENCODING_CP813 = 15; // JAVA
static const int LG_ENCODING_IBM_813 = 15; // IBM* JAVA*
static const int LG_ENCODING_IBM_813_P100_1995 = 15; // UTR22*

// ibm-5012_P100-1999
static const int LG_ENCODING_8859_8 = 16; // JAVA
static const int LG_ENCODING_ISO_8859_8 = 16; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_8_E = 16; // IANA MIME
static const int LG_ENCODING_ISO_8859_8_I = 16; // IANA MIME
static const int LG_ENCODING_ISO_8859_8_1988 = 16; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CSISOLATINHEBREW = 16; // IANA WINDOWS JAVA
static const int LG_ENCODING_HEBREW = 16; // IANA WINDOWS JAVA
static const int LG_ENCODING_HEBREW8 = 16;
static const int LG_ENCODING_IBM_5012 = 16; // IBM*
static const int LG_ENCODING_IBM_5012_P100_1999 = 16; // UTR22*
static const int LG_ENCODING_ISO_IR_138 = 16; // IANA WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_28598 = 16; // WINDOWS*

// ibm-916_P100-1995
static const int LG_ENCODING_916 = 17; // JAVA
static const int LG_ENCODING_CP916 = 17; // JAVA
static const int LG_ENCODING_IBM_916 = 17; // IBM* JAVA*
static const int LG_ENCODING_IBM_916_P100_1995 = 17; // UTR22*

// ibm-920_P100-1995
static const int LG_ENCODING_8859_9 = 18; // JAVA
static const int LG_ENCODING_920 = 18; // JAVA
static const int LG_ENCODING_ECMA_128 = 18;
static const int LG_ENCODING_ISO_8859_9 = 18; // IANA MIME* WINDOWS JAVA*
static const int LG_ENCODING_ISO_8859_9_1989 = 18; // IANA* WINDOWS
static const int LG_ENCODING_CP920 = 18; // JAVA
static const int LG_ENCODING_CSISOLATIN5 = 18; // IANA JAVA
static const int LG_ENCODING_IBM_920 = 18; // IBM* JAVA
static const int LG_ENCODING_IBM_920_P100_1995 = 18; // UTR22*
static const int LG_ENCODING_ISO_IR_148 = 18; // IANA WINDOWS JAVA
static const int LG_ENCODING_L5 = 18; // IANA WINDOWS JAVA
static const int LG_ENCODING_LATIN5 = 18; // IANA WINDOWS JAVA
static const int LG_ENCODING_TURKISH = 18;
static const int LG_ENCODING_TURKISH8 = 18;
static const int LG_ENCODING_WINDOWS_28599 = 18; // WINDOWS*

// iso-8859_10-1998
static const int LG_ENCODING_ISO_8859_10 = 19; // IANA* MIME*
static const int LG_ENCODING_ISO_8859_10_1992 = 19; // IANA
static const int LG_ENCODING_CSISOLATIN6 = 19; // IANA
static const int LG_ENCODING_ISO_8859_10_1998 = 19; // UTR22*
static const int LG_ENCODING_ISO_IR_157 = 19; // IANA
static const int LG_ENCODING_L6 = 19; // IANA
static const int LG_ENCODING_LATIN6 = 19; // IANA

// iso-8859_11-2001
static const int LG_ENCODING_ISO_8859_11 = 20;
static const int LG_ENCODING_ISO_8859_11_2001 = 20; // UTR22*
static const int LG_ENCODING_THAI8 = 20;
static const int LG_ENCODING_X_ISO_8859_11 = 20; // JAVA*

// ibm-921_P100-1995
static const int LG_ENCODING_8859_13 = 21; // JAVA
static const int LG_ENCODING_921 = 21;
static const int LG_ENCODING_ISO_8859_13 = 21; // IANA* MIME* JAVA*
static const int LG_ENCODING_CP921 = 21;
static const int LG_ENCODING_IBM_921 = 21; // IBM*
static const int LG_ENCODING_IBM_921_P100_1995 = 21; // UTR22*
static const int LG_ENCODING_WINDOWS_28603 = 21; // WINDOWS*
static const int LG_ENCODING_X_IBM921 = 21; // JAVA

// iso-8859_14-1998
static const int LG_ENCODING_ISO_8859_14 = 22; // IANA*
static const int LG_ENCODING_ISO_8859_14_1998 = 22; // IANA UTR22*
static const int LG_ENCODING_ISO_CELTIC = 22; // IANA
static const int LG_ENCODING_ISO_IR_199 = 22; // IANA
static const int LG_ENCODING_L8 = 22; // IANA
static const int LG_ENCODING_LATIN8 = 22; // IANA

// ibm-923_P100-1998
static const int LG_ENCODING_8859_15 = 23; // JAVA
static const int LG_ENCODING_923 = 23; // JAVA
static const int LG_ENCODING_ISO_8859_15 = 23; // IANA* MIME* WINDOWS JAVA*
static const int LG_ENCODING_LATIN_9 = 23; // IANA WINDOWS
static const int LG_ENCODING_CP923 = 23; // JAVA
static const int LG_ENCODING_CSISOLATIN0 = 23; // JAVA
static const int LG_ENCODING_CSISOLATIN9 = 23; // JAVA
static const int LG_ENCODING_IBM_923 = 23; // IBM* JAVA
static const int LG_ENCODING_IBM_923_P100_1998 = 23; // UTR22*
static const int LG_ENCODING_ISO8859_15_FDIS = 23; // JAVA
static const int LG_ENCODING_L9 = 23; // WINDOWS
static const int LG_ENCODING_LATIN0 = 23; // JAVA
static const int LG_ENCODING_WINDOWS_28605 = 23; // WINDOWS*

// ibm-942_P12A-1999
static const int LG_ENCODING_CP932 = 24;
static const int LG_ENCODING_IBM_932 = 24; // IBM
static const int LG_ENCODING_IBM_932_VSUB_VPUA = 24;
static const int LG_ENCODING_IBM_942 = 24; // IBM*
static const int LG_ENCODING_IBM_942_P12A_1999 = 24; // UTR22*
static const int LG_ENCODING_IBM_942_VSUB_VPUA = 24;
static const int LG_ENCODING_SHIFT_JIS78 = 24;
static const int LG_ENCODING_SJIS78 = 24;
static const int LG_ENCODING_X_IBM942 = 24; // JAVA*
static const int LG_ENCODING_X_IBM942C = 24; // JAVA

// ibm-943_P15A-2003
static const int LG_ENCODING_IBM_943C = 25;
static const int LG_ENCODING_MS_KANJI = 25; // IANA WINDOWS JAVA
static const int LG_ENCODING_SHIFT_JIS = 25; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_CP943C = 25; // JAVA*
static const int LG_ENCODING_CSSHIFTJIS = 25; // IANA WINDOWS JAVA
static const int LG_ENCODING_CSWINDOWS31J = 25; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_943 = 25;
static const int LG_ENCODING_IBM_943_P15A_2003 = 25; // UTR22*
static const int LG_ENCODING_IBM_943_VSUB_VPUA = 25;
static const int LG_ENCODING_MS932 = 25;
static const int LG_ENCODING_PCK = 25;
static const int LG_ENCODING_SJIS = 25;
static const int LG_ENCODING_WINDOWS_31J = 25; // IANA JAVA
static const int LG_ENCODING_WINDOWS_932 = 25; // WINDOWS*
static const int LG_ENCODING_X_JISAUTODETECT = 25; // JAVA
static const int LG_ENCODING_X_MS932_0213 = 25; // JAVA
static const int LG_ENCODING_X_MS_CP932 = 25; // WINDOWS
static const int LG_ENCODING_X_SJIS = 25; // WINDOWS JAVA

// ibm-943_P130-1999
static const int LG_ENCODING_943 = 26; // JAVA
static const int LG_ENCODING_CP943 = 26; // JAVA*
static const int LG_ENCODING_IBM_943_P130_1999 = 26; // UTR22*
static const int LG_ENCODING_IBM_943_VASCII_VSUB_VPUA = 26;
static const int LG_ENCODING_X_IBM943 = 26; // JAVA

// ibm-33722_P12A_P12A-2009_U2
static const int LG_ENCODING_IBM_EUCJP = 27;
static const int LG_ENCODING_IBM_33722 = 27;
static const int LG_ENCODING_IBM_33722_P12A_P12A_2009_U2 = 27; // UTR22*
static const int LG_ENCODING_IBM_33722_VPUA = 27;
static const int LG_ENCODING_IBM_5050 = 27;

// ibm-33722_P120-1999
static const int LG_ENCODING_33722 = 28; // JAVA
static const int LG_ENCODING_CP33722 = 28; // JAVA*
static const int LG_ENCODING_IBM_33722_P120_1999 = 28; // UTR22*
static const int LG_ENCODING_IBM_33722_VASCII_VPUA = 28;
static const int LG_ENCODING_X_IBM33722 = 28; // JAVA
static const int LG_ENCODING_X_IBM33722A = 28; // JAVA
static const int LG_ENCODING_X_IBM33722C = 28; // JAVA

// ibm-954_P101-2007
static const int LG_ENCODING_IBM_954 = 29; // IBM*
static const int LG_ENCODING_IBM_954_P101_2007 = 29; // UTR22*
static const int LG_ENCODING_X_IBM954 = 29; // JAVA*
static const int LG_ENCODING_X_IBM954C = 29; // JAVA

// euc-jp-2007
static const int LG_ENCODING_EUC_JP = 30; // IANA MIME* WINDOWS* JAVA*
static const int LG_ENCODING_EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE = 30; // IANA* WINDOWS JAVA
static const int LG_ENCODING_X_EUC_JP = 30; // MIME WINDOWS JAVA
static const int LG_ENCODING_CSEUCPKDFMTJAPANESE = 30; // IANA WINDOWS JAVA
static const int LG_ENCODING_EUC_JP_2007 = 30; // UTR22*
static const int LG_ENCODING_EUCJIS = 30; // JAVA
static const int LG_ENCODING_UJIS = 30;

// ibm-1373_P100-2002
static const int LG_ENCODING_IBM_1373 = 31; // IBM*
static const int LG_ENCODING_IBM_1373_P100_2002 = 31; // UTR22*
static const int LG_ENCODING_WINDOWS_950 = 31;

// windows-950-2000
static const int LG_ENCODING_BIG5 = 32; // IANA* MIME* WINDOWS JAVA*
static const int LG_ENCODING_CSBIG5 = 32; // IANA WINDOWS
static const int LG_ENCODING_MS950 = 32;
static const int LG_ENCODING_WINDOWS_950_2000 = 32; // UTR22*
static const int LG_ENCODING_X_BIG5 = 32;
static const int LG_ENCODING_X_WINDOWS_950 = 32; // JAVA

// ibm-950_P110-1999
static const int LG_ENCODING_950 = 33; // JAVA
static const int LG_ENCODING_CP950 = 33; // JAVA*
static const int LG_ENCODING_IBM_950 = 33; // IBM* JAVA
static const int LG_ENCODING_IBM_950_P110_1999 = 33; // UTR22*
static const int LG_ENCODING_X_IBM950 = 33; // JAVA

// ibm-1375_P100-2008
static const int LG_ENCODING_BIG5_HKSCS = 34; // IANA* JAVA*
static const int LG_ENCODING_HKSCS_BIG5 = 34;
static const int LG_ENCODING_BIG5HK = 34; // JAVA
static const int LG_ENCODING_IBM_1375 = 34; // IBM*
static const int LG_ENCODING_IBM_1375_P100_2008 = 34; // UTR22*

// ibm-5471_P100-2006
static const int LG_ENCODING_MS950_HKSCS = 35; // JAVA*
static const int LG_ENCODING_BIG5_HKSCS_UNICODE3_0 = 35;
static const int LG_ENCODING_HKBIG5 = 35;
static const int LG_ENCODING_IBM_5471 = 35; // IBM*
static const int LG_ENCODING_IBM_5471_P100_2006 = 35; // UTR22*
static const int LG_ENCODING_X_MS950_HKSCS = 35; // JAVA

// ibm-1386_P100-2001
static const int LG_ENCODING_CP1386 = 36;
static const int LG_ENCODING_IBM_1386 = 36; // IBM*
static const int LG_ENCODING_IBM_1386_P100_2001 = 36; // UTR22*
static const int LG_ENCODING_IBM_1386_VSUB_VPUA = 36;
static const int LG_ENCODING_WINDOWS_936 = 36;

// windows-936-2000
static const int LG_ENCODING_CP936 = 37; // IANA JAVA
static const int LG_ENCODING_GBK = 37; // IANA* WINDOWS JAVA*
static const int LG_ENCODING_MS936 = 37; // IANA
static const int LG_ENCODING_WINDOWS_936_2000 = 37; // UTR22*

// ibm-1383_P110-1999
static const int LG_ENCODING_1383 = 38; // JAVA
static const int LG_ENCODING_EUC_CN = 38;
static const int LG_ENCODING_GB2312 = 38; // IANA* MIME*
static const int LG_ENCODING_CP1383 = 38; // JAVA*
static const int LG_ENCODING_CSGB2312 = 38; // IANA
static const int LG_ENCODING_HP15CN = 38;
static const int LG_ENCODING_IBM_1383 = 38; // IBM* JAVA
static const int LG_ENCODING_IBM_1383_P110_1999 = 38; // UTR22*
static const int LG_ENCODING_IBM_1383_VPUA = 38;
static const int LG_ENCODING_IBM_EUCCN = 38;

// ibm-5478_P100-1995
static const int LG_ENCODING_GB2312_1980_0 = 39;
static const int LG_ENCODING_GB_2312_80 = 39; // IANA*
static const int LG_ENCODING_CHINESE = 39; // IANA
static const int LG_ENCODING_CSISO58GB231280 = 39; // IANA
static const int LG_ENCODING_GB2312_1980 = 39;
static const int LG_ENCODING_IBM_5478 = 39; // IBM*
static const int LG_ENCODING_IBM_5478_P100_1995 = 39; // UTR22*
static const int LG_ENCODING_ISO_IR_58 = 39; // IANA

// euc-tw-2014
static const int LG_ENCODING_EUC_TW = 40;
static const int LG_ENCODING_EUC_TW_2014 = 40; // UTR22*

// ibm-964_P110-1999
static const int LG_ENCODING_964 = 41; // JAVA
static const int LG_ENCODING_CNS11643 = 41;
static const int LG_ENCODING_CP964 = 41; // JAVA*
static const int LG_ENCODING_IBM_964 = 41; // IBM* JAVA
static const int LG_ENCODING_IBM_964_P110_1999 = 41; // UTR22*
static const int LG_ENCODING_IBM_964_VPUA = 41;
static const int LG_ENCODING_IBM_EUCTW = 41;
static const int LG_ENCODING_X_IBM964 = 41; // JAVA

// ibm-949_P110-1999
static const int LG_ENCODING_949 = 42; // JAVA
static const int LG_ENCODING_CP949 = 42; // JAVA*
static const int LG_ENCODING_IBM_949 = 42; // IBM* JAVA
static const int LG_ENCODING_IBM_949_P110_1999 = 42; // UTR22*
static const int LG_ENCODING_IBM_949_VASCII_VSUB_VPUA = 42;
static const int LG_ENCODING_X_IBM949 = 42; // JAVA

// ibm-949_P11A-1999
static const int LG_ENCODING_IBM_949C = 43; // JAVA
static const int LG_ENCODING_CP949C = 43; // JAVA*
static const int LG_ENCODING_IBM_949_P11A_1999 = 43; // UTR22*
static const int LG_ENCODING_IBM_949_VSUB_VPUA = 43;
static const int LG_ENCODING_X_IBM949C = 43; // JAVA

// ibm-970_P110_P110-2006_U2
static const int LG_ENCODING_5601 = 44; // JAVA
static const int LG_ENCODING_970 = 44; // JAVA
static const int LG_ENCODING_EUC_KR = 44; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_KSC_5601 = 44; // JAVA
static const int LG_ENCODING_KS_C_5601_1987 = 44; // JAVA
static const int LG_ENCODING_CP970 = 44; // JAVA*
static const int LG_ENCODING_CSEUCKR = 44; // IANA WINDOWS
static const int LG_ENCODING_IBM_970 = 44; // IBM* JAVA
static const int LG_ENCODING_IBM_970_P110_P110_2006_U2 = 44; // UTR22*
static const int LG_ENCODING_IBM_970_VPUA = 44;
static const int LG_ENCODING_IBM_EUCKR = 44; // JAVA
static const int LG_ENCODING_WINDOWS_51949 = 44; // WINDOWS*
static const int LG_ENCODING_X_IBM970 = 44; // JAVA

// ibm-971_P100-1995
static const int LG_ENCODING_IBM_971 = 45; // IBM*
static const int LG_ENCODING_IBM_971_P100_1995 = 45;
static const int LG_ENCODING_IBM_971_VPUA = 45;
static const int LG_ENCODING_X_IBM971 = 45; // JAVA*

// ibm-1363_P11B-1998
static const int LG_ENCODING_KS_C_5601_1989 = 46; // IANA
static const int LG_ENCODING_CP1363 = 46; // MIME*
static const int LG_ENCODING_CSKSC56011987 = 46; // IANA
static const int LG_ENCODING_IBM_1363 = 46;
static const int LG_ENCODING_IBM_1363_P11B_1998 = 46; // UTR22*
static const int LG_ENCODING_IBM_1363_VSUB_VPUA = 46;
static const int LG_ENCODING_ISO_IR_149 = 46; // IANA
static const int LG_ENCODING_KOREAN = 46; // IANA
static const int LG_ENCODING_KSC = 46;
static const int LG_ENCODING_WINDOWS_949 = 46;
static const int LG_ENCODING_X_IBM1363C = 46; // JAVA*

// ibm-1363_P110-1997
static const int LG_ENCODING_IBM_1363_P110_1997 = 47; // UTR22*
static const int LG_ENCODING_IBM_1363_VASCII_VSUB_VPUA = 47;
static const int LG_ENCODING_X_IBM1363 = 47; // JAVA*

// windows-949-2000
static const int LG_ENCODING_MS949 = 48; // JAVA
static const int LG_ENCODING_WINDOWS_949_2000 = 48; // UTR22*
static const int LG_ENCODING_X_KSC5601 = 48; // JAVA

// windows-874-2000
static const int LG_ENCODING_MS874 = 49; // JAVA
static const int LG_ENCODING_TIS_620 = 49; // WINDOWS
static const int LG_ENCODING_WINDOWS_874 = 49; // WINDOWS* JAVA*
static const int LG_ENCODING_WINDOWS_874_2000 = 49; // UTR22*
static const int LG_ENCODING_X_WINDOWS_874 = 49; // JAVA

// ibm-874_P100-1995
static const int LG_ENCODING_CP874 = 50; // JAVA*
static const int LG_ENCODING_EUCTH = 50;
static const int LG_ENCODING_IBM_874 = 50; // IBM* JAVA
static const int LG_ENCODING_IBM_874_P100_1995 = 50; // UTR22*
static const int LG_ENCODING_IBM_9066 = 50; // IBM
static const int LG_ENCODING_TIS620_2533 = 50; // JAVA
static const int LG_ENCODING_X_IBM874 = 50; // JAVA

// ibm-1162_P100-1999
static const int LG_ENCODING_IBM_1162 = 51; // IBM*
static const int LG_ENCODING_IBM_1162_P100_1999 = 51; // UTR22*

// ibm-437_P100-1995
static const int LG_ENCODING_437 = 52; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM437 = 52; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP437 = 52; // IANA WINDOWS JAVA*
static const int LG_ENCODING_CSPC8CODEPAGE437 = 52; // IANA JAVA
static const int LG_ENCODING_IBM_437 = 52; // IBM*
static const int LG_ENCODING_IBM_437_P100_1995 = 52; // UTR22*
static const int LG_ENCODING_WINDOWS_437 = 52; // WINDOWS*

// ibm-720_P100-1997
static const int LG_ENCODING_DOS_720 = 53; // WINDOWS
static const int LG_ENCODING_IBM_720 = 53; // IBM*
static const int LG_ENCODING_IBM_720_P100_1997 = 53; // UTR22*
static const int LG_ENCODING_WINDOWS_720 = 53; // WINDOWS*
static const int LG_ENCODING_X_IBM720 = 53; // JAVA*

// ibm-737_P100-1997
static const int LG_ENCODING_737 = 54; // JAVA
static const int LG_ENCODING_IBM737 = 54; // WINDOWS JAVA
static const int LG_ENCODING_CP737 = 54; // JAVA*
static const int LG_ENCODING_IBM_737 = 54; // IBM*
static const int LG_ENCODING_IBM_737_P100_1997 = 54; // UTR22*
static const int LG_ENCODING_WINDOWS_737 = 54; // WINDOWS*
static const int LG_ENCODING_X_IBM737 = 54; // JAVA

// ibm-775_P100-1996
static const int LG_ENCODING_775 = 55; // JAVA
static const int LG_ENCODING_IBM775 = 55; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP775 = 55; // IANA WINDOWS JAVA*
static const int LG_ENCODING_CSPC775BALTIC = 55; // IANA
static const int LG_ENCODING_IBM_775 = 55; // IBM*
static const int LG_ENCODING_IBM_775_P100_1996 = 55; // UTR22*
static const int LG_ENCODING_WINDOWS_775 = 55; // WINDOWS*

// ibm-850_P100-1995
static const int LG_ENCODING_850 = 56; // IANA JAVA
static const int LG_ENCODING_IBM850 = 56; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_CP850 = 56; // IANA MIME WINDOWS JAVA*
static const int LG_ENCODING_CSPC850MULTILINGUAL = 56; // IANA JAVA
static const int LG_ENCODING_IBM_850 = 56; // IBM*
static const int LG_ENCODING_IBM_850_P100_1995 = 56; // UTR22*
static const int LG_ENCODING_WINDOWS_850 = 56; // WINDOWS*

// ibm-851_P100-1995
static const int LG_ENCODING_851 = 57; // IANA
static const int LG_ENCODING_IBM851 = 57; // IANA*
static const int LG_ENCODING_CP851 = 57; // IANA MIME*
static const int LG_ENCODING_CSPC851 = 57; // IANA
static const int LG_ENCODING_IBM_851 = 57; // IBM*
static const int LG_ENCODING_IBM_851_P100_1995 = 57; // UTR22*

// ibm-852_P100-1995
static const int LG_ENCODING_852 = 58; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM852 = 58; // IANA* WINDOWS JAVA
static const int LG_ENCODING_CP852 = 58; // IANA WINDOWS JAVA*
static const int LG_ENCODING_CSPCP852 = 58; // IANA JAVA
static const int LG_ENCODING_IBM_852 = 58; // IBM*
static const int LG_ENCODING_IBM_852_P100_1995 = 58; // UTR22*
static const int LG_ENCODING_WINDOWS_852 = 58; // WINDOWS*

// ibm-855_P100-1995
static const int LG_ENCODING_855 = 59; // IANA
static const int LG_ENCODING_IBM855 = 59; // IANA* JAVA
static const int LG_ENCODING_CP855 = 59; // IANA JAVA*
static const int LG_ENCODING_CSIBM855 = 59; // IANA
static const int LG_ENCODING_CSPCP855 = 59; // JAVA
static const int LG_ENCODING_IBM_855 = 59; // IBM*
static const int LG_ENCODING_IBM_855_P100_1995 = 59; // UTR22*
static const int LG_ENCODING_WINDOWS_855 = 59; // WINDOWS*

// ibm-856_P100-1995
static const int LG_ENCODING_856 = 60; // JAVA
static const int LG_ENCODING_IBM856 = 60; // JAVA
static const int LG_ENCODING_CP856 = 60; // JAVA*
static const int LG_ENCODING_IBM_856 = 60; // IBM*
static const int LG_ENCODING_IBM_856_P100_1995 = 60; // UTR22*
static const int LG_ENCODING_X_IBM856 = 60; // JAVA

// ibm-857_P100-1995
static const int LG_ENCODING_857 = 61; // IANA JAVA
static const int LG_ENCODING_IBM857 = 61; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_CP857 = 61; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM857 = 61; // IANA JAVA
static const int LG_ENCODING_IBM_857 = 61; // IBM*
static const int LG_ENCODING_IBM_857_P100_1995 = 61; // UTR22*
static const int LG_ENCODING_WINDOWS_857 = 61; // WINDOWS*

// ibm-858_P100-1997
static const int LG_ENCODING_CCSID00858 = 62; // IANA JAVA
static const int LG_ENCODING_CP00858 = 62; // IANA JAVA
static const int LG_ENCODING_IBM00858 = 62; // IANA* MIME* JAVA
static const int LG_ENCODING_PC_MULTILINGUAL_850_EURO = 62; // IANA
static const int LG_ENCODING_CP858 = 62; // MIME JAVA*
static const int LG_ENCODING_IBM_858 = 62; // IBM*
static const int LG_ENCODING_IBM_858_P100_1997 = 62; // UTR22*
static const int LG_ENCODING_WINDOWS_858 = 62; // WINDOWS*

// ibm-860_P100-1995
static const int LG_ENCODING_860 = 63; // IANA JAVA
static const int LG_ENCODING_IBM860 = 63; // IANA* MIME* JAVA
static const int LG_ENCODING_CP860 = 63; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM860 = 63; // IANA JAVA
static const int LG_ENCODING_IBM_860 = 63; // IBM*
static const int LG_ENCODING_IBM_860_P100_1995 = 63; // UTR22*

// ibm-861_P100-1995
static const int LG_ENCODING_861 = 64; // IANA JAVA
static const int LG_ENCODING_IBM861 = 64; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_CP_IS = 64; // IANA JAVA
static const int LG_ENCODING_CP861 = 64; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM861 = 64; // IANA JAVA
static const int LG_ENCODING_IBM_861 = 64; // IBM*
static const int LG_ENCODING_IBM_861_P100_1995 = 64; // UTR22*
static const int LG_ENCODING_WINDOWS_861 = 64; // WINDOWS*

// ibm-862_P100-1995
static const int LG_ENCODING_862 = 65; // IANA JAVA
static const int LG_ENCODING_DOS_862 = 65; // WINDOWS
static const int LG_ENCODING_IBM862 = 65; // IANA* MIME* JAVA
static const int LG_ENCODING_CP862 = 65; // IANA MIME JAVA*
static const int LG_ENCODING_CSPC862LATINHEBREW = 65; // IANA JAVA
static const int LG_ENCODING_IBM_862 = 65; // IBM*
static const int LG_ENCODING_IBM_862_P100_1995 = 65; // UTR22*
static const int LG_ENCODING_WINDOWS_862 = 65; // WINDOWS*

// ibm-863_P100-1995
static const int LG_ENCODING_863 = 66; // IANA JAVA
static const int LG_ENCODING_IBM863 = 66; // IANA* MIME* JAVA
static const int LG_ENCODING_CP863 = 66; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM863 = 66; // IANA JAVA
static const int LG_ENCODING_IBM_863 = 66; // IBM*
static const int LG_ENCODING_IBM_863_P100_1995 = 66; // UTR22*

// ibm-864_X110-1999
static const int LG_ENCODING_IBM864 = 67; // IANA* MIME* JAVA
static const int LG_ENCODING_CP864 = 67; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM864 = 67; // IANA JAVA
static const int LG_ENCODING_IBM_864 = 67; // IBM*
static const int LG_ENCODING_IBM_864_X110_1999 = 67; // UTR22*

// ibm-865_P100-1995
static const int LG_ENCODING_865 = 68; // IANA JAVA
static const int LG_ENCODING_IBM865 = 68; // IANA* MIME* JAVA
static const int LG_ENCODING_CP865 = 68; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM865 = 68; // IANA JAVA
static const int LG_ENCODING_IBM_865 = 68; // IBM*
static const int LG_ENCODING_IBM_865_P100_1995 = 68; // UTR22*

// ibm-866_P100-1995
static const int LG_ENCODING_866 = 69; // IANA JAVA
static const int LG_ENCODING_IBM866 = 69; // IANA* MIME* JAVA
static const int LG_ENCODING_CP866 = 69; // IANA MIME WINDOWS JAVA*
static const int LG_ENCODING_CSIBM866 = 69; // IANA JAVA
static const int LG_ENCODING_IBM_866 = 69; // IBM*
static const int LG_ENCODING_IBM_866_P100_1995 = 69; // UTR22*
static const int LG_ENCODING_WINDOWS_866 = 69; // WINDOWS*

// ibm-867_P100-1998
static const int LG_ENCODING_IBM_867 = 70; // IBM*
static const int LG_ENCODING_IBM_867_P100_1998 = 70; // UTR22*
static const int LG_ENCODING_X_IBM867 = 70; // JAVA*

// ibm-868_P100-1995
static const int LG_ENCODING_868 = 71; // JAVA
static const int LG_ENCODING_CP868 = 71; // IANA MIME JAVA*
static const int LG_ENCODING_IBM868 = 71; // IANA* MIME* JAVA
static const int LG_ENCODING_CP_AR = 71; // IANA
static const int LG_ENCODING_CSIBM868 = 71; // IANA
static const int LG_ENCODING_IBM_868 = 71; // IBM*
static const int LG_ENCODING_IBM_868_P100_1995 = 71; // UTR22*

// ibm-869_P100-1995
static const int LG_ENCODING_869 = 72; // IANA JAVA
static const int LG_ENCODING_IBM869 = 72; // IANA* MIME* WINDOWS JAVA
static const int LG_ENCODING_CP_GR = 72; // IANA JAVA
static const int LG_ENCODING_CP869 = 72; // IANA MIME JAVA*
static const int LG_ENCODING_CSIBM869 = 72; // IANA JAVA
static const int LG_ENCODING_IBM_869 = 72; // IBM*
static const int LG_ENCODING_IBM_869_P100_1995 = 72; // UTR22*
static const int LG_ENCODING_WINDOWS_869 = 72; // WINDOWS*

// ibm-878_P100-1996
static const int LG_ENCODING_KOI8_R = 73; // IANA* MIME* WINDOWS JAVA*
static const int LG_ENCODING_CP878 = 73;
static const int LG_ENCODING_CSKOI8R = 73; // IANA WINDOWS JAVA
static const int LG_ENCODING_IBM_878 = 73; // IBM*
static const int LG_ENCODING_IBM_878_P100_1996 = 73; // UTR22*
static const int LG_ENCODING_KOI8 = 73; // WINDOWS JAVA
static const int LG_ENCODING_WINDOWS_20866 = 73; // WINDOWS*

// ibm-901_P100-1999
static const int LG_ENCODING_IBM_901 = 74; // IBM*
static const int LG_ENCODING_IBM_901_P100_1999 = 74; // UTR22*

// ibm-902_P100-1999
static const int LG_ENCODING_IBM_902 = 75; // IBM*
static const int LG_ENCODING_IBM_902_P100_1999 = 75; // UTR22*

// ibm-922_P100-1999
static const int LG_ENCODING_922 = 76; // JAVA
static const int LG_ENCODING_IBM922 = 76; // JAVA
static const int LG_ENCODING_CP922 = 76; // JAVA*
static const int LG_ENCODING_IBM_922 = 76; // IBM*
static const int LG_ENCODING_IBM_922_P100_1999 = 76; // UTR22*
static const int LG_ENCODING_X_IBM922 = 76; // JAVA

// ibm-1168_P100-2002
static const int LG_ENCODING_KOI8_U = 77; // IANA* WINDOWS
static const int LG_ENCODING_IBM_1168 = 77; // IBM*
static const int LG_ENCODING_IBM_1168_P100_2002 = 77; // UTR22*
static const int LG_ENCODING_WINDOWS_21866 = 77; // WINDOWS*

// ibm-4909_P100-1999
static const int LG_ENCODING_IBM_4909 = 78; // IBM*
static const int LG_ENCODING_IBM_4909_P100_1999 = 78; // UTR22*

// ibm-5346_P100-1998
static const int LG_ENCODING_CP1250 = 79; // WINDOWS JAVA
static const int LG_ENCODING_IBM_5346 = 79; // IBM*
static const int LG_ENCODING_IBM_5346_P100_1998 = 79; // UTR22*
static const int LG_ENCODING_WINDOWS_1250 = 79; // IANA* WINDOWS* JAVA*

// ibm-5347_P100-1998
static const int LG_ENCODING_ANSI1251 = 80;
static const int LG_ENCODING_CP1251 = 80; // WINDOWS JAVA
static const int LG_ENCODING_IBM_5347 = 80; // IBM*
static const int LG_ENCODING_IBM_5347_P100_1998 = 80; // UTR22*
static const int LG_ENCODING_WINDOWS_1251 = 80; // IANA* WINDOWS* JAVA*

// ibm-5348_P100-1997
static const int LG_ENCODING_CP1252 = 81; // JAVA
static const int LG_ENCODING_IBM_5348 = 81; // IBM*
static const int LG_ENCODING_IBM_5348_P100_1997 = 81; // UTR22*
static const int LG_ENCODING_WINDOWS_1252 = 81; // IANA* WINDOWS* JAVA*

// ibm-5349_P100-1998
static const int LG_ENCODING_CP1253 = 82; // JAVA
static const int LG_ENCODING_IBM_5349 = 82; // IBM*
static const int LG_ENCODING_IBM_5349_P100_1998 = 82; // UTR22*
static const int LG_ENCODING_WINDOWS_1253 = 82; // IANA* WINDOWS* JAVA*

// ibm-5350_P100-1998
static const int LG_ENCODING_CP1254 = 83; // JAVA
static const int LG_ENCODING_IBM_5350 = 83; // IBM*
static const int LG_ENCODING_IBM_5350_P100_1998 = 83; // UTR22*
static const int LG_ENCODING_WINDOWS_1254 = 83; // IANA* WINDOWS* JAVA*

// ibm-9447_P100-2002
static const int LG_ENCODING_CP1255 = 84; // JAVA
static const int LG_ENCODING_IBM_9447 = 84; // IBM*
static const int LG_ENCODING_IBM_9447_P100_2002 = 84; // UTR22*
static const int LG_ENCODING_WINDOWS_1255 = 84; // IANA* WINDOWS* JAVA*

// ibm-9448_X100-2005
static const int LG_ENCODING_CP1256 = 85; // WINDOWS JAVA
static const int LG_ENCODING_IBM_9448 = 85; // IBM*
static const int LG_ENCODING_IBM_9448_X100_2005 = 85; // UTR22*
static const int LG_ENCODING_WINDOWS_1256 = 85; // IANA* WINDOWS* JAVA*
static const int LG_ENCODING_X_WINDOWS_1256S = 85; // JAVA

// ibm-9449_P100-2002
static const int LG_ENCODING_CP1257 = 86; // JAVA
static const int LG_ENCODING_IBM_9449 = 86; // IBM*
static const int LG_ENCODING_IBM_9449_P100_2002 = 86; // UTR22*
static const int LG_ENCODING_WINDOWS_1257 = 86; // IANA* WINDOWS* JAVA*

// ibm-5354_P100-1998
static const int LG_ENCODING_CP1258 = 87; // JAVA
static const int LG_ENCODING_IBM_5354 = 87; // IBM*
static const int LG_ENCODING_IBM_5354_P100_1998 = 87; // UTR22*
static const int LG_ENCODING_WINDOWS_1258 = 87; // IANA* WINDOWS* JAVA*

// ibm-1250_P100-1995
static const int LG_ENCODING_IBM_1250 = 88; // IBM*
static const int LG_ENCODING_IBM_1250_P100_1995 = 88; // UTR22*

// ibm-1251_P100-1995
static const int LG_ENCODING_IBM_1251 = 89; // IBM*
static const int LG_ENCODING_IBM_1251_P100_1995 = 89; // UTR22*

// ibm-1252_P100-2000
static const int LG_ENCODING_IBM_1252 = 90; // IBM*
static const int LG_ENCODING_IBM_1252_P100_2000 = 90; // UTR22*

// ibm-1253_P100-1995
static const int LG_ENCODING_IBM_1253 = 91; // IBM*
static const int LG_ENCODING_IBM_1253_P100_1995 = 91; // UTR22*

// ibm-1254_P100-1995
static const int LG_ENCODING_IBM_1254 = 92; // IBM*
static const int LG_ENCODING_IBM_1254_P100_1995 = 92; // UTR22*

// ibm-1255_P100-1995
static const int LG_ENCODING_IBM_1255 = 93; // IBM*
static const int LG_ENCODING_IBM_1255_P100_1995 = 93; // UTR22*

// ibm-5351_P100-1998
static const int LG_ENCODING_IBM_5351 = 94; // IBM*
static const int LG_ENCODING_IBM_5351_P100_1998 = 94; // UTR22*

// ibm-1256_P110-1997
static const int LG_ENCODING_IBM_1256 = 95; // IBM*
static const int LG_ENCODING_IBM_1256_P110_1997 = 95; // UTR22*

// ibm-5352_P100-1998
static const int LG_ENCODING_IBM_5352 = 96; // IBM*
static const int LG_ENCODING_IBM_5352_P100_1998 = 96; // UTR22*

// ibm-1257_P100-1995
static const int LG_ENCODING_IBM_1257 = 97; // IBM*
static const int LG_ENCODING_IBM_1257_P100_1995 = 97; // UTR22*

// ibm-5353_P100-1998
static const int LG_ENCODING_IBM_5353 = 98; // IBM*
static const int LG_ENCODING_IBM_5353_P100_1998 = 98; // UTR22*

// ibm-1258_P100-1997
static const int LG_ENCODING_IBM_1258 = 99; // IBM*
static const int LG_ENCODING_IBM_1258_P100_1997 = 99; // UTR22*

// macos-0_2-10.2
static const int LG_ENCODING_CSMACINTOSH = 100; // IANA
static const int LG_ENCODING_MAC = 100; // IANA
static const int LG_ENCODING_MACINTOSH = 100; // IANA* MIME* WINDOWS
static const int LG_ENCODING_MACOS_0_2_10_2 = 100; // UTR22*
static const int LG_ENCODING_MACROMAN = 100; // JAVA
static const int LG_ENCODING_WINDOWS_10000 = 100; // WINDOWS*
static const int LG_ENCODING_X_MACROMAN = 100; // JAVA*

// macos-6_2-10.4
static const int LG_ENCODING_MACGR = 101;
static const int LG_ENCODING_MACOS_6_2_10_4 = 101; // UTR22*
static const int LG_ENCODING_WINDOWS_10006 = 101; // WINDOWS*
static const int LG_ENCODING_X_MACGREEK = 101; // JAVA*
static const int LG_ENCODING_X_MAC_GREEK = 101; // MIME* WINDOWS

// macos-7_3-10.2
static const int LG_ENCODING_MAC_CYRILLIC = 102;
static const int LG_ENCODING_MACCY = 102;
static const int LG_ENCODING_MACOS_7_3_10_2 = 102; // UTR22*
static const int LG_ENCODING_WINDOWS_10007 = 102; // WINDOWS*
static const int LG_ENCODING_X_MACCYRILLIC = 102; // JAVA
static const int LG_ENCODING_X_MACUKRAINE = 102; // JAVA*
static const int LG_ENCODING_X_MAC_CYRILLIC = 102; // MIME* WINDOWS

// macos-29-10.2
static const int LG_ENCODING_MACCE = 103;
static const int LG_ENCODING_MACCENTRALEUROPE = 103;
static const int LG_ENCODING_MACOS_29_10_2 = 103; // UTR22*
static const int LG_ENCODING_WINDOWS_10029 = 103; // WINDOWS*
static const int LG_ENCODING_X_MACCENTRALEUROPE = 103; // JAVA*
static const int LG_ENCODING_X_MAC_CE = 103; // WINDOWS
static const int LG_ENCODING_X_MAC_CENTRALEURROMAN = 103; // MIME*

// macos-35-10.2
static const int LG_ENCODING_MACOS_35_10_2 = 104; // UTR22*
static const int LG_ENCODING_MACTR = 104;
static const int LG_ENCODING_WINDOWS_10081 = 104; // WINDOWS*
static const int LG_ENCODING_X_MACTURKISH = 104; // JAVA*
static const int LG_ENCODING_X_MAC_TURKISH = 104; // MIME* WINDOWS

// ibm-1051_P100-1995
static const int LG_ENCODING_CSHPROMAN8 = 105; // IANA
static const int LG_ENCODING_HP_ROMAN8 = 105; // IANA*
static const int LG_ENCODING_IBM_1051 = 105; // IBM*
static const int LG_ENCODING_IBM_1051_P100_1995 = 105; // UTR22*
static const int LG_ENCODING_R8 = 105; // IANA
static const int LG_ENCODING_ROMAN8 = 105; // IANA
static const int LG_ENCODING_X_ROMAN8 = 105; // JAVA*

// ibm-1276_P100-1995
static const int LG_ENCODING_ADOBE_STANDARD_ENCODING = 106; // IANA*
static const int LG_ENCODING_CSADOBESTANDARDENCODING = 106; // IANA
static const int LG_ENCODING_IBM_1276 = 106; // IBM*
static const int LG_ENCODING_IBM_1276_P100_1995 = 106; // UTR22*

// ibm-1006_P100-1995
static const int LG_ENCODING_1006 = 107; // JAVA
static const int LG_ENCODING_IBM1006 = 107; // JAVA
static const int LG_ENCODING_CP1006 = 107; // JAVA*
static const int LG_ENCODING_IBM_1006 = 107; // IBM*
static const int LG_ENCODING_IBM_1006_P100_1995 = 107; // UTR22*
static const int LG_ENCODING_X_IBM1006 = 107; // JAVA

// ibm-1098_P100-1995
static const int LG_ENCODING_1098 = 108; // JAVA
static const int LG_ENCODING_IBM1098 = 108; // JAVA
static const int LG_ENCODING_CP1098 = 108; // JAVA*
static const int LG_ENCODING_IBM_1098 = 108; // IBM*
static const int LG_ENCODING_IBM_1098_P100_1995 = 108; // UTR22*
static const int LG_ENCODING_X_IBM1098 = 108; // JAVA

// ibm-1124_P100-1996
static const int LG_ENCODING_1124 = 109; // JAVA
static const int LG_ENCODING_CP1124 = 109; // JAVA*
static const int LG_ENCODING_IBM_1124 = 109; // IBM* JAVA
static const int LG_ENCODING_IBM_1124_P100_1996 = 109; // UTR22*
static const int LG_ENCODING_X_IBM1124 = 109; // JAVA

// ibm-1125_P100-1997
static const int LG_ENCODING_CP1125 = 110;
static const int LG_ENCODING_IBM_1125 = 110; // IBM*
static const int LG_ENCODING_IBM_1125_P100_1997 = 110; // UTR22*

// ibm-1129_P100-1997
static const int LG_ENCODING_IBM_1129 = 111; // IBM*
static const int LG_ENCODING_IBM_1129_P100_1997 = 111; // UTR22*

// ibm-1131_P100-1997
static const int LG_ENCODING_CP1131 = 112;
static const int LG_ENCODING_IBM_1131 = 112; // IBM*
static const int LG_ENCODING_IBM_1131_P100_1997 = 112; // UTR22*

// ibm-1133_P100-1997
static const int LG_ENCODING_IBM_1133 = 113; // IBM*
static const int LG_ENCODING_IBM_1133_P100_1997 = 113; // UTR22*

// gsm-03.38-2009
static const int LG_ENCODING_GSM0338 = 114;
static const int LG_ENCODING_GSM_03_38_2009 = 114; // UTR22*

// ibm-37_P100-1995
static const int LG_ENCODING_037 = 115; // JAVA
static const int LG_ENCODING_IBM037 = 115; // IANA* JAVA
static const int LG_ENCODING_CP037 = 115; // JAVA*
static const int LG_ENCODING_CP37 = 115;
static const int LG_ENCODING_CPIBM37 = 115; // JAVA
static const int LG_ENCODING_CSIBM037 = 115; // IANA JAVA
static const int LG_ENCODING_EBCDIC_CP_CA = 115; // IANA JAVA
static const int LG_ENCODING_EBCDIC_CP_NL = 115; // IANA JAVA
static const int LG_ENCODING_EBCDIC_CP_US = 115; // IANA JAVA
static const int LG_ENCODING_EBCDIC_CP_WT = 115; // IANA JAVA
static const int LG_ENCODING_IBM_037 = 115;
static const int LG_ENCODING_IBM_37 = 115; // IBM*
static const int LG_ENCODING_IBM_37_P100_1995 = 115; // UTR22*

// ibm-273_P100-1995
static const int LG_ENCODING_273 = 116; // JAVA
static const int LG_ENCODING_CP273 = 116; // IANA JAVA*
static const int LG_ENCODING_IBM273 = 116; // IANA* JAVA
static const int LG_ENCODING_CSIBM273 = 116; // IANA
static const int LG_ENCODING_EBCDIC_DE = 116;
static const int LG_ENCODING_IBM_273 = 116; // IBM*
static const int LG_ENCODING_IBM_273_P100_1995 = 116; // UTR22*

// ibm-277_P100-1995
static const int LG_ENCODING_277 = 117; // JAVA
static const int LG_ENCODING_EBCDIC_CP_DK = 117; // IANA
static const int LG_ENCODING_EBCDIC_CP_NO = 117; // IANA
static const int LG_ENCODING_IBM277 = 117; // IANA* JAVA
static const int LG_ENCODING_CP277 = 117; // JAVA*
static const int LG_ENCODING_CSIBM277 = 117; // IANA
static const int LG_ENCODING_EBCDIC_DK = 117;
static const int LG_ENCODING_IBM_277 = 117; // IBM*
static const int LG_ENCODING_IBM_277_P100_1995 = 117; // UTR22*

// ibm-278_P100-1995
static const int LG_ENCODING_278 = 118; // JAVA
static const int LG_ENCODING_IBM278 = 118; // IANA* JAVA
static const int LG_ENCODING_CP278 = 118; // JAVA*
static const int LG_ENCODING_CSIBM278 = 118; // IANA
static const int LG_ENCODING_EBCDIC_CP_FI = 118; // IANA
static const int LG_ENCODING_EBCDIC_CP_SE = 118; // IANA
static const int LG_ENCODING_EBCDIC_SV = 118; // JAVA
static const int LG_ENCODING_IBM_278 = 118; // IBM*
static const int LG_ENCODING_IBM_278_P100_1995 = 118; // UTR22*

// ibm-280_P100-1995
static const int LG_ENCODING_280 = 119; // JAVA
static const int LG_ENCODING_CP280 = 119; // IANA JAVA*
static const int LG_ENCODING_IBM280 = 119; // IANA* JAVA
static const int LG_ENCODING_CSIBM280 = 119; // IANA
static const int LG_ENCODING_EBCDIC_CP_IT = 119; // IANA
static const int LG_ENCODING_IBM_280 = 119; // IBM*
static const int LG_ENCODING_IBM_280_P100_1995 = 119; // UTR22*

// ibm-284_P100-1995
static const int LG_ENCODING_284 = 120; // JAVA
static const int LG_ENCODING_CP284 = 120; // IANA JAVA*
static const int LG_ENCODING_IBM284 = 120; // IANA* JAVA
static const int LG_ENCODING_CPIBM284 = 120; // JAVA
static const int LG_ENCODING_CSIBM284 = 120; // IANA
static const int LG_ENCODING_EBCDIC_CP_ES = 120; // IANA
static const int LG_ENCODING_IBM_284 = 120; // IBM*
static const int LG_ENCODING_IBM_284_P100_1995 = 120; // UTR22*

// ibm-285_P100-1995
static const int LG_ENCODING_285 = 121; // JAVA
static const int LG_ENCODING_CP285 = 121; // IANA JAVA*
static const int LG_ENCODING_IBM285 = 121; // IANA* JAVA
static const int LG_ENCODING_CPIBM285 = 121; // JAVA
static const int LG_ENCODING_CSIBM285 = 121; // IANA
static const int LG_ENCODING_EBCDIC_CP_GB = 121; // IANA
static const int LG_ENCODING_EBCDIC_GB = 121; // JAVA
static const int LG_ENCODING_IBM_285 = 121; // IBM*
static const int LG_ENCODING_IBM_285_P100_1995 = 121; // UTR22*

// ibm-290_P100-1995
static const int LG_ENCODING_EBCDIC_JP_KANA = 122; // IANA
static const int LG_ENCODING_IBM290 = 122; // IANA*
static const int LG_ENCODING_CP290 = 122; // IANA
static const int LG_ENCODING_CSIBM290 = 122; // IANA
static const int LG_ENCODING_IBM_290 = 122; // IBM*
static const int LG_ENCODING_IBM_290_P100_1995 = 122; // UTR22*

// ibm-297_P100-1995
static const int LG_ENCODING_297 = 123; // JAVA
static const int LG_ENCODING_IBM297 = 123; // IANA* JAVA
static const int LG_ENCODING_CP297 = 123; // IANA JAVA*
static const int LG_ENCODING_CPIBM297 = 123; // JAVA
static const int LG_ENCODING_CSIBM297 = 123; // IANA
static const int LG_ENCODING_EBCDIC_CP_FR = 123; // IANA
static const int LG_ENCODING_IBM_297 = 123; // IBM*
static const int LG_ENCODING_IBM_297_P100_1995 = 123; // UTR22*

// ibm-420_X120-1999
static const int LG_ENCODING_420 = 124; // JAVA
static const int LG_ENCODING_IBM420 = 124; // IANA* JAVA
static const int LG_ENCODING_CP420 = 124; // IANA JAVA*
static const int LG_ENCODING_CSIBM420 = 124; // IANA
static const int LG_ENCODING_EBCDIC_CP_AR1 = 124; // IANA
static const int LG_ENCODING_IBM_420 = 124; // IBM*
static const int LG_ENCODING_IBM_420_X120_1999 = 124; // UTR22*

// ibm-424_P100-1995
static const int LG_ENCODING_424 = 125; // JAVA
static const int LG_ENCODING_IBM424 = 125; // IANA* JAVA
static const int LG_ENCODING_CP424 = 125; // IANA JAVA*
static const int LG_ENCODING_CSIBM424 = 125; // IANA
static const int LG_ENCODING_EBCDIC_CP_HE = 125; // IANA
static const int LG_ENCODING_IBM_424 = 125; // IBM*
static const int LG_ENCODING_IBM_424_P100_1995 = 125; // UTR22*

// ibm-500_P100-1995
static const int LG_ENCODING_500 = 126;
static const int LG_ENCODING_CP500 = 126; // IANA JAVA*
static const int LG_ENCODING_IBM500 = 126; // IANA* JAVA
static const int LG_ENCODING_CSIBM500 = 126; // IANA
static const int LG_ENCODING_EBCDIC_CP_BE = 126; // IANA
static const int LG_ENCODING_EBCDIC_CP_CH = 126; // IANA
static const int LG_ENCODING_IBM_500 = 126; // IBM*
static const int LG_ENCODING_IBM_500_P100_1995 = 126; // UTR22*

// ibm-803_P100-1999
static const int LG_ENCODING_CP803 = 127;
static const int LG_ENCODING_IBM_803 = 127; // IBM*
static const int LG_ENCODING_IBM_803_P100_1999 = 127; // UTR22*

// ibm-838_P100-1995
static const int LG_ENCODING_838 = 128; // JAVA
static const int LG_ENCODING_IBM_THAI = 128; // IANA* JAVA
static const int LG_ENCODING_IBM838 = 128; // JAVA
static const int LG_ENCODING_CP838 = 128; // JAVA*
static const int LG_ENCODING_CSIBMTHAI = 128; // IANA
static const int LG_ENCODING_IBM_838 = 128; // IBM*
static const int LG_ENCODING_IBM_838_P100_1995 = 128; // UTR22*
static const int LG_ENCODING_IBM_9030 = 128; // IBM

// ibm-870_P100-1995
static const int LG_ENCODING_CP870 = 129; // IANA JAVA*
static const int LG_ENCODING_IBM870 = 129; // IANA* JAVA
static const int LG_ENCODING_CSIBM870 = 129; // IANA
static const int LG_ENCODING_EBCDIC_CP_ROECE = 129; // IANA
static const int LG_ENCODING_EBCDIC_CP_YU = 129; // IANA
static const int LG_ENCODING_IBM_870 = 129; // IBM*
static const int LG_ENCODING_IBM_870_P100_1995 = 129; // UTR22*

// ibm-871_P100-1995
static const int LG_ENCODING_871 = 130; // JAVA
static const int LG_ENCODING_CP871 = 130; // IANA JAVA*
static const int LG_ENCODING_IBM871 = 130; // IANA* JAVA
static const int LG_ENCODING_CSIBM871 = 130; // IANA JAVA
static const int LG_ENCODING_EBCDIC_CP_IS = 130; // IANA JAVA
static const int LG_ENCODING_EBCDIC_IS = 130; // JAVA
static const int LG_ENCODING_IBM_871 = 130; // IBM*
static const int LG_ENCODING_IBM_871_P100_1995 = 130; // UTR22*

// ibm-875_P100-1995
static const int LG_ENCODING_875 = 131; // JAVA
static const int LG_ENCODING_IBM875 = 131; // JAVA
static const int LG_ENCODING_CP875 = 131; // JAVA*
static const int LG_ENCODING_IBM_875 = 131; // IBM*
static const int LG_ENCODING_IBM_875_P100_1995 = 131; // UTR22*
static const int LG_ENCODING_X_IBM875 = 131; // JAVA

// ibm-918_P100-1995
static const int LG_ENCODING_CP918 = 132; // IANA JAVA*
static const int LG_ENCODING_IBM918 = 132; // IANA* JAVA
static const int LG_ENCODING_CSIBM918 = 132; // IANA
static const int LG_ENCODING_EBCDIC_CP_AR2 = 132; // IANA
static const int LG_ENCODING_IBM_918 = 132; // IBM*
static const int LG_ENCODING_IBM_918_P100_1995 = 132; // UTR22*

// ibm-1025_P100-1995
static const int LG_ENCODING_1025 = 133; // JAVA
static const int LG_ENCODING_CP1025 = 133; // JAVA*
static const int LG_ENCODING_IBM_1025 = 133; // IBM* JAVA
static const int LG_ENCODING_IBM_1025_P100_1995 = 133; // UTR22*
static const int LG_ENCODING_X_IBM1025 = 133; // JAVA

// ibm-1026_P100-1995
static const int LG_ENCODING_1026 = 134; // JAVA
static const int LG_ENCODING_CP1026 = 134; // IANA JAVA*
static const int LG_ENCODING_IBM1026 = 134; // IANA* JAVA
static const int LG_ENCODING_CSIBM1026 = 134; // IANA
static const int LG_ENCODING_IBM_1026 = 134; // IBM*
static const int LG_ENCODING_IBM_1026_P100_1995 = 134; // UTR22*

// ibm-1047_P100-1995
static const int LG_ENCODING_1047 = 135; // JAVA
static const int LG_ENCODING_IBM1047 = 135; // IANA* JAVA
static const int LG_ENCODING_CP1047 = 135; // JAVA*
static const int LG_ENCODING_IBM_1047 = 135; // IBM*
static const int LG_ENCODING_IBM_1047_P100_1995 = 135; // UTR22*

// ibm-1097_P100-1995
static const int LG_ENCODING_1097 = 136; // JAVA
static const int LG_ENCODING_CP1097 = 136; // JAVA*
static const int LG_ENCODING_IBM_1097 = 136; // IBM* JAVA
static const int LG_ENCODING_IBM_1097_P100_1995 = 136; // UTR22*
static const int LG_ENCODING_X_IBM1097 = 136; // JAVA

// ibm-1112_P100-1995
static const int LG_ENCODING_1112 = 137; // JAVA
static const int LG_ENCODING_CP1112 = 137; // JAVA*
static const int LG_ENCODING_IBM_1112 = 137; // IBM* JAVA
static const int LG_ENCODING_IBM_1112_P100_1995 = 137; // UTR22*
static const int LG_ENCODING_X_IBM1112 = 137; // JAVA

// ibm-1122_P100-1999
static const int LG_ENCODING_1122 = 138; // JAVA
static const int LG_ENCODING_CP1122 = 138; // JAVA*
static const int LG_ENCODING_IBM_1122 = 138; // IBM* JAVA
static const int LG_ENCODING_IBM_1122_P100_1999 = 138; // UTR22*
static const int LG_ENCODING_X_IBM1122 = 138; // JAVA

// ibm-1123_P100-1995
static const int LG_ENCODING_1123 = 139; // JAVA
static const int LG_ENCODING_CP1123 = 139; // JAVA*
static const int LG_ENCODING_IBM_1123 = 139; // IBM* JAVA
static const int LG_ENCODING_IBM_1123_P100_1995 = 139; // UTR22*
static const int LG_ENCODING_X_IBM1123 = 139; // JAVA

// ibm-1130_P100-1997
static const int LG_ENCODING_IBM_1130 = 140; // IBM*
static const int LG_ENCODING_IBM_1130_P100_1997 = 140; // UTR22*

// ibm-1132_P100-1998
static const int LG_ENCODING_IBM_1132 = 141; // IBM*
static const int LG_ENCODING_IBM_1132_P100_1998 = 141; // UTR22*

// ibm-1137_P100-1999
static const int LG_ENCODING_IBM_1137 = 142; // IBM*
static const int LG_ENCODING_IBM_1137_P100_1999 = 142; // UTR22*

// ibm-4517_P100-2005
static const int LG_ENCODING_IBM_4517 = 143; // IBM*
static const int LG_ENCODING_IBM_4517_P100_2005 = 143; // UTR22*

// ibm-1140_P100-1997
static const int LG_ENCODING_CCSID01140 = 144; // IANA JAVA
static const int LG_ENCODING_CP01140 = 144; // IANA JAVA
static const int LG_ENCODING_IBM01140 = 144; // IANA* JAVA
static const int LG_ENCODING_CP1140 = 144; // JAVA*
static const int LG_ENCODING_EBCDIC_US_37_EURO = 144; // IANA
static const int LG_ENCODING_IBM_1140 = 144; // IBM*
static const int LG_ENCODING_IBM_1140_P100_1997 = 144; // UTR22*

// ibm-1141_P100-1997
static const int LG_ENCODING_CCSID01141 = 145; // IANA JAVA
static const int LG_ENCODING_CP01141 = 145; // IANA JAVA
static const int LG_ENCODING_IBM01141 = 145; // IANA* JAVA
static const int LG_ENCODING_CP1141 = 145; // JAVA*
static const int LG_ENCODING_EBCDIC_DE_273_EURO = 145; // IANA
static const int LG_ENCODING_IBM_1141 = 145; // IBM*
static const int LG_ENCODING_IBM_1141_P100_1997 = 145; // UTR22*

// ibm-1142_P100-1997
static const int LG_ENCODING_CCSID01142 = 146; // IANA JAVA
static const int LG_ENCODING_CP01142 = 146; // IANA JAVA
static const int LG_ENCODING_IBM01142 = 146; // IANA* JAVA
static const int LG_ENCODING_CP1142 = 146; // JAVA*
static const int LG_ENCODING_EBCDIC_DK_277_EURO = 146; // IANA
static const int LG_ENCODING_EBCDIC_NO_277_EURO = 146; // IANA
static const int LG_ENCODING_IBM_1142 = 146; // IBM*
static const int LG_ENCODING_IBM_1142_P100_1997 = 146; // UTR22*

// ibm-1143_P100-1997
static const int LG_ENCODING_CCSID01143 = 147; // IANA JAVA
static const int LG_ENCODING_CP01143 = 147; // IANA JAVA
static const int LG_ENCODING_IBM01143 = 147; // IANA* JAVA
static const int LG_ENCODING_CP1143 = 147; // JAVA*
static const int LG_ENCODING_EBCDIC_FI_278_EURO = 147; // IANA
static const int LG_ENCODING_EBCDIC_SE_278_EURO = 147; // IANA
static const int LG_ENCODING_IBM_1143 = 147; // IBM*
static const int LG_ENCODING_IBM_1143_P100_1997 = 147; // UTR22*

// ibm-1144_P100-1997
static const int LG_ENCODING_CCSID01144 = 148; // IANA JAVA
static const int LG_ENCODING_CP01144 = 148; // IANA JAVA
static const int LG_ENCODING_IBM01144 = 148; // IANA* JAVA
static const int LG_ENCODING_CP1144 = 148; // JAVA*
static const int LG_ENCODING_EBCDIC_IT_280_EURO = 148; // IANA
static const int LG_ENCODING_IBM_1144 = 148; // IBM*
static const int LG_ENCODING_IBM_1144_P100_1997 = 148; // UTR22*

// ibm-1145_P100-1997
static const int LG_ENCODING_CCSID01145 = 149; // IANA JAVA
static const int LG_ENCODING_CP01145 = 149; // IANA JAVA
static const int LG_ENCODING_IBM01145 = 149; // IANA* JAVA
static const int LG_ENCODING_CP1145 = 149; // JAVA*
static const int LG_ENCODING_EBCDIC_ES_284_EURO = 149; // IANA
static const int LG_ENCODING_IBM_1145 = 149; // IBM*
static const int LG_ENCODING_IBM_1145_P100_1997 = 149; // UTR22*

// ibm-1146_P100-1997
static const int LG_ENCODING_CCSID01146 = 150; // IANA JAVA
static const int LG_ENCODING_CP01146 = 150; // IANA JAVA
static const int LG_ENCODING_IBM01146 = 150; // IANA* JAVA
static const int LG_ENCODING_CP1146 = 150; // JAVA*
static const int LG_ENCODING_EBCDIC_GB_285_EURO = 150; // IANA
static const int LG_ENCODING_IBM_1146 = 150; // IBM*
static const int LG_ENCODING_IBM_1146_P100_1997 = 150; // UTR22*

// ibm-1147_P100-1997
static const int LG_ENCODING_CCSID01147 = 151; // IANA JAVA
static const int LG_ENCODING_CP01147 = 151; // IANA JAVA
static const int LG_ENCODING_IBM01147 = 151; // IANA* JAVA
static const int LG_ENCODING_CP1147 = 151; // JAVA*
static const int LG_ENCODING_EBCDIC_FR_297_EURO = 151; // IANA
static const int LG_ENCODING_IBM_1147 = 151; // IBM*
static const int LG_ENCODING_IBM_1147_P100_1997 = 151; // UTR22*

// ibm-1148_P100-1997
static const int LG_ENCODING_CCSID01148 = 152; // IANA JAVA
static const int LG_ENCODING_CP01148 = 152; // IANA JAVA
static const int LG_ENCODING_IBM01148 = 152; // IANA* JAVA
static const int LG_ENCODING_CP1148 = 152; // JAVA*
static const int LG_ENCODING_EBCDIC_INTERNATIONAL_500_EURO = 152; // IANA
static const int LG_ENCODING_IBM_1148 = 152; // IBM*
static const int LG_ENCODING_IBM_1148_P100_1997 = 152; // UTR22*

// ibm-1149_P100-1997
static const int LG_ENCODING_CCSID01149 = 153; // IANA JAVA
static const int LG_ENCODING_CP01149 = 153; // IANA JAVA
static const int LG_ENCODING_IBM01149 = 153; // IANA* JAVA
static const int LG_ENCODING_CP1149 = 153; // JAVA*
static const int LG_ENCODING_EBCDIC_IS_871_EURO = 153; // IANA
static const int LG_ENCODING_IBM_1149 = 153; // IBM*
static const int LG_ENCODING_IBM_1149_P100_1997 = 153; // UTR22*

// ibm-1153_P100-1999
static const int LG_ENCODING_IBM1153 = 154; // JAVA
static const int LG_ENCODING_IBM_1153 = 154; // IBM*
static const int LG_ENCODING_IBM_1153_P100_1999 = 154; // UTR22*
static const int LG_ENCODING_X_IBM1153 = 154; // JAVA*

// ibm-1154_P100-1999
static const int LG_ENCODING_IBM_1154 = 155; // IBM*
static const int LG_ENCODING_IBM_1154_P100_1999 = 155; // UTR22*

// ibm-1155_P100-1999
static const int LG_ENCODING_IBM_1155 = 156; // IBM*
static const int LG_ENCODING_IBM_1155_P100_1999 = 156; // UTR22*

// ibm-1156_P100-1999
static const int LG_ENCODING_IBM_1156 = 157; // IBM*
static const int LG_ENCODING_IBM_1156_P100_1999 = 157; // UTR22*

// ibm-1157_P100-1999
static const int LG_ENCODING_IBM_1157 = 158; // IBM*
static const int LG_ENCODING_IBM_1157_P100_1999 = 158; // UTR22*

// ibm-1158_P100-1999
static const int LG_ENCODING_IBM_1158 = 159; // IBM*
static const int LG_ENCODING_IBM_1158_P100_1999 = 159; // UTR22*

// ibm-1160_P100-1999
static const int LG_ENCODING_IBM_1160 = 160; // IBM*
static const int LG_ENCODING_IBM_1160_P100_1999 = 160; // UTR22*

// ibm-1164_P100-1999
static const int LG_ENCODING_IBM_1164 = 161; // IBM*
static const int LG_ENCODING_IBM_1164_P100_1999 = 161; // UTR22*

// ibm-5123_P100-1999
static const int LG_ENCODING_IBM_5123 = 162; // IBM*
static const int LG_ENCODING_IBM_5123_P100_1999 = 162; // UTR22*

// ibm-8482_P100-1999
static const int LG_ENCODING_IBM_8482 = 163; // IBM*
static const int LG_ENCODING_IBM_8482_P100_1999 = 163; // UTR22*

// ibm-4899_P100-1998
static const int LG_ENCODING_IBM_4899 = 164; // IBM*
static const int LG_ENCODING_IBM_4899_P100_1998 = 164; // UTR22*

// ibm-4971_P100-1999
static const int LG_ENCODING_IBM_4971 = 165; // IBM*
static const int LG_ENCODING_IBM_4971_P100_1999 = 165; // UTR22*

// ibm-9067_X100-2005
static const int LG_ENCODING_IBM_9067 = 166; // IBM*
static const int LG_ENCODING_IBM_9067_X100_2005 = 166; // UTR22*

// ibm-12712_P100-1998
static const int LG_ENCODING_EBCDIC_HE = 167;
static const int LG_ENCODING_IBM_12712 = 167; // IBM*
static const int LG_ENCODING_IBM_12712_P100_1998 = 167; // UTR22*

// ibm-16804_X110-1999
static const int LG_ENCODING_EBCDIC_AR = 168;
static const int LG_ENCODING_IBM_16804 = 168; // IBM*
static const int LG_ENCODING_IBM_16804_X110_1999 = 168; // UTR22*

// ibm-37_P100-1995,swaplfnl
static const int LG_ENCODING_IBM_37_S390 = 169;
static const int LG_ENCODING_IBM_37_P100_1995_SWAPLFNL = 169;

// ibm-1047_P100-1995,swaplfnl
static const int LG_ENCODING_IBM1047_LF = 170; // JAVA*
static const int LG_ENCODING_IBM_1047_S390 = 170;
static const int LG_ENCODING_IBM_1047_P100_1995_SWAPLFNL = 170;

// ibm-1140_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1140_S390 = 171;
static const int LG_ENCODING_IBM_1140_P100_1997_SWAPLFNL = 171;

// ibm-1141_P100-1997,swaplfnl
static const int LG_ENCODING_IBM1141_LF = 172; // JAVA*
static const int LG_ENCODING_IBM_1141_S390 = 172;
static const int LG_ENCODING_IBM_1141_P100_1997_SWAPLFNL = 172;

// ibm-1142_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1142_S390 = 173;
static const int LG_ENCODING_IBM_1142_P100_1997_SWAPLFNL = 173;

// ibm-1143_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1143_S390 = 174;
static const int LG_ENCODING_IBM_1143_P100_1997_SWAPLFNL = 174;

// ibm-1144_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1144_S390 = 175;
static const int LG_ENCODING_IBM_1144_P100_1997_SWAPLFNL = 175;

// ibm-1145_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1145_S390 = 176;
static const int LG_ENCODING_IBM_1145_P100_1997_SWAPLFNL = 176;

// ibm-1146_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1146_S390 = 177;
static const int LG_ENCODING_IBM_1146_P100_1997_SWAPLFNL = 177;

// ibm-1147_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1147_S390 = 178;
static const int LG_ENCODING_IBM_1147_P100_1997_SWAPLFNL = 178;

// ibm-1148_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1148_S390 = 179;
static const int LG_ENCODING_IBM_1148_P100_1997_SWAPLFNL = 179;

// ibm-1149_P100-1997,swaplfnl
static const int LG_ENCODING_IBM_1149_S390 = 180;
static const int LG_ENCODING_IBM_1149_P100_1997_SWAPLFNL = 180;

// ibm-1153_P100-1999,swaplfnl
static const int LG_ENCODING_IBM_1153_S390 = 181;
static const int LG_ENCODING_IBM_1153_P100_1999_SWAPLFNL = 181;

// ibm-12712_P100-1998,swaplfnl
static const int LG_ENCODING_IBM_12712_S390 = 182;
static const int LG_ENCODING_IBM_12712_P100_1998_SWAPLFNL = 182;

// ibm-16804_X110-1999,swaplfnl
static const int LG_ENCODING_IBM_16804_S390 = 183;
static const int LG_ENCODING_IBM_16804_X110_1999_SWAPLFNL = 183;

// ebcdic-xml-us
static const int LG_ENCODING_EBCDIC_XML_US = 184;

#ifdef __cplusplus
}
#endif

#endif /* LIGHTGREP_C_ENCODINGS_H_ */
