/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed.test;

import java.util.Random;
import junit.framework.TestCase;
import no.uib.cipr.matrix.distributed.CollectiveCommunications;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.Reductions;

public class CollectiveTest
extends TestCase {
    CollectiveCommunications coll;
    Random r;

    protected void setUp() throws Exception {
        this.r = new Random();
        int size = Math.max(1, this.r.nextInt(16));
        this.coll = new CollectiveCommunications(size);
    }

    public void testBarrier() throws InterruptedException {
        int i;
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.barrier();
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join(10000L);
        }
        for (i = 0; i < t.length; ++i) {
            CollectiveTest.assertTrue(!t[i].isAlive());
        }
    }

    public void testBroadcast() throws InterruptedException {
        int i;
        int[] send = new int[this.r.nextInt(100)];
        for (int i2 = 0; i2 < send.length; ++i2) {
            send[i2] = this.r.nextInt();
        }
        final int[][] recv = new int[this.coll.size()][send.length];
        recv[0] = send;
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.broadcast(recv[rank], 0);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (int j = 0; j < send.length; ++j) {
                CollectiveTest.assertEquals(send[j], recv[i][j]);
            }
        }
    }

    public void testScatter() throws InterruptedException {
        int i;
        int length = this.r.nextInt(100);
        final int[][] send = new int[this.coll.size()][length];
        for (int i2 = 0; i2 < this.coll.size(); ++i2) {
            for (int j = 0; j < length; ++j) {
                send[i2][j] = this.r.nextInt();
            }
        }
        final int[][] recv = new int[this.coll.size()][length];
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.scatter((Object[])send, recv[rank], 0);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (int j = 0; j < length; ++j) {
                CollectiveTest.assertEquals(send[i][j], recv[i][j]);
            }
        }
    }

    public void testGather() throws InterruptedException {
        int i;
        int length = this.r.nextInt(100);
        final int[][] send = new int[this.coll.size()][length];
        for (int i2 = 0; i2 < this.coll.size(); ++i2) {
            for (int j = 0; j < length; ++j) {
                send[i2][j] = this.r.nextInt();
            }
        }
        final int[][] recv = new int[this.coll.size()][length];
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.gather(send[rank], (Object[])recv, 0);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (int j = 0; j < length; ++j) {
                CollectiveTest.assertEquals(send[i][j], recv[i][j]);
            }
        }
    }

    public void testAllGather() throws InterruptedException {
        int i;
        int length = this.r.nextInt(100);
        final int[][] send = new int[this.coll.size()][length];
        for (int i2 = 0; i2 < this.coll.size(); ++i2) {
            for (int j = 0; j < length; ++j) {
                send[i2][j] = this.r.nextInt();
            }
        }
        final int[][][] recv = new int[this.coll.size()][this.coll.size()][length];
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.allGather(send[rank], (Object[])recv[rank]);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (int j = 0; j < length; ++j) {
                CollectiveTest.assertEquals(send[i][j], recv[i][i][j]);
            }
        }
    }

    public void testAllToAll() throws InterruptedException {
        int i;
        int length = this.r.nextInt(100);
        final int[][][] send = new int[this.coll.size()][this.coll.size()][length];
        for (int i2 = 0; i2 < this.coll.size(); ++i2) {
            for (int j = 0; j < this.coll.size(); ++j) {
                for (int k = 0; k < length; ++k) {
                    send[i2][j][k] = this.r.nextInt();
                }
            }
        }
        final int[][][] recv = new int[this.coll.size()][this.coll.size()][length];
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.allToAll((Object[])send[rank], (Object[])recv[rank]);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (int j = 0; j < this.coll.size(); ++j) {
                for (int k = 0; k < length; ++k) {
                    CollectiveTest.assertEquals(send[i][j][k], recv[j][i][k]);
                }
            }
        }
    }

    public void testReduce() throws InterruptedException {
        int i;
        int length = this.r.nextInt(100);
        final int[][] send = new int[this.coll.size()][length];
        for (int i2 = 0; i2 < this.coll.size(); ++i2) {
            for (int j = 0; j < length; ++j) {
                send[i2][j] = this.r.nextInt(1000);
            }
        }
        final int[] recv = new int[length];
        Thread[] t = new Thread[this.coll.size()];
        for (i = 0; i < t.length; ++i) {
            final int rank = i;
            t[i] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.reduce(send[rank], recv, Reductions.sum(), 0);
                }
            });
            t[i].start();
        }
        for (i = 0; i < t.length; ++i) {
            t[i].join();
        }
        int[] mysum = new int[length];
        for (int i3 = 0; i3 < this.coll.size(); ++i3) {
            for (int j = 0; j < length; ++j) {
                int n = j;
                mysum[n] = mysum[n] + send[i3][j];
            }
        }
        for (int j = 0; j < length; ++j) {
            CollectiveTest.assertEquals(mysum[j], recv[j]);
        }
    }

    public void testAllReduce() throws InterruptedException {
        int j;
        int i;
        int i2;
        int length = this.r.nextInt(100);
        final int[][] send = new int[this.coll.size()][length];
        for (int i3 = 0; i3 < this.coll.size(); ++i3) {
            for (int j2 = 0; j2 < length; ++j2) {
                send[i3][j2] = this.r.nextInt(1000);
            }
        }
        final int[][] recv = new int[this.coll.size()][length];
        Thread[] t = new Thread[this.coll.size()];
        for (i2 = 0; i2 < t.length; ++i2) {
            final int rank = i2;
            t[i2] = new Thread(new Runnable(){

                public void run() {
                    Communicator comm = CollectiveTest.this.coll.createCommunicator(rank);
                    comm.allReduce(send[rank], recv[rank], Reductions.sum());
                }
            });
            t[i2].start();
        }
        for (i2 = 0; i2 < t.length; ++i2) {
            t[i2].join();
        }
        int[] mysum = new int[length];
        for (i = 0; i < this.coll.size(); ++i) {
            for (j = 0; j < length; ++j) {
                int n = j;
                mysum[n] = mysum[n] + send[i][j];
            }
        }
        for (i = 0; i < this.coll.size(); ++i) {
            for (j = 0; j < length; ++j) {
                CollectiveTest.assertEquals(mysum[j], recv[i][j]);
            }
        }
    }
}

