/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.pipe.Noop;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.FeatureCountTool;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Logger;

public class Vectors2Vectors {
    private static Logger logger = MalletLogger.getLogger(Vectors2Vectors.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(Vectors2Vectors.class, "input", "FILE", true, new File("-"), "Read the instance list from this file; Using - indicates stdin.", null);
    static CommandOption.File outputFile = new CommandOption.File(Vectors2Vectors.class, "output", "FILE", true, new File("-"), "Write pruned instance list to this file (use --training-file etc. if you are splitting the list). Using - indicates stdin.", null);
    static CommandOption.File trainingFile = new CommandOption.File(Vectors2Vectors.class, "training-file", "FILE", true, new File("training.vectors"), "Write the training set instance list to this file (or use --output if you are only pruning features); Using - indicates stdout.", null);
    static CommandOption.File testFile = new CommandOption.File(Vectors2Vectors.class, "testing-file", "FILE", true, new File("test.vectors"), "Write the test set instance list to this file; Using - indicates stdout.", null);
    static CommandOption.File validationFile = new CommandOption.File(Vectors2Vectors.class, "validation-file", "FILE", true, new File("validation.vectors"), "Write the validation set instance list to this file; Using - indicates stdout.", null);
    static CommandOption.Double trainingProportion = new CommandOption.Double(Vectors2Vectors.class, "training-portion", "DECIMAL", true, 1.0, "The fraction (0.0 - 1.0) of the instances that should be used for training.", null);
    static CommandOption.Double validationProportion = new CommandOption.Double(Vectors2Vectors.class, "validation-portion", "DECIMAL", true, 0.0, "The fraction (0.0 - 1.0) of the instances that should be used for validation.", null);
    static CommandOption.Integer randomSeed = new CommandOption.Integer(Vectors2Vectors.class, "random-seed", "INTEGER", true, 0, "The random seed for randomly selecting a proportion of the instance list for training", null);
    static CommandOption.Integer pruneInfogain = new CommandOption.Integer(Vectors2Vectors.class, "prune-infogain", "N", false, 0, "Reduce features to the top N by information gain.", null);
    static CommandOption.Integer pruneCount = new CommandOption.Integer(Vectors2Vectors.class, "prune-count", "N", false, 0, "Reduce features to those that occur more than N times.", null);
    static CommandOption.Integer pruneDocFreq = new CommandOption.Integer(Vectors2Vectors.class, "prune-document-freq", "N", false, 0, "Reduce features to those that occur in more than N contexts.", null);
    static CommandOption.Double minIDF = new CommandOption.Double(Vectors2Vectors.class, "min-idf", "NUMBER", false, 0.0, "Remove frequent features with inverse document frequency less than this value.", null);
    static CommandOption.Double maxIDF = new CommandOption.Double(Vectors2Vectors.class, "max-idf", "NUMBER", false, Double.POSITIVE_INFINITY, "Remove rare features with inverse document frequency greater than this value.", null);
    static CommandOption.Boolean vectorToSequence = new CommandOption.Boolean(Vectors2Vectors.class, "vector-to-sequence", "[TRUE|FALSE]", false, false, "Convert FeatureVector's to FeatureSequence's.", null);
    static CommandOption.Boolean hideTargets = new CommandOption.Boolean(Vectors2Vectors.class, "hide-targets", "[TRUE|FALSE]", false, false, "Hide targets.", null);
    static CommandOption.Boolean revealTargets = new CommandOption.Boolean(Vectors2Vectors.class, "reveal-targets", "[TRUE|FALSE]", false, false, "Reveal targets.", null);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(Vectors2Vectors.class, "A tool for manipulating instance lists of feature vectors.");
        CommandOption.process(Vectors2Vectors.class, args);
        if (args.length == 0) {
            CommandOption.getList(Vectors2Vectors.class).printUsage(false);
            System.exit(-1);
        }
        Random r = randomSeed.wasInvoked() ? new Random(Vectors2Vectors.randomSeed.value) : new Random();
        double t = Vectors2Vectors.trainingProportion.value;
        double v = Vectors2Vectors.validationProportion.value;
        logger.info("Training portion = " + t);
        logger.info("Validation portion = " + v);
        logger.info("Testing portion = " + (1.0 - v - t));
        logger.info("Prune info gain = " + Vectors2Vectors.pruneInfogain.value);
        logger.info("Prune count = " + Vectors2Vectors.pruneCount.value);
        logger.info("Prune df = " + Vectors2Vectors.pruneDocFreq.value);
        logger.info("idf range = " + Vectors2Vectors.minIDF.value + "-" + Vectors2Vectors.maxIDF.value);
        InstanceList instances = InstanceList.load(Vectors2Vectors.inputFile.value);
        if (!(t != 1.0 || Vectors2Vectors.vectorToSequence.value || pruneInfogain.wasInvoked() || pruneCount.wasInvoked() || pruneDocFreq.wasInvoked() || minIDF.wasInvoked() || maxIDF.wasInvoked() || hideTargets.wasInvoked() || revealTargets.wasInvoked())) {
            logger.warning("Vectors2Vectors was invoked, but did not change anything");
            instances.save(trainingFile.value());
            System.exit(0);
        }
        if (pruneInfogain.wasInvoked() || pruneDocFreq.wasInvoked() || pruneCount.wasInvoked() || minIDF.wasInvoked() || maxIDF.wasInvoked()) {
            if (t != 1.0) {
                throw new UnsupportedOperationException("Infogain/count processing of test or validation lists not yet supported.");
            }
            if (pruneCount.wasInvoked() || pruneDocFreq.wasInvoked() || minIDF.wasInvoked() || maxIDF.wasInvoked()) {
                FeatureCountTool counter = new FeatureCountTool(instances);
                counter.count();
                int minDocs = 0;
                int maxDocs = Integer.MAX_VALUE;
                int minCount = 0;
                int maxCount = Integer.MAX_VALUE;
                if (pruneCount.wasInvoked()) {
                    minCount = Vectors2Vectors.pruneCount.value;
                }
                if (pruneDocFreq.wasInvoked()) {
                    minDocs = Vectors2Vectors.pruneDocFreq.value;
                    System.out.println("min docs: " + minDocs);
                }
                if (maxIDF.wasInvoked()) {
                    minDocs = (int)Math.floor((double)instances.size() * Math.exp(-Vectors2Vectors.maxIDF.value));
                }
                if (minIDF.wasInvoked()) {
                    maxDocs = (int)Math.ceil((double)instances.size() * Math.exp(-Vectors2Vectors.minIDF.value));
                }
                Alphabet oldAlphabet = instances.getDataAlphabet();
                Alphabet newAlphabet = counter.getPrunedAlphabet(minDocs, maxDocs, minCount, maxCount);
                Instance firstInstance = (Instance)instances.get(0);
                if (firstInstance.getData() instanceof FeatureSequence) {
                    Noop newPipe = new Noop(newAlphabet, instances.getTargetAlphabet());
                    InstanceList newInstanceList = new InstanceList(newPipe);
                    int numFeatures = oldAlphabet.size();
                    double[] counts = new double[numFeatures];
                    for (int ii = 0; ii < instances.size(); ++ii) {
                        Instance instance = (Instance)instances.get(ii);
                        FeatureSequence featureSequence = (FeatureSequence)instance.getData();
                        featureSequence.addFeatureWeightsTo(counts);
                    }
                    while (instances.size() > 0) {
                        Instance instance = (Instance)instances.get(0);
                        FeatureSequence featureSequence = (FeatureSequence)instance.getData();
                        featureSequence.prune(newAlphabet);
                        newInstanceList.add(newPipe.instanceFrom(new Instance(featureSequence, instance.getTarget(), instance.getName(), instance.getSource())));
                        instances.remove(0);
                    }
                    logger.info("features: " + oldAlphabet.size() + " -> " + newAlphabet.size());
                    instances = newInstanceList;
                } else {
                    void var21_56;
                    if (!(firstInstance.getData() instanceof FeatureVector)) throw new UnsupportedOperationException("Pruning features from " + firstInstance.getClass().getName() + " is not currently supported");
                    Alphabet alpha2 = new Alphabet();
                    Noop pipe2 = new Noop(alpha2, instances.getTargetAlphabet());
                    InstanceList instances2 = new InstanceList(pipe2);
                    int numFeatures = oldAlphabet.size();
                    double[] counts = new double[numFeatures];
                    BitSet bs = new BitSet(numFeatures);
                    boolean bl = false;
                    while (var21_56 < numFeatures) {
                        if (newAlphabet.contains(oldAlphabet.lookupObject((int)var21_56))) {
                            bs.set((int)var21_56);
                        }
                        ++var21_56;
                    }
                    logger.info("Pruning " + (numFeatures - bs.cardinality()) + " features out of " + numFeatures + "; leaving " + bs.cardinality() + " features.");
                    FeatureSelection featureSelection = new FeatureSelection(oldAlphabet, bs);
                    for (int ii = 0; ii < instances.size(); ++ii) {
                        Instance instance = (Instance)instances.get(ii);
                        FeatureVector fv = (FeatureVector)instance.getData();
                        FeatureVector fv2 = FeatureVector.newFeatureVector(fv, alpha2, featureSelection);
                        instances2.add(new Instance(fv2, instance.getTarget(), instance.getName(), instance.getSource()), instances.getInstanceWeight(ii));
                        instance.unLock();
                        instance.setData(null);
                    }
                    instances = instances2;
                }
            }
            if (Vectors2Vectors.pruneInfogain.value > 0) {
                Alphabet alpha2 = new Alphabet();
                Noop pipe2 = new Noop(alpha2, instances.getTargetAlphabet());
                InstanceList instances2 = new InstanceList(pipe2);
                InfoGain ig = new InfoGain(instances);
                FeatureSelection fs = new FeatureSelection(ig, Vectors2Vectors.pruneInfogain.value);
                for (int ii = 0; ii < instances.size(); ++ii) {
                    Instance instance = (Instance)instances.get(ii);
                    FeatureVector fv = (FeatureVector)instance.getData();
                    FeatureVector fv2 = FeatureVector.newFeatureVector(fv, alpha2, fs);
                    instance.unLock();
                    instance.setData(null);
                    instances2.add(pipe2.instanceFrom(new Instance(fv2, instance.getTarget(), instance.getName(), instance.getSource())), instances.getInstanceWeight(ii));
                }
                instances = instances2;
            }
            if (Vectors2Vectors.vectorToSequence.value) {
                Alphabet alpha = instances.getDataAlphabet();
                Noop pipe2 = new Noop(alpha, instances.getTargetAlphabet());
                InstanceList instances2 = new InstanceList(pipe2);
                for (int ii = 0; ii < instances.size(); ++ii) {
                    Instance instance = (Instance)instances.get(ii);
                    FeatureVector fv = (FeatureVector)instance.getData();
                    ArrayList<Integer> seq = new ArrayList<Integer>();
                    for (int loc = 0; loc < fv.numLocations(); ++loc) {
                        int count = 0;
                        while ((double)count < fv.valueAtLocation(loc)) {
                            seq.add(new Integer(fv.indexAtLocation(loc)));
                            ++count;
                        }
                    }
                    Collections.shuffle(seq);
                    int[] indices = new int[seq.size()];
                    for (int i = 0; i < indices.length; ++i) {
                        indices[i] = (Integer)seq.get(i);
                    }
                    FeatureSequence fs = new FeatureSequence(alpha, indices);
                    instance.unLock();
                    instance.setData(null);
                    instances2.add(pipe2.instanceFrom(new Instance(fs, instance.getTarget(), instance.getName(), instance.getSource())), instances.getInstanceWeight(ii));
                }
                instances = instances2;
            }
            if (outputFile.wasInvoked()) {
                Vectors2Vectors.writeInstanceList(instances, outputFile.value());
                return;
            } else {
                if (!trainingFile.wasInvoked()) throw new IllegalArgumentException("You must specify a file to write to, using --output [filename]");
                Vectors2Vectors.writeInstanceList(instances, trainingFile.value());
            }
            return;
        } else if (Vectors2Vectors.vectorToSequence.value) {
            Alphabet alpha = instances.getDataAlphabet();
            Noop pipe2 = new Noop(alpha, instances.getTargetAlphabet());
            InstanceList instances2 = new InstanceList(pipe2);
            for (int ii = 0; ii < instances.size(); ++ii) {
                Instance instance = (Instance)instances.get(ii);
                FeatureVector fv = (FeatureVector)instance.getData();
                ArrayList<Integer> seq = new ArrayList<Integer>();
                for (int loc = 0; loc < fv.numLocations(); ++loc) {
                    int count = 0;
                    while ((double)count < fv.valueAtLocation(loc)) {
                        seq.add(new Integer(fv.indexAtLocation(loc)));
                        ++count;
                    }
                }
                Collections.shuffle(seq);
                int[] indices = new int[seq.size()];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = (Integer)seq.get(i);
                }
                FeatureSequence fs = new FeatureSequence(alpha, indices);
                instance.unLock();
                instance.setData(null);
                instances2.add(pipe2.instanceFrom(new Instance(fs, instance.getTarget(), instance.getName(), instance.getSource())), instances.getInstanceWeight(ii));
            }
            instances = instances2;
            if (!outputFile.wasInvoked()) return;
            Vectors2Vectors.writeInstanceList(instances, outputFile.value());
            return;
        } else if (trainingProportion.wasInvoked() || validationProportion.wasInvoked()) {
            InstanceList[] instanceLists = instances.split(r, new double[]{t, 1.0 - t - v, v});
            if (instanceLists[0].size() > 0) {
                Vectors2Vectors.writeInstanceList(instanceLists[0], trainingFile.value());
            }
            if (instanceLists[1].size() > 0) {
                Vectors2Vectors.writeInstanceList(instanceLists[1], testFile.value());
            }
            if (instanceLists[2].size() <= 0) return;
            Vectors2Vectors.writeInstanceList(instanceLists[2], validationFile.value());
            return;
        } else if (hideTargets.wasInvoked()) {
            for (Instance instance : instances) {
                instance.unLock();
                instance.setProperty("target", instance.getTarget());
                instance.setTarget(null);
                instance.lock();
            }
            if (!outputFile.wasInvoked()) return;
            Vectors2Vectors.writeInstanceList(instances, outputFile.value());
            return;
        } else {
            if (!revealTargets.wasInvoked()) return;
            for (Instance instance : instances) {
                instance.unLock();
                instance.setTarget(instance.getProperty("target"));
                instance.lock();
            }
            if (!outputFile.wasInvoked()) return;
            Vectors2Vectors.writeInstanceList(instances, outputFile.value());
        }
    }

    private static void writeInstanceList(InstanceList instances, File file) throws FileNotFoundException, IOException {
        logger.info("Writing instance list to " + file);
        instances.save(file);
    }
}

