package Alien::HDF4;

use strict;
use warnings;

our $VERSION = '0.06';

sub Inline {
  require Alien::HDF4::Install::Files;
  goto &Alien::HDF4::Install::Files::Inline;
}

1;

__END__

=head1 NAME

Alien::HDF4 - Encapsulate install info for HDF4

=head1 SYNOPSIS

  # PDL/Makefile.PL
  use ExtUtils::Depends;
  my $pkg = ExtUtils::Depends->new(qw(PDL Alien::HDF4)); # HDF4 config info

  use Inline with => 'Alien::HDF4';

=head1 DESCRIPTION

Use in your F<Makefile.PL> as above. Produces config info usable via
L<ExtUtils::Depends>.

=head1 AUTHOR

Ed J

=head1 SEE ALSO

L<ExtUtils::Depends>.
