/*
 * Copyright 2008 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Definitions for all the extensions over the
 *  W3C's event specification by IE in JScript. This file depends on
 *  w3c_event.js.
 *
 * @see http://msdn.microsoft.com/en-us/library/ms535863.aspx
 * @externs
 */

/** @type {string} */
Event.prototype.Abstract;

/** @type {boolean} */
Event.prototype.altKey;

/** @type {boolean} */
Event.prototype.altLeft;

/** @type {string} */
Event.prototype.Banner;

/** @type {number} */
Event.prototype.button;

/** @type {boolean} */
Event.prototype.cancelBubble;

/** @type {number} */
Event.prototype.clientX;

/** @type {number} */
Event.prototype.clientY;

/**
 * @see http://msdn.microsoft.com/en-us/library/ms535220.aspx
 * @type {(ClipboardData|undefined)}
 */
Event.prototype.clipboardData;

/** @type {boolean} */
Event.prototype.contentOverflow;

/** @type {boolean} */
Event.prototype.ctrlKey;

/** @type {boolean} */
Event.prototype.ctrlLeft;

/** @type {string} */
Event.prototype.data;

/** @type {string} */
Event.prototype.dataFld;

Event.prototype.domain;

/** @type {Element} */
Event.prototype.fromElement;

/** @type {number} */
Event.prototype.keyCode;

/** @type {string} */
Event.prototype.MoreInfo;

/** @type {string} */
Event.prototype.nextPage;

/** @type {number} */
Event.prototype.offsetX;

/** @type {number} */
Event.prototype.offsetY;

/** @type {string} */
Event.prototype.propertyName;

/** @type {string} */
Event.prototype.qualifier;

/** @type {number} */
Event.prototype.reason;

/** @type {Object.<*,*>} */
Event.prototype.recordset;

/** @type {boolean} */
Event.prototype.repeat;

/** @type {(boolean|string|undefined)} */
Event.prototype.returnValue;

/** @type {string} */
Event.prototype.saveType;

Event.prototype.scheme;

/** @type {number} */
Event.prototype.screenX;

/** @type {number} */
Event.prototype.screenY;

/** @type {boolean} */
Event.prototype.shiftKey;

/** @type {boolean} */
Event.prototype.shiftLeft;

/** @type {Window} */
Event.prototype.source;

/** @type {Element} */
Event.prototype.srcElement;

Event.prototype.srcFilter;

/** @type {string} */
Event.prototype.srcUrn;

/** @type {Element} */
Event.prototype.toElement;

Event.prototype.userName;

/** @type {number} */
Event.prototype.wheelDelta;

/** @type {number} */
Event.prototype.x;

/** @type {number} */
Event.prototype.y;

