/*
 * Copyright 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Definitions for IE's vector markup language, or VML.
 *
 * @externs
 * @author robbyw@google.com (Robby Walker)
 */


/**
 * @type {Object|string}
 * @see http://msdn.microsoft.com/en-us/library/bb263836(VS.85).aspx
 */
Element.prototype.coordorigin;

/**
 * @type {Object|string}
 * @see http://msdn.microsoft.com/en-us/library/bb263837(VS.85).aspx
 */
Element.prototype.coordsize;

/**
 * @type {string}
 * @see http://msdn.microsoft.com/en-us/library/bb263839(VS.85).aspx
 */
Element.prototype.fillcolor;

/**
 * @type {boolean}
 * @see http://msdn.microsoft.com/en-us/library/bb263840(VS.85).aspx
 */
Element.prototype.filled;

/**
 * @type {string}
 * @see http://msdn.microsoft.com/en-us/library/bb263871(VS.85).aspx
 */
Element.prototype.path;

/**
 * @type {number|string}
 * @see http://msdn.microsoft.com/en-us/library/bb263877(VS.85).aspx
 */
Element.prototype.rotation;

/**
 * @type {string}
 * @see http://msdn.microsoft.com/en-us/library/bb263881(VS.85).aspx
 */
Element.prototype.strokecolor;

/**
 * @type {boolean}
 * @see http://msdn.microsoft.com/en-us/library/bb263882(VS.85).aspx
 */
Element.prototype.stroked;

/**
 * @type {number|string}
 * @see http://msdn.microsoft.com/en-us/library/bb263883(VS.85).aspx
 */
Element.prototype.strokeweight;
