/*-------------------------------------------------------------------------
 *
 * unicode_norm_hashfunc.h
 *	  Perfect hash functions used for Unicode normalization
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_norm_hashfunc.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_norm_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_NORM_HASHFUNC_H
 * here.
 */

#include "common/unicode_norm_table.h"

/* Typedef for perfect hash functions */
typedef int (*cp_hash_func) (const void *key);

/* Information for lookups with perfect hash functions */
typedef struct
{
	const pg_unicode_decomposition *decomps;
	cp_hash_func	hash;
	int		num_decomps;
} pg_unicode_decompinfo;

typedef struct
{
	const uint16	*inverse_lookup;
	cp_hash_func	hash;
	int		num_recomps;
} pg_unicode_recompinfo;

/* Perfect hash function for decomposition */
static int
Decomp_hash_func(const void *key)
{
	static const int16 h[13407] = {
		4943,  4944,  4945,  4946,  4947,  4948,  4949,  4950,
		4951,  4952,  4953,  4954,  4955,  4956,  4957,  4958,
		4959,  4960,  4961,  4962,  4963,  4964,  4965,  4966,
		4967,  4968,  4969,  32767, 4970,  4971,  32767, 32767,
		4972,  32767, 32767, 4973,  4974,  32767, 32767, 4975,
		4976,  4977,  4978,  32767, 4979,  4980,  4981,  4982,
		4983,  4984,  4985,  4986,  4987,  4988,  4989,  4990,
		32767, 4991,  32767, 4992,  4993,  4994,  4995,  4996,
		4997,  4998,  32767, 4999,  5000,  5001,  5002,  5003,
		5004,  5005,  5006,  5007,  5008,  -6192, 5010,  5011,
		5012,  5013,  5014,  5015,  5016,  5017,  5018,  5019,
		5020,  5021,  5022,  5023,  5024,  5025,  5026,  5027,
		5028,  5029,  5030,  5031,  5032,  5033,  5034,  5035,
		5036,  5037,  5038,  5039,  5040,  5041,  5042,  5043,
		5044,  5045,  5046,  5047,  5048,  5049,  5050,  5051,
		5052,  5053,  5054,  5055,  5056,  5057,  32767, 6396,
		6397,  6398,  6399,  6400,  6401,  32767, 6402,  6403,
		6404,  6405,  32767, 32767, 5059,  6407,  5060,  6409,
		-9156, 6411,  5507,  6413,  32767, -290,  -290,  -290,
		-290,  -290,  9059,  9060,  32767, -291,  -291,  -291,
		-6392, -291,  -291,  -291,  -291,  -291,  -291,  -291,
		951,   -291,  952,   -291,  -291,  -291,  -291,  -6404,
		-291,  -291,  4828,  4828,  -6406, -6406, -291,  -291,
		-6408, -1694, -292,  -292,  -292,  -292,  -6408, -293,
		-293,  -293,  -293,  -293,  -6409, -294,  32767, -6410,
		-6410, -297,  -297,  -297,  -297,  -297,  -297,  -297,
		32767, -298,  -6411, 2161,  -298,  -9253, -6861, 1544,
		2165,  2165,  2165,  7485,  7485,  7485,  7485,  25276,
		7485,  13219, 7485,  1043,  7485,  7485,  7485,  7485,
		7485,  7485,  7485,  5094,  12010, 12010, 13226, 12010,
		13228, 8732,  13230, -298,  -6417, 7487,  12010, -298,
		-298,  -298,  -6419, -6419, -1660, 8442,  8442,  8442,
		8442,  8442,  -2519, 8442,  18541, -5775, 375,   8887,
		13224, -4566, 13226, 38,    39,    -296,  -296,  4431,
		-296,  -296,  -6532, -296,  -296,  1556,  -296,  1557,
		-296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,
		-296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,
		-296,  449,   450,   -296,  106,   107,   679,   -296,
		1559,  -296,  -1981, 112,   -296,  -296,  -296,  -296,
		-296,  -296,  -296,  1560,  1561,  1562,  1563,  1564,
		-296,  -296,  1565,  1566,  -296,  -296,  1567,  1568,
		-296,  -296,  -296,  -296,  -296,  -296,  1569,  1570,
		-296,  -296,  1571,  1572,  -296,  139,   -1933, -295,
		-295,  1895,  -295,  -295,  -295,  -295,  -295,  -295,
		-295,  -295,  -295,  -295,  -486,  -1943, -486,  -1943,
		-295,  -295,  -295,  -295,  -295,  -295,  -295,  -295,
		-295,  -295,  4399,  -295,  -295,  -295,  -295,  -295,
		-295,  -295,  -295,  -295,  -295,  -295,  -295,  179,
		-1339, -1339, -3797, -3797, -3797, -1339, -1339, -1339,
		1310,  1311,  1312,  1313,  -6671, 1315,  -13749,-1339,
		-13748,1320,  6679,  -1699, 1323,  1324,  1325,  -1339,
		-1339, -1339, -1339, -1339, 803,   804,   805,   806,
		5334,  3345,  -3570, -3569, -1338, -1338, -1338, -1338,
		-1338, -1338, -1338, -1338, -1338, -1338, -1338, -1338,
		-1338, -1338, -1338, -1338, -1338, 8,     -1338, 9,
		-1338, 10,    -1338, 14228, -1338, -433,  -1338, 5365,
		5366,  5367,  5368,  5369,  5370,  -3978, -3978, -3978,
		5374,  5375,  5376,  11478, 5378,  5379,  5380,  5381,
		5382,  5383,  5384,  4143,  5386,  4144,  5388,  5389,
		5390,  5391,  11505, 5393,  5394,  276,   277,   11512,
		11513, 5399,  5400,  11518, 5402,  5403,  5404,  5405,
		5406,  5407,  5408,  5409,  5410,  5411,  5412,  5413,
		5414,  5415,  5416,  5417,  5418,  5419,  5420,  5421,
		5422,  5423,  5424,  5425,  5426,  11540, 2969,  5429,
		14385, 11994, 3590,  2970,  2971,  2972,  -2347, -2346,
		-2345, -2344, -20134,-2342, -8075, -2340, 4103,  -2338,
		-2337, -2336, -2335, -2334, -2333, -2332, 60,    -6855,
		-6854, -8069, -6852, -8069, -3572, -8069, 5460,  11580,
		-2323, -6845, 5464,  5465,  5466,  11588, 11589, 6831,
		-3270, -3269, -3268, -3267, -3266, 7696,  -3264, -13362,
		10955, 4806,  -3705, -8041, 9750,  -8041, 5148,  5148,
		5484,  5485,  759,   5487,  5488,  11725, 5490,  5491,
		3640,  5493,  3641,  5495,  5496,  5497,  5498,  5499,
		5500,  5501,  5502,  5503,  5504,  5505,  5506,  5507,
		5508,  5509,  5510,  5511,  4767,  4767,  5514,  5113,
		5113,  4542,  5518,  3664,  5520,  7206,  5114,  5523,
		5524,  5525,  5526,  5527,  5528,  5529,  3674,  3674,
		3674,  3674,  3674,  5535,  5536,  3676,  3676,  5539,
		5540,  3678,  3678,  5543,  5544,  5545,  5546,  5547,
		5548,  3684,  3684,  5551,  5552,  3686,  3686,  5555,
		5121,  7194,  5557,  5558,  3369,  5560,  5561,  5562,
		5563,  5564,  5565,  5566,  5567,  5568,  5569,  5761,
		7219,  5763,  7221,  5574,  5575,  5576,  5577,  5578,
		5579,  5580,  5581,  5582,  5583,  890,   5585,  5586,
		5587,  5588,  5589,  5590,  5591,  5592,  5593,  5594,
		5595,  5596,  5597,  5598,  5599,  5600,  5601,  5602,
		5603,  5604,  -2311, -2310, -2309, -2308, -2307, -2306,
		-2305, -2304, -2303, 5614,  5615,  5616,  5617,  5618,
		5619,  5620,  5621,  5622,  5623,  5624,  5625,  5626,
		5627,  5628,  5629,  5630,  5631,  5632,  5633,  5634,
		5635,  5636,  5637,  5638,  5639,  5640,  5641,  5642,
		5643,  5644,  5645,  5646,  5647,  5648,  5649,  5650,
		5651,  5652,  -3666, 5654,  5655,  5656,  5657,  5658,
		5659,  5660,  5661,  5662,  5663,  5664,  5665,  5666,
		5667,  5668,  5669,  5670,  5671,  5672,  5673,  5674,
		5675,  5676,  5677,  5678,  5679,  5680,  5681,  5682,
		5683,  5684,  5685,  304,   305,   306,   307,   308,
		309,   310,   311,   312,   313,   314,   315,   4336,
		317,   318,   319,   320,   321,   322,   323,   324,
		325,   326,   327,   328,   329,   330,   331,   332,
		333,   334,   335,   -433,  -433,  -433,  -433,  -433,
		-433,  -433,  -433,  -433,  -433,  346,   347,   9415,
		349,   350,   351,   352,   353,   354,   355,   356,
		357,   358,   359,   360,   361,   362,   363,   364,
		365,   366,   367,   368,   369,   370,   371,   372,
		373,   374,   375,   376,   377,   378,   379,   6920,
		6921,  -2430, -2430, -2430, -8531, -2430, -2430, -2430,
		388,   389,   390,   391,   392,   393,   394,   395,
		396,   397,   398,   399,   400,   401,   402,   403,
		404,   405,   406,   407,   408,   409,   410,   411,
		412,   413,   -348,  5796,  5797,  2779,  5799,  2780,
		2780,  7568,  5803,  5804,  2782,  14440, 7577,  7578,
		-2893, 417,   32767, 32767, 32767, 32767, 32767, 418,
		419,   420,   421,   422,   423,   424,   32767, 425,
		32767, 426,   427,   428,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     2084,  2085,
		2657,  0,     0,     0,     0,     2093,  0,     0,
		32767, 32767, 32767, 32767, 32767, 429,   4598,  4599,
		4600,  4601,  4602,  435,   4603,  4604,  4605,  4606,
		4607,  4608,  4609,  4610,  4611,  4612,  4613,  4614,
		-2552, 4616,  4617,  4618,  4619,  4620,  4621,  4765,
		4766,  3854,  4625,  4626,  4627,  436,   437,   438,
		4631,  4632,  4633,  4634,  4635,  4636,  4637,  4638,
		4639,  38,    17830, 4642,  4643,  4644,  0,     4645,
		4646,  4647,  4648,  4649,  4650,  4651,  4652,  4653,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 448,   449,   450,   32767, 451,
		452,   32767, 32767, 32767, 453,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, -5211, -5211, 32767, -5212,
		32767, 32767, 32767, -5215, 32767, 32767, 32767, 32767,
		-5219, -5219, -5219, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 153,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 895,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 100,   100,   32767, 99,
		32767, 32767, 32767, 96,    32767, 32767, 32767, 32767,
		92,    92,    92,    32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 70,    70,    32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 59,
		821,   -5322, -5322, -2303, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -4122, -4122, 32767,
		32767, 3651,  3652,  3653,  0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, -4134, -4134, 3033,  -4134,
		32767, 32767, -4136, -4136, 32767, 32767, -4281, -3368,
		-4138, -4138, -4138, 54,    32767, 32767, -4140, -4140,
		-4140, -4140, -4140, -4140, 32767, 32767, -4142, 460,
		-17331,-4142, -4142, -4142, 503,   -4141, -4141, -4141,
		-4141, -4141, 32767, 32767, -4143, -4143, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 511,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 512,   513,
		514,   515,   516,   -4236, -4236, -4236, -4236, -4236,
		522,   523,   524,   525,   526,   527,   528,   529,
		530,   531,   532,   5533,  534,   5534,  536,   5535,
		538,   5536,  540,   5537,  -9327, 543,   544,   545,
		546,   547,   548,   549,   550,   551,   552,   553,
		554,   555,   556,   32767, 557,   32767, 558,   559,
		32767, 560,   561,   32767, 562,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 0,     32767, 32767, 0,     0,     32767,
		0,     0,     32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 750,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 751,   32767, 32767,
		752,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		753,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -8394, 567,   568,   569,   -8394, -8393, -8392,
		-6000, 32767, 32767, 32767, 0,     760,   761,   -14129,
		574,   575,   576,   -12902,-462,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -1748, 32767, -1749,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     -255,  -255,  581,   582,   583,   584,   585,
		586,   587,   588,   589,   590,   591,   1214,  1215,
		1216,  1217,  1218,  1219,  1220,  1221,  1222,  1223,
		4947,  -171,  -170,  1227,  1228,  1229,  1230,  11067,
		1232,  1233,  1234,  1235,  1236,  1237,  1238,  -1391,
		1240,  1241,  1242,  -1390, 1244,  -3217, 604,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		767,   32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, -9177, 32767, 32767, 32767, 911,
		912,   0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		771,   -3830, 32767, 773,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 605,   32767,
		606,   32767, 774,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 607,   32767, 32767, 608,   609,   610,   -236,
		612,   613,   5235,  32767, 32767, 615,   616,   617,
		618,   619,   620,   32767, 32767, -4084, -4084, 32767,
		-63,   -62,   625,   -61,   32767, 32767, 32767, -61,
		-60,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4955,  4956,  32767,
		-3764, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -3794,
		-3794, -3794, -3794, -3794, 4880,  -3794, -3794, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-1423, -1750, -3794, -3794, -3794, -3794, -1754, -1754,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     6081,
		6082,  6083,  6084,  6085,  6086,  6087,  6088,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 3706,  4916,  3706,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4918,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 655,   656,   657,   658,   -1487, -1487,
		-1487, -1487, -1487, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -1669, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 665,   -573,
		9529,  -573,  32767, -574,  -574,  -5333, -5333, -5333,
		-5333, -5333, -5333, -5333, 32767, -5334, -5334, -5334,
		32767, 681,   682,   683,   684,   685,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2467,  2468,  2469,  2470,
		2471,  2472,  2473,  2474,  2475,  2476,  2477,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     -1001,
		-1001, -1001, -1001, 32767, -1002, -1002, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2512,  2513,  2514,  2515,  2516,  0,
		0,     0,     0,     0,     2522,  2523,  0,     1041,
		1042,  2527,  2528,  2529,  2530,  2531,  2532,  2533,
		2534,  2535,  2536,  2537,  693,   694,   695,   -8253,
		-4639, -4639, 32767, 32767, 2538,  2539,  0,     2541,
		2542,  2543,  2544,  2545,  0,     2547,  0,     2549,
		2550,  0,     2552,  2553,  0,     2555,  2556,  2557,
		2558,  2559,  2560,  2561,  2562,  2563,  2564,  2565,
		2566,  2567,  2568,  2569,  2570,  2571,  2572,  2573,
		2574,  2575,  2576,  2577,  2578,  2579,  2580,  2581,
		2582,  2583,  -1309, 706,   2585,  2586,  2587,  2588,
		2589,  2590,  2591,  2592,  -7879, 2594,  2595,  2596,
		2597,  2598,  2599,  2600,  2601,  2602,  2603,  2604,
		2605,  2606,  2607,  8568,  2609,  2610,  2611,  5328,
		5329,  5330,  5331,  5332,  2617,  5335,  201,   5337,
		5338,  5339,  5340,  5341,  5342,  5343,  5344,  5345,
		5346,  2630,  2631,  3718,  3719,  2634,  2635,  2636,
		2637,  2638,  2639,  2640,  2641,  2642,  2643,  2644,
		2645,  2646,  2647,  2648,  2649,  2650,  2651,  2652,
		2653,  2654,  2655,  2656,  2657,  2658,  2659,  2660,
		2661,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2695,  2696,  2697,  2698,  2699,  2700,
		2701,  2702,  2703,  14882, 9148,  2706,  9148,  9148,
		2072,  9149,  9149,  9149,  9149,  6758,  13674, 13674,
		32767, 759,   0,     0,     14891, 189,   189,   189,
		13668, -4759, -4759, 1362,  -4759, -4759, 0,     10102,
		0,     10103, 0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1458,  1459,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     9309,  9310,  9311,  9312,  9313,  9314,
		0,     0,     0,     9320,  9321,  9322,  9323,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     1962,  1962,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     7167,  0,     0,
		0,     0,     0,     0,     -143,  -143,  770,   0,
		0,     0,     4192,  4192,  4192,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     4602,  -13189,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		5320,  5320,  5320,  5320,  23111, 5320,  11054, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 0,
		0,     0,     0,     0,     0,     6247,  6247,  -4714,
		6247,  2055,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 778,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 779,   780,   781,   32767, 32767,
		782,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -2571, -2136, 32767, 32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4811,  4812,  4813,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 2178,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 2189,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4666,
		4667,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1743,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 785,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 786,   32767, 32767, 787,   788,
		789,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 790,
		791,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4668,  2585,  2585,  2014,  4672,
		4673,  4674,  4675,  2583,  4677,  4678,  32767, 32767,
		32767, 32767, 755,   756,   757,   758,   759,   760,
		761,   2992,  762,   -1954, -1953, -866,  -865,  -1950,
		-1949, -4921, -858,  -857,  7336,  -4923, -4923, 792,
		660,   660,   660,   32767, 32767, -4922, -4922, -4922,
		-4922, 658,   658,   -4874, 32767, 657,   657,   -8375,
		2587,  -8373, -18471,5846,  -303,  -8814, -13150,4641,
		-13150,39,    39,    375,   376,   -4350, 378,   32767,
		32767, 379,   380,   -1471, 382,   -1470, 384,   385,
		386,   387,   388,   389,   390,   391,   392,   393,
		394,   395,   396,   397,   398,   -346,  -346,  -346,
		-346,  401,   0,     0,     -571,  405,   -1449, 407,
		32767, 0,     409,   410,   411,   412,   413,   0,
		414,   -1441, -1441, -1441, -1441, -1441, 420,   421,
		32767, 32767, 422,   423,   -1439, -1439, 426,   427,
		428,   32767, 32767, 429,   -1435, -1435, 432,   433,
		-1433, 32767, 32767, 0,     2073,  436,   437,   -1752,
		439,   440,   441,   442,   443,   444,   445,   446,
		447,   448,   640,   2098,  642,   32767, 32767, 452,
		453,   454,   455,   456,   457,   458,   459,   460,
		-4233, 462,   463,   464,   465,   466,   467,   468,
		469,   470,   471,   472,   473,   0,     1519,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-456,  32767, 32767, 32767, 32767, 32767, 32767, -3164,
		3752,  32767, 32767, 32767, -467,  32767, 32767, 32767,
		32767, 799,   32767, 32767, 32767, 32767, 1521,  1522,
		32767, -4966, -478,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -2387, -2386, -2385, -2384, -2383,
		-2382, -2381, 3002,  4163,  4164,  4165,  -5186, -5186,
		-5186, -11287,-5186, -5186, -5186, -5186, -5186, -5186,
		-5186, -3944, -5186, -3943, -5186, -5186, -5186, -5186,
		-11299,-5186, -5186, -67,   32767, -11302,-11302,-5187,
		-5187, -11304,-5187, 32767, 32767, -5189, -5189, -5189,
		-5189, -5189, -5189, -5189, -5189, -5189, -5189, -5189,
		-5189, -5189, -5189, -5189, -5189, 32767, 4684,  -5191,
		-5191, -5191, -5191, -11304,-2732, -5191, -14146,32767,
		32767, 32767, 32767, 32767, 32767, 4685,  32767, 3013,
		3014,  3015,  32767, 5848,  5849,  5850,  5851,  5852,
		5853,  5854,  32767, 32767, 32767, 32767, 32767, 32767,
		802,   32767, 32767, 32767, 803,   32767, 32767, 32767,
		4686,  32767, 4687,  804,   805,   32767, 806,   807,
		32767, 808,   32767, 32767, 32767, 32767, 32767, 3016,
		32767, 4688,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4689,
		4690,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 4691,
		4692,  4693,  32767, 32767, 32767, 32767, 32767, 2190,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-1638, -1638, 0,     0,     2190,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     -191,
		-1648, -191,  -1648, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     4694,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     7916,  7916,  7916,  7916,  7916,  7916,
		7916,  7916,  7916,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     9319,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  1362,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  6151,  6152,  6153,  6154,  6155,
		6156,  6157,  6158,  6159,  6160,  5382,  5382,  -3685,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  5382,  5382,  5382,  5382,  5382,
		5382,  5382,  5382,  5382,  5382,  0,     -1160, -1160,
		-1160, 8192,  8193,  8194,  14296, 8196,  8197,  8198,
		5381,  5381,  5381,  5381,  5381,  5381,  5381,  5381,
		5381,  5381,  5381,  5381,  5381,  5381,  5381,  5381,
		5381,  5381,  5381,  5381,  5381,  5381,  5381,  5381,
		5381,  5381,  6143,  0,     0,     3019,  0,     3020,
		3021,  -1766, 0,     0,     3023,  -8634, -1770, -1770,
		8702,  32767, 32767, 3025,  3026,  32767, 3027,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, -1783, -7743,
		-1783, -1783, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 5046,  5047,  5048,  5049,  5050,
		5051,  5052,  32767, 32767, 32767, 169,   169,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		6144,  6145,  5767,  6147,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, -2883, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 563,   564,   565,
		8960,  0,     0,     0,     8964,  8964,  8964,  6573,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     13479, 1040,  0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -5930, 32767, 32767, 32767, 32767, 829,   830,
		-14060,32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 832,   833,
		834,   835,   0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -622,  -622,  -622,
		-622,  -622,  -622,  -622,  -622,  3032,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 32767, 32767, 32767, -638,  32767, 32767,
		32767, 32767, 1991,  -642,  3820,  0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 838,   32767, 32767, 32767, 32767,
		32767, 2458,  2458,  32767, 0,     4695,  32767, 839,
		840,   4696,  4697,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 841,   32767, 842,   32767,
		843,   32767, 32767, 32767, 32767, 0,     32767, 0,
		32767, 32767, 844,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 845,   32767, 32767, 32767,
		0,     846,   32767, 0,     0,     0,     847,   0,
		0,     -4621, 32767, -2323, 0,     0,     0,     0,
		0,     0,     32767, 32767, 4705,  4706,  32767, 686,
		686,   0,     687,   3034,  32767, 32767, 32767, 32767,
		-1963, -2342, -2342, 6037,  12728, 12729, -2990, 12731,
		12732, 12733, 12734, 12735, -531,  32767, 32767, -533,
		-533,  2711,  2711,  2711,  32767, 2710,  5710,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 6589,
		6590,  6591,  2699,  4714,  6593,  6594,  32767, 32767,
		32767, 6595,  6596,  6597,  -3874, 6599,  32767, 32767,
		32767, 2803,  32767, 32767, 32767, 32767, 8384,  32767,
		32767, 32767, 32767, 8337,  32767, 32767, 32767, 32767,
		-682,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-2389, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -2401, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		32767, 0,     0,     32767, 0,     32767, 32767, 0,
		32767, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 0,     0,     0,     0,
		32767, 0,     32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, -957,  32767, 32767, 32767, 32767, 0,
		32767, 0,     880,   0,     32767, 0,     0,     0,
		32767, 0,     0,     32767, 0,     32767, 32767, 0,
		32767, 0,     32767, 0,     32767, 0,     32767, 0,
		32767, 0,     0,     32767, 0,     32767, 32767, 0,
		0,     6115,  0,     6116,  6116,  0,     0,     6116,
		6116,  6116,  6116,  0,     6115,  0,     0,     0,
		6113,  6113,  6113,  6113,  6113,  6113,  6113,  0,
		6113,  0,     8572,  6113,  -2842, -450,  0,     0,
		8578,  8578,  13898, 13898, 13898, 0,     0,     13900,
		19634, 13900, 7458,  13900, 13900, 6824,  13901, 13901,
		13901, 13901, 11510, 18426, 18426, 19642, 18426, 0,
		15149, 19647, 6119,  0,     13904, 18427, 0,     0,
		6121,  0,     0,     4759,  14861, 4759,  14862, 4759,
		4759,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     4775,  4775,  4775,  4775,  0,     4776,  4776,
		4776,  0,     7826,  7827,  7828,  7829,  7830,  7831,
		4777,  4777,  4777,  4777,  4777,  0,     4778,  4778,
		0,     0,     4780,  4780,  4780,  4780,  4780,  0,
		0,     4782,  4782,  4782,  0,     4783,  0,     4784,
		0,     4785,  0,     4786,  4786,  4786,  4786,  0,
		4787,  4787,  4787,  0,     4788,  4788,  4788,  4788,
		4788,  4788,  4788,  0,     4789,  4789,  4789,  4789,
		4789,  4789,  0,     0,     0,     0,     4793,  4793,
		4793,  4793,  4793,  0,     882,   0,     0,     0,
		0,     4799,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  7927,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  4799,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  4799,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  4799,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  4799,  4799,  4799,  4799,  4799,  4799,  4799,
		4799,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -2458, -2458, -2458, 0,     0,
		0,     2649,  2650,  2651,  2652,  -5332, 2654,  -12410,
		0,     -12409,2659,  8018,  -360,  2662,  2663,  2664,
		0,     0,     0,     0,     0,     2142,  2143,  2144,
		2145,  0,     0,     0,     0,     0,     0,     0,
		0,     4307,  4308,  0,     4309,  4310,  0,     -173,
		0,     0,     -1457, 0,     -1457, 0,     -1457, 0,
		-1458, -8534, -8533, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     -3244,
		-3244, 0,     0,     0,     0,     0,     3000,  0,
		5135,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     2717,  2717,  1631,  1631,  2717,
		2717,  5690,  1628,  1628,  -6564, 5696,  5697,  0,
		5700,  5701,  5702,  5703,  5704,  5705,  5706,  5707,
		5708,  129,   130,   5663,  0,     5664,  5664,  6433,
		0,     0,     0,     -5044, 1106,  1107,  1108,  1109,
		1110,  1111,  1112,  1113,  1114,  1115,  1116,  1117,
		1118,  1119,  1120,  1121,  1122,  1123,  1124,  1125,
		1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,
		1134,  1135,  1136,  1137,  1138,  1139,  1140,  1141,
		1142,  1143,  1144,  1145,  1146,  1147,  1148,  1149,
		1150,  1151,  -5940, -5319, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 0,     32767,
		0,     32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     3316,  32767, 3317,  32767,
		3318,  32767, 32767, 3319,  3320,  32767, 32767, 32767,
		0,     0,     0,     9778,  3325,  3326,  3327,  3328,
		3329,  3330,  3331,  3332,  3333,  3334,  454,   3336,
		3337,  3338,  3339,  3340,  3341,  3342,  3343,  3344,
		3345,  3346,  3347,  3348,  3349,  3350,  3351,  3352,
		3353,  3354,  3355,  3356,  3357,  3358,  3359,  3360,
		3361,  0,     0,     3364,  3365,  3366,  3367,  3368,
		3369,  3370,  3371,  3372,  3373,  3374,  3375,  0,
		3377,  3378,  3379,  3380,  3381,  3382,  3383,  3384,
		3385,  3386,  0,     3388,  32767, 32767, 3389,  3390,
		3391,  3392,  3393,  0,     3395,  3396,  3397,  0,
		0,     0,     0,     0,     3403,  3404,  3405,  0,
		3407,  0,     3409,  3410,  3411,  3412,  3413,  3414,
		3415,  3416,  3417,  3418,  3419,  3420,  3421,  3422,
		3423,  3424,  3425,  3426,  3427,  3428,  3429,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -3723, 1396,  1396,  0,     0,     0,     0,
		-9836, 0,     0,     0,     0,     0,     0,     0,
		2630,  0,     0,     0,     2633,  0,     4462,  3462,
		3463,  3464,  3465,  3466,  3467,  3468,  3469,  3470,
		3471,  3472,  3473,  3474,  3475,  3476,  3477,  3478,
		3479,  3480,  3481,  3482,  3483,  3484,  3485,  3486,
		3487,  3488,  3489,  3490,  3491,  3492,  3493,  3494,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		3400,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		471,   471,   885,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 7954,  32767,
		32767, 32767, 32767, 0,     32767, 32767, -620,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -11684,32767,
		7964,  32767, 32767, 32767, 32767, 32767, 7967,  0,
		32767, -6890, -6889, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -2878, -2877, -2876, -2875, 8087,  -2873,
		-12971,0,     32767, 0,     32767, 32767, 32767, 877,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 7021,
		13712, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		878,   32767, 879,   0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     32767, 32767, 0,     0,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 0,     0,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     32767, 32767, 32767, 32767, -18761,5867,
		5868,  5869,  5870,  5871,  5872,  5873,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     4392,
		4393,  4394,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     8674,  0,     0,     3794,  3794,  3794,
		3794,  3794,  3794,  3794,  3794,  3794,  2371,  2044,
		0,     0,     0,     0,     2040,  2040,  3794,  3794,
		0,     0,     -4405, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     2454,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		7266,  7266,  7266,  7266,  7266,  7266,  7266,  7266,
		7266,  7266,  7266,  7266,  7266,  7266,  7266,  7266,
		7266,  7266,  7266,  32767, 32767, 32767, 7263,  7263,
		7263,  7263,  7263,  7263,  32767, 32767, 7261,  7261,
		7261,  7261,  7261,  7261,  32767, 32767, 2460,  2460,
		2460,  2460,  2460,  2460,  32767, 32767, 0,     0,
		0,     32767, 5102,  5103,  5104,  5105,  5106,  5107,
		-2877, 5109,  -9955, -6587, -9955, 5113,  10472, 2094,
		5116,  5117,  5118,  5119,  5120,  5121,  5122,  4744,
		5124,  5125,  -3253, -9943, -9943, 5777,  -9943, -9943,
		-9943, -9943, -9943, 3324,  3325,  3326,  3327,  3328,
		85,    86,    87,    88,    89,    -2910, 91,    -5043,
		93,    94,    95,    96,    97,    98,    99,    100,
		101,   102,   -2614, -2613, -1526, -1525, -2610, -2609,
		-5581, -1518, -1517, 6676,  -5583, -5583, 132,   0,
		0,     0,     -5580, -5580, -5580, -5580, -5580, -5580,
		0,     0,     -5532, 5183,  0,     0,     6677,  32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     4922,
		4923,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     32767,
		0,     0,     32767, 32767, 0,     32767, 32767, 0,
		0,     32767, 32767, 0,     0,     0,     0,     32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     32767, 0,
		0,     0,     0,     0,     0,     0,     32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     11201, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 886,   887,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 888,   32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     -4020, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     769,   770,
		771,   772,   773,   774,   775,   776,   777,   778,
		0,     0,     -9067, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     -6540, -6540, 2812,  32767, 2813,  8915,
		2815,  2816,  2817,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     762,   32767, 32767,
		32767, 32767, -2365, 32767, 32767, 32767, 32767, 32767,
		-14024,32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     0,     0,
		0,     32767, 0,     32767, 0,     0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 889,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 890,   32767, 32767, 32767,
		0,     -4168, -4168, -4168, -4168, -4168, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     -4192, -4192, 32767, -4193, -4193,
		-4193, -4193, -4193, -4193, 409,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 0,     0,     32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -1663, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 891,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 892,   893,   894,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 0,
		0,     4788,  32767, 32767, 0,     11658, 32767, 8415,
		8416,  32767, 32767, 0,     0,     32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		5874,  5875,  5876,  5877,  32767, 5878,  5879,  5880,
		5881,  5882,  5883,  5884,  5885,  5886,  5887,  5888,
		5889,  5890,  5891,  5892,  5893,  5894,  5895,  5896,
		5897,  5898,  5899,  5900,  5901,  5902,  5903,  5904,
		32767, 5905,  5906,  32767, 5907,  32767, 32767, 5908,
		32767, 5909,  5910,  5911,  5912,  5913,  5914,  5915,
		5916,  5917,  5918,  32767, 5919,  5920,  5921,  5922,
		32767, 5923,  32767, 5924,  32767, 32767, 32767, 32767,
		32767, 32767, 6882,  32767, 32767, 32767, 32767, 5926,
		32767, 5927,  32767, 5928,  32767, 5929,  5930,  5931,
		32767, 5932,  5933,  32767, 5934,  32767, 32767, 5935,
		32767, 5936,  32767, 5937,  32767, 5938,  32767, 5939,
		32767, 5940,  5941,  32767, 5942,  32767, 32767, 5943,
		5944,  -170,  5946,  32767, -169,  5948,  5949,  -166,
		-165,  -164,  -163,  32767, -161,  5955,  5956,  5957,
		32767, -155,  -154,  -153,  -152,  32767, -151,  32767,
		-150,  5964,  -2607, -147,  8809,  6418,  5969,  5970,
		-2607, -2606, 32767, -7925, -7924, 5975,  5976,  -7923,
		-13656,-7921, -1478, -7919, -7918, -841,  -7917, -7916,
		-7915, -7914, -5522, -12437,32767, 32767, 32767, 32767,
		32767, -13657,-128,  5992,  32767, -12434,5994,  5995,
		-125,  5997,  0,     1239,  -8862, 1241,  -8861, 1243,
		1244,  6004,  6005,  6006,  6007,  6008,  6009,  6010,
		6011,  6012,  6013,  6014,  32767, 0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 897,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 0,     -1786, -1786, -1786,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 898,
		899,   900,   901,   902,   903,   904,   905,   32767,
		32767, 906,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 907,   -8041, -8041,
		7679,  -3281, 912,   913,   914,   915,   916,   0,
		0,     0,     0,     32767, -1845, -1845, -1845, -1845,
		0,     0,     0,     8949,  8950,  -6769, 4192,  0,
		0,     0,     0,     0,     917,   918,   919,   920,
		32767, 2766,  2767,  2768,  2769,  925,   926,   927,
		-8021, -8021, 7699,  -3261, 932,   933,   934,   935,
		936,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -1879, -1879,
		-1879, -1879, -1879, -1879, -1879, -1879, 2014,  0,
		-1878, -1878, -1878, -1878, -1878, -1878, -1878, -1878,
		8594,  -1878, -1878, -1878, -1878, -1878, 32767, -1879,
		-1879, -1879, -1879, -1879, -1879, -1879, -1879, -7839,
		-1879, -1879, -1879, -4595, -4595, -4595, -4595, -4595,
		-1879, -4596, 539,   -4596, -4596, -4596, -4596, -4596,
		-4596, -4596, -4596, -4596, 32767, 397,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 943,
		32767, 32767, 32767, 32767, 32767, 32767, 944,   32767,
		945,   32767, 32767, 946,   947,   32767, 948,   949,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 950,   951,
		952,   953,   954,   955,   956,   957,   958,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4591,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 959,   960,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 961,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 51,    51,    32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 964,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4767,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 6015,  6016,  6017,  6018,  6019,
		6020,  6021,  6022,  6023,  7447,  7775,  32767, 32767,
		32767, 32767, 32767, 7780,  6027,  6028,  6029,  6030,
		6031,  6032,  6033,  6034,  6035,  6036,  6037,  6038,
		6039,  6040,  6041,  6042,  6043,  6044,  6045,  6046,
		6047,  6048,  6049,  6050,  6051,  6052,  6053,  6054,
		6055,  6056,  32767, 6057,  6058,  6059,  6060,  6061,
		6062,  6063,  6064,  6065,  6066,  6067,  6068,  6069,
		6070,  6071,  6072,  6073,  6074,  6075,  6076,  6077,
		6078,  6079,  6080,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     965,   1410,  1411,  1412,
		1413,  1414,  1415,  1416,  1417,  1418,  12380, 1420,
		-8678, 15639, 9490,  979,   -3357, 14434, -3357, 2377,
		-3357, 2379,  1174,  2381,  1174,  2383,  1174,  2385,
		1174,  2387,  1174,  1174,  2390,  1174,  2392,  -2104,
		2394,  1174,  -2102, 1174,  1174,  1174,  1174,  -2400,
		-2400, -2400, -2400, 2405,  1174,  2407,  2408,  1174,
		2410,  2411,  1174,  2413,  2414,  -1896, 1174,  1174,
		1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,
		1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,
		1174,  1174,  -3323, 2437,  1174,  1174,  1174,  1174,
		2442,  2443,  2444,  2445,  1174,  2447,  2448,  1174,
		1174,  992,   -3314, -3314, -2076, -3314, -3314, 997,
		1171,  999,   1000,  2458,  1002,  2460,  1004,  2462,
		9540,  2464,  9541,  9541,  1009,  1010,  1011,  1012,
		1013,  1014,  1015,  1016,  1017,  1018,  1019,  1020,
		1021,  1022,  1023,  0,     1024,  1025,  1026,  1027,
		1028,  1029,  1030,  1031,  1032,  1033,  1034,  1035,
		1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,
		1044,  1045,  1046,  1047,  1048,  1049,  1050,  1051,
		0,     0,     0,     0,     -8971, -1739, -1738, -1737,
		-8971, -8971, -8971, -8971, -8971, 1052,  -8971, -8971,
		32767, -8972, -8972, -8972, -8972, -5604, -8972, -8972,
		-8972, -8972, -8972, -8972, -8972, -1697, -8972, -8972,
		32767, -8973, -8973, -8973, -2283, -8973, -8973, 6747,
		-8973, -8973, -8973, -8973, -8973, 4294,  4295,  4296,
		4297,  4298,  1055,  1056,  1057,  1058,  1059,  -1940,
		1061,  -4073, 1063,  1064,  1065,  1066,  1067,  1068,
		1069,  1070,  1071,  1072,  -1644, -1643, -556,  -555,
		-1640, -1639, -4611, -548,  -547,  7646,  -4613, -4613,
		1085,  -4614, -4614, -4614, -4614, -4614, -4614, -4614,
		-4614, -4614, 966,   966,   -4566, 1098,  -4565, -4564,
		-5332, 1102,  1103,  1104,  6149,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     7092,  6472,  6473,  6474,  1155,
		1156,  1157,  1158,  -16632,1160,  -4573, 1162,  7605,
		1164,  1165,  1166,  1167,  1168,  1169,  1170,  3562,
		-3353, -3352, -4567, -3350, -4567, -70,   -4567, -3346,
		1180,  1181,  -3341, -3340, -3339, 236,   237,   238,
		239,   240,   241,   242,   243,   244,   11206, 246,
		-9852, 14465, 8316,  -195,  -4531, 13260, -4531, 1203,
		-4531, 1205,  0,     1207,  0,     1209,  0,     1211,
		0,     1213,  0,     0,     1216,  0,     1218,  -3278,
		1220,  0,     -3276, 0,     0,     0,     0,     -3574,
		-3574, -3574, -3574, 1231,  0,     1233,  1234,  0,
		1236,  1237,  0,     1239,  1240,  -3070, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     -4497, 1263,  0,     0,     0,     0,
		1268,  1269,  1270,  1271,  0,     1273,  1274,  0,
		0,     -182,  -4488, 0,     1280,  1281,  -4485, -174,
		0,     -172,  -171,  1287,  -169,  1289,  -167,  1291,
		8369,  1293,  8370,  8370,  1296,  1297,  1298,  1299,
		1300,  1301,  1302,  1303,  1304,  1305,  1306,  1307,
		1308,  1309,  0,     0,     0,     0,     1310,  1311,
		1312,  1313,  1314,  1315,  1316,  1317,  1318,  1319,
		1320,  1321,  1322,  1323,  1324,  1325,  1326,  1327,
		1328,  1329,  1330,  1331,  1332,  1333,  1334,  1335,
		1336,  0,     1338,  1339,  1340,  1341,  1342,  1343,
		1344,  1345,  1346,  1347,  1348,  1349,  1350,  1351,
		1352,  1353,  1354,  1355,  1356,  1357,  1358,  1359,
		1360,  1361,  1362,  1363,  1364,  1365,  1366,  1367,
		1368,  1369,  1370,  1371,  1372,  1373,  1374,  1375,
		1376,  1377,  1378,  1379,  1380,  1381,  1382,  1383,
		1384,  1385,  1386,  1387,  1388,  1389,  1390,  1391,
		1392,  1393,  1394,  1395,  1396,  1397,  1398,  1399,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 1400,
		1401,  1402,  1403,  1404,  1405,  1406,  1407,  1408,
		444,   0,     0,     0,     0,     0,     0,     0,
		0,     0,     -10961,0,     10099, 32767, 32767, 443,
		4780,  -13010,4782,  -951,  4784,  11227, 32767, -953,
		255,   -953,  257,   -953,  259,   -953,  261,   262,
		-953,  264,   -953,  3544,  -953,  268,   3545,  270,
		271,   272,   273,   3848,  3849,  3850,  3851,  -953,
		279,   -953,  -953,  282,   -953,  -953,  285,   -953,
		-953,  3358,  289,   290,   291,   32767, 32767, 292,
		293,   294,   295,   296,   297,   32767, 32767, 298,
		299,   300,   301,   302,   303,   304,   4802,  3582,
		306,   32767, 307,   32767, -960,  32767, -961,  -961,
		311,   -961,  -961,  314,   315,   498,   4805,  4806,
		3569,  4808,  4809,  499,   326,   499,   499,   -958,
		499,   -958,  499,   -958,  -8035, -958,  -8034, -8033,
		500,   500,   500,   500,   500,   32767, 32767, 498,
		498,   498,   498,   498,   498,   498,   498,   1522,
		499,   499,   499,   499,   499,   499,   499,   499,
		499,   499,   499,   499,   499,   499,   499,   499,
		499,   499,   499,   499,   499,   499,   499,   499,
		499,   499,   499,   499,   1551,  1552,  1553,  1554,
		10526, 3295,  3295,  3295,  10530, 10531, 10532, 10533,
		10534, 512,   10536, 10537, 10538, 10539, 10540, 10541,
		10542, 7175,  10544, 10545, 10546, 10547, 10548, 10549,
		10550, 3276,  10552, 10553, 10554, 10555, 10556, 10557,
		3868,  10559, 10560, -5159, 10562, 10563, 10564, 10565,
		10566, -2700, -2700, 3260,  10570, -2702, 542,   542,
		542,   542,   542,   3258,  541,   5676,  541,   541,
		541,   541,   541,   541,   541,   541,   541,   541,
		3258,  3258,  2172,  2172,  3258,  3258,  6231,  6232,
		6233,  -6025, 6235,  6236,  6237,  6238,  6239,  6240,
		6241,  6242,  6243,  6244,  6245,  6246,  6247,  6248,
		1633,  1634,  1635,  1636,  1637,  1638,  1639,  -872,
		-872,  -872,  -872,  6260,  6261,  6262,  6263,  6264,
		6265,  -878,  6267,  6268,  6269,  6270,  6271,  -883,
		6273,  6274,  6275,  6276,  6277,  6278,  6279,  6280,
		6281,  6282,  6283,  6284,  9899,  6286,  6287,  6288,
		6289,  6290,  6291,  6292,  6293,  6294,  6295,  -895,
		6297,  6298,  6299,  1650,  -898,  6302,  1652,  -899,
		6305,  6306,  6307,  6308,  -903,  6310,  -904,  6312,
		6313,  6314,  6315,  6316,  6317,  6318,  6319,  -912,
		-912,  -912,  6323,  6324,  6325,  6326,  6327,  -3695,
		6329,  6330,  6331,  6332,  6333,  6334,  6335,  2968,
		6337,  6338,  6339,  6340,  6341,  6342,  6343,  -931,
		6345,  6346,  6347,  6348,  6349,  6350,  -339,  6352,
		6353,  -9366, 6355,  6356,  6357,  6358,  6359,  -6907,
		-6907, -947,  6363,  -6909, -3665, -3665, -3665, -3665,
		-3665, -949,  -3666, 1469,  -3666, -3666, -3666, -3666,
		-3666, -3666, -3666, -3666, -3666, -3666, -949,  -949,
		-2035, -2035, -949,  -949,  -949,  -949,  -949,  6392,
		-950,  -950,  -950,  -950,  -950,  -950,  -950,  -950,
		-950,  -950,  -950,  -950,  -950,  6406,  6407,  6408,
		6409,  -4824, -4823, 6412,  6413,  6414,  6415,  6416,
		1703,  302,   6418,  303,   304,   6421,  6422,  307,
		308,   309,   310,   6427,  313,   6429,  6430,  6431,
		319,   320,   321,   322,   323,   324,   325,   6439,
		327,   6441,  -2130, 330,   9286,  6895,  6446,  6447,
		-2130, -2129, -7448, -7447, -7446, 6453,  6454,  -7445,
		-13178,-7443, -1000, -7441, -7440, -363,  -7439, -7438,
		-7437, -7436, -5044, -11959,-11958,-13173,-11956,6471,
		-8677, -13174,355,   6475,  -7428, -11950,6478,  6479,
		359,   6481,  6482,  1724,  -8377, 1726,  -8376, 1728,
		1729,  6489,  6490,  6491,  6492,  6493,  6494,  6495,
		6496,  6497,  6498,  6499,  6500,  6501,  6502,  6503,
		6504,  1730,  1731,  1732,  1733,  6509,  1734,  1735,
		1736,  6513,  -1312, -1312, -1312, -1312, -1312, -1312,
		1743,  1744,  1745,  1746,  1747,  6525,  1748,  1749,
		6528,  6529,  1750,  1751,  1752,  1753,  1754,  6535,
		6536,  1755,  1756,  1757,  6540,  1758,  6542,  1759,
		6544,  1760,  6546,  1761,  1762,  1763,  1764,  6551,
		1765,  1766,  1767,  6555,  1768,  1769,  1770,  1771,
		1772,  1773,  1774,  6563,  1775,  1776,  1777,  1778,
		1779,  1780,  6570,  6571,  6572,  6573,  1781,  1782,
		1783,  1784,  1785,  6579,  5698,  6581,  6582,  6583,
		6584,  1786,  1787,  1788,  1789,  1790,  1791,  1792,
		1793,  -1334, 1795,  1796,  1797,  1798,  1799,  1800,
		1801,  1802,  1803,  1804,  1805,  1806,  1807,  1808,
		1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,
		1817,  1818,  1819,  1820,  1821,  1822,  1823,  1824,
		1825,  1826,  1827,  1828,  1829,  1830,  1831,  1832,
		1833,  6633,  6634,  6635,  6636,  6637,  6638,  6639,
		6640,  6641,  6642,  9101,  9102,  9103,  6646,  6647,
		6648,  4000,  4000,  4000,  4000,  11985, 4000,  19065,
		6656,  19066, 3999,  -1359, 7020,  3999,  3999,  3999,
		6664,  6665,  6666,  6667,  6668,  4527,  4527,  4527,
		4527,  0,     1990,  8906,  8906,  6676,  6677,  6678,
		6679,  6680,  6681,  6682,  6683,  6684,  6685,  6686,
		6687,  6688,  6689,  6690,  6691,  6692,  5347,  6694,
		5348,  6696,  5349,  6698,  -8867, 6700,  5796,  6702,
		0,     0,     0,     0,     0,     0,     9349,  9350,
		9351,  0,     0,     0,     -6101, 0,     0,     0,
		0,     0,     0,     0,     1242,  0,     1243,  0,
		0,     0,     0,     -6113, 0,     0,     5119,  5119,
		-6115, -6115, 0,     0,     -6117, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -6113, 2459,
		0,     -8955, -6563, 1842,  2463,  2463,  2463,  7783,
		7783,  7783,  7783,  25574, 7783,  13517, 7783,  1341,
		7783,  7783,  7783,  7783,  7783,  7783,  7783,  5392,
		12308, 12308, 13524, 12308, 13526, 9030,  13528, 0,
		-6119, 7785,  12308, 0,     0,     0,     -6121, 1847,
		32767, 8738,  8738,  8738,  8738,  8738,  -2223, 8738,
		18837, -5479, 671,   9183,  13520, -4270, 13522, 334,
		335,   0,     0,     4727,  0,     0,     -6236, 0,
		0,     1852,  0,     1853,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     745,   746,   0,
		402,   403,   975,   0,     1855,  0,     -1685, 408,
		0,     0,     0,     0,     0,     0,     0,     1856,
		1857,  1858,  1859,  1860,  0,     0,     1861,  1862,
		0,     0,     1863,  1864,  0,     0,     0,     0,
		0,     0,     1865,  1866,  0,     0,     1867,  1868,
		0,     32767, 1869,  1870,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1871,  1872,
		1873,  1874,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1875,  1876,  1877,  1878,  32767, 32767,
		32767, 32767, 32767, 32767, 1879,  1880,  1881,  1882,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1883,  1884,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     0,     0,     4753,  4754,  4755,  4756,  4757,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -5000, 0,     -4999, 0,     -4998,
		0,     -4997, 0,     -4996, 9869,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 0,     32767, 0,     0,
		32767, 0,     0,     32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 251,   251,   251,   251,
		251,   251,   2763,  2764,  2765,  2766,  -4365, -4365,
		-4365, -4365, -4365, -4365, 2779,  -4365, -4365, -4365,
		-4365, -4365, 2790,  -4365, -4365, -4365, -4365, -4365,
		-4365, -4365, -4365, -4365, -4365, -4365, -4365, -7979,
		-4365, -4365, -4365, -4365, -4365, -4365, -4365, -4365,
		-4365, -4365, 2826,  -4365, -4365, -4365, 285,   2834,
		-4365, 286,   2838,  -4365, -4365, -4365, -4365, 2847,
		-4365, 2850,  -4365, -4365, -4365, -4365, -4365, -4365,
		-4365, -4365, 2867,  2868,  2869,  -4365, -4365, -4365,
		-4365, -4365, 5658,  -4365, -4365, -4365, -4365, -4365,
		-4365, -4365, -997,  -4365, -4365, -4365, -4365, -4365,
		-4365, -4365, 2910,  -4365, -4365, -4365, -4365, -4365,
		-4365, 2325,  -4365, -4365, 11355, -4365, -4365, -4365,
		-4365, -4365, 8902,  8903,  2944,  -4365, 8908,  5665,
		5666,  5667,  5668,  5669,  2954,  5672,  538,   5674,
		5675,  5676,  5677,  5678,  5679,  5680,  5681,  5682,
		5683,  2967,  2968,  4055,  4056,  2971,  2972,  0,
		0,     0,     12259, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     4616,  4616,  4616,  4616,  4616,  4616,  4616,
		7128,  7129,  7130,  7131,  0,     0,     0,     0,
		0,     0,     7144,  0,     0,     0,     0,     0,
		7155,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -3614, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		7191,  0,     0,     0,     4650,  7199,  0,     4651,
		7203,  0,     0,     0,     0,     7212,  0,     7215,
		0,     0,     0,     0,     0,     0,     0,     0,
		7232,  7233,  7234,  0,     0,     0,     0,     0,
		10023, 0,     0,     0,     0,     0,     0,     0,
		3368,  0,     0,     0,     0,     0,     0,     0,
		7275,  0,     0,     0,     0,     0,     0,     6690,
		0,     0,     15720, 0,     0,     0,     0,     0,
		13267, 13268, 7309,  0,     13273, 10030, 10031, 10032,
		10033, 10034, 7319,  10037, 4903,  10039, 10040, 10041,
		10042, 10043, 10044, 10045, 10046, 10047, 10048, 7332,
		7333,  8420,  8421,  7336,  7337,  7338,  7339,  7340,
		0,     7343,  7344,  7345,  7346,  7347,  7348,  7349,
		7350,  7351,  7352,  7353,  7354,  7355,  0,     0,
		0,     0,     11234, 11234, 0,     0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 775,   32767,
		32767, 776,   32767, 32767, 32767, 32767, 32767, 777,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 0,     -444,  -444,  32767,
		-445,  -445,  -445,  -445,  -445,  -445,  -11406,-445,
		9654,  -14662,-8512, 0,     4337,  32767, 4338,  -1395,
		4340,  -1395, -189,  -1395, -187,  32767, 32767, 32767,
		32767, -1399, 32767, 32767, 32767, 32767, 32767, 32767,
		-1405, 32767, 32767, 32767, -184,  -183,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 3035,  3036,
		3037,  3038,  3039,  3040,  3041,  3042,  3043,  3044,
		3045,  3046,  3047,  0,     0,     0,     0,     0,
		0,     0,     3055,  3056,  3057,  3058,  3059,  3060,
		3061,  3062,  3063,  3064,  3065,  3066,  3067,  3068,
		3069,  3070,  3071,  3072,  3073,  3074,  3075,  3076,
		3077,  3078,  3079,  3080,  3081,  3082,  3083,  3084,
		3085,  3086,  3087,  3088,  3089,  3090,  3091,  3092,
		3093,  3094,  3095,  3096,  3097,  3098,  3099,  3100,
		3101,  3102,  3103,  3104,  3105,  3106,  3107,  3108,
		3109,  3110,  3111,  3112,  3113,  3114,  3115,  3116,
		3117,  3118,  3119,  3120,  3121,  3122,  3123,  3124,
		3125,  3126,  3127,  0,     3129,  3130,  3131,  3132,
		3133,  3134,  3135,  3136,  3137,  3138,  3139,  3140,
		3141,  3142,  3143,  3144,  3145,  3146,  3147,  3148,
		3149,  3150,  3151,  3152,  3153,  3154,  3155,  3156,
		3157,  3158,  3159,  3160,  3161,  3162,  3163,  3164,
		3165,  3166,  3167,  3168,  3169,  3170,  0,     0,
		0,     0,     0,     0,     7985,  0,     15065, 11698,
		15067, 0,     -5358, 3021,  0,     0,     0,     0,
		0,     0,     0,     379,   0,     0,     8379,  15070,
		15071, -648,  15073, 15074, 15075, 15076, 15077, 1811,
		1811,  1811,  1811,  1811,  5055,  5055,  5055,  5055,
		5055,  8055,  5055,  10190, 5055,  5055,  5055,  5055,
		5055,  5055,  5055,  5055,  5055,  5055,  7772,  7772,
		6686,  6686,  7772,  7772,  10745, 6683,  6683,  -1509,
		10751, 10752, 5038,  5171,  5172,  5173,  10754, 10755,
		10756, 10757, 10758, 10759, 5180,  5181,  10714, 0,
		5184,  5185,  -1491, 3256,  14217, 24316, 0,     6150,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 2713,  2714,  2715,  2716,  2717,
		2718,  2719,  2720,  2721,  2722,  2723,  2724,  2725,
		2726,  2727,  2728,  2729,  2730,  2731,  2732,  2733,
		2734,  2735,  2736,  2737,  2738,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     3048,  3049,  3050,  3051,  3052,  3053,
		3054,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     3128,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     3171,  3172,  3173,
		3174,  3175,  3176,  -4808, 3178,  -11886,-8518, -11886,
		3182,  8541,  163,   3185,  3186,  3187,  3188,  3189,
		3190,  3191,  2813,  3193,  3194,  -5184, -11874,-11874,
		3846,  -11874,-11874,-11874,-11874,-11874,1393,  1394,
		1395,  1396,  1397,  -1846, -1845, -1844, -1843, -1842,
		-4841, -1840, -6974, -1838, -1837, -1836, -1835, -1834,
		-1833, -1832, -1831, -1830, -1829, -4545, -4544, -3457,
		-3456, -4541, -4540, -7512, -3449, -3448, 4745,  -7514,
		-7514, -1799, -1931, -1931, -1931, -7511, -7511, -7511,
		-7511, -7511, -7511, -1931, -1931, -7463, 3252,  -1931,
		-1931, 4746,  0,     -10960,-21058,3259,  -2890, 3261,
		3262,  3263,  3264,  3265,  3266,  3267,  3268,  3269,
		3270,  3271,  3272,  3273,  3274,  3275,  3276,  3277,
		3278,  3279,  3280,  3281,  3282,  3283,  3284,  3285,
		3286,  3287,  3288,  3289,  3290,  32767, 3291,  3292,
		3293,  3294,  3295,  3296,  3297,  3298,  3299,  3300,
		3301,  3302,  3303,  3304,  32767, 32767, 3305,  32767,
		3306,  32767, 32767, 3307,  3308,  3309,  3310,  3311,
		3312,  3313,  3314,  3315,  0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		3321,  3322,  3323,  -6454, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     2881,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     3362,  3363,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     3376,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     3387,  0,     0,     0,     0,     0,
		0,     0,     0,     3394,  0,     0,     0,     3398,
		3399,  3400,  3401,  3402,  0,     0,     0,     3406,
		0,     3408,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     3430,
		3431,  3432,  3433,  3434,  3435,  3436,  3437,  3438,
		3439,  7163,  2045,  2046,  3443,  3444,  3445,  3446,
		13283, 3448,  3449,  3450,  3451,  3452,  3453,  3454,
		825,   3456,  3457,  3458,  826,   3460,  -1001, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     3499,  0,     0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3502,  3503,  3504,  3505,  3506,  32767,
		32767, 32767, 32767, 32767, 3507,  3508,  985,   2026,
		2027,  3512,  3513,  3514,  3515,  3516,  3517,  3518,
		3519,  3520,  3521,  3522,  3523,  3524,  3525,  3526,
		3527,  3528,  3529,  3530,  3531,  3532,  32767, 3533,
		3534,  3535,  3536,  3537,  32767, 3538,  32767, 3539,
		3540,  32767, 3541,  3542,  32767, 3543,  3544,  3545,
		3546,  3547,  3548,  3549,  3550,  3551,  3552,  3553,
		3554,  3555,  3556,  3557,  3558,  3559,  3560,  3561,
		3562,  3563,  3564,  3565,  3566,  3567,  3568,  3569,
		3570,  3571,  -321,  3573,  3574,  3575,  3576,  3577,
		3578,  3579,  3580,  3581,  -6890, 3583,  3584,  3585,
		3586,  3587,  3588,  3589,  3590,  3591,  3592,  3593,
		3594,  3595,  3596,  9557,  3598,  3599,  3600,  6317,
		6318,  6319,  6320,  6321,  3606,  6324,  1190,  6326,
		6327,  6328,  6329,  6330,  6331,  6332,  6333,  6334,
		6335,  3619,  3620,  4707,  4708,  3623,  3624,  3625,
		3626,  3627,  3628,  3629,  3630,  3631,  3632,  3633,
		3634,  3635,  3636,  3637,  3638,  3639,  3640,  3641,
		3642,  3643,  3644,  3645,  3646,  3647,  3648,  3649,
		3650,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3651,  3652,  3653,  3654,  3655,  3656,
		3657,  3658,  3659,  15838, 10104, 3662,  10104, 10104,
		3028,  10105, 10105, 10105, 3669,  3670,  3671,  3672,
		3673,  3674,  3675,  3676,  3677,  3678,  3679,  3680,
		3681,  3682,  3683,  3684,  3685,  3686,  3687,  3688,
		3689,  3690,  3691,  3692,  3693,  3694,  3695,  32767,
		3696,  3697,  3698,  3699,  3700,  3701,  3702,  3703,
		3704,  3705,  3706,  3707,  3708,  3709,  3710,  3711,
		3712,  3713,  3714,  3715,  3716,  3717,  3718,  3719,
		3720,  3721,  3722,  3723,  3724,  3725,  3726,  3727,
		3728,  3729,  3730,  3731,  3732,  3733,  3734,  3735,
		3736,  3737,  3738,  3739,  3740,  3741,  -3350, -2729,
		-2729, -2729, 2591,  2591,  2591,  2591,  20382, 2591,
		8325,  2591,  -3851, 2591,  2591,  2591,  2591,  2591,
		2591,  2591,  200,   7116,  7116,  8332,  7116,  8334,
		3838,  8336,  7116,  2591,  2591,  7114,  7114,  7114,
		3540,  3540,  3540,  3540,  3540,  3540,  3540,  3540,
		3540,  -7421, 3540,  13639, -10677,-4527, 3985,  8322,
		-9468, 8324,  2591,  8326,  2591,  3797,  2591,  3799,
		2591,  3801,  2591,  3803,  2591,  3805,  3806,  2591,
		3808,  2591,  7088,  2591,  3812,  7089,  3814,  3815,
		3816,  3817,  7392,  7393,  7394,  7395,  2591,  3823,
		2591,  2591,  3826,  2591,  2591,  3829,  2591,  2591,
		6902,  3833,  3834,  3835,  3836,  3837,  3838,  3839,
		3840,  3841,  3842,  3843,  3844,  3845,  3846,  3847,
		3848,  3849,  3850,  3851,  3852,  8350,  2591,  3855,
		3856,  3857,  3858,  2591,  2591,  2591,  2591,  3863,
		2591,  2591,  3866,  3867,  4050,  8357,  3870,  2591,
		2591,  8358,  4048,  3875,  4048,  4048,  2591,  4048,
		2591,  4048,  2591,  -4486, 2591,  -4485, -4484, 2591,
		2591,  2591,  2591,  2591,  2591,  2591,  2591,  2591,
		2591,  2591,  2591,  2591,  2591,  3901,  3902,  3903,
		3904,  2595,  2595,  2595,  2595,  2595,  2595,  2595,
		2595,  2595,  2595,  2595,  2595,  2595,  2595,  2595,
		2595,  2595,  2595,  2595,  2595,  2595,  2595,  2595,
		2595,  2595,  2595,  2595,  3932,  2595,  2595,  2595,
		2595,  2595,  2595,  2595,  2595,  2595,  2595,  2595,
		2595,  2595,  2595,  2595,  2595,  2595,  2595,  2595,
		32767, 3952,  3953,  3954,  3955,  3956,  -5352, -5352,
		-5352, -5352, -5352, -5352, 3963,  3964,  3965,  -5354,
		-5354, -5354, -5354, 3970,  3971,  3972,  3973,  3974,
		3975,  3976,  3977,  3978,  3979,  3980,  3981,  3982,
		3983,  3984,  3985,  3986,  3987,  3988,  3989,  3990,
		2029,  2030,  3993,  3994,  3995,  3996,  3997,  3998,
		3999,  4000,  4001,  4002,  4003,  4004,  4005,  4006,
		4007,  4008,  4009,  4010,  4011,  4012,  4013,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4014,  4015,  4016,  4017,  4018,  4019,  4020,
		4021,  4022,  -579,  17213, 4025,  4026,  4027,  4028,
		4029,  4030,  4031,  4032,  4033,  4034,  4035,  4036,
		4037,  4038,  4039,  4040,  4041,  4042,  4043,  4044,
		4045,  4046,  4047,  4048,  -1271, -1270, -1269, -1268,
		-19058,-1266, -6999, 4056,  4057,  4058,  4059,  4060,
		4061,  4062,  4063,  4064,  4065,  4066,  4067,  4068,
		4069,  4070,  4071,  4072,  4073,  4074,  4075,  4076,
		4077,  32767, 32767, 4078,  4079,  4080,  4081,  4082,
		4083,  -2163, -2162, 8800,  -2160, 2033,  4089,  4090,
		4091,  4092,  4093,  4094,  4095,  4096,  4097,  4098,
		4099,  4100,  4101,  4102,  4103,  4104,  4105,  4106,
		4107,  4108,  4109,  4110,  4111,  4112,  4113,  4114,
		4115,  4116,  4117,  4118,  4119,  4120,  4121,  4122,
		4123,  4124,  4125,  4126,  4127,  4128,  4129,  4130,
		4131,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 4132,  4133,  4134,  4135,  4136,  4137,  4138,
		4139,  4140,  4141,  4142,  4143,  4144,  32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 4145,  4146,  4147,  4148,  4149,  4150,
		4151,  4152,  4153,  4154,  2034,  32767, 32767, 32767,
		32767, 32767, 4155,  4156,  4157,  4158,  4159,  4160,
		4161,  4162,  4163,  4164,  1284,  4166,  4167,  4168,
		4169,  4170,  4171,  4172,  4173,  4174,  4175,  4176,
		4177,  4178,  4179,  4180,  4181,  4182,  4183,  4184,
		4185,  4186,  4187,  4188,  4189,  4190,  4191,  32767,
		32767, 4192,  4193,  4194,  4195,  4196,  4197,  4198,
		4199,  4200,  4201,  4202,  4203,  32767, 4204,  4205,
		4206,  4207,  4208,  4209,  4210,  4211,  4212,  4213,
		827,   4215,  4216,  4217,  4218,  4219,  4220,  4221,
		4222,  32767, 4223,  4224,  4225,  828,   32767, 32767,
		32767, 32767, 4227,  4228,  4229,  32767, 4230,  32767,
		4231,  4232,  4233,  4234,  4235,  4236,  4237,  4238,
		4239,  4240,  4241,  4242,  4243,  4244,  4245,  4246,
		4247,  4248,  4249,  4250,  4251,  822,   822,   822,
		822,   822,   822,   822,   822,   822,   822,   -2901,
		2218,  2218,  822,   822,   822,   822,   -9014, 822,
		822,   822,   822,   822,   822,   822,   3452,  822,
		822,   822,   3455,  822,   5284,  4284,  4285,  4286,
		4287,  4288,  4289,  4290,  4291,  4292,  4293,  4294,
		4295,  4296,  4297,  4298,  4299,  4300,  4301,  4302,
		4303,  4304,  4305,  4306,  4307,  4308,  4309,  4310,
		4311,  4312,  4313,  4314,  4315,  4316,  4317,  4318,
		4319,  4320,  4321,  4322,  4323,  4324,  4325,  4326,
		4327,  4328,  4329,  4330,  4331,  4332,  4333,  4334,
		4335,  4336,  4337,  4338,  4339,  4340,  4341,  4342,
		4343,  4344,  4345,  4346,  4347,  4348,  4349,  4350,
		4351,  4352,  4353,  4354,  4355,  4356,  4357,  4358,
		4359,  861,   4361,  4362,  4363,  4364,  4365,  32767,
		32767, 32767, 32767, 32767, 4366,  4367,  4368,  4369,
		4370,  4371,  4372,  4373,  4374,  4375,  4376,  4377,
		4378,  4379,  4380,  4381,  4382,  4383,  4384,  4385,
		4386,  4387,  4388,  4389,  4390,  4391,  0,     0,
		0,     4395,  4396,  4397,  4398,  4399,  4400,  4401,
		4402,  4403,  4404,  4405,  4406,  4407,  4408,  4409,
		4410,  4411,  4412,  4413,  4414,  4415,  4416,  4417,
		4418,  4419,  4420,  4421,  4422,  4423,  4424,  4425,
		4426,  -4247, 4428,  4429,  636,   637,   638,   639,
		640,   641,   642,   643,   644,   2068,  2396,  4441,
		4442,  4443,  4444,  2405,  2406,  653,   654,   4449,
		4450,  8856,  4452,  4453,  4454,  4455,  4456,  4457,
		4458,  4459,  4460,  4461,  4462,  4463,  4464,  4465,
		4466,  4467,  4468,  4469,  4470,  4471,  4472,  4473,
		4474,  4475,  4476,  4477,  4478,  4479,  4480,  4481,
		4482,  4483,  4484,  4485,  4486,  4487,  4488,  4489,
		4490,  4491,  4492,  4493,  4494,  4495,  4496,  4497,
		4498,  4499,  4500,  4501,  4502,  4503,  4504,  4505,
		4506,  4507,  4508,  4509,  4510,  4511,  4512,  4513,
		4514,  4515,  4516,  4517,  4518,  4519,  4520,  4521,
		4522,  2069,  4524,  4525,  4526,  4527,  4528,  4529,
		4530,  4531,  4532,  4533,  4534,  4535,  4536,  -2729,
		-2728, -2727, -2726, -2725, -2724, -2723, -2722, -2721,
		-2720, -2719, -2718, -2717, -2716, -2715, -2714, -2713,
		-2712, -2711, -2710, -2709, -2708, -2707, -2706, -2705,
		-2704, -2703, -2702, -2701, -2700, -2699, -2698, -2697,
		-2696, -2695, -2694, 2106,  2107,  2108,  2109,  2110,
		2111,  2112,  2113,  2114,  2115,  4574,  4575,  4576,
		2119,  2120,  2121,  -527,  -527,  -527,  -527,  7458,
		-527,  14538, 2129,  14539, -528,  -5886, 2493,  -528,
		-528,  -528,  2137,  2138,  2139,  2140,  2141,  0,
		0,     0,     0,     2146,  2147,  2148,  2149,  2150,
		2151,  2152,  2153,  -2153, -2153, 2156,  -2152, -2152,
		2159,  2333,  2161,  2162,  3620,  2164,  3622,  2166,
		3624,  2168,  3627,  10704, 10704, 2172,  2173,  2174,
		2175,  2176,  2177,  2178,  2179,  2180,  2181,  2182,
		2183,  2184,  2185,  2186,  2187,  2188,  2189,  2190,
		2191,  2192,  2193,  2194,  2195,  2196,  2197,  2198,
		2199,  2200,  2201,  2202,  2203,  2204,  2205,  2206,
		2207,  2208,  2209,  2210,  2211,  2212,  2213,  2214,
		2215,  2216,  2217,  2218,  2219,  2220,  2221,  2222,
		2223,  2224,  2225,  2226,  2227,  2228,  2229,  2230,
		2231,  2232,  2233,  2234,  2235,  2236,  2237,  2238,
		2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,
		2247,  2248,  2249,  2250,  2251,  2252,  2253,  2254,
		2255,  2256,  2257,  2258,  2259,  2260,  2261,  2262,
		2263,  5508,  5509,  2266,  2267,  2268,  2269,  2270,
		-729,  2272,  -2862, 2274,  2275,  2276,  2277,  2278,
		2279,  2280,  2281,  2282,  2283,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		2284,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 2285,  2286,  -15504,2288,  -3445, 2290,
		32767, 32767, 32767, 32767, 32767, 32767, 2291,  32767,
		4683,  -2232, -2231, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     1346,  0,     1347,  0,
		1348,  0,     15566, 0,     905,   0,     14359, 32767,
		2301,  32767, 2302,  32767, 2303,  32767, 2304,  32767,
		2305,  32767, 2306,  32767, 32767, 2307,  32767, 2308,
		32767, 2309,  32767, 32767, 32767, 32767, 32767, 32767,
		-2491, -2491, 32767, -2492, 2313,  32767, 2314,  2315,
		32767, 2316,  2317,  32767, 2318,  2319,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2320,  32767, 32767, 32767,
		32767, 2321,  2322,  2323,  2324,  32767, 2325,  2326,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2327,  32767, 2328,  32767,
		2329,  32767, 2330,  32767, 9406,  32767, 2332,  32767,
		2333,  32767, 2334,  32767, 2335,  32767, 2336,  32767,
		2337,  32767, 2338,  32767, 32767, 2339,  32767, 2340,
		32767, 2341,  32767, 32767, 32767, 32767, 32767, 32767,
		2342,  2343,  32767, 2344,  2345,  32767, 2346,  2347,
		32767, 2348,  2349,  32767, 2350,  2351,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2352,  32767, 32767, 2353,
		2354,  2355,  2356,  32767, 32767, 32767, 2357,  2358,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4768,  4769,  4770,  4771,  4772,  4773,  4774,  4775,
		4776,  15738, 4778,  -5320, 0,     0,     0,     0,
		17791, 0,     5734,  0,     -6442, 0,     0,     0,
		0,     0,     0,     0,     -2391, 4525,  4525,  5741,
		4525,  5743,  1247,  5745,  4525,  0,     0,     4523,
		4523,  4523,  949,   949,   949,   949,   949,   949,
		949,   949,   949,   -10012,949,   11048, -13268,-7118,
		1394,  5731,  -12059,5733,  0,     5735,  0,     1206,
		0,     1208,  0,     1210,  0,     1212,  0,     1214,
		1215,  0,     1217,  0,     4497,  0,     1221,  4498,
		1223,  1224,  1225,  1226,  4801,  4802,  4803,  4804,
		0,     1232,  0,     0,     1235,  0,     0,     1238,
		0,     0,     4311,  1242,  1243,  1244,  1245,  1246,
		1247,  1248,  1249,  1250,  1251,  1252,  1253,  1254,
		1255,  1256,  1257,  1258,  1259,  1260,  1261,  5759,
		0,     1264,  1265,  1266,  1267,  0,     0,     0,
		0,     1272,  0,     0,     1275,  1276,  1459,  5766,
		1279,  0,     0,     5767,  1457,  1284,  1457,  1457,
		0,     1457,  0,     1457,  0,     -7077, 0,     -7076,
		-7075, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     32767,
		32767, 0,     32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     1337,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     2478,  2479,  2480,
		2481,  2482,  2483,  2484,  2485,  2486,  2487,  2488,
		2489,  2490,  2491,  2492,  2493,  3495,  3496,  3497,
		3498,  0,     3500,  3501,  2500,  2501,  2502,  2503,
		2504,  2505,  2506,  2507,  2508,  2509,  2510,  2511,
		0,     0,     0,     0,     0,     2517,  2518,  2519,
		2520,  2521,  0,     0,     2524,  1484,  1484,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     2540,  0,     0,     0,
		0,     0,     2546,  0,     2548,  0,     0,     2551,
		0,     0,     2554,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		3893,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     10472, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -5960, 0,     0,     0,     -2716, -2716, -2716,
		-2716, -2716, 0,     -2717, 2418,  -2717, -2717, -2717,
		-2717, -2717, -2717, -2717, -2717, -2717, -2717, 0,
		0,     -1086, -1086, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     2662,
		2663,  2664,  2665,  2666,  2667,  2668,  2669,  2670,
		2671,  2672,  2673,  2674,  2675,  2676,  2677,  2678,
		2679,  2680,  2681,  2682,  2683,  2684,  2685,  2686,
		2687,  2688,  2689,  2690,  2691,  2692,  2693,  2694,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     -12178,-6443, 0,     -6441, -6440, 637,   -6439,
		-6438, -6437, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     2739,  2740,  2741,
		2742,  2743,  2744,  2745,  2746,  2747,  2748,  2749,
		2750,  2751,  2752,  2753,  2754,  2755,  2756,  2757,
		2758,  2759,  -288,  -288,  -288,  -288,  -288,  -288,
		-288,  2767,  2768,  2769,  2770,  2771,  2772,  2773,
		2774,  2775,  2776,  2777,  2778,  2779,  2780,  2781,
		2782,  2783,  2784,  2785,  2786,  2787,  2788,  2789,
		2790,  2791,  2792,  2793,  2794,  2795,  2796,  2797,
		2798,  2799,  2800,  2801,  2802,  2803,  2804,  2805,
		2806,  2807,  2808,  2809,  2810,  2811,  2812,  2813,
		2814,  2815,  2816,  2817,  2818,  2819,  2820,  2821,
		2822,  2823,  2824,  2825,  2826,  2827,  2828,  2829,
		2830,  2831,  2832,  2833,  2834,  2835,  2836,  2837,
		2838,  2839,  -288,  2841,  2842,  2843,  2844,  2845,
		2846,  2847,  2848,  2849,  2850,  2851,  2852,  2853,
		2854,  2855,  2856,  2857,  2858,  2859,  2860,  2861,
		2862,  2863,  2864,  2865,  2866,  2867,  2868,  2869,
		2870,  2871,  2872,  2873,  2874,  2875,  2876,  2877,
		2878,  2879,  2880,  2881,  2882,  -288,  -288,  -288,
		-288,  -288,  -288,  7697,  -288,  14777, 11410, 14779,
		-288,  -5646, 2733,  -288,  -288,  -288,  -288,  -288,
		-288,  -288,  91,    -288,  -288,  8091,  14782, 14783,
		-936,  14785, 14786, 14787, 14788, 14789, 1523,  1523,
		1523,  1523,  1523,  4767,  4767,  4767,  4767,  4767,
		7767,  4767,  9902,  4767,  4767,  4767,  4767,  4767,
		4767,  4767,  4767,  4767,  4767,  7484,  7484,  6398,
		6398,  7484,  7484,  10457, 6395,  6395,  -1797, 10463,
		10464, 4750,  4883,  4884,  4885,  10466, 10467, 10468,
		10469, 10470, 10471, 4892,  4893,  10426, -288,  4896,
		4897,  -1779, 2968,  4899,  4900,  4901,  4902,  4903,
		4904,  4905,  4906,  4907,  4908,  4909,  4910,  4911,
		4912,  4913,  4914,  4915,  4916,  4917,  4918,  4919,
		4920,  4921,  0,     0,     4924,  4925,  4926,  4927,
		4928,  4929,  4930,  4931,  4932,  4933,  4934,  4935,
		4936,  4937,  4938,  4939,  4940,  4941,  4942
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 4;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 13407] + h[b % 13407];
}

/* Hash lookup information for decomposition */
static const pg_unicode_decompinfo UnicodeDecompInfo =
{
	UnicodeDecompMain,
	Decomp_hash_func,
	6703
};

/* Inverse lookup array -- contains indexes into UnicodeDecompMain[] */
static const uint16 RecompInverseLookup[941] =
{
	/* U+003C+0338 -> U+226E */ 1857,
	/* U+003D+0338 -> U+2260 */ 1854,
	/* U+003E+0338 -> U+226F */ 1858,
	/* U+0041+0300 -> U+00C0 */ 14,
	/* U+0041+0301 -> U+00C1 */ 15,
	/* U+0041+0302 -> U+00C2 */ 16,
	/* U+0041+0303 -> U+00C3 */ 17,
	/* U+0041+0304 -> U+0100 */ 67,
	/* U+0041+0306 -> U+0102 */ 69,
	/* U+0041+0307 -> U+0226 */ 270,
	/* U+0041+0308 -> U+00C4 */ 18,
	/* U+0041+0309 -> U+1EA2 */ 1312,
	/* U+0041+030A -> U+00C5 */ 19,
	/* U+0041+030C -> U+01CD */ 194,
	/* U+0041+030F -> U+0200 */ 240,
	/* U+0041+0311 -> U+0202 */ 242,
	/* U+0041+0323 -> U+1EA0 */ 1310,
	/* U+0041+0325 -> U+1E00 */ 1154,
	/* U+0041+0328 -> U+0104 */ 71,
	/* U+0042+0307 -> U+1E02 */ 1156,
	/* U+0042+0323 -> U+1E04 */ 1158,
	/* U+0042+0331 -> U+1E06 */ 1160,
	/* U+0043+0301 -> U+0106 */ 73,
	/* U+0043+0302 -> U+0108 */ 75,
	/* U+0043+0307 -> U+010A */ 77,
	/* U+0043+030C -> U+010C */ 79,
	/* U+0043+0327 -> U+00C7 */ 20,
	/* U+0044+0307 -> U+1E0A */ 1164,
	/* U+0044+030C -> U+010E */ 81,
	/* U+0044+0323 -> U+1E0C */ 1166,
	/* U+0044+0327 -> U+1E10 */ 1170,
	/* U+0044+032D -> U+1E12 */ 1172,
	/* U+0044+0331 -> U+1E0E */ 1168,
	/* U+0045+0300 -> U+00C8 */ 21,
	/* U+0045+0301 -> U+00C9 */ 22,
	/* U+0045+0302 -> U+00CA */ 23,
	/* U+0045+0303 -> U+1EBC */ 1338,
	/* U+0045+0304 -> U+0112 */ 83,
	/* U+0045+0306 -> U+0114 */ 85,
	/* U+0045+0307 -> U+0116 */ 87,
	/* U+0045+0308 -> U+00CB */ 24,
	/* U+0045+0309 -> U+1EBA */ 1336,
	/* U+0045+030C -> U+011A */ 91,
	/* U+0045+030F -> U+0204 */ 244,
	/* U+0045+0311 -> U+0206 */ 246,
	/* U+0045+0323 -> U+1EB8 */ 1334,
	/* U+0045+0327 -> U+0228 */ 272,
	/* U+0045+0328 -> U+0118 */ 89,
	/* U+0045+032D -> U+1E18 */ 1178,
	/* U+0045+0330 -> U+1E1A */ 1180,
	/* U+0046+0307 -> U+1E1E */ 1184,
	/* U+0047+0301 -> U+01F4 */ 230,
	/* U+0047+0302 -> U+011C */ 93,
	/* U+0047+0304 -> U+1E20 */ 1186,
	/* U+0047+0306 -> U+011E */ 95,
	/* U+0047+0307 -> U+0120 */ 97,
	/* U+0047+030C -> U+01E6 */ 216,
	/* U+0047+0327 -> U+0122 */ 99,
	/* U+0048+0302 -> U+0124 */ 101,
	/* U+0048+0307 -> U+1E22 */ 1188,
	/* U+0048+0308 -> U+1E26 */ 1192,
	/* U+0048+030C -> U+021E */ 268,
	/* U+0048+0323 -> U+1E24 */ 1190,
	/* U+0048+0327 -> U+1E28 */ 1194,
	/* U+0048+032E -> U+1E2A */ 1196,
	/* U+0049+0300 -> U+00CC */ 25,
	/* U+0049+0301 -> U+00CD */ 26,
	/* U+0049+0302 -> U+00CE */ 27,
	/* U+0049+0303 -> U+0128 */ 103,
	/* U+0049+0304 -> U+012A */ 105,
	/* U+0049+0306 -> U+012C */ 107,
	/* U+0049+0307 -> U+0130 */ 111,
	/* U+0049+0308 -> U+00CF */ 28,
	/* U+0049+0309 -> U+1EC8 */ 1350,
	/* U+0049+030C -> U+01CF */ 196,
	/* U+0049+030F -> U+0208 */ 248,
	/* U+0049+0311 -> U+020A */ 250,
	/* U+0049+0323 -> U+1ECA */ 1352,
	/* U+0049+0328 -> U+012E */ 109,
	/* U+0049+0330 -> U+1E2C */ 1198,
	/* U+004A+0302 -> U+0134 */ 114,
	/* U+004B+0301 -> U+1E30 */ 1202,
	/* U+004B+030C -> U+01E8 */ 218,
	/* U+004B+0323 -> U+1E32 */ 1204,
	/* U+004B+0327 -> U+0136 */ 116,
	/* U+004B+0331 -> U+1E34 */ 1206,
	/* U+004C+0301 -> U+0139 */ 118,
	/* U+004C+030C -> U+013D */ 122,
	/* U+004C+0323 -> U+1E36 */ 1208,
	/* U+004C+0327 -> U+013B */ 120,
	/* U+004C+032D -> U+1E3C */ 1214,
	/* U+004C+0331 -> U+1E3A */ 1212,
	/* U+004D+0301 -> U+1E3E */ 1216,
	/* U+004D+0307 -> U+1E40 */ 1218,
	/* U+004D+0323 -> U+1E42 */ 1220,
	/* U+004E+0300 -> U+01F8 */ 232,
	/* U+004E+0301 -> U+0143 */ 126,
	/* U+004E+0303 -> U+00D1 */ 29,
	/* U+004E+0307 -> U+1E44 */ 1222,
	/* U+004E+030C -> U+0147 */ 130,
	/* U+004E+0323 -> U+1E46 */ 1224,
	/* U+004E+0327 -> U+0145 */ 128,
	/* U+004E+032D -> U+1E4A */ 1228,
	/* U+004E+0331 -> U+1E48 */ 1226,
	/* U+004F+0300 -> U+00D2 */ 30,
	/* U+004F+0301 -> U+00D3 */ 31,
	/* U+004F+0302 -> U+00D4 */ 32,
	/* U+004F+0303 -> U+00D5 */ 33,
	/* U+004F+0304 -> U+014C */ 133,
	/* U+004F+0306 -> U+014E */ 135,
	/* U+004F+0307 -> U+022E */ 278,
	/* U+004F+0308 -> U+00D6 */ 34,
	/* U+004F+0309 -> U+1ECE */ 1356,
	/* U+004F+030B -> U+0150 */ 137,
	/* U+004F+030C -> U+01D1 */ 198,
	/* U+004F+030F -> U+020C */ 252,
	/* U+004F+0311 -> U+020E */ 254,
	/* U+004F+031B -> U+01A0 */ 181,
	/* U+004F+0323 -> U+1ECC */ 1354,
	/* U+004F+0328 -> U+01EA */ 220,
	/* U+0050+0301 -> U+1E54 */ 1238,
	/* U+0050+0307 -> U+1E56 */ 1240,
	/* U+0052+0301 -> U+0154 */ 139,
	/* U+0052+0307 -> U+1E58 */ 1242,
	/* U+0052+030C -> U+0158 */ 143,
	/* U+0052+030F -> U+0210 */ 256,
	/* U+0052+0311 -> U+0212 */ 258,
	/* U+0052+0323 -> U+1E5A */ 1244,
	/* U+0052+0327 -> U+0156 */ 141,
	/* U+0052+0331 -> U+1E5E */ 1248,
	/* U+0053+0301 -> U+015A */ 145,
	/* U+0053+0302 -> U+015C */ 147,
	/* U+0053+0307 -> U+1E60 */ 1250,
	/* U+0053+030C -> U+0160 */ 151,
	/* U+0053+0323 -> U+1E62 */ 1252,
	/* U+0053+0326 -> U+0218 */ 264,
	/* U+0053+0327 -> U+015E */ 149,
	/* U+0054+0307 -> U+1E6A */ 1260,
	/* U+0054+030C -> U+0164 */ 155,
	/* U+0054+0323 -> U+1E6C */ 1262,
	/* U+0054+0326 -> U+021A */ 266,
	/* U+0054+0327 -> U+0162 */ 153,
	/* U+0054+032D -> U+1E70 */ 1266,
	/* U+0054+0331 -> U+1E6E */ 1264,
	/* U+0055+0300 -> U+00D9 */ 35,
	/* U+0055+0301 -> U+00DA */ 36,
	/* U+0055+0302 -> U+00DB */ 37,
	/* U+0055+0303 -> U+0168 */ 157,
	/* U+0055+0304 -> U+016A */ 159,
	/* U+0055+0306 -> U+016C */ 161,
	/* U+0055+0308 -> U+00DC */ 38,
	/* U+0055+0309 -> U+1EE6 */ 1380,
	/* U+0055+030A -> U+016E */ 163,
	/* U+0055+030B -> U+0170 */ 165,
	/* U+0055+030C -> U+01D3 */ 200,
	/* U+0055+030F -> U+0214 */ 260,
	/* U+0055+0311 -> U+0216 */ 262,
	/* U+0055+031B -> U+01AF */ 183,
	/* U+0055+0323 -> U+1EE4 */ 1378,
	/* U+0055+0324 -> U+1E72 */ 1268,
	/* U+0055+0328 -> U+0172 */ 167,
	/* U+0055+032D -> U+1E76 */ 1272,
	/* U+0055+0330 -> U+1E74 */ 1270,
	/* U+0056+0303 -> U+1E7C */ 1278,
	/* U+0056+0323 -> U+1E7E */ 1280,
	/* U+0057+0300 -> U+1E80 */ 1282,
	/* U+0057+0301 -> U+1E82 */ 1284,
	/* U+0057+0302 -> U+0174 */ 169,
	/* U+0057+0307 -> U+1E86 */ 1288,
	/* U+0057+0308 -> U+1E84 */ 1286,
	/* U+0057+0323 -> U+1E88 */ 1290,
	/* U+0058+0307 -> U+1E8A */ 1292,
	/* U+0058+0308 -> U+1E8C */ 1294,
	/* U+0059+0300 -> U+1EF2 */ 1392,
	/* U+0059+0301 -> U+00DD */ 39,
	/* U+0059+0302 -> U+0176 */ 171,
	/* U+0059+0303 -> U+1EF8 */ 1398,
	/* U+0059+0304 -> U+0232 */ 282,
	/* U+0059+0307 -> U+1E8E */ 1296,
	/* U+0059+0308 -> U+0178 */ 173,
	/* U+0059+0309 -> U+1EF6 */ 1396,
	/* U+0059+0323 -> U+1EF4 */ 1394,
	/* U+005A+0301 -> U+0179 */ 174,
	/* U+005A+0302 -> U+1E90 */ 1298,
	/* U+005A+0307 -> U+017B */ 176,
	/* U+005A+030C -> U+017D */ 178,
	/* U+005A+0323 -> U+1E92 */ 1300,
	/* U+005A+0331 -> U+1E94 */ 1302,
	/* U+0061+0300 -> U+00E0 */ 40,
	/* U+0061+0301 -> U+00E1 */ 41,
	/* U+0061+0302 -> U+00E2 */ 42,
	/* U+0061+0303 -> U+00E3 */ 43,
	/* U+0061+0304 -> U+0101 */ 68,
	/* U+0061+0306 -> U+0103 */ 70,
	/* U+0061+0307 -> U+0227 */ 271,
	/* U+0061+0308 -> U+00E4 */ 44,
	/* U+0061+0309 -> U+1EA3 */ 1313,
	/* U+0061+030A -> U+00E5 */ 45,
	/* U+0061+030C -> U+01CE */ 195,
	/* U+0061+030F -> U+0201 */ 241,
	/* U+0061+0311 -> U+0203 */ 243,
	/* U+0061+0323 -> U+1EA1 */ 1311,
	/* U+0061+0325 -> U+1E01 */ 1155,
	/* U+0061+0328 -> U+0105 */ 72,
	/* U+0062+0307 -> U+1E03 */ 1157,
	/* U+0062+0323 -> U+1E05 */ 1159,
	/* U+0062+0331 -> U+1E07 */ 1161,
	/* U+0063+0301 -> U+0107 */ 74,
	/* U+0063+0302 -> U+0109 */ 76,
	/* U+0063+0307 -> U+010B */ 78,
	/* U+0063+030C -> U+010D */ 80,
	/* U+0063+0327 -> U+00E7 */ 46,
	/* U+0064+0307 -> U+1E0B */ 1165,
	/* U+0064+030C -> U+010F */ 82,
	/* U+0064+0323 -> U+1E0D */ 1167,
	/* U+0064+0327 -> U+1E11 */ 1171,
	/* U+0064+032D -> U+1E13 */ 1173,
	/* U+0064+0331 -> U+1E0F */ 1169,
	/* U+0065+0300 -> U+00E8 */ 47,
	/* U+0065+0301 -> U+00E9 */ 48,
	/* U+0065+0302 -> U+00EA */ 49,
	/* U+0065+0303 -> U+1EBD */ 1339,
	/* U+0065+0304 -> U+0113 */ 84,
	/* U+0065+0306 -> U+0115 */ 86,
	/* U+0065+0307 -> U+0117 */ 88,
	/* U+0065+0308 -> U+00EB */ 50,
	/* U+0065+0309 -> U+1EBB */ 1337,
	/* U+0065+030C -> U+011B */ 92,
	/* U+0065+030F -> U+0205 */ 245,
	/* U+0065+0311 -> U+0207 */ 247,
	/* U+0065+0323 -> U+1EB9 */ 1335,
	/* U+0065+0327 -> U+0229 */ 273,
	/* U+0065+0328 -> U+0119 */ 90,
	/* U+0065+032D -> U+1E19 */ 1179,
	/* U+0065+0330 -> U+1E1B */ 1181,
	/* U+0066+0307 -> U+1E1F */ 1185,
	/* U+0067+0301 -> U+01F5 */ 231,
	/* U+0067+0302 -> U+011D */ 94,
	/* U+0067+0304 -> U+1E21 */ 1187,
	/* U+0067+0306 -> U+011F */ 96,
	/* U+0067+0307 -> U+0121 */ 98,
	/* U+0067+030C -> U+01E7 */ 217,
	/* U+0067+0327 -> U+0123 */ 100,
	/* U+0068+0302 -> U+0125 */ 102,
	/* U+0068+0307 -> U+1E23 */ 1189,
	/* U+0068+0308 -> U+1E27 */ 1193,
	/* U+0068+030C -> U+021F */ 269,
	/* U+0068+0323 -> U+1E25 */ 1191,
	/* U+0068+0327 -> U+1E29 */ 1195,
	/* U+0068+032E -> U+1E2B */ 1197,
	/* U+0068+0331 -> U+1E96 */ 1304,
	/* U+0069+0300 -> U+00EC */ 51,
	/* U+0069+0301 -> U+00ED */ 52,
	/* U+0069+0302 -> U+00EE */ 53,
	/* U+0069+0303 -> U+0129 */ 104,
	/* U+0069+0304 -> U+012B */ 106,
	/* U+0069+0306 -> U+012D */ 108,
	/* U+0069+0308 -> U+00EF */ 54,
	/* U+0069+0309 -> U+1EC9 */ 1351,
	/* U+0069+030C -> U+01D0 */ 197,
	/* U+0069+030F -> U+0209 */ 249,
	/* U+0069+0311 -> U+020B */ 251,
	/* U+0069+0323 -> U+1ECB */ 1353,
	/* U+0069+0328 -> U+012F */ 110,
	/* U+0069+0330 -> U+1E2D */ 1199,
	/* U+006A+0302 -> U+0135 */ 115,
	/* U+006A+030C -> U+01F0 */ 226,
	/* U+006B+0301 -> U+1E31 */ 1203,
	/* U+006B+030C -> U+01E9 */ 219,
	/* U+006B+0323 -> U+1E33 */ 1205,
	/* U+006B+0327 -> U+0137 */ 117,
	/* U+006B+0331 -> U+1E35 */ 1207,
	/* U+006C+0301 -> U+013A */ 119,
	/* U+006C+030C -> U+013E */ 123,
	/* U+006C+0323 -> U+1E37 */ 1209,
	/* U+006C+0327 -> U+013C */ 121,
	/* U+006C+032D -> U+1E3D */ 1215,
	/* U+006C+0331 -> U+1E3B */ 1213,
	/* U+006D+0301 -> U+1E3F */ 1217,
	/* U+006D+0307 -> U+1E41 */ 1219,
	/* U+006D+0323 -> U+1E43 */ 1221,
	/* U+006E+0300 -> U+01F9 */ 233,
	/* U+006E+0301 -> U+0144 */ 127,
	/* U+006E+0303 -> U+00F1 */ 55,
	/* U+006E+0307 -> U+1E45 */ 1223,
	/* U+006E+030C -> U+0148 */ 131,
	/* U+006E+0323 -> U+1E47 */ 1225,
	/* U+006E+0327 -> U+0146 */ 129,
	/* U+006E+032D -> U+1E4B */ 1229,
	/* U+006E+0331 -> U+1E49 */ 1227,
	/* U+006F+0300 -> U+00F2 */ 56,
	/* U+006F+0301 -> U+00F3 */ 57,
	/* U+006F+0302 -> U+00F4 */ 58,
	/* U+006F+0303 -> U+00F5 */ 59,
	/* U+006F+0304 -> U+014D */ 134,
	/* U+006F+0306 -> U+014F */ 136,
	/* U+006F+0307 -> U+022F */ 279,
	/* U+006F+0308 -> U+00F6 */ 60,
	/* U+006F+0309 -> U+1ECF */ 1357,
	/* U+006F+030B -> U+0151 */ 138,
	/* U+006F+030C -> U+01D2 */ 199,
	/* U+006F+030F -> U+020D */ 253,
	/* U+006F+0311 -> U+020F */ 255,
	/* U+006F+031B -> U+01A1 */ 182,
	/* U+006F+0323 -> U+1ECD */ 1355,
	/* U+006F+0328 -> U+01EB */ 221,
	/* U+0070+0301 -> U+1E55 */ 1239,
	/* U+0070+0307 -> U+1E57 */ 1241,
	/* U+0072+0301 -> U+0155 */ 140,
	/* U+0072+0307 -> U+1E59 */ 1243,
	/* U+0072+030C -> U+0159 */ 144,
	/* U+0072+030F -> U+0211 */ 257,
	/* U+0072+0311 -> U+0213 */ 259,
	/* U+0072+0323 -> U+1E5B */ 1245,
	/* U+0072+0327 -> U+0157 */ 142,
	/* U+0072+0331 -> U+1E5F */ 1249,
	/* U+0073+0301 -> U+015B */ 146,
	/* U+0073+0302 -> U+015D */ 148,
	/* U+0073+0307 -> U+1E61 */ 1251,
	/* U+0073+030C -> U+0161 */ 152,
	/* U+0073+0323 -> U+1E63 */ 1253,
	/* U+0073+0326 -> U+0219 */ 265,
	/* U+0073+0327 -> U+015F */ 150,
	/* U+0074+0307 -> U+1E6B */ 1261,
	/* U+0074+0308 -> U+1E97 */ 1305,
	/* U+0074+030C -> U+0165 */ 156,
	/* U+0074+0323 -> U+1E6D */ 1263,
	/* U+0074+0326 -> U+021B */ 267,
	/* U+0074+0327 -> U+0163 */ 154,
	/* U+0074+032D -> U+1E71 */ 1267,
	/* U+0074+0331 -> U+1E6F */ 1265,
	/* U+0075+0300 -> U+00F9 */ 61,
	/* U+0075+0301 -> U+00FA */ 62,
	/* U+0075+0302 -> U+00FB */ 63,
	/* U+0075+0303 -> U+0169 */ 158,
	/* U+0075+0304 -> U+016B */ 160,
	/* U+0075+0306 -> U+016D */ 162,
	/* U+0075+0308 -> U+00FC */ 64,
	/* U+0075+0309 -> U+1EE7 */ 1381,
	/* U+0075+030A -> U+016F */ 164,
	/* U+0075+030B -> U+0171 */ 166,
	/* U+0075+030C -> U+01D4 */ 201,
	/* U+0075+030F -> U+0215 */ 261,
	/* U+0075+0311 -> U+0217 */ 263,
	/* U+0075+031B -> U+01B0 */ 184,
	/* U+0075+0323 -> U+1EE5 */ 1379,
	/* U+0075+0324 -> U+1E73 */ 1269,
	/* U+0075+0328 -> U+0173 */ 168,
	/* U+0075+032D -> U+1E77 */ 1273,
	/* U+0075+0330 -> U+1E75 */ 1271,
	/* U+0076+0303 -> U+1E7D */ 1279,
	/* U+0076+0323 -> U+1E7F */ 1281,
	/* U+0077+0300 -> U+1E81 */ 1283,
	/* U+0077+0301 -> U+1E83 */ 1285,
	/* U+0077+0302 -> U+0175 */ 170,
	/* U+0077+0307 -> U+1E87 */ 1289,
	/* U+0077+0308 -> U+1E85 */ 1287,
	/* U+0077+030A -> U+1E98 */ 1306,
	/* U+0077+0323 -> U+1E89 */ 1291,
	/* U+0078+0307 -> U+1E8B */ 1293,
	/* U+0078+0308 -> U+1E8D */ 1295,
	/* U+0079+0300 -> U+1EF3 */ 1393,
	/* U+0079+0301 -> U+00FD */ 65,
	/* U+0079+0302 -> U+0177 */ 172,
	/* U+0079+0303 -> U+1EF9 */ 1399,
	/* U+0079+0304 -> U+0233 */ 283,
	/* U+0079+0307 -> U+1E8F */ 1297,
	/* U+0079+0308 -> U+00FF */ 66,
	/* U+0079+0309 -> U+1EF7 */ 1397,
	/* U+0079+030A -> U+1E99 */ 1307,
	/* U+0079+0323 -> U+1EF5 */ 1395,
	/* U+007A+0301 -> U+017A */ 175,
	/* U+007A+0302 -> U+1E91 */ 1299,
	/* U+007A+0307 -> U+017C */ 177,
	/* U+007A+030C -> U+017E */ 179,
	/* U+007A+0323 -> U+1E93 */ 1301,
	/* U+007A+0331 -> U+1E95 */ 1303,
	/* U+00A8+0300 -> U+1FED */ 1618,
	/* U+00A8+0301 -> U+0385 */ 419,
	/* U+00A8+0342 -> U+1FC1 */ 1578,
	/* U+00C2+0300 -> U+1EA6 */ 1316,
	/* U+00C2+0301 -> U+1EA4 */ 1314,
	/* U+00C2+0303 -> U+1EAA */ 1320,
	/* U+00C2+0309 -> U+1EA8 */ 1318,
	/* U+00C4+0304 -> U+01DE */ 210,
	/* U+00C5+0301 -> U+01FA */ 234,
	/* U+00C6+0301 -> U+01FC */ 236,
	/* U+00C6+0304 -> U+01E2 */ 214,
	/* U+00C7+0301 -> U+1E08 */ 1162,
	/* U+00CA+0300 -> U+1EC0 */ 1342,
	/* U+00CA+0301 -> U+1EBE */ 1340,
	/* U+00CA+0303 -> U+1EC4 */ 1346,
	/* U+00CA+0309 -> U+1EC2 */ 1344,
	/* U+00CF+0301 -> U+1E2E */ 1200,
	/* U+00D4+0300 -> U+1ED2 */ 1360,
	/* U+00D4+0301 -> U+1ED0 */ 1358,
	/* U+00D4+0303 -> U+1ED6 */ 1364,
	/* U+00D4+0309 -> U+1ED4 */ 1362,
	/* U+00D5+0301 -> U+1E4C */ 1230,
	/* U+00D5+0304 -> U+022C */ 276,
	/* U+00D5+0308 -> U+1E4E */ 1232,
	/* U+00D6+0304 -> U+022A */ 274,
	/* U+00D8+0301 -> U+01FE */ 238,
	/* U+00DC+0300 -> U+01DB */ 208,
	/* U+00DC+0301 -> U+01D7 */ 204,
	/* U+00DC+0304 -> U+01D5 */ 202,
	/* U+00DC+030C -> U+01D9 */ 206,
	/* U+00E2+0300 -> U+1EA7 */ 1317,
	/* U+00E2+0301 -> U+1EA5 */ 1315,
	/* U+00E2+0303 -> U+1EAB */ 1321,
	/* U+00E2+0309 -> U+1EA9 */ 1319,
	/* U+00E4+0304 -> U+01DF */ 211,
	/* U+00E5+0301 -> U+01FB */ 235,
	/* U+00E6+0301 -> U+01FD */ 237,
	/* U+00E6+0304 -> U+01E3 */ 215,
	/* U+00E7+0301 -> U+1E09 */ 1163,
	/* U+00EA+0300 -> U+1EC1 */ 1343,
	/* U+00EA+0301 -> U+1EBF */ 1341,
	/* U+00EA+0303 -> U+1EC5 */ 1347,
	/* U+00EA+0309 -> U+1EC3 */ 1345,
	/* U+00EF+0301 -> U+1E2F */ 1201,
	/* U+00F4+0300 -> U+1ED3 */ 1361,
	/* U+00F4+0301 -> U+1ED1 */ 1359,
	/* U+00F4+0303 -> U+1ED7 */ 1365,
	/* U+00F4+0309 -> U+1ED5 */ 1363,
	/* U+00F5+0301 -> U+1E4D */ 1231,
	/* U+00F5+0304 -> U+022D */ 277,
	/* U+00F5+0308 -> U+1E4F */ 1233,
	/* U+00F6+0304 -> U+022B */ 275,
	/* U+00F8+0301 -> U+01FF */ 239,
	/* U+00FC+0300 -> U+01DC */ 209,
	/* U+00FC+0301 -> U+01D8 */ 205,
	/* U+00FC+0304 -> U+01D6 */ 203,
	/* U+00FC+030C -> U+01DA */ 207,
	/* U+0102+0300 -> U+1EB0 */ 1326,
	/* U+0102+0301 -> U+1EAE */ 1324,
	/* U+0102+0303 -> U+1EB4 */ 1330,
	/* U+0102+0309 -> U+1EB2 */ 1328,
	/* U+0103+0300 -> U+1EB1 */ 1327,
	/* U+0103+0301 -> U+1EAF */ 1325,
	/* U+0103+0303 -> U+1EB5 */ 1331,
	/* U+0103+0309 -> U+1EB3 */ 1329,
	/* U+0112+0300 -> U+1E14 */ 1174,
	/* U+0112+0301 -> U+1E16 */ 1176,
	/* U+0113+0300 -> U+1E15 */ 1175,
	/* U+0113+0301 -> U+1E17 */ 1177,
	/* U+014C+0300 -> U+1E50 */ 1234,
	/* U+014C+0301 -> U+1E52 */ 1236,
	/* U+014D+0300 -> U+1E51 */ 1235,
	/* U+014D+0301 -> U+1E53 */ 1237,
	/* U+015A+0307 -> U+1E64 */ 1254,
	/* U+015B+0307 -> U+1E65 */ 1255,
	/* U+0160+0307 -> U+1E66 */ 1256,
	/* U+0161+0307 -> U+1E67 */ 1257,
	/* U+0168+0301 -> U+1E78 */ 1274,
	/* U+0169+0301 -> U+1E79 */ 1275,
	/* U+016A+0308 -> U+1E7A */ 1276,
	/* U+016B+0308 -> U+1E7B */ 1277,
	/* U+017F+0307 -> U+1E9B */ 1309,
	/* U+01A0+0300 -> U+1EDC */ 1370,
	/* U+01A0+0301 -> U+1EDA */ 1368,
	/* U+01A0+0303 -> U+1EE0 */ 1374,
	/* U+01A0+0309 -> U+1EDE */ 1372,
	/* U+01A0+0323 -> U+1EE2 */ 1376,
	/* U+01A1+0300 -> U+1EDD */ 1371,
	/* U+01A1+0301 -> U+1EDB */ 1369,
	/* U+01A1+0303 -> U+1EE1 */ 1375,
	/* U+01A1+0309 -> U+1EDF */ 1373,
	/* U+01A1+0323 -> U+1EE3 */ 1377,
	/* U+01AF+0300 -> U+1EEA */ 1384,
	/* U+01AF+0301 -> U+1EE8 */ 1382,
	/* U+01AF+0303 -> U+1EEE */ 1388,
	/* U+01AF+0309 -> U+1EEC */ 1386,
	/* U+01AF+0323 -> U+1EF0 */ 1390,
	/* U+01B0+0300 -> U+1EEB */ 1385,
	/* U+01B0+0301 -> U+1EE9 */ 1383,
	/* U+01B0+0303 -> U+1EEF */ 1389,
	/* U+01B0+0309 -> U+1EED */ 1387,
	/* U+01B0+0323 -> U+1EF1 */ 1391,
	/* U+01B7+030C -> U+01EE */ 224,
	/* U+01EA+0304 -> U+01EC */ 222,
	/* U+01EB+0304 -> U+01ED */ 223,
	/* U+0226+0304 -> U+01E0 */ 212,
	/* U+0227+0304 -> U+01E1 */ 213,
	/* U+0228+0306 -> U+1E1C */ 1182,
	/* U+0229+0306 -> U+1E1D */ 1183,
	/* U+022E+0304 -> U+0230 */ 280,
	/* U+022F+0304 -> U+0231 */ 281,
	/* U+0292+030C -> U+01EF */ 225,
	/* U+0391+0300 -> U+1FBA */ 1571,
	/* U+0391+0301 -> U+0386 */ 420,
	/* U+0391+0304 -> U+1FB9 */ 1570,
	/* U+0391+0306 -> U+1FB8 */ 1569,
	/* U+0391+0313 -> U+1F08 */ 1408,
	/* U+0391+0314 -> U+1F09 */ 1409,
	/* U+0391+0345 -> U+1FBC */ 1573,
	/* U+0395+0300 -> U+1FC8 */ 1584,
	/* U+0395+0301 -> U+0388 */ 422,
	/* U+0395+0313 -> U+1F18 */ 1422,
	/* U+0395+0314 -> U+1F19 */ 1423,
	/* U+0397+0300 -> U+1FCA */ 1586,
	/* U+0397+0301 -> U+0389 */ 423,
	/* U+0397+0313 -> U+1F28 */ 1436,
	/* U+0397+0314 -> U+1F29 */ 1437,
	/* U+0397+0345 -> U+1FCC */ 1588,
	/* U+0399+0300 -> U+1FDA */ 1600,
	/* U+0399+0301 -> U+038A */ 424,
	/* U+0399+0304 -> U+1FD9 */ 1599,
	/* U+0399+0306 -> U+1FD8 */ 1598,
	/* U+0399+0308 -> U+03AA */ 429,
	/* U+0399+0313 -> U+1F38 */ 1452,
	/* U+0399+0314 -> U+1F39 */ 1453,
	/* U+039F+0300 -> U+1FF8 */ 1626,
	/* U+039F+0301 -> U+038C */ 425,
	/* U+039F+0313 -> U+1F48 */ 1466,
	/* U+039F+0314 -> U+1F49 */ 1467,
	/* U+03A1+0314 -> U+1FEC */ 1617,
	/* U+03A5+0300 -> U+1FEA */ 1615,
	/* U+03A5+0301 -> U+038E */ 426,
	/* U+03A5+0304 -> U+1FE9 */ 1614,
	/* U+03A5+0306 -> U+1FE8 */ 1613,
	/* U+03A5+0308 -> U+03AB */ 430,
	/* U+03A5+0314 -> U+1F59 */ 1480,
	/* U+03A9+0300 -> U+1FFA */ 1628,
	/* U+03A9+0301 -> U+038F */ 427,
	/* U+03A9+0313 -> U+1F68 */ 1492,
	/* U+03A9+0314 -> U+1F69 */ 1493,
	/* U+03A9+0345 -> U+1FFC */ 1630,
	/* U+03AC+0345 -> U+1FB4 */ 1566,
	/* U+03AE+0345 -> U+1FC4 */ 1581,
	/* U+03B1+0300 -> U+1F70 */ 1500,
	/* U+03B1+0301 -> U+03AC */ 431,
	/* U+03B1+0304 -> U+1FB1 */ 1563,
	/* U+03B1+0306 -> U+1FB0 */ 1562,
	/* U+03B1+0313 -> U+1F00 */ 1400,
	/* U+03B1+0314 -> U+1F01 */ 1401,
	/* U+03B1+0342 -> U+1FB6 */ 1567,
	/* U+03B1+0345 -> U+1FB3 */ 1565,
	/* U+03B5+0300 -> U+1F72 */ 1502,
	/* U+03B5+0301 -> U+03AD */ 432,
	/* U+03B5+0313 -> U+1F10 */ 1416,
	/* U+03B5+0314 -> U+1F11 */ 1417,
	/* U+03B7+0300 -> U+1F74 */ 1504,
	/* U+03B7+0301 -> U+03AE */ 433,
	/* U+03B7+0313 -> U+1F20 */ 1428,
	/* U+03B7+0314 -> U+1F21 */ 1429,
	/* U+03B7+0342 -> U+1FC6 */ 1582,
	/* U+03B7+0345 -> U+1FC3 */ 1580,
	/* U+03B9+0300 -> U+1F76 */ 1506,
	/* U+03B9+0301 -> U+03AF */ 434,
	/* U+03B9+0304 -> U+1FD1 */ 1593,
	/* U+03B9+0306 -> U+1FD0 */ 1592,
	/* U+03B9+0308 -> U+03CA */ 436,
	/* U+03B9+0313 -> U+1F30 */ 1444,
	/* U+03B9+0314 -> U+1F31 */ 1445,
	/* U+03B9+0342 -> U+1FD6 */ 1596,
	/* U+03BF+0300 -> U+1F78 */ 1508,
	/* U+03BF+0301 -> U+03CC */ 438,
	/* U+03BF+0313 -> U+1F40 */ 1460,
	/* U+03BF+0314 -> U+1F41 */ 1461,
	/* U+03C1+0313 -> U+1FE4 */ 1609,
	/* U+03C1+0314 -> U+1FE5 */ 1610,
	/* U+03C5+0300 -> U+1F7A */ 1510,
	/* U+03C5+0301 -> U+03CD */ 439,
	/* U+03C5+0304 -> U+1FE1 */ 1606,
	/* U+03C5+0306 -> U+1FE0 */ 1605,
	/* U+03C5+0308 -> U+03CB */ 437,
	/* U+03C5+0313 -> U+1F50 */ 1472,
	/* U+03C5+0314 -> U+1F51 */ 1473,
	/* U+03C5+0342 -> U+1FE6 */ 1611,
	/* U+03C9+0300 -> U+1F7C */ 1512,
	/* U+03C9+0301 -> U+03CE */ 440,
	/* U+03C9+0313 -> U+1F60 */ 1484,
	/* U+03C9+0314 -> U+1F61 */ 1485,
	/* U+03C9+0342 -> U+1FF6 */ 1624,
	/* U+03C9+0345 -> U+1FF3 */ 1622,
	/* U+03CA+0300 -> U+1FD2 */ 1594,
	/* U+03CA+0301 -> U+0390 */ 428,
	/* U+03CA+0342 -> U+1FD7 */ 1597,
	/* U+03CB+0300 -> U+1FE2 */ 1607,
	/* U+03CB+0301 -> U+03B0 */ 435,
	/* U+03CB+0342 -> U+1FE7 */ 1612,
	/* U+03CE+0345 -> U+1FF4 */ 1623,
	/* U+03D2+0301 -> U+03D3 */ 444,
	/* U+03D2+0308 -> U+03D4 */ 445,
	/* U+0406+0308 -> U+0407 */ 457,
	/* U+0410+0306 -> U+04D0 */ 479,
	/* U+0410+0308 -> U+04D2 */ 481,
	/* U+0413+0301 -> U+0403 */ 456,
	/* U+0415+0300 -> U+0400 */ 454,
	/* U+0415+0306 -> U+04D6 */ 483,
	/* U+0415+0308 -> U+0401 */ 455,
	/* U+0416+0306 -> U+04C1 */ 477,
	/* U+0416+0308 -> U+04DC */ 487,
	/* U+0417+0308 -> U+04DE */ 489,
	/* U+0418+0300 -> U+040D */ 459,
	/* U+0418+0304 -> U+04E2 */ 491,
	/* U+0418+0306 -> U+0419 */ 461,
	/* U+0418+0308 -> U+04E4 */ 493,
	/* U+041A+0301 -> U+040C */ 458,
	/* U+041E+0308 -> U+04E6 */ 495,
	/* U+0423+0304 -> U+04EE */ 501,
	/* U+0423+0306 -> U+040E */ 460,
	/* U+0423+0308 -> U+04F0 */ 503,
	/* U+0423+030B -> U+04F2 */ 505,
	/* U+0427+0308 -> U+04F4 */ 507,
	/* U+042B+0308 -> U+04F8 */ 509,
	/* U+042D+0308 -> U+04EC */ 499,
	/* U+0430+0306 -> U+04D1 */ 480,
	/* U+0430+0308 -> U+04D3 */ 482,
	/* U+0433+0301 -> U+0453 */ 465,
	/* U+0435+0300 -> U+0450 */ 463,
	/* U+0435+0306 -> U+04D7 */ 484,
	/* U+0435+0308 -> U+0451 */ 464,
	/* U+0436+0306 -> U+04C2 */ 478,
	/* U+0436+0308 -> U+04DD */ 488,
	/* U+0437+0308 -> U+04DF */ 490,
	/* U+0438+0300 -> U+045D */ 468,
	/* U+0438+0304 -> U+04E3 */ 492,
	/* U+0438+0306 -> U+0439 */ 462,
	/* U+0438+0308 -> U+04E5 */ 494,
	/* U+043A+0301 -> U+045C */ 467,
	/* U+043E+0308 -> U+04E7 */ 496,
	/* U+0443+0304 -> U+04EF */ 502,
	/* U+0443+0306 -> U+045E */ 469,
	/* U+0443+0308 -> U+04F1 */ 504,
	/* U+0443+030B -> U+04F3 */ 506,
	/* U+0447+0308 -> U+04F5 */ 508,
	/* U+044B+0308 -> U+04F9 */ 510,
	/* U+044D+0308 -> U+04ED */ 500,
	/* U+0456+0308 -> U+0457 */ 466,
	/* U+0474+030F -> U+0476 */ 470,
	/* U+0475+030F -> U+0477 */ 471,
	/* U+04D8+0308 -> U+04DA */ 485,
	/* U+04D9+0308 -> U+04DB */ 486,
	/* U+04E8+0308 -> U+04EA */ 497,
	/* U+04E9+0308 -> U+04EB */ 498,
	/* U+0627+0653 -> U+0622 */ 574,
	/* U+0627+0654 -> U+0623 */ 575,
	/* U+0627+0655 -> U+0625 */ 577,
	/* U+0648+0654 -> U+0624 */ 576,
	/* U+064A+0654 -> U+0626 */ 578,
	/* U+06C1+0654 -> U+06C2 */ 606,
	/* U+06D2+0654 -> U+06D3 */ 607,
	/* U+06D5+0654 -> U+06C0 */ 605,
	/* U+0928+093C -> U+0929 */ 750,
	/* U+0930+093C -> U+0931 */ 751,
	/* U+0933+093C -> U+0934 */ 752,
	/* U+09C7+09BE -> U+09CB */ 768,
	/* U+09C7+09D7 -> U+09CC */ 769,
	/* U+0B47+0B3E -> U+0B4B */ 787,
	/* U+0B47+0B56 -> U+0B48 */ 786,
	/* U+0B47+0B57 -> U+0B4C */ 788,
	/* U+0B92+0BD7 -> U+0B94 */ 792,
	/* U+0BC6+0BBE -> U+0BCA */ 793,
	/* U+0BC6+0BD7 -> U+0BCC */ 795,
	/* U+0BC7+0BBE -> U+0BCB */ 794,
	/* U+0C46+0C56 -> U+0C48 */ 798,
	/* U+0CBF+0CD5 -> U+0CC0 */ 803,
	/* U+0CC6+0CC2 -> U+0CCA */ 806,
	/* U+0CC6+0CD5 -> U+0CC7 */ 804,
	/* U+0CC6+0CD6 -> U+0CC8 */ 805,
	/* U+0CCA+0CD5 -> U+0CCB */ 807,
	/* U+0D46+0D3E -> U+0D4A */ 811,
	/* U+0D46+0D57 -> U+0D4C */ 813,
	/* U+0D47+0D3E -> U+0D4B */ 812,
	/* U+0DD9+0DCA -> U+0DDA */ 816,
	/* U+0DD9+0DCF -> U+0DDC */ 817,
	/* U+0DD9+0DDF -> U+0DDE */ 819,
	/* U+0DDC+0DCA -> U+0DDD */ 818,
	/* U+1025+102E -> U+1026 */ 877,
	/* U+1B05+1B35 -> U+1B06 */ 937,
	/* U+1B07+1B35 -> U+1B08 */ 938,
	/* U+1B09+1B35 -> U+1B0A */ 939,
	/* U+1B0B+1B35 -> U+1B0C */ 940,
	/* U+1B0D+1B35 -> U+1B0E */ 941,
	/* U+1B11+1B35 -> U+1B12 */ 942,
	/* U+1B3A+1B35 -> U+1B3B */ 944,
	/* U+1B3C+1B35 -> U+1B3D */ 945,
	/* U+1B3E+1B35 -> U+1B40 */ 946,
	/* U+1B3F+1B35 -> U+1B41 */ 947,
	/* U+1B42+1B35 -> U+1B43 */ 948,
	/* U+1E36+0304 -> U+1E38 */ 1210,
	/* U+1E37+0304 -> U+1E39 */ 1211,
	/* U+1E5A+0304 -> U+1E5C */ 1246,
	/* U+1E5B+0304 -> U+1E5D */ 1247,
	/* U+1E62+0307 -> U+1E68 */ 1258,
	/* U+1E63+0307 -> U+1E69 */ 1259,
	/* U+1EA0+0302 -> U+1EAC */ 1322,
	/* U+1EA0+0306 -> U+1EB6 */ 1332,
	/* U+1EA1+0302 -> U+1EAD */ 1323,
	/* U+1EA1+0306 -> U+1EB7 */ 1333,
	/* U+1EB8+0302 -> U+1EC6 */ 1348,
	/* U+1EB9+0302 -> U+1EC7 */ 1349,
	/* U+1ECC+0302 -> U+1ED8 */ 1366,
	/* U+1ECD+0302 -> U+1ED9 */ 1367,
	/* U+1F00+0300 -> U+1F02 */ 1402,
	/* U+1F00+0301 -> U+1F04 */ 1404,
	/* U+1F00+0342 -> U+1F06 */ 1406,
	/* U+1F00+0345 -> U+1F80 */ 1514,
	/* U+1F01+0300 -> U+1F03 */ 1403,
	/* U+1F01+0301 -> U+1F05 */ 1405,
	/* U+1F01+0342 -> U+1F07 */ 1407,
	/* U+1F01+0345 -> U+1F81 */ 1515,
	/* U+1F02+0345 -> U+1F82 */ 1516,
	/* U+1F03+0345 -> U+1F83 */ 1517,
	/* U+1F04+0345 -> U+1F84 */ 1518,
	/* U+1F05+0345 -> U+1F85 */ 1519,
	/* U+1F06+0345 -> U+1F86 */ 1520,
	/* U+1F07+0345 -> U+1F87 */ 1521,
	/* U+1F08+0300 -> U+1F0A */ 1410,
	/* U+1F08+0301 -> U+1F0C */ 1412,
	/* U+1F08+0342 -> U+1F0E */ 1414,
	/* U+1F08+0345 -> U+1F88 */ 1522,
	/* U+1F09+0300 -> U+1F0B */ 1411,
	/* U+1F09+0301 -> U+1F0D */ 1413,
	/* U+1F09+0342 -> U+1F0F */ 1415,
	/* U+1F09+0345 -> U+1F89 */ 1523,
	/* U+1F0A+0345 -> U+1F8A */ 1524,
	/* U+1F0B+0345 -> U+1F8B */ 1525,
	/* U+1F0C+0345 -> U+1F8C */ 1526,
	/* U+1F0D+0345 -> U+1F8D */ 1527,
	/* U+1F0E+0345 -> U+1F8E */ 1528,
	/* U+1F0F+0345 -> U+1F8F */ 1529,
	/* U+1F10+0300 -> U+1F12 */ 1418,
	/* U+1F10+0301 -> U+1F14 */ 1420,
	/* U+1F11+0300 -> U+1F13 */ 1419,
	/* U+1F11+0301 -> U+1F15 */ 1421,
	/* U+1F18+0300 -> U+1F1A */ 1424,
	/* U+1F18+0301 -> U+1F1C */ 1426,
	/* U+1F19+0300 -> U+1F1B */ 1425,
	/* U+1F19+0301 -> U+1F1D */ 1427,
	/* U+1F20+0300 -> U+1F22 */ 1430,
	/* U+1F20+0301 -> U+1F24 */ 1432,
	/* U+1F20+0342 -> U+1F26 */ 1434,
	/* U+1F20+0345 -> U+1F90 */ 1530,
	/* U+1F21+0300 -> U+1F23 */ 1431,
	/* U+1F21+0301 -> U+1F25 */ 1433,
	/* U+1F21+0342 -> U+1F27 */ 1435,
	/* U+1F21+0345 -> U+1F91 */ 1531,
	/* U+1F22+0345 -> U+1F92 */ 1532,
	/* U+1F23+0345 -> U+1F93 */ 1533,
	/* U+1F24+0345 -> U+1F94 */ 1534,
	/* U+1F25+0345 -> U+1F95 */ 1535,
	/* U+1F26+0345 -> U+1F96 */ 1536,
	/* U+1F27+0345 -> U+1F97 */ 1537,
	/* U+1F28+0300 -> U+1F2A */ 1438,
	/* U+1F28+0301 -> U+1F2C */ 1440,
	/* U+1F28+0342 -> U+1F2E */ 1442,
	/* U+1F28+0345 -> U+1F98 */ 1538,
	/* U+1F29+0300 -> U+1F2B */ 1439,
	/* U+1F29+0301 -> U+1F2D */ 1441,
	/* U+1F29+0342 -> U+1F2F */ 1443,
	/* U+1F29+0345 -> U+1F99 */ 1539,
	/* U+1F2A+0345 -> U+1F9A */ 1540,
	/* U+1F2B+0345 -> U+1F9B */ 1541,
	/* U+1F2C+0345 -> U+1F9C */ 1542,
	/* U+1F2D+0345 -> U+1F9D */ 1543,
	/* U+1F2E+0345 -> U+1F9E */ 1544,
	/* U+1F2F+0345 -> U+1F9F */ 1545,
	/* U+1F30+0300 -> U+1F32 */ 1446,
	/* U+1F30+0301 -> U+1F34 */ 1448,
	/* U+1F30+0342 -> U+1F36 */ 1450,
	/* U+1F31+0300 -> U+1F33 */ 1447,
	/* U+1F31+0301 -> U+1F35 */ 1449,
	/* U+1F31+0342 -> U+1F37 */ 1451,
	/* U+1F38+0300 -> U+1F3A */ 1454,
	/* U+1F38+0301 -> U+1F3C */ 1456,
	/* U+1F38+0342 -> U+1F3E */ 1458,
	/* U+1F39+0300 -> U+1F3B */ 1455,
	/* U+1F39+0301 -> U+1F3D */ 1457,
	/* U+1F39+0342 -> U+1F3F */ 1459,
	/* U+1F40+0300 -> U+1F42 */ 1462,
	/* U+1F40+0301 -> U+1F44 */ 1464,
	/* U+1F41+0300 -> U+1F43 */ 1463,
	/* U+1F41+0301 -> U+1F45 */ 1465,
	/* U+1F48+0300 -> U+1F4A */ 1468,
	/* U+1F48+0301 -> U+1F4C */ 1470,
	/* U+1F49+0300 -> U+1F4B */ 1469,
	/* U+1F49+0301 -> U+1F4D */ 1471,
	/* U+1F50+0300 -> U+1F52 */ 1474,
	/* U+1F50+0301 -> U+1F54 */ 1476,
	/* U+1F50+0342 -> U+1F56 */ 1478,
	/* U+1F51+0300 -> U+1F53 */ 1475,
	/* U+1F51+0301 -> U+1F55 */ 1477,
	/* U+1F51+0342 -> U+1F57 */ 1479,
	/* U+1F59+0300 -> U+1F5B */ 1481,
	/* U+1F59+0301 -> U+1F5D */ 1482,
	/* U+1F59+0342 -> U+1F5F */ 1483,
	/* U+1F60+0300 -> U+1F62 */ 1486,
	/* U+1F60+0301 -> U+1F64 */ 1488,
	/* U+1F60+0342 -> U+1F66 */ 1490,
	/* U+1F60+0345 -> U+1FA0 */ 1546,
	/* U+1F61+0300 -> U+1F63 */ 1487,
	/* U+1F61+0301 -> U+1F65 */ 1489,
	/* U+1F61+0342 -> U+1F67 */ 1491,
	/* U+1F61+0345 -> U+1FA1 */ 1547,
	/* U+1F62+0345 -> U+1FA2 */ 1548,
	/* U+1F63+0345 -> U+1FA3 */ 1549,
	/* U+1F64+0345 -> U+1FA4 */ 1550,
	/* U+1F65+0345 -> U+1FA5 */ 1551,
	/* U+1F66+0345 -> U+1FA6 */ 1552,
	/* U+1F67+0345 -> U+1FA7 */ 1553,
	/* U+1F68+0300 -> U+1F6A */ 1494,
	/* U+1F68+0301 -> U+1F6C */ 1496,
	/* U+1F68+0342 -> U+1F6E */ 1498,
	/* U+1F68+0345 -> U+1FA8 */ 1554,
	/* U+1F69+0300 -> U+1F6B */ 1495,
	/* U+1F69+0301 -> U+1F6D */ 1497,
	/* U+1F69+0342 -> U+1F6F */ 1499,
	/* U+1F69+0345 -> U+1FA9 */ 1555,
	/* U+1F6A+0345 -> U+1FAA */ 1556,
	/* U+1F6B+0345 -> U+1FAB */ 1557,
	/* U+1F6C+0345 -> U+1FAC */ 1558,
	/* U+1F6D+0345 -> U+1FAD */ 1559,
	/* U+1F6E+0345 -> U+1FAE */ 1560,
	/* U+1F6F+0345 -> U+1FAF */ 1561,
	/* U+1F70+0345 -> U+1FB2 */ 1564,
	/* U+1F74+0345 -> U+1FC2 */ 1579,
	/* U+1F7C+0345 -> U+1FF2 */ 1621,
	/* U+1FB6+0345 -> U+1FB7 */ 1568,
	/* U+1FBF+0300 -> U+1FCD */ 1589,
	/* U+1FBF+0301 -> U+1FCE */ 1590,
	/* U+1FBF+0342 -> U+1FCF */ 1591,
	/* U+1FC6+0345 -> U+1FC7 */ 1583,
	/* U+1FF6+0345 -> U+1FF7 */ 1625,
	/* U+1FFE+0300 -> U+1FDD */ 1602,
	/* U+1FFE+0301 -> U+1FDE */ 1603,
	/* U+1FFE+0342 -> U+1FDF */ 1604,
	/* U+2190+0338 -> U+219A */ 1835,
	/* U+2192+0338 -> U+219B */ 1836,
	/* U+2194+0338 -> U+21AE */ 1837,
	/* U+21D0+0338 -> U+21CD */ 1838,
	/* U+21D2+0338 -> U+21CF */ 1840,
	/* U+21D4+0338 -> U+21CE */ 1839,
	/* U+2203+0338 -> U+2204 */ 1841,
	/* U+2208+0338 -> U+2209 */ 1842,
	/* U+220B+0338 -> U+220C */ 1843,
	/* U+2223+0338 -> U+2224 */ 1844,
	/* U+2225+0338 -> U+2226 */ 1845,
	/* U+223C+0338 -> U+2241 */ 1850,
	/* U+2243+0338 -> U+2244 */ 1851,
	/* U+2245+0338 -> U+2247 */ 1852,
	/* U+2248+0338 -> U+2249 */ 1853,
	/* U+224D+0338 -> U+226D */ 1856,
	/* U+2261+0338 -> U+2262 */ 1855,
	/* U+2264+0338 -> U+2270 */ 1859,
	/* U+2265+0338 -> U+2271 */ 1860,
	/* U+2272+0338 -> U+2274 */ 1861,
	/* U+2273+0338 -> U+2275 */ 1862,
	/* U+2276+0338 -> U+2278 */ 1863,
	/* U+2277+0338 -> U+2279 */ 1864,
	/* U+227A+0338 -> U+2280 */ 1865,
	/* U+227B+0338 -> U+2281 */ 1866,
	/* U+227C+0338 -> U+22E0 */ 1875,
	/* U+227D+0338 -> U+22E1 */ 1876,
	/* U+2282+0338 -> U+2284 */ 1867,
	/* U+2283+0338 -> U+2285 */ 1868,
	/* U+2286+0338 -> U+2288 */ 1869,
	/* U+2287+0338 -> U+2289 */ 1870,
	/* U+2291+0338 -> U+22E2 */ 1877,
	/* U+2292+0338 -> U+22E3 */ 1878,
	/* U+22A2+0338 -> U+22AC */ 1871,
	/* U+22A8+0338 -> U+22AD */ 1872,
	/* U+22A9+0338 -> U+22AE */ 1873,
	/* U+22AB+0338 -> U+22AF */ 1874,
	/* U+22B2+0338 -> U+22EA */ 1879,
	/* U+22B3+0338 -> U+22EB */ 1880,
	/* U+22B4+0338 -> U+22EC */ 1881,
	/* U+22B5+0338 -> U+22ED */ 1882,
	/* U+3046+3099 -> U+3094 */ 2320,
	/* U+304B+3099 -> U+304C */ 2295,
	/* U+304D+3099 -> U+304E */ 2296,
	/* U+304F+3099 -> U+3050 */ 2297,
	/* U+3051+3099 -> U+3052 */ 2298,
	/* U+3053+3099 -> U+3054 */ 2299,
	/* U+3055+3099 -> U+3056 */ 2300,
	/* U+3057+3099 -> U+3058 */ 2301,
	/* U+3059+3099 -> U+305A */ 2302,
	/* U+305B+3099 -> U+305C */ 2303,
	/* U+305D+3099 -> U+305E */ 2304,
	/* U+305F+3099 -> U+3060 */ 2305,
	/* U+3061+3099 -> U+3062 */ 2306,
	/* U+3064+3099 -> U+3065 */ 2307,
	/* U+3066+3099 -> U+3067 */ 2308,
	/* U+3068+3099 -> U+3069 */ 2309,
	/* U+306F+3099 -> U+3070 */ 2310,
	/* U+306F+309A -> U+3071 */ 2311,
	/* U+3072+3099 -> U+3073 */ 2312,
	/* U+3072+309A -> U+3074 */ 2313,
	/* U+3075+3099 -> U+3076 */ 2314,
	/* U+3075+309A -> U+3077 */ 2315,
	/* U+3078+3099 -> U+3079 */ 2316,
	/* U+3078+309A -> U+307A */ 2317,
	/* U+307B+3099 -> U+307C */ 2318,
	/* U+307B+309A -> U+307D */ 2319,
	/* U+309D+3099 -> U+309E */ 2325,
	/* U+30A6+3099 -> U+30F4 */ 2352,
	/* U+30AB+3099 -> U+30AC */ 2327,
	/* U+30AD+3099 -> U+30AE */ 2328,
	/* U+30AF+3099 -> U+30B0 */ 2329,
	/* U+30B1+3099 -> U+30B2 */ 2330,
	/* U+30B3+3099 -> U+30B4 */ 2331,
	/* U+30B5+3099 -> U+30B6 */ 2332,
	/* U+30B7+3099 -> U+30B8 */ 2333,
	/* U+30B9+3099 -> U+30BA */ 2334,
	/* U+30BB+3099 -> U+30BC */ 2335,
	/* U+30BD+3099 -> U+30BE */ 2336,
	/* U+30BF+3099 -> U+30C0 */ 2337,
	/* U+30C1+3099 -> U+30C2 */ 2338,
	/* U+30C4+3099 -> U+30C5 */ 2339,
	/* U+30C6+3099 -> U+30C7 */ 2340,
	/* U+30C8+3099 -> U+30C9 */ 2341,
	/* U+30CF+3099 -> U+30D0 */ 2342,
	/* U+30CF+309A -> U+30D1 */ 2343,
	/* U+30D2+3099 -> U+30D3 */ 2344,
	/* U+30D2+309A -> U+30D4 */ 2345,
	/* U+30D5+3099 -> U+30D6 */ 2346,
	/* U+30D5+309A -> U+30D7 */ 2347,
	/* U+30D8+3099 -> U+30D9 */ 2348,
	/* U+30D8+309A -> U+30DA */ 2349,
	/* U+30DB+3099 -> U+30DC */ 2350,
	/* U+30DB+309A -> U+30DD */ 2351,
	/* U+30EF+3099 -> U+30F7 */ 2353,
	/* U+30F0+3099 -> U+30F8 */ 2354,
	/* U+30F1+3099 -> U+30F9 */ 2355,
	/* U+30F2+3099 -> U+30FA */ 2356,
	/* U+30FD+3099 -> U+30FE */ 2357,
	/* U+11099+110BA -> U+1109A */ 4686,
	/* U+1109B+110BA -> U+1109C */ 4687,
	/* U+110A5+110BA -> U+110AB */ 4688,
	/* U+11131+11127 -> U+1112E */ 4694,
	/* U+11132+11127 -> U+1112F */ 4695,
	/* U+11347+1133E -> U+1134B */ 4707,
	/* U+11347+11357 -> U+1134C */ 4708,
	/* U+114B9+114B0 -> U+114BC */ 4726,
	/* U+114B9+114BA -> U+114BB */ 4725,
	/* U+114B9+114BD -> U+114BE */ 4727,
	/* U+115B8+115AF -> U+115BA */ 4730,
	/* U+115B9+115AF -> U+115BB */ 4731,
	/* U+11935+11930 -> U+11938 */ 4740
};

/* Perfect hash function for recomposition */
static int
Recomp_hash_func(const void *key)
{
	static const int16 h[1883] = {
		772,   773,   621,   32767, 32767, 387,   653,   196,
		32767, 32767, 855,   463,   -19,   651,   32767, 32767,
		32767, 364,   32767, 32767, -108,  32767, 32767, 32767,
		32767, 0,     -568,  32767, 32767, 32767, 0,     0,
		0,     -103,  364,   0,     210,   732,   0,     0,
		-506,  0,     0,     0,     32767, 32767, 0,     32767,
		407,   -140,  32767, 409,   32767, 772,   0,     86,
		842,   934,   32767, 32767, -499,  -355,  32767, 32767,
		532,   138,   174,   -243,  860,   1870,  742,   32767,
		32767, 339,   32767, 1290,  0,     32767, 32767, 0,
		-449,  -1386, 1633,  560,   561,   32767, 1219,  1004,
		139,   -804,  32767, -179,  141,   579,   1586,  32767,
		32767, 32767, 142,   199,   32767, 32767, 143,   0,
		32767, 32767, 314,   896,   32767, 32767, 428,   129,
		286,   -58,   0,     68,    32767, 0,     244,   -566,
		32767, 32767, 32767, 246,   32767, 32767, 0,     32767,
		32767, 271,   -108,  928,   32767, 715,   32767, 32767,
		-211,  -497,  32767, 0,     1055,  1339,  32767, 0,
		32767, 32767, -968,  -144,  32767, 32767, 248,   32767,
		-161,  32767, 32767, 282,   32767, -372,  0,     2,
		-137,  1116,  32767, 687,   32767, 459,   913,   0,
		461,   879,   -816,  443,   32767, 32767, 462,   1089,
		32767, 1054,  0,     314,   447,   -26,   480,   32767,
		64,    0,     0,     112,   32767, 66,    0,     646,
		603,   22,    -292,  0,     710,   475,   32767, 24,
		-781,  32767, 32767, 32767, 281,   307,   32767, 1289,
		32767, 0,     1064,  -149,  454,   118,   32767, 32767,
		0,     32767, -126,  0,     32767, 32767, 858,   32767,
		32767, 32767, 1029,  886,   665,   209,   0,     26,
		359,   0,     0,     -108,  -508,  -603,  894,   906,
		32767, 32767, 14,    0,     0,     534,   984,   876,
		32767, -93,   110,   -367,  167,   843,   32767, 32767,
		-947,  -290,  169,   0,     0,     32767, -42,   564,
		0,     -927,  32767, 817,   32767, 32767, 32767, 110,
		0,     32767, 32767, -38,   32767, 32767, -101,  694,
		-142,  190,   191,   1288,  32767, -687,  194,   -579,
		534,   -452,  0,     -72,   536,   765,   823,   266,
		-259,  684,   767,   32767, 654,   32767, 32767, 64,
		920,   32767, 32767, 32767, 0,     1653,  0,     0,
		32767, 32767, -452,  -222,  855,   0,     32767, -1153,
		127,   490,   449,   863,   32767, -144,  32767, -379,
		545,   32767, 32767, 32767, 530,   32767, 32767, 1331,
		611,   -612,  332,   545,   -73,   0,     604,   201,
		32767, -279,  338,   836,   340,   408,   32767, -60,
		-358,  32767, 343,   69,    707,   0,     -129,  582,
		32767, 0,     32767, 96,    392,   490,   639,   157,
		-4,    406,   32767, 32767, -571,  1077,  546,   32767,
		551,   0,     0,     0,     32767, 32767, 348,   32767,
		498,   -181,  0,     -433,  1057,  260,   0,     32767,
		32767, 397,   32767, 816,   -130,  32767, 624,   0,
		0,     32767, 32767, 32767, 485,   0,     32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 1222,
		-230,  32767, 797,   -538,  32767, 974,   32767, 32767,
		831,   70,    -658,  145,   0,     147,   0,     32767,
		1295,  32767, 0,     0,     895,   0,     0,     -385,
		491,   -287,  32767, -587,  32767, 32767, 32767, 813,
		-471,  -13,   32767, 32767, 32767, 0,     203,   411,
		470,   0,     -546,  -179,  146,   0,     0,     32767,
		-468,  32767, 0,     0,     32767, 32767, 32767, 211,
		32767, 32767, 0,     32767, 0,     52,    32767, 0,
		32767, 0,     692,   990,   32767, 32767, 32767, 56,
		-507,  784,   951,   0,     32767, 0,     697,   32767,
		187,   0,     32767, 32767, 430,   1209,  682,   32767,
		130,   0,     -25,   0,     -1006, 0,     32767, 214,
		433,   22,    0,     -1119, 32767, 285,   32767, 32767,
		32767, 216,   32767, 32767, 32767, 217,   527,   32767,
		32767, 32767, 829,   485,   419,   717,   620,   731,
		32767, 470,   0,     -145,  -620,  1162,  -644,  848,
		287,   -632,  32767, 32767, 32767, 32767, 381,   32767,
		510,   511,   -554,  -2,    32767, 0,     0,     698,
		32767, 32767, 436,   1154,  32767, 463,   32767, 32767,
		627,   517,   32767, 32767, 854,   579,   723,   396,
		110,   -42,   354,   32767, 664,   32767, 32767, 0,
		0,     32767, 65,    -163,  67,    140,   69,    341,
		70,    71,    402,   73,    623,   544,   624,   417,
		-1375, 648,   32767, -26,   904,   0,     548,   0,
		0,     32767, 32767, 855,   32767, 488,   -524,  599,
		130,   131,   32767, 32767, 542,   -1110, -324,  -462,
		32767, -405,  -440,  0,     0,     629,   850,   0,
		741,   257,   258,   32767, 32767, 0,     32767, 923,
		0,     32767, 0,     32767, 1559,  32767, 32767, 32767,
		671,   32767, 134,   32767, 32767, -336,  -104,  576,
		577,   829,   32767, 32767, 762,   902,   32767, 0,
		32767, 0,     1506,  887,   32767, 636,   601,   2465,
		426,   0,     236,   317,   427,   968,   32767, -975,
		-559,  -343,  341,   32767, 937,   241,   0,     32767,
		32767, 547,   32767, 32767, 32767, 32767, 32767, 789,
		0,     32767, 32767, 32767, 0,     0,     0,     32767,
		-192,  859,   1185,  1153,  69,    32767, 32767, 32767,
		-539,  32767, 32767, 0,     32767, 32767, 32767, 32767,
		640,   578,   32767, 32767, -766,  32767, 32767, 32767,
		32767, 1050,  -572,  32767, 32767, 32767, 32767, 1268,
		32767, 32767, 32767, 754,   32767, 32767, 1640,  179,
		804,   32767, 32767, 32767, 32767, 0,     684,   943,
		1006,  32767, 32767, 652,   0,     32767, 1041,  32767,
		718,   791,   32767, 274,   697,   32767, 32767, 0,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 735,
		0,     32767, 32767, 32767, 275,   358,   688,   32767,
		32767, 32767, 548,   -87,   770,   32767, -42,   0,
		551,   32767, 691,   222,   32767, 32767, 32767, 32767,
		0,     1273,  403,   -121,  806,   553,   554,   163,
		32767, 32767, 892,   825,   32767, 32767, -490,  32767,
		32767, 32767, 32767, 32767, -109,  744,   910,   32767,
		91,    32767, 32767, 0,     0,     32767, 32767, 32767,
		1521,  50,    701,   32767, 32767, 32767, 32767, 164,
		658,   32767, 288,   0,     32767, 0,     51,    0,
		32767, 32767, 32767, 32767, 555,   1547,  32767, 32767,
		595,   585,   429,   32767, -80,   32767, 1258,  0,
		540,   486,   -434,  865,   0,     192,   0,     884,
		0,     0,     0,     175,   555,   0,     32767, 32767,
		0,     32767, -566,  866,   591,   32767, 32767, 32767,
		32767, 32767, 496,   495,   -215,  32767, 849,   -772,
		32767, 32767, 502,   178,   483,   32767, 912,   793,
		794,   0,     32767, 32767, 32767, -556,  499,   838,
		32767, 32767, -506,  331,   0,     0,     -1096, 512,
		880,   0,     774,   -338,  649,   32767, 270,   32767,
		32767, -624,  328,   459,   32767, 32767, 32767, 32767,
		329,   -201,  -835,  813,   -879,  560,   0,     -212,
		-114,  35,    -494,  37,    523,   653,   751,   -653,
		-743,  32767, 1356,  818,   32767, 32767, 856,   0,
		44,    902,   0,     0,     0,     0,     32767, -26,
		526,   795,   456,   32767, 104,   -209,  -341,  133,
		-372,  0,     45,    110,   111,   0,     511,   47,
		114,   32767, 32767, 93,    48,    116,   -1031, -279,
		32767, 192,   0,     32767, 453,   415,   0,     -190,
		32767, 471,   240,   175,   29,    665,   684,   0,
		-11,   -95,   -344,  32767, 245,   148,   0,     530,
		0,     1185,  -615,  -712,  693,   784,   32767, 0,
		-776,  32767, 32767, -813,  0,     0,     0,     207,
		208,   32767, 674,   32767, 742,   -289,  249,   32767,
		520,   929,   -50,   781,   0,     -778,  32767, 0,
		302,   32767, 720,   -465,  0,     32767, 32767, 32767,
		0,     0,     32767, 833,   328,   806,   32767, -403,
		0,     32767, -77,   32767, 0,     441,   930,   32767,
		643,   0,     32767, 1938,  0,     1334,  381,   32767,
		216,   32767, 32767, 0,     32767, 484,   383,   0,
		242,   395,   0,     32767, 32767, 32767, -781,  355,
		356,   32767, 292,   706,   32767, 32767, 32767, 32767,
		32767, -410,  32767, 32767, 782,   32767, 189,   32767,
		32767, 943,   0,     -212,  407,   335,   0,     135,
		32767, 616,   0,     -497,  0,     -67,   853,   32767,
		700,   32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     459,   -48,   32767, 58,    0,
		-856,  1017,  32767, 59,    916,   -731,  32767, 940,
		-855,  347,   650,   0,     678,   32767, 0,     32767,
		32767, 530,   32767, 0,     -80,   32767, -730,  32767,
		1214,  799,   58,    651,   841,   0,     0,     -589,
		-1530, -478,  651,   652,   93,    576,   -1215, 32767,
		125,   32767, 1279,  32767, 32767, 0,     32767, 0,
		-367,  416,   -1236, 32767, 418,   32767, 815,   558,
		559,   781,   419,   32767, 739,   32767, 0,     32767,
		128,   570,   1349,  -298,  -66,   0,     147,   -488,
		32767, 590,   189,   274,   524,   32767, 1082,  -209,
		32767, 423,   32767, 32767, 975,   573,   32767, 424,
		32767, 32767, 1241,  32767, 32767, 32767, 32767, 32767,
		612,   391,   32767, 0,     -803,  1004,  -561,  32767,
		32767, 735,   870,   32767, 0,     32767, 32767, -123,
		99,    210,   600,   1294,  109,   1053,  32767, 307,
		834,   32767, 0,     1651,  32767, 644,   32767, 32767,
		0,     32767, -801,  385,   379,   32767, -368,  32767,
		32767, 830,   0,     32767, 32767, 739,   371,   372,
		-275,  32767, 32767, 331,   -780,  32767, 0,     1229,
		-1462, 913,   266,   827,   125,   32767, 32767, 32767,
		393,   32767, 631,   -33,   -883,  -661,  -204,  6,
		-19,   257,   8,     9,     118,   519,   615,   -541,
		-893,  0,     32767, 0,     1156,  15,    900,   32767,
		32767, 32767, 32767, 32767, 32767, 1022,  376,   0,
		32767, 32767, -972,  676,   840,   -661,  631,   58,
		0,     17,    32767, 0,     -799,  82,    0,     32767,
		32767, 680,   32767, 905,   0,     0,     32767, 32767,
		0,     0,     32767, 0,     828,   386,   802,   0,
		146,   0,     148,   32767, -1146, 0,     150,   151,
		-743,  153,   154,   32767, 32767, 442,   32767, 743,
		0,     0,     746,   0,     32767, 32767, 32767, 98,
		32767, 157,   0,     696,   0,     32767, 32767, -294,
		32767, 158,   159,   32767, 0,     32767, 160,   32767,
		933,   32767, 32767, -50,   759,   824,   162,   672,
		32767, 356,   0,     356,   32767, 32767, 0,     0,
		656,   692,   253,   254,   -374,  102,   256,   32767,
		0,     0,     32767, 32767, 259,   32767, 63,    260,
		510,   261,   32767, 0,     32767, 1061,  32767, 521,
		32767, 32767, 32767, 32767, 32767, 32767, 316,   317,
		846,   0,     32767, -500,  318,   0,     32767, 32767,
		263,   0,     790,   872,   32767, 32767, 32767, 2171,
		264,   32767, 32767, 32767, 32767, 486,   334,   465,
		32767, 466,   32767, 444,   606,   32767, 0,     445,
		320,   -317,  0,     520,   322,   718,   32767, 32767,
		32767, 0,     1013,  32767, 32767, 32767, 32767, 32767,
		32767, 611,   32767, 0,     0,     32767, 32767, -120,
		156,   613,   0,     0,     32767, -68,   32767, 622,
		32767, 32767, 32767, 32767, 32767, 455,   32767, 32767,
		32767, 403,   533,   0,     -161,  405,   95,    96,
		32767, 97,    32767, 0,     29,    0,     32767, 32767,
		30,    32767, 99,    32767, 32767, 0,     161,   32767,
		97,    0,     32,    32767, 32767, 0,     0,     315,
		32767, 32767, 414,   966,   0,     585,   32767, 32767,
		-616,  -256,  171,   172,   666,   101,   562,   563,
		32767, 95,    0,     0,     1492,  390,   -251,  103,
		32767, 0,     32767, 188,   1487,  32767, 0,     0,
		586,   668,   -126,  0,     0,     32767, 32767, 204,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 656,   32767, 32767,
		599,   0,     222,   32767, 0,     1368,  -412,  435,
		32767, 936,   32767, -17,   32767, 832,   32767, 437,
		0,     -518,  787,   32767, 864,   -449,  0,     636,
		713,   206,   592,   572,   0,     483,   -139,  32767,
		32767, 180,   818,   32767, 32767, 1304,  0,     32767,
		274,   0,     0,     0,     0,     705,   32767, 32767,
		32767, 0,     -272,  0,     502,   503,   319,   0,
		32767, 0,     13,    32767, 32767, 0,     32767, 270,
		737,   0,     32767, 32767, 32767, 901,   32767, 616,
		180,   32767, 721,   353,   32767, 0,     32767, 32767,
		-199,  0,     280,   788,   32767, 940,   32767, 51,
		0,     400,   53,    0,     54,    -637,  0,     -453,
		0,     0,     0,     380,   0,     32767, 504,   0,
		2049,  0,     -964,  32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 798,   32767, 32767, 32767, 0,
		538,   488,   0,     32767, -528,  57,    819,   32767,
		32767, 1244,  0,     488,   739,   908,   32767, 32767,
		0,     32767, 32767, 0,     55,    533,   0,     32767,
		814,   0,     32767, 458,   0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 776,   777,   920,   0,
		0,     755,   32767, 0,     32767, 32767, 0,     32767,
		55,    -954,  0,     372,   166,   218,   165,   857,
		221,   675,   0,     223,   224,   -155,  226,   32767,
		1851,  227,   32767, 32767, 1192,  0,     229,   0,
		-72,   0,     865,   0,     0,     -330,  0,     683,
		32767, -550,  -196,  725,   -573,  293,   102,   32767,
		-589,  296,   297,   298,   231,   -256,  300,   32767,
		32767, 301,   233,   868,   32767, 234,   0,     811,
		1187,  32767, 32767, 0,     32767, 518,   0,     361,
		362,   466,   0,     365,   32767, -179,  366,   367,
		874,   369,   305,   0,     32767, 0,     32767, 0,
		32767, 2000,  1215,  451,   652,   0,     0,     799,
		32767, 32767, 32767
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 8;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 1883] + h[b % 1883];
}

/* Hash lookup information for recomposition */
static const pg_unicode_recompinfo UnicodeRecompInfo =
{
	RecompInverseLookup,
	Recomp_hash_func,
	941
};
