# -*- coding: latin-1 -*-
from mx import Tidy

### Test input data...

data = """\
<?xml version='1.0' encoding='iso-8859-1'?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>------&auml;---</title>
</head>
<body>------&uuml;---</body>
</html>
"""

### This is the expected output...

verifydata = """\
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<?xml version='1.0' encoding='iso-8859-1'?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type"
content="text/html; charset=iso-8859-1" />
<title>---------</title>
</head>
<body>
---------
</body>
</html>

"""

### Testing string buffer interface...

print 'Testing file parsing...',
open('testWalter.xml', 'wb').write(data)
(nerrors, nwarnings, outputdata, error) = Tidy.tidy(open('testWalter.xml', 'rb'), 
                                                    open('output.xml', 'wb'),
                                                    numeric_entities=1,
                                                    output_xhtml=1,
                                                    char_encoding="latin1")
print error,
outputdata = open('output.xml', 'rb').read()
if outputdata != verifydata:
    print '*** Output does NOT verify OK !'
else:
    print 'OK'
print

### Testing file interface...

print 'Testing data parsing...',
(nerrors, nwarnings, outputdata, error) = Tidy.tidy(data, 
                                                    numeric_entities=1,
                                                    output_xhtml=1,
                                                    char_encoding="latin1")
print error,
if outputdata != verifydata:
    print '*** Output does NOT verify OK !'
else:
    print 'OK'
print
