#!/usr/local/bin/python

# A simple example that runs 'show version' on a Cisco router.

# Notes:
# - Assumes that netdevicelib is in your PYTHONPATH.
# - Error checking omitted for clarity

# $Id: version.py,v 1.1 2001/08/26 18:05:51 bluecoat93 Exp $

import sys
from netdevicelib.connections import ConnectionFactory

# Check the command-line arguments
if len( sys.argv ) < 4:
    print "Usage: version.py device username password"
    sys.exit(0)

# Create a Connection object for a telnet connection to an IOS device
conn = ConnectionFactory().createConnection( "telnet", "IOS" )

# Open the connection to the device
conn.open( sys.argv[1] )

# Login to the device. Assumes username/password login (i.e. TACACS)
conn.login( sys.argv[2], sys.argv[3] )

# Run the command on the device
lines = conn.cmd( "show version" )

# Print the output
print lines
