/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ServiceLoader;

public class QoreJavaDynamicApi {
    public static Object newInstance(Constructor<?> constructor, Object ... objectArray) throws Throwable {
        try {
            constructor.trySetAccessible();
            return constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException;
            while (throwable instanceof InvocationTargetException) {
                throwable = ((Throwable)throwable).getCause();
            }
            throw throwable;
        }
    }

    public static Object invokeMethod(Method method, Object object, Object ... objectArray) throws Throwable {
        try {
            method.trySetAccessible();
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException;
            while (throwable instanceof InvocationTargetException) {
                throwable = ((Throwable)throwable).getCause();
            }
            throw throwable;
        }
    }

    public static Object invokeMethodNonvirtual(Method method, Object object, Object ... objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        method.trySetAccessible();
        return MethodHandles.privateLookupIn(clazz, MethodHandles.lookup()).unreflectSpecial(method, clazz).bindTo(object).invokeWithArguments(objectArray);
    }

    public static Object getField(Field field, Object object) throws Throwable {
        field.setAccessible(true);
        return field.get(object);
    }

    public static MethodHandles.Lookup lookup() {
        return MethodHandles.lookup();
    }

    public static <S> ServiceLoader<S> loadServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        return ServiceLoader.load(clazz, classLoader);
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        return DriverManager.getConnection(string, properties);
    }
}

