/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.modifier.MethodArguments;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import org.qore.jni.QoreJavaObjectPtr;
import org.qore.jni.QoreURLClassLoader;
import org.qore.jni.StaticEntry;

public class JavaClassBuilder {
    private static Class objArray;
    private static Method mStaticCall;
    private static Method mNormalCall;
    private static Method mFunctionCall;
    private static Method mGetConstantValue;
    private static final String CLASS_FIELD = "$qore_cls_ptr";
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_ABSTRACT = 1024;

    public static DynamicType.Builder<?> getFunctionConstantClassBuilder(final String string) throws NoSuchMethodException {
        return new ByteBuddy().with(TypeValidation.DISABLED).with(new NamingStrategy.AbstractBase(){

            @Override
            public String name(TypeDescription typeDescription) {
                return string;
            }
        }).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).modifiers(1);
    }

    public static DynamicType.Builder<?> addFunction(DynamicType.Builder<?> builder, String string, long l, long l2, long l3, TypeDefinition typeDefinition, List<TypeDefinition> list, boolean bl) {
        if (list == null) {
            list = new ArrayList<TypeDefinition>();
        }
        DynamicType.Builder.MethodDefinition.ExceptionDefinition<?> exceptionDefinition = bl ? builder.defineMethod(string, typeDefinition, Visibility.PUBLIC, Ownership.STATIC, MethodArguments.VARARGS).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class}) : builder.defineMethod(string, typeDefinition, Visibility.PUBLIC, Ownership.STATIC).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class});
        return exceptionDefinition.intercept(MethodCall.invoke(mFunctionCall).with(l).with(l2).with(l3).withArgumentArray().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC));
    }

    public static DynamicType.Builder<?> addStaticField(DynamicType.Builder<?> builder, String string, int n, TypeDescription typeDescription, long l, ArrayList<StaticEntry> arrayList) {
        builder = builder.defineField(string, (TypeDefinition)typeDescription, n |= 0x18);
        arrayList.add(new StaticEntry(string, n, typeDescription, l));
        return builder;
    }

    public static DynamicType.Builder<?> createStaticInitializer(DynamicType.Builder<?> builder, String string, long l, ArrayList<StaticEntry> arrayList) {
        Implementation.Composable composable = null;
        for (StaticEntry staticEntry : arrayList) {
            Implementation.Composable composable2 = MethodCall.invoke(mGetConstantValue).with(l).with(staticEntry.cPtr).setsField(ElementMatchers.is(new FieldDescription.Latent(InstrumentedType.Default.of(string, null, 1), new FieldDescription.Token(staticEntry.fieldName, staticEntry.modifiers, new TypeDescription.Generic.OfNonGenericType.Latent(staticEntry.fieldType, null))))).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
            if (composable == null) {
                composable = composable2;
                continue;
            }
            composable = composable.andThen(composable2);
        }
        if (composable == null) {
            return builder;
        }
        return builder.invokable(ElementMatchers.isTypeInitializer()).intercept(composable);
    }

    public static DynamicType.Builder<?> getClassBuilder(final String string, Class<?> clazz, ArrayList<Type> arrayList, boolean bl, long l) throws NoSuchMethodException {
        DynamicType.Builder<?> builder = new ByteBuddy().with(TypeValidation.DISABLED).with(new NamingStrategy.AbstractBase(){

            @Override
            public String name(TypeDescription typeDescription) {
                return string;
            }
        }).subclass(clazz, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS);
        if (arrayList != null) {
            for (Type arrayList22 : arrayList) {
                builder = builder.implement(arrayList22);
            }
        }
        int n = 1;
        if (bl) {
            n |= 0x400;
        }
        builder = builder.modifiers(n);
        builder = builder.defineField(CLASS_FIELD, Long.TYPE, 25).value(l);
        ArrayList<Class<QoreJavaObjectPtr>> arrayList2 = new ArrayList<Class<QoreJavaObjectPtr>>();
        arrayList2.add(QoreJavaObjectPtr.class);
        builder = builder.defineConstructor(Visibility.PUBLIC).withParameters((List<Type>)arrayList2).intercept(MethodCall.invoke(clazz.getConstructor(QoreJavaObjectPtr.class)).onSuper().withArgument(0));
        ArrayList<Class> arrayList3 = new ArrayList<Class>();
        arrayList3.add(Long.TYPE);
        arrayList3.add(Long.TYPE);
        arrayList3.add(Long.TYPE);
        arrayList3.add(objArray);
        return builder.defineConstructor(Visibility.PUBLIC).withParameters((List<Type>)arrayList3).throwing(new Type[]{Throwable.class}).intercept(MethodCall.invoke(clazz.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, objArray)).onSuper().withAllArguments());
    }

    public static DynamicType.Builder<?> addConstructor(DynamicType.Builder<?> builder, Class<?> clazz, long l, long l2, int n, List<TypeDefinition> list, boolean bl) {
        if (list == null) {
            list = new ArrayList<TypeDefinition>();
        }
        DynamicType.Builder.MethodDefinition.ExceptionDefinition<?> exceptionDefinition = bl ? builder.defineConstructor(JavaClassBuilder.getVisibility(n), MethodArguments.VARARGS).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class}) : builder.defineConstructor(JavaClassBuilder.getVisibility(n)).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class});
        try {
            if (list.size() == 0) {
                return exceptionDefinition.intercept(MethodCall.invoke(clazz.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, objArray)).onSuper().withField(CLASS_FIELD).with(l).with(l2).with(new Object[]{null}));
            }
            return exceptionDefinition.intercept(MethodCall.invoke(clazz.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, objArray)).onSuper().withField(CLASS_FIELD).with(l).with(l2).withArgumentArray());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public static DynamicType.Builder<?> addNormalMethod(DynamicType.Builder<?> builder, String string, long l, long l2, int n, TypeDefinition typeDefinition, List<TypeDefinition> list, boolean bl, boolean bl2) {
        DynamicType.Builder.MethodDefinition.ExceptionDefinition<?> exceptionDefinition;
        if (list == null) {
            list = new ArrayList<TypeDefinition>();
        }
        DynamicType.Builder.MethodDefinition.ExceptionDefinition<?> exceptionDefinition2 = exceptionDefinition = bl2 ? builder.defineMethod(string, typeDefinition, JavaClassBuilder.getVisibility(n), Ownership.MEMBER, MethodArguments.VARARGS).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class}) : builder.defineMethod(string, typeDefinition, JavaClassBuilder.getVisibility(n), Ownership.MEMBER).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class});
        if (bl) {
            builder = exceptionDefinition.withoutCode();
        } else {
            builder = list.size() == 0 ? exceptionDefinition.intercept(MethodCall.invoke(mNormalCall).with(string).withField("obj").with(l).with(l2).with(new Object[]{null}).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)) : exceptionDefinition.intercept(MethodCall.invoke(mNormalCall).with(string).withField("obj").with(l).with(l2).withArgumentArray().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC));
        }
        return builder;
    }

    public static DynamicType.Builder<?> addStaticMethod(DynamicType.Builder<?> builder, String string, long l, long l2, long l3, int n, TypeDefinition typeDefinition, List<TypeDefinition> list, boolean bl) {
        if (list == null) {
            list = new ArrayList<TypeDefinition>();
        }
        DynamicType.Builder.MethodDefinition.ExceptionDefinition<?> exceptionDefinition = bl ? builder.defineMethod(string, typeDefinition, JavaClassBuilder.getVisibility(n), Ownership.STATIC, MethodArguments.VARARGS).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class}) : builder.defineMethod(string, typeDefinition, JavaClassBuilder.getVisibility(n), Ownership.STATIC).withParameters((Collection<TypeDefinition>)list).throwing(new Type[]{Throwable.class});
        return exceptionDefinition.intercept(MethodCall.invoke(mStaticCall).with(string).withField(CLASS_FIELD).with(l).with(l2).with(l3).withArgumentArray().withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC));
    }

    public static byte[] getByteCodeFromBuilder(DynamicType.Builder<?> builder, QoreURLClassLoader qoreURLClassLoader) {
        return builder.make().getBytes();
    }

    @RuntimeType
    public static Object doStaticCall(String string, long l, long l2, long l3, long l4, Object ... objectArray) throws Throwable {
        return JavaClassBuilder.doStaticCall0(string, l, l2, l3, l4, objectArray);
    }

    @RuntimeType
    public static Object doNormalCall(String string, long l, long l2, long l3, Object ... objectArray) throws Throwable {
        return JavaClassBuilder.doNormalCall0(string, l, l2, l3, objectArray);
    }

    @RuntimeType
    public static Object doFunctionCall(long l, long l2, long l3, Object ... objectArray) throws Throwable {
        return JavaClassBuilder.doFunctionCall0(l, l2, l3, objectArray);
    }

    @RuntimeType
    public static Object getConstantValue(long l, long l2) throws Throwable {
        return JavaClassBuilder.getConstantValue0(l, l2);
    }

    public static TypeDescription getTypeDescription(Class<?> clazz) {
        return new TypeDescription.ForLoadedType(clazz);
    }

    public static TypeDescription getTypeDescription(String string) {
        return InstrumentedType.Default.of(string, null, 1);
    }

    public static boolean findBaseClassMethodConflict(Class<?> clazz, String string, List<TypeDescription> list, boolean bl) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string) || Modifier.isStatic(method.getModifiers()) != bl) continue;
            Type[] typeArray = method.getGenericParameterTypes();
            if (typeArray == null || typeArray.length == 0) {
                if (list != null && list.size() != 0) continue;
                return true;
            }
            if (typeArray.length != list.size()) continue;
            boolean bl2 = true;
            for (int i = 0; i < typeArray.length; ++i) {
                Type type = typeArray[i];
                TypeDescription typeDescription = list.get(i);
                if (type instanceof Class) {
                    Class clazz2 = (Class)type;
                    if (typeDescription.getCanonicalName().equals(clazz2.getCanonicalName())) continue;
                    bl2 = false;
                    break;
                }
                if (typeDescription.getCanonicalName().equals(type.getTypeName())) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private static Visibility getVisibility(int n) {
        switch (n) {
            case 1: {
                return Visibility.PUBLIC;
            }
            case 4: {
                return Visibility.PROTECTED;
            }
        }
        return Visibility.PRIVATE;
    }

    private static native Object doStaticCall0(String var0, long var1, long var3, long var5, long var7, Object ... var9) throws Throwable;

    private static native Object doNormalCall0(String var0, long var1, long var3, long var5, Object ... var7) throws Throwable;

    private static native Object doFunctionCall0(long var0, long var2, long var4, Object ... var6) throws Throwable;

    private static native Object getConstantValue0(long var0, long var2) throws Throwable;

    static {
        try {
            objArray = Class.forName("[L" + Object.class.getCanonicalName() + ";");
            Class[] classArray = new Class[]{String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, objArray};
            mStaticCall = JavaClassBuilder.class.getDeclaredMethod("doStaticCall", classArray);
            classArray = new Class[]{String.class, Long.TYPE, Long.TYPE, Long.TYPE, objArray};
            mNormalCall = JavaClassBuilder.class.getDeclaredMethod("doNormalCall", classArray);
            classArray = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, objArray};
            mFunctionCall = JavaClassBuilder.class.getDeclaredMethod("doFunctionCall", classArray);
            classArray = new Class[]{Long.TYPE, Long.TYPE};
            mGetConstantValue = JavaClassBuilder.class.getDeclaredMethod("getConstantValue", classArray);
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }
}

