/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.qore.jni.BooleanWrapper;
import org.qore.jni.ClassModInfo;
import org.qore.jni.QoreJavaApi;
import org.qore.jni.QoreJavaFileObject;

public class QoreURLClassLoader
extends URLClassLoader {
    public static String INIT_PROP_NAME = "qore.QoreURLClassLoader.init";
    private static InheritableThreadLocal<QoreURLClassLoader> current = new InheritableThreadLocal();
    private HashSet<String> classPathElements = new HashSet();
    private String classPath = new String();
    private long pgm_ptr = 0L;
    private boolean enable_cache = false;
    private boolean startup = false;
    private final HashMap<String, QoreJavaFileObject> classes = new HashMap();
    private HashSet<String> classInProgress = new HashSet();
    private HashMap<String, byte[]> pendingClasses = new HashMap();
    private HashMap<String, Class<?>> classCache = new HashMap();
    private static boolean static_bootstrap = false;

    public QoreURLClassLoader(ClassLoader classLoader) {
        super("QoreURLClassLoader", new URL[0], classLoader);
        this.enable_cache = true;
        this.setContextProgram(this);
        this.startup = true;
        String string = System.getProperty("java.class.path");
        if (string != null && !string.isEmpty()) {
            this.addPath(string);
        }
    }

    public QoreURLClassLoader() {
        super("QoreURLClassLoader", new URL[0], ClassLoader.getSystemClassLoader());
        this.setContext();
        this.enable_cache = true;
        this.setContextProgram(this);
    }

    public QoreURLClassLoader(long l) {
        super("QoreURLClassLoader", new URL[0], ClassLoader.getPlatformClassLoader());
        this.setContext();
        this.pgm_ptr = l;
    }

    public QoreURLClassLoader(long l, ClassLoader classLoader) {
        super("QoreURLClassLoader", new URL[0], classLoader);
        this.pgm_ptr = l;
        this.setContext();
    }

    public QoreURLClassLoader(String string, ClassLoader classLoader) {
        super(string, new URL[0], classLoader);
        this.setContext();
        this.enable_cache = true;
        this.setContextProgram(this);
    }

    public void add(String string, QoreJavaFileObject qoreJavaFileObject) {
        this.classes.put(string, qoreJavaFileObject);
    }

    public Collection<QoreJavaFileObject> files() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        String string2;
        QoreJavaFileObject qoreJavaFileObject;
        if (string.endsWith(".class") && (qoreJavaFileObject = this.classes.get(string2 = string.substring(0, string.length() - ".class".length()).replace('/', '.'))) != null) {
            return new ByteArrayInputStream(qoreJavaFileObject.getByteCode());
        }
        return super.getResourceAsStream(string);
    }

    public void addPathOrig(String string) throws Exception {
        super.addURL(new URL("file", null, 0, string));
    }

    public void addPendingClass(String string, byte[] byArray) {
        if (byArray == null) {
            throw new RuntimeException("QoreURLClassLoader.addPendingClass() called with null byte_code");
        }
        this.pendingClasses.put(string, byArray);
    }

    public Class<?> getResolveClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.tryGetPendingClass(string);
        if (clazz == null) {
            clazz = super.findClass(string);
        }
        this.resolveClass(clazz);
        return clazz;
    }

    public void clearCache() {
        this.pendingClasses.clear();
    }

    public byte[] removePendingByteCode(String string) {
        byte[] byArray = this.pendingClasses.get(string);
        return byArray;
    }

    public ArrayList<String> getPendingClassesForPackage(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.pendingClasses.forEach((string2, byArray) -> {
            int n = string2.indexOf(".");
            if (n == -1 && string.isEmpty() || n > 0 && string2.startsWith(string + ".") && string2.indexOf(".", string.length() + 1) == -1) {
                arrayList.add((String)string2);
            }
        });
        return arrayList;
    }

    private Class<?> tryGetPendingClass(String string) {
        byte[] byArray = this.pendingClasses.remove(string);
        if (byArray == null) {
            if (this.enable_cache) {
                ClassLoader classLoader;
                Class<?> clazz = this.classCache.remove(string);
                if (clazz == null && (classLoader = this.getParent()) != null && classLoader instanceof QoreURLClassLoader) {
                    clazz = ((QoreURLClassLoader)classLoader).tryGetPendingClass(string);
                }
                return clazz;
            }
            return null;
        }
        return this.defineClassIntern(string, byArray, 0, byArray.length);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        byte[] byArray;
        if (string.startsWith("net.bytebuddy.")) {
            byte[] byArray2 = QoreURLClassLoader.getCachedClass0(string);
            if (byArray2 != null) {
                return this.defineClassIntern(string, byArray2, 0, byArray2.length);
            }
        } else if (string.startsWith("org.qore.") && (byArray = QoreURLClassLoader.getInternalClass0(string)) != null) {
            return this.defineClassIntern(string, byArray, 0, byArray.length);
        }
        Class<?> clazz = super.findClass(string);
        return clazz;
    }

    public byte[] getInternalClass(String string) throws ClassNotFoundException {
        byte[] byArray = QoreURLClassLoader.getInternalClass0(string);
        if (byArray != null) {
            return byArray;
        }
        throw new ClassNotFoundException(String.format("unknown internal class '%s'", string));
    }

    public ArrayList<String> getInternalClassesForPackage(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        QoreURLClassLoader.getInternalClassesForPackage0(this.pgm_ptr, string, arrayList);
        return arrayList;
    }

    public synchronized boolean checkInProgress(String string) {
        return this.classInProgress.contains(string);
    }

    private synchronized boolean markInProgress(String string) {
        if (this.classInProgress.contains(string)) {
            return true;
        }
        this.classInProgress.add(string);
        return false;
    }

    private synchronized void removeInProgress(String string) {
        this.classInProgress.remove(string);
    }

    public Class<?> loadResolveClass(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    public Class<?> checkLoadedClass(String string) {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = this.getParent();
        if (classLoader instanceof QoreURLClassLoader) {
            return ((QoreURLClassLoader)classLoader).checkLoadedClass(string);
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.checkLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.tryGetPendingClass(string);
        if (clazz != null) {
            return clazz;
        }
        QoreJavaFileObject qoreJavaFileObject = this.classes.get(string);
        if (qoreJavaFileObject != null) {
            byte[] byArray = qoreJavaFileObject.getByteCode();
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        if (string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.") || string.startsWith("jdk.") || string.startsWith("org.qore.jni.") || string.startsWith("org.qore.lang.")) {
            clazz = super.loadClass(string);
            return clazz;
        }
        if (QoreURLClassLoader.isDynamic(string)) {
            try {
                byte[] byArray = this.generateByteCode(string);
                clazz = this.checkLoadedClass(string);
                if (clazz != null) {
                    return clazz;
                }
                clazz = this.defineClassIntern(string, byArray, 0, byArray.length);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (!this.startup) {
            ClassLoader classLoader = this.getParent();
            if (classLoader == null) {
                classLoader = QoreURLClassLoader.getSystemClassLoader();
            }
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            try {
                clazz = super.findClass(string);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.loadClass(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassWithPtr(String string, long l) throws ClassNotFoundException {
        Class<?> clazz;
        Object object = this.getClassLoadingLock(string);
        synchronized (object) {
            clazz = this.checkLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.tryGetPendingClass(string);
            if (clazz != null) {
                return clazz;
            }
            QoreJavaFileObject qoreJavaFileObject = this.classes.get(string);
            if (qoreJavaFileObject != null) {
                byte[] byArray = qoreJavaFileObject.getByteCode();
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            try {
                byte[] byArray = this.generateByteCode(string, l);
                clazz = this.checkLoadedClass(string);
                if (clazz != null) {
                    return clazz;
                }
                clazz = this.defineClassIntern(string, byArray, 0, byArray.length);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return clazz;
    }

    public static boolean isDynamic(String string) {
        return string.equals("qore") || string.equals("python") || string.startsWith("qore.") && string.length() > 5 || string.startsWith("qoremod.") && string.length() > 8 || string.startsWith("python.") && string.length() > 7 || string.startsWith("pythonmod.") && string.length() > 10;
    }

    protected Class<?> defineClassIntern(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        Class<?> clazz = this.defineClass(string, byArray, n, n2);
        if (this.enable_cache) {
            this.classCache.put(string, clazz);
        }
        return clazz;
    }

    public Class<?> defineClassUnconditional(String string, byte[] byArray) throws ClassFormatError {
        return this.defineClassIntern(string, byArray, 0, byArray.length);
    }

    public Class<?> defineResolveClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        Class<?> clazz = this.defineClassIntern(string, byArray, n, n2);
        this.resolveClass(clazz);
        return clazz;
    }

    public long getPtr() {
        return this.pgm_ptr;
    }

    public void clearProgramPtr() {
        this.pgm_ptr = 0L;
    }

    public static long getProgramPtr() {
        return ((QoreURLClassLoader)QoreURLClassLoader.current.get()).pgm_ptr;
    }

    public static void setProgramPtr(long l) {
        ((QoreURLClassLoader)QoreURLClassLoader.current.get()).pgm_ptr = l;
    }

    public static QoreURLClassLoader getCurrent() {
        return (QoreURLClassLoader)current.get();
    }

    public void setContext() {
        Thread.currentThread().setContextClassLoader(this);
        current.set(this);
    }

    public void addPath(String string) {
        Object object = File.pathSeparator;
        if (!File.pathSeparator.equals(";")) {
            object = (String)object + ";";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, (String)object, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.length() == 0) continue;
            File file = new File(string2);
            if (file.getName().indexOf(42) != -1) {
                string3 = file.getName();
                if ((file = file.getParentFile()).getName().indexOf(42) != -1) {
                    QoreURLClassLoader.errorLog("Ignoring wildcard in classpath directory element '" + string2 + "'");
                    continue;
                }
            }
            if (!file.isAbsolute() && string2.charAt(0) != '/' && string2.charAt(0) != '\\') {
                file = new File(file.getPath());
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                QoreURLClassLoader.errorLog("Ignoring non-existent classpath element '" + String.valueOf(file) + "' (" + String.valueOf(iOException) + ").");
                continue;
            }
            if (string3 != null && !string3.isEmpty()) {
                file = new File(file, string3);
            }
            if (this.classPathElements.contains(file.getPath())) continue;
            this.classPathElements.add(file.getPath());
            if (string3 != null && !string3.isEmpty()) {
                this.addWildcard(file.getParentFile(), string3);
                continue;
            }
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this.addURL(this.createUrl(file));
                continue;
            }
            if (QoreURLClassLoader.isLoadable(file.getName())) {
                this.addURL(this.createUrl(file));
                continue;
            }
            QoreURLClassLoader.errorLog("ClassPath element '" + String.valueOf(file) + "' is not an existing directory and is not a file ending with '.zip' or '.jar'");
        }
    }

    public ArrayList<String> getClassesInNamespace(String string) {
        ClassLoader classLoader;
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassModInfo classModInfo = new ClassModInfo(string, true);
        QoreURLClassLoader.getClassesInNamespace0(this.pgm_ptr, classModInfo.cls, classModInfo.mod, classModInfo.python, arrayList);
        if (arrayList.size() == 0 && (classLoader = this.getParent()) instanceof QoreURLClassLoader) {
            return ((QoreURLClassLoader)classLoader).getClassesInNamespace(string);
        }
        return arrayList;
    }

    public static ArrayList<File> splitClassPath(String string) {
        Object object = File.pathSeparator;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!File.pathSeparator.equals(";")) {
            object = (String)object + ";";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, (String)object, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.length() == 0) continue;
            File file = new File(string2);
            if (file.getName().indexOf(42) != -1) {
                string3 = file.getName();
                if ((file = file.getParentFile()).getName().indexOf(42) != -1) {
                    QoreURLClassLoader.errorLog("Ignoring wildcard in classpath directory element '" + string2 + "'");
                    continue;
                }
            }
            if (!file.isAbsolute() && string2.charAt(0) != '/' && string2.charAt(0) != '\\') {
                file = new File(file.getPath());
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                QoreURLClassLoader.errorLog("Ignoring non-existent classpath element '" + String.valueOf(file) + "' (" + String.valueOf(iOException) + ").");
                continue;
            }
            if (string3 != null && !string3.isEmpty()) {
                file = new File(file, string3);
            }
            arrayList.add(file);
        }
        return arrayList;
    }

    static boolean isLoadable(String string) {
        return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
    }

    private static void infoLog(String string) {
        System.out.println("QoreURLClassLoader INFO: " + string);
    }

    private static void debugLog(String string) {
        System.out.println("QoreURLClassLoader DEBUG: " + string);
    }

    private static void errorLog(String string) {
        System.out.println("QoreURLClassLoader ERROR: " + string);
    }

    public void addWildcard(File file, String string) {
        if (!file.exists()) {
            QoreURLClassLoader.errorLog("Cannot find directory for classpath element '" + String.valueOf(file) + File.separator + string + "'");
            return;
        }
        if (!file.canRead()) {
            QoreURLClassLoader.errorLog("Cannot read directory for classpath element '" + String.valueOf(file) + File.separator + string + "'");
            return;
        }
        final String string2 = string.replace(new StringBuffer("*"), new StringBuffer(".*"));
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.matches("^" + string2 + "$");
            }
        });
        if (fileArray == null) {
            QoreURLClassLoader.errorLog("Error accessing directory for classpath element '" + String.valueOf(file) + File.separator + string + "'");
            return;
        }
        if (fileArray.length == 0) {
            QoreURLClassLoader.debugLog("no matching files for classpath element '" + String.valueOf(file) + File.separator + string + "'");
            return;
        }
        for (File file2 : fileArray) {
            if (!QoreURLClassLoader.isLoadable(file2.getName())) continue;
            this.addURL(this.createUrl(file2));
        }
    }

    public void clearCompilationCache() {
        this.classCache.clear();
        QoreURLClassLoader.clearCompilationCache0(this.pgm_ptr);
    }

    public synchronized byte[] generateByteCode(String string) throws ClassNotFoundException {
        return this.generateByteCode(string, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] generateByteCode(String string, long l) throws ClassNotFoundException {
        byte[] byArray = this.pendingClasses.get(string);
        if (byArray == null) {
            if (this.markInProgress(string)) {
                throw new ClassNotFoundException(String.format("%s is already being created", string));
            }
            try {
                byArray = this.generateByteCodeIntern(string, l);
            }
            finally {
                this.removeInProgress(string);
            }
        }
        return byArray;
    }

    private byte[] generateByteCodeIntern(String string, long l) throws ClassNotFoundException {
        ClassModInfo classModInfo = new ClassModInfo(string);
        if (classModInfo.cls == null) {
            throw new ClassNotFoundException(String.format("invalid dynamic import path '%s'", string));
        }
        byte[] byArray = null;
        if (this.pgm_ptr != 0L) {
            try {
                byArray = this.generateByteCode0(this.pgm_ptr, classModInfo.cls, string, classModInfo.mod, classModInfo.python, l);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (byArray == null) {
            throw new ClassNotFoundException(String.format("could not find a Qore source class matching '%s' to create Java class '%s'", classModInfo.cls, string));
        }
        this.pendingClasses.put(string, byArray);
        return byArray;
    }

    private URL createUrl(File file) {
        try {
            URL uRL = file.toURI().toURL();
            String string = uRL.getPath();
            if (uRL.getPath().endsWith(".jar")) {
                uRL = new URL("jar:file:" + string + "!/");
            }
            if (this.classPath.length() > 0) {
                this.classPath = this.classPath + File.pathSeparator;
            }
            this.classPath = this.classPath + file.getPath();
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            QoreURLClassLoader.errorLog("classpath element '" + String.valueOf(file) + "' could not be used to create a valid file system URL (" + String.valueOf(malformedURLException) + ")");
            return null;
        }
    }

    private void setContextProgram(QoreURLClassLoader qoreURLClassLoader) {
        BooleanWrapper booleanWrapper = new BooleanWrapper();
        this.pgm_ptr = QoreURLClassLoader.getContextProgram0(this, booleanWrapper, static_bootstrap);
        if (booleanWrapper.val) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    QoreURLClassLoader.shutdownContext0();
                }
            });
        }
    }

    private static native void finalizeModuleInit0();

    private static native byte[] getCachedClass0(String var0);

    private static native byte[] getInternalClass0(String var0);

    private native byte[] generateByteCode0(long var1, String var3, String var4, String var5, boolean var6, long var7) throws Throwable;

    private static native void getClassesInNamespace0(long var0, String var2, String var3, boolean var4, ArrayList<String> var5);

    private static native void getInternalClassesForPackage0(long var0, String var2, ArrayList<String> var3);

    private static native long getContextProgram0(QoreURLClassLoader var0, BooleanWrapper var1, boolean var2);

    private static native void shutdownContext0();

    private static native void clearCompilationCache0(long var0);

    private static native void dummy0();

    private static native void debug0(long var0);

    static {
        if ("org.qore.jni.QoreURLClassLoader".equals(System.getProperty("java.system.class.loader"))) {
            static_bootstrap = true;
        }
        System.setProperty(INIT_PROP_NAME, "true");
        try {
            QoreURLClassLoader.dummy0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                if (static_bootstrap) {
                    QoreJavaApi.initQoreBootstrap();
                } else {
                    QoreJavaApi.initQore();
                }
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                throw exceptionInInitializerError;
            }
            catch (Throwable throwable) {
                throw new ExceptionInInitializerError(throwable);
            }
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        finally {
            System.clearProperty(INIT_PROP_NAME);
        }
    }
}

