/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.qore.jni.QoreURLClassLoader;
import org.qore.jni.compiler.CustomJavaFileObject;
import org.qore.jni.compiler.PackageInternalsFinder;
import org.qore.jni.compiler.QoreJavaClassObject;

public class QoreJavaFileManager
implements JavaFileManager {
    private final QoreURLClassLoader classLoader;
    private final StandardJavaFileManager standardFileManager;
    private final PackageInternalsFinder finder;

    public QoreJavaFileManager(QoreURLClassLoader qoreURLClassLoader, StandardJavaFileManager standardJavaFileManager) {
        this.classLoader = qoreURLClassLoader;
        this.standardFileManager = standardJavaFileManager;
        this.finder = new PackageInternalsFinder(qoreURLClassLoader);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof QoreJavaClassObject) {
            return ((QoreJavaClassObject)javaFileObject).binaryName();
        }
        if (javaFileObject instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)javaFileObject).binaryName();
        }
        return this.standardFileManager.inferBinaryName(location, javaFileObject);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return this.standardFileManager.isSameFile(fileObject, fileObject2);
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return this.standardFileManager.handleOption(string, iterator);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH || location.getName().startsWith("SYSTEM_MODULES");
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        return this.standardFileManager.getLocationForModule(location, string);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
        return this.standardFileManager.getLocationForModule(location, javaFileObject);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.standardFileManager.listLocationsForModules(location);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.standardFileManager.inferModuleName(location);
    }

    public void setLocation(StandardLocation standardLocation, List<? extends File> list) throws IOException {
        this.standardFileManager.setLocation(standardLocation, list);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        return this.standardFileManager.getJavaFileForInput(location, string, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        return this.standardFileManager.getJavaFileForOutput(location, string, kind, fileObject);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        return this.standardFileManager.getFileForInput(location, string, string2);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        return this.standardFileManager.getFileForOutput(location, string, string2, fileObject);
    }

    @Override
    public void flush() throws IOException {
        this.standardFileManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.standardFileManager.close();
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        boolean bl2 = location.getName().startsWith("SYSTEM_MODULES");
        if (bl2 || location == StandardLocation.PLATFORM_CLASS_PATH || !set.contains((Object)JavaFileObject.Kind.CLASS)) {
            return this.standardFileManager.list(location, string, set, bl);
        }
        if (location == StandardLocation.CLASS_PATH && set.contains((Object)JavaFileObject.Kind.CLASS)) {
            List<JavaFileObject> list = this.finder.find(string);
            this.standardFileManager.list(location, string, set, bl).forEach(javaFileObject -> list.add((JavaFileObject)javaFileObject));
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public int isSupportedOption(String string) {
        return this.standardFileManager.isSupportedOption(string);
    }
}

