/*
 * Decompiled with CFR 0.152.
 */
package org.qore.jni;

import java.util.Arrays;
import org.qore.jni.QoreObject;
import org.qore.jni.QoreURLClassLoader;

public class QoreJavaApi {
    public static void initQore() throws Throwable {
        try {
            QoreURLClassLoader.getProgramPtr();
        }
        catch (NullPointerException nullPointerException) {
            long l;
            try {
                l = QoreJavaApi.initQore0();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String string = System.getenv("QORE_LIBRARY");
                if (string != null) {
                    System.load(string);
                } else {
                    System.loadLibrary("qore");
                }
                l = QoreJavaApi.initQore0();
            }
            QoreURLClassLoader.setProgramPtr(l);
        }
    }

    public static void initQoreBootstrap() throws Throwable {
        try {
            QoreURLClassLoader.getProgramPtr();
        }
        catch (NullPointerException nullPointerException) {
            try {
                QoreJavaApi.initQoreBootstrap0();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String string = System.getenv("QORE_LIBRARY");
                if (string != null) {
                    System.load(string);
                } else {
                    System.loadLibrary("qore");
                }
                QoreJavaApi.initQoreBootstrap0();
            }
        }
    }

    public static Object callFunction(String string, Object ... objectArray) throws Throwable {
        QoreURLClassLoader qoreURLClassLoader = QoreURLClassLoader.getCurrent();
        return QoreJavaApi.callFunction0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static Object callFunctionArgs(String string, Object[] objectArray) throws Throwable {
        QoreURLClassLoader qoreURLClassLoader = QoreURLClassLoader.getCurrent();
        return QoreJavaApi.callFunction0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static Object callFunctionSave(String string, Object ... objectArray) throws Throwable {
        return QoreJavaApi.callFunctionSave0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static Object callFunctionSaveArgs(String string, Object[] objectArray) throws Throwable {
        return QoreJavaApi.callFunctionSave0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static Object callStaticMethod(String string, String string2, Object ... objectArray) throws Throwable {
        return QoreJavaApi.callStaticMethod0(QoreURLClassLoader.getProgramPtr(), string, string2, objectArray);
    }

    public static Object callStaticMethodArgs(String string, String string2, Object[] objectArray) throws Throwable {
        return QoreJavaApi.callStaticMethod0(QoreURLClassLoader.getProgramPtr(), string, string2, objectArray);
    }

    public static Object callStaticMethodSave(String string, String string2, Object ... objectArray) throws Throwable {
        return QoreJavaApi.callStaticMethodSave0(QoreURLClassLoader.getProgramPtr(), string, string2, objectArray);
    }

    public static Object callStaticMethodSaveArgs(String string, String string2, Object[] objectArray) throws Throwable {
        return QoreJavaApi.callStaticMethodSave0(QoreURLClassLoader.getProgramPtr(), string, string2, objectArray);
    }

    public static QoreObject newObjectSave(String string, Object ... objectArray) throws Throwable {
        return QoreJavaApi.newObjectSave0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static QoreObject newObjectSaveArgs(String string, Object[] objectArray) throws Throwable {
        return QoreJavaApi.newObjectSave0(QoreURLClassLoader.getProgramPtr(), string, objectArray);
    }

    public static boolean registerJavaThread() {
        return QoreJavaApi.registerJavaThread0();
    }

    public static void deregisterJavaThread() {
        QoreJavaApi.deregisterJavaThread0();
    }

    public static StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        return stackTraceElementArray.length > 0 ? Arrays.copyOfRange(stackTraceElementArray, 1, stackTraceElementArray.length) : null;
    }

    private static native long initQore0() throws Throwable;

    private static native void initQoreBootstrap0() throws Throwable;

    private static native Object callFunction0(long var0, String var2, Object ... var3) throws Throwable;

    private static native Object callFunctionSave0(long var0, String var2, Object ... var3) throws Throwable;

    private static native Object callStaticMethod0(long var0, String var2, String var3, Object ... var4) throws Throwable;

    private static native Object callStaticMethodSave0(long var0, String var2, String var3, Object ... var4) throws Throwable;

    private static native QoreObject newObjectSave0(long var0, String var2, Object ... var3) throws Throwable;

    private static native boolean registerJavaThread0();

    private static native void deregisterJavaThread0();
}

