
if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qt 5 requires at least CMake version 2.8.3")
endif()

get_filename_component(_qt53DExtras_install_prefix "/opt/local/libexec/qt5/lib/cmake/Qt53DExtras/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt53DExtras_VERSION instead.
set(Qt53DExtras_VERSION_STRING 5.7.1)

set(Qt53DExtras_LIBRARIES Qt5::3DExtras)

macro(_qt5_3DExtras_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::3DExtras\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()

macro(_populate_3DExtras_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5::3DExtras APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt53DExtras_install_prefix}/lib/${LIB_LOCATION}")
    _qt5_3DExtras_check_file_exists(${imported_location})
    set_target_properties(Qt5::3DExtras PROPERTIES
        "INTERFACE_LINK_LIBRARIES" "${_Qt53DExtras_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        # For backward compatibility with CMake < 2.8.12
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt53DExtras_LIB_DEPENDENCIES}"
    )

endmacro()

if (NOT TARGET Qt5::3DExtras)

    set(_Qt53DExtras_OWN_INCLUDE_DIRS
      "${_qt53DExtras_install_prefix}/lib/Qt3DExtras.framework"
      "${_qt53DExtras_install_prefix}/lib/Qt3DExtras.framework/Headers"
    )
    set(Qt53DExtras_PRIVATE_INCLUDE_DIRS
        "${_qt53DExtras_install_prefix}/lib/Qt3DExtras.framework/Versions/5/Headers/5.7.1/"
        "${_qt53DExtras_install_prefix}/lib/Qt3DExtras.framework/Versions/5/Headers/5.7.1/Qt3DExtras"
    )

    foreach(_dir ${_Qt53DExtras_OWN_INCLUDE_DIRS})
        _qt5_3DExtras_check_file_exists(${_dir})
    endforeach()


    set(Qt53DExtras_INCLUDE_DIRS ${_Qt53DExtras_OWN_INCLUDE_DIRS})

    set(Qt53DExtras_DEFINITIONS -DQT_3DEXTRAS_LIB)
    set(Qt53DExtras_COMPILE_DEFINITIONS QT_3DEXTRAS_LIB)
    set(_Qt53DExtras_MODULE_DEPENDENCIES "3DRender;3DInput;3DLogic;3DCore;Gui;Core")


    set(_Qt53DExtras_FIND_DEPENDENCIES_REQUIRED)
    if (Qt53DExtras_FIND_REQUIRED)
        set(_Qt53DExtras_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt53DExtras_FIND_DEPENDENCIES_QUIET)
    if (Qt53DExtras_FIND_QUIETLY)
        set(_Qt53DExtras_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt53DExtras_FIND_VERSION_EXACT)
    if (Qt53DExtras_FIND_VERSION_EXACT)
        set(_Qt53DExtras_FIND_VERSION_EXACT EXACT)
    endif()

    set(Qt53DExtras_EXECUTABLE_COMPILE_FLAGS "")

    foreach(_module_dep ${_Qt53DExtras_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                5.7.1 ${_Qt53DExtras_FIND_VERSION_EXACT}
                ${_Qt53DExtras_DEPENDENCIES_FIND_QUIET}
                ${_Qt53DExtras_FIND_DEPENDENCIES_REQUIRED}
                PATHS "/opt/local/libexec/qt5/lib/cmake/Qt53DExtras/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt53DExtras_FOUND False)
            return()
        endif()

        list(APPEND Qt53DExtras_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt53DExtras_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt53DExtras_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt53DExtras_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt53DExtras_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt53DExtras_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt53DExtras_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt53DExtras_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt53DExtras_COMPILE_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt53DExtras_EXECUTABLE_COMPILE_FLAGS)

    set(_Qt53DExtras_LIB_DEPENDENCIES "Qt5::3DRender;Qt5::3DInput;Qt5::3DLogic;Qt5::3DCore;Qt5::Gui;Qt5::Core")


    add_library(Qt5::3DExtras SHARED IMPORTED)
    set_property(TARGET Qt5::3DExtras PROPERTY FRAMEWORK 1)

    set_property(TARGET Qt5::3DExtras PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt53DExtras_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::3DExtras PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_3DEXTRAS_LIB)

    _populate_3DExtras_target_properties(RELEASE "Qt3DExtras.framework/Qt3DExtras" "" )




    file(GLOB pluginTargets "/opt/local/libexec/qt5/lib/cmake/Qt53DExtras/Qt53DExtras_*Plugin.cmake")

    macro(_populate_3DExtras_plugin_properties Plugin Configuration PLUGIN_LOCATION)
        set_property(TARGET Qt5::${Plugin} APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

        set(imported_location "${_qt53DExtras_install_prefix}/plugins/${PLUGIN_LOCATION}")
        _qt5_3DExtras_check_file_exists(${imported_location})
        set_target_properties(Qt5::${Plugin} PROPERTIES
            "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        )
    endmacro()

    if (pluginTargets)
        foreach(pluginTarget ${pluginTargets})
            include(${pluginTarget})
        endforeach()
    endif()




_qt5_3DExtras_check_file_exists("/opt/local/libexec/qt5/lib/cmake/Qt53DExtras/Qt53DExtrasConfigVersion.cmake")

endif()
