/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.ArrayList;
import slothLib.linearAlgebra.featureVector.Cluster;
import slothLib.linearAlgebra.featureVector.ClusteringDistanceType;
import slothLib.linearAlgebra.featureVector.ClusteringResult;
import slothLib.linearAlgebra.featureVector.IDendrogramNode;
import slothLib.linearAlgebra.featureVector.IVector;

public class HierarchicalClusteringResult<T> {
    private IDendrogramNode<T>[] nodes;
    private IVector<T>[] vectors;
    private ClusteringDistanceType dType;
    private double ds;
    private int itemCount;

    public HierarchicalClusteringResult(IDendrogramNode<T>[] nodes, IVector<T>[] vectors, ClusteringDistanceType dType) {
        this.nodes = nodes;
        this.vectors = vectors;
        this.itemCount = vectors.length;
        this.dType = dType;
        this.ds = 1.0;
        if (dType == ClusteringDistanceType.Similarity) {
            this.ds = -1.0;
        }
    }

    public IDendrogramNode<T>[] dendrogramNodes() {
        return this.nodes;
    }

    public ClusteringResult<T> getClusteringResult(int thresholdClusterCount, double thresholdDistanceOrSimilarity) {
        double thresholdDs = thresholdDistanceOrSimilarity * this.ds;
        int[] clusterID = new int[this.itemCount];
        IVector[] centroidVectors = (IVector[])new Object[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            clusterID[i] = i;
            centroidVectors[i] = this.vectors[i];
            ++i;
        }
        int numCluster = this.itemCount;
        IDendrogramNode<T>[] iDendrogramNodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDendrogramNode<T> node = iDendrogramNodeArray[n2];
            if (numCluster <= thresholdClusterCount || node.distance() > thresholdDs) break;
            int i2 = node.itemID2();
            while (i2 < this.itemCount) {
                if (clusterID[i2] == node.itemID2()) {
                    clusterID[i2] = node.itemID1();
                    centroidVectors[i2] = node.centroidVector();
                }
                ++i2;
            }
            --numCluster;
            ++n2;
        }
        ArrayList clusterList = new ArrayList();
        int curLoc = 0;
        int i3 = 0;
        while (i3 < this.itemCount) {
            if (clusterID[i3] == i3) {
                ArrayList<IVector<T>> members = new ArrayList<IVector<T>>();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                members.add(this.vectors[i3]);
                indices.add(i3);
                int j = i3 + 1;
                while (j < this.itemCount) {
                    if (clusterID[j] == i3) {
                        members.add(this.vectors[j]);
                        indices.add(j);
                    }
                    ++j;
                }
                int[] indicesArray = new int[indices.size()];
                int l_i = 0;
                while (l_i < indices.size()) {
                    indicesArray[l_i] = (Integer)indices.get(l_i);
                    ++l_i;
                }
                clusterList.add(new Cluster((IVector[])members.toArray(), indicesArray, centroidVectors[i3]));
                ++curLoc;
            }
            ++i3;
        }
        return new ClusteringResult((Cluster[])clusterList.toArray());
    }

    public ClusteringResult<T> GetClusteringResult(int thresholdClusterCount) {
        return this.getClusteringResult(thresholdClusterCount, Double.MAX_VALUE * this.ds);
    }

    public ClusteringResult<T> GetClusteringResult(double thresholdDistanceOrSimilarity) {
        return this.getClusteringResult(1, thresholdDistanceOrSimilarity);
    }
}

