/*
 * Decompiled with CFR 0.152.
 */
package slothLib.linearAlgebra.featureVector;

import java.util.Collection;
import slothLib.linearAlgebra.featureVector.BasicVector;
import slothLib.linearAlgebra.featureVector.IVector;

public class MultiplyVector<T>
extends BasicVector<T> {
    public MultiplyVector(Collection<IVector<T>> vectors) {
        this(1.0, vectors);
    }

    public MultiplyVector(IVector<T> ... vectors) {
        this(1.0, vectors);
    }

    public MultiplyVector(double multiplyValue, Collection<IVector<T>> vectors) {
        if (vectors.size() == 0) {
            return;
        }
        this.initialize(multiplyValue, vectors.iterator().next());
        for (IVector<T> vector : vectors) {
            this.calculate(vector);
        }
    }

    public MultiplyVector(double multiplyValue, IVector<T> ... vectors) {
        if (vectors.length == 0) {
            return;
        }
        this.initialize(multiplyValue, vectors[0]);
        IVector<T>[] iVectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            IVector<T> vector = iVectorArray[n2];
            this.calculate(vector);
            ++n2;
        }
    }

    private void initialize(double multiplyValue, IVector<T> vector) {
        for (T key : vector.keys()) {
            this.set(key, multiplyValue);
        }
    }

    private void calculate(IVector<T> vector) {
        for (Object key : this.keys()) {
            this.set(key, this.get(key) * vector.get(key));
        }
    }
}

