cmake_minimum_required(VERSION 3.17 FATAL_ERROR)

get_filename_component(STRUMPACK_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
list(INSERT CMAKE_MODULE_PATH 0 ${STRUMPACK_CMAKE_DIR})
list(APPEND CMAKE_PREFIX_PATH "/opt/local/share/cmake/Modules;/opt/local")

include(CMakeFindDependencyMacro)

enable_language(C)
enable_language(CXX)

if(OFF) # STRUMPACK_USE_CUDA
  enable_language(CUDA)
  find_dependency(CUDAToolkit)
endif()

if(ON) # STRUMPACK_USE_OPENMP
  find_dependency(OpenMP)
endif()

if(OFF) # STRUMPACK_USE_MPI
  enable_language(Fortran)
  find_dependency(MPI)

  # find_dependency(SCALAPACK)
endif()

# don't really need to find these because they have no targets
# find_dependency(BLAS)
# find_dependency(LAPACK)

set(metis_PREFIX /opt/local)
set(metis_INCLUDE_DIR )
set(metis_LIBRARY_DIR )
set(metis_LIBRARIES )
find_dependency(METIS)

if() # STRUMPACK_USE_SCOTCH
  set(scotch_PREFIX )
  set(scotch_INCLUDE_DIR )
  set(scotch_LIBRARY_DIR )
  set(scotch_LIBRARIES )
  find_dependency(SCOTCH)
endif()

# if() # STRUMPACK_USE_PTSCOTCH
#   set(ptscotch_PREFIX )
#   set(ptscotch_INCLUDE_DIR )
#   set(ptscotch_LIBRARY_DIR )
#   set(ptscotch_LIBRARIES )
#   find_dependency(PTSCOTCH)
# endif()

if() # STRUMPACK_USE_PARMETIS
  set(parmetis_PREFIX )
  set(parmetis_INCLUDE_DIR )
  set(parmetis_LIBRARY_DIR )
  set(parmetis_LIBRARIES )
  find_dependency(ParMETIS)
endif()

if() # STRUMPACK_USE_ZFP
  set(zfp_PREFIX )
  set(zfp_INCLUDE_DIR )
  set(zfp_LIBRARY_DIR )
  set(zfp_LIBRARIES )
  find_dependency(ZFP)
endif()

if() # STRUMPACK_USE_MAGMA
  set(zfp_PREFIX )
  set(zfp_INCLUDE_DIR )
  set(zfp_LIBRARY_DIR )
  set(zfp_LIBRARIES )
  find_dependency(MAGMA)
endif()

if() # STRUMPACK_USE_BPACK
  find_dependency(ButterflyPACK)
endif()

if() # STRUMPACK_USE_SLATE
  set(slate_PREFIX )
  set(blaspp_DIR )
  set(lapackpp_DIR )
  set(slate_DIR )
  find_dependency(blaspp)
  find_dependency(lapackpp)
  find_dependency(slate)
endif()

list(REMOVE_AT CMAKE_MODULE_PATH 0)

if(NOT TARGET STRUMPACK::strumpack)
  include("${CMAKE_CURRENT_LIST_DIR}/strumpack-targets.cmake")
endif()

set(STRUMPACK_LIBRARIES STRUMPACK::strumpack)
