/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Status;

public class WC {
    Map items = new HashMap();

    public void materialize(File file) throws IOException {
        File file2;
        for (Item item : this.items.values()) {
            if (item.myContent != null || (file2 = new File(file, item.myPath)).exists()) continue;
            file2.mkdirs();
        }
        for (Item item : this.items.values()) {
            if (item.myContent == null) continue;
            file2 = new File(file, item.myPath);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            printWriter.print(item.myContent);
            printWriter.close();
        }
    }

    public Item addItem(String string, String string2) {
        return new Item(string, string2);
    }

    public Item getItem(String string) {
        return (Item)this.items.get(string);
    }

    public void removeItem(String string) {
        this.items.remove(string);
    }

    public void setItemTextStatus(String string, int n) {
        ((Item)this.items.get((Object)string)).textStatus = n;
    }

    public void setItemPropStatus(String string, int n) {
        ((Item)this.items.get((Object)string)).propStatus = n;
    }

    public void setItemWorkingCopyRevision(String string, long l) {
        ((Item)this.items.get((Object)string)).workingCopyRev = l;
    }

    public void setRevision(long l) {
        for (Item item : this.items.values()) {
            item.workingCopyRev = l;
        }
    }

    public String getItemContent(String string) {
        return ((Item)this.items.get((Object)string)).myContent;
    }

    public void setItemContent(String string, String string2) {
        Assert.assertNotNull((String)"cannot unset content", (Object)string2);
        Item item = (Item)this.items.get(string);
        Assert.assertNotNull((String)"cannot set content on directory", (Object)item.myContent);
        item.myContent = string2;
    }

    public void setItemCheckContent(String string, boolean bl) {
        Item item = (Item)this.items.get(string);
        item.checkContent = bl;
    }

    public void setItemNodeKind(String string, int n) {
        Item item = (Item)this.items.get(string);
        item.nodeKind = n;
    }

    public void setItemIsLocked(String string, boolean bl) {
        Item item = (Item)this.items.get(string);
        item.isLocked = bl;
    }

    public void setItemIsSwitched(String string, boolean bl) {
        Item item = (Item)this.items.get(string);
        item.isSwitched = bl;
    }

    public void setItemReposLastCmtRevision(String string, long l) {
        ((Item)this.items.get((Object)string)).reposLastCmtRevision = l;
    }

    public void setItemReposLastCmtAuthor(String string, String string2) {
        ((Item)this.items.get((Object)string)).reposLastCmtAuthor = string2;
    }

    public void setItemReposLastCmtDate(String string, long l) {
        ((Item)this.items.get((Object)string)).reposLastCmtDate = l;
    }

    public void setItemReposKind(String string, int n) {
        ((Item)this.items.get((Object)string)).reposKind = n;
    }

    public void setItemOODInfo(String string, long l, String string2, long l2, int n) {
        this.setItemReposLastCmtRevision(string, l);
        this.setItemReposLastCmtAuthor(string, string2);
        this.setItemReposLastCmtDate(string, l2);
        this.setItemReposKind(string, n);
    }

    public WC copy() {
        WC wC = new WC();
        Iterator iterator = this.items.values().iterator();
        while (iterator.hasNext()) {
            ((Item)iterator.next()).copy(wC);
        }
        return wC;
    }

    void check(DirEntry[] dirEntryArray, String string) {
        Assert.assertEquals((String)"not a single dir entry", (int)1, (int)dirEntryArray.length);
        Item item = (Item)this.items.get(string);
        Assert.assertNotNull((String)"not found in working copy", (Object)item);
        Assert.assertNotNull((String)"not a file", (Object)item.myContent);
        Assert.assertEquals((String)"state says file, working copy not", (int)dirEntryArray[0].getNodeKind(), (int)(item.nodeKind == -1 ? 1 : item.nodeKind));
    }

    void check(DirEntry[] dirEntryArray, String string, boolean bl) {
        for (Item item : this.items.values()) {
            item.touched = false;
        }
        string = string != null && string.length() > 0 ? string + '/' : "";
        for (int i = 0; i < dirEntryArray.length; ++i) {
            String string2 = string + dirEntryArray[i].getPath();
            Item item = (Item)this.items.get(string2);
            Assert.assertNotNull((String)"null paths won't be found in working copy", (Object)item);
            if (item.myContent != null) {
                Assert.assertEquals((String)("Expected '" + dirEntryArray[i] + "' to be file"), (int)dirEntryArray[i].getNodeKind(), (int)(item.nodeKind == -1 ? 1 : item.nodeKind));
            } else {
                Assert.assertEquals((String)("Expected '" + dirEntryArray[i] + "' to be dir"), (int)dirEntryArray[i].getNodeKind(), (int)(item.nodeKind == -1 ? 2 : item.nodeKind));
            }
            item.touched = true;
        }
        for (Item item : this.items.values()) {
            if (item.touched || !item.myPath.startsWith(string) || item.myPath.equals(string)) continue;
            Assert.assertFalse((String)("Expected path '" + item.myPath + "' not found in dir entries"), (boolean)bl);
            boolean bl2 = false;
            for (int i = 0; i < dirEntryArray.length; ++i) {
                if (dirEntryArray[i].getNodeKind() != 2 || !item.myPath.startsWith(string + dirEntryArray[i].getPath())) continue;
                bl2 = true;
                break;
            }
            Assert.assertTrue((String)("Expected path '" + item.myPath + "' not found in dir entries"), (boolean)bl2);
        }
    }

    void check(Status[] statusArray, String string) throws IOException {
        this.check(statusArray, string, false);
    }

    void check(Status[] statusArray, String string, boolean bl) throws IOException {
        Object object2;
        for (Object object2 : this.items.values()) {
            ((Item)object2).touched = false;
        }
        object2 = string.replace(File.separatorChar, '/');
        for (int i = 0; i < statusArray.length; ++i) {
            String string2 = statusArray[i].getPath();
            Assert.assertTrue((String)"status path starts not with working copy path", (boolean)string2.startsWith((String)object2));
            if (string2.length() > string.length() + 1) {
                Assert.assertEquals((String)"missing '/' in status path", (char)string2.charAt(string.length()), (char)'/');
                string2 = string2.substring(string.length() + 1);
            } else {
                string2 = "";
            }
            Item item = (Item)this.items.get(string2);
            Assert.assertNotNull((String)("status not found in working copy: " + string2), (Object)item);
            Assert.assertEquals((String)("wrong text status in working copy: " + string2), (int)item.textStatus, (int)statusArray[i].getTextStatus());
            if (item.workingCopyRev != -1L) {
                Assert.assertEquals((String)("wrong revision number in working copy: " + string2), (long)item.workingCopyRev, (long)statusArray[i].getRevisionNumber());
            }
            Assert.assertEquals((String)("lock status wrong: " + string2), (boolean)item.isLocked, (boolean)statusArray[i].isLocked());
            Assert.assertEquals((String)("switch status wrong: " + string2), (boolean)item.isSwitched, (boolean)statusArray[i].isSwitched());
            Assert.assertEquals((String)("wrong prop status in working copy: " + string2), (int)item.propStatus, (int)statusArray[i].getPropStatus());
            if (item.myContent != null) {
                Assert.assertEquals((String)("state says file, working copy not: " + string2), (int)statusArray[i].getNodeKind(), (int)(item.nodeKind == -1 ? 1 : item.nodeKind));
                if (statusArray[i].getTextStatus() == 1 || item.checkContent) {
                    int n;
                    File file = new File(string, item.myPath);
                    InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = ((Reader)inputStreamReader).read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    ((Reader)inputStreamReader).close();
                    Assert.assertEquals((String)("content mismatch: " + string2), (String)stringBuffer.toString(), (String)item.myContent);
                }
            } else {
                Assert.assertEquals((String)("state says dir, working copy not: " + string2), (int)statusArray[i].getNodeKind(), (int)(item.nodeKind == -1 ? 2 : item.nodeKind));
            }
            if (bl) {
                Assert.assertEquals((String)("Last commit revisions for OOD path '" + item.myPath + "' don't match:"), (long)item.reposLastCmtRevision, (long)statusArray[i].getReposLastCmtRevisionNumber());
                Assert.assertEquals((String)("Last commit kinds for OOD path '" + item.myPath + "' don't match:"), (int)item.reposKind, (int)statusArray[i].getReposKind());
                if (statusArray[i].getRepositoryTextStatus() != 4) {
                    long l = statusArray[i].getReposLastCmtDate() == null ? 0L : statusArray[i].getReposLastCmtDate().getTime();
                    Assert.assertEquals((String)("Last commit dates for OOD path '" + item.myPath + "' don't match:"), (Object)new Date(item.reposLastCmtDate), (Object)new Date(l));
                    Assert.assertEquals((String)("Last commit authors for OOD path '" + item.myPath + "' don't match:"), (String)item.reposLastCmtAuthor, (String)statusArray[i].getReposLastCmtAuthor());
                }
            }
            item.touched = true;
        }
        for (Item item : this.items.values()) {
            Assert.assertTrue((String)"item in working copy not found in status", (boolean)item.touched);
        }
    }

    public class Item {
        String myContent;
        String myPath;
        int textStatus = 1;
        int propStatus = 0;
        long workingCopyRev = -1L;
        boolean touched;
        boolean checkContent;
        int nodeKind = -1;
        boolean isLocked;
        boolean isSwitched;
        long reposLastCmtRevision = -1L;
        long reposLastCmtDate = 0L;
        int reposKind = 0;
        String reposLastCmtAuthor;

        private Item(String string, String string2) {
            this.myPath = string;
            this.myContent = string2;
            WC.this.items.put(string, this);
        }

        private Item(Item item, WC wC2) {
            this.myPath = item.myPath;
            this.myContent = item.myContent;
            this.textStatus = item.textStatus;
            this.propStatus = item.propStatus;
            wC2.items.put(this.myPath, this);
        }

        private Item copy(WC wC) {
            return new Item(this, wC);
        }
    }
}

