/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.subversion.javahl.BasicTests;
import org.apache.subversion.javahl.ExceptionTests;
import org.apache.subversion.javahl.SVNRemoteTests;
import org.apache.subversion.javahl.SVNReposTests;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.UtilTests;

public class RunTests {
    public static void main(String[] stringArray) {
        RunTests.processArgs(stringArray);
        TestResult testResult = TestRunner.run((Test)SVNTestSuite.suite());
        if (testResult.errorCount() > 0 || testResult.failureCount() > 0) {
            System.exit(1);
        }
    }

    private static void processArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-d".equals(string)) {
                if (i + 1 >= stringArray.length) continue;
                SVNTests.rootDirectoryName = stringArray[++i];
                continue;
            }
            if (!"-u".equals(string) || i + 1 >= stringArray.length) continue;
            SVNTests.rootUrl = stringArray[++i];
        }
    }

    private static class SVNTestSuite
    extends TestSuite {
        private SVNTestSuite() {
        }

        public static TestSuite suite() {
            SVNTestSuite sVNTestSuite = new SVNTestSuite();
            TestCase[] testCaseArray = null;
            String string = System.getProperty("test.tests");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                testCaseArray = new TestCase[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n2 = string2.lastIndexOf(46);
                    String string3 = string2.substring(0, n2);
                    try {
                        Class<?> clazz = Class.forName(string3);
                        Class[] classArray = new Class[]{String.class};
                        Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                        string2 = string2.substring(n2 + 1);
                        String[] stringArray = new String[]{string2};
                        testCaseArray[n++] = (TestCase)constructor.newInstance(stringArray);
                    }
                    catch (Exception exception) {
                        testCaseArray = null;
                        break;
                    }
                }
            }
            if (testCaseArray == null || testCaseArray.length == 0) {
                sVNTestSuite.addTestSuite(BasicTests.class);
                sVNTestSuite.addTestSuite(UtilTests.class);
                sVNTestSuite.addTestSuite(SVNRemoteTests.class);
                sVNTestSuite.addTestSuite(SVNReposTests.class);
                sVNTestSuite.addTestSuite(ExceptionTests.class);
            } else {
                for (int i = 0; i < testCaseArray.length; ++i) {
                    sVNTestSuite.addTest((Test)testCaseArray[i]);
                }
            }
            return sVNTestSuite;
        }
    }
}

