/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jpl7.JPLException;
import org.jpl7.Term;

public class Rational
extends Term {
    protected final long numerator;
    protected final long denominator;

    public Rational(long l, long l2) {
        if (l2 == 0L) {
            throw new JPLException("denominator of rational cannot be 0");
        }
        long l3 = Rational.gcd(l, l2);
        long l4 = l / l3;
        long l5 = l2 / l3;
        if (l5 < 0L) {
            this.denominator = -l5;
            this.numerator = -l4;
        } else {
            this.denominator = l5;
            this.numerator = l4;
        }
        if (l2 == 1L) {
            throw new JPLException("the denominator is 1 so it should be an Integer.");
        }
    }

    public Rational(String string) {
        if (Pattern.compile("-?\\d+r\\d+").matcher(string).matches()) {
            long l = Long.parseLong(string.split("r", -2)[0]);
            long l2 = Long.parseLong(string.split("r", -2)[1]);
            if (l2 == 0L) {
                throw new JPLException("denominator of rational cannot be 0");
            }
            long l3 = Rational.gcd(l, l2);
            long l4 = l / l3;
            long l5 = l2 / l3;
            if (l5 < 0L) {
                this.denominator = -l5;
                this.numerator = -l4;
            } else {
                this.denominator = l5;
                this.numerator = l4;
            }
            if (l2 == 1L) {
                throw new JPLException("the denominator is 1 so it should be an Integer.");
            }
        } else {
            throw new JPLException("incorrect format for rational number; should be of the form NrM.");
        }
    }

    private static long gcd(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (0L == l2) {
            return l;
        }
        return Rational.gcd(l2, l % l2);
    }

    @Override
    public Term[] args() {
        return new Term[0];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.numerator == rational.numerator && this.denominator == rational.denominator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public final long getNumerator() {
        return this.numerator;
    }

    public final long getDenominator() {
        return this.denominator;
    }

    @Override
    public final boolean hasFunctor(long l, int n) {
        return this.numerator == l && n == 0;
    }

    @Override
    public final int intValue() {
        return Math.round(this.numerator / this.denominator);
    }

    @Override
    public final long longValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public final float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public final double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public String toString() {
        return String.format("%sr%s", this.numerator, this.denominator);
    }

    @Override
    public final int type() {
        return 4;
    }

    @Override
    public String typeName() {
        return "Rational";
    }
}

