# $Id: td_make.in,v 12.44 2025/09/28 17:44:30 tom Exp $
# common definitions for makefiles built over TD_LIB library.
# vile:makemode

SHELL	= /bin/sh


####### (Environment) ##########################################################
prefix		= /opt/local
exec_prefix	= ${prefix}

bindir		= ${exec_prefix}/bin
libdir		= ${exec_prefix}/lib
includedir	= ${prefix}/include
datarootdir	= ${prefix}/share
mandir		= ${datarootdir}/man
datadir		= ${datarootdir}

# BUILD_DIR, when needed, is derived in component configure scripts
BUILD_LIB	= $(BUILD_DIR)/lib
BUILD_INC	= $(BUILD_DIR)/include
BUILD_CFG	= $(BUILD_DIR)/support

TD_LIB		= /opt/local/lib
TD_INC		= /opt/local/include/td
TD_CFG		= /opt/local/share/td

AR		= ar
ARFLAGS		= -curv
RM		= rm -f
LINT		= 
LINT_OPTS	= 
CTAGS		= ctags
ETAGS		= 

CC		= /usr/bin/clang
CPP		= /usr/bin/clang -E
INSTALL		= /opt/local/libexec/macports/clonebin/install 
INSTALL_PROGRAM	= ${INSTALL} -s
INSTALL_DATA	= ${INSTALL} -m 644
RANLIB		= ranlib
MAKE_OPTS	= 

EXEEXT		= 
OBJEXT		= o

EXTRA_CFLAGS	= 
CFLAGS		= -pipe -Os -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX13.sdk -arch x86_64 -Qunused-arguments -Wno-error=implicit-function-declaration
LINK		= $(CC) $(CFLAGS)

INSTALL_BIN	= $(DESTDIR)$(bindir)
INSTALL_INC	= $(DESTDIR)$(includedir)
INSTALL_LIB	= $(DESTDIR)$(libdir)
INSTALL_MAN	= $(DESTDIR)$(mandir)

####### (Command-line Options) #################################################
EXTRA_CPPFLAGS	= 
CPPFLAGS	= -I/opt/local/include -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX13.sdk -D_DARWIN_C_SOURCE -D_XOPEN_SOURCE_EXTENDED -I$(includedir)
CPP_CONFIG	= -I. -I$(TD_INC) -DHAVE_CONFIG_H -I$(BUILD_INC) $(CPPFLAGS) $(EXTRA_CPPFLAGS)
CPP_OPTS	= $(CPP_CONFIG) $(EXTRA_CPP_OPTS)

x		= 
LIB_DEPS	= $(BUILD_LIB)/libtd.a
LIB_ARGS	=  -L/opt/local/lib -L$(TD_LIB) -ltd 

CURSES_LIBS	=  -L/opt/local/lib -L$(TD_LIB) -ltd -lncurses  

DATE		= echo '** '`date` >> $@

LINTLIBS	= -ltd 
LINTOPTS	= $(LINT_OPTS) $(CPP_OPTS) -DNO_IDENT $(LINTLIBS)

####### (Standard Lists) #######################################################
# don't put .a into CLEAN, because VERDIX-ADA uses that for source!
CLEAN	= *.[oi] *.lint *.bak *.log *.out *.tst .nfs* *.pure* core tags
DESTROY	=$(SHELL) -c 'for i in *;do case $$i in RCS);; *) $(RM) $$i;;esac;done;exit 0'
RUN_TESTS=$(SHELL) -c '$(srcdir)/run_test.sh 2>&1 | tee -a $@.out'

PTYPES_H =	$(TD_INC)/ptypes.h \
		$(TD_INC)/td_ext.h \
		$(TD_INC)/td_lib.h \
		$(BUILD_INC)/td_config.h
CURSES_H =	$(PTYPES_H) \
		$(TD_INC)/td_curse.h
QSORT_H =	$(PTYPES_H) \
		$(TD_INC)/td_qsort.h
RCSDEFS_H =	$(PTYPES_H) \
		$(TD_INC)/rcsdefs.h \
		$(TD_INC)/deltree.h
SCCSDEFS_H =	$(PTYPES_H) \
		$(TD_INC)/sccsdefs.h

####### (Development) ##########################################################
CPROTO	= cproto -e -i -fo'\\n\\t\\t' -fp'\\n\\t\\t'

LINT_EACH = $(SHELL) -c 'for i in $?;do echo $$i:; $(LINT) $(LINTOPTS) $$i >>$@;done'

.SUFFIXES: .c .o .a .i .proto .lint .tst .man $(SUFFIX_MAN) .txt .pdf .ps .html

.c.o:
	
	$(CC) $(CPP_OPTS) $(CFLAGS) $(EXTRA_CFLAGS) -c $(srcdir)/$*.c
.o.a:
	@$(AR) $(ARFLAGS) $@ $*.o
	-@$(RM) $*.o
.c.a:
	
	$(CC) $(CPP_OPTS) $(CFLAGS) $(EXTRA_CFLAGS) -c $(srcdir)/$*.c
	@$(AR) $(ARFLAGS) $@ $*.o
	-@$(RM) $*.o

.c.i:		; $(CC) $(CPP_OPTS) -E -C $*.c >$@
.c.proto:	; $(CPROTO) $(CPP_OPTS) $*.c >$@
.c.lint:	; $(LINT) $(LINTOPTS) $*.c >$@

# In CF_TD_TEST_MAKEFILES, we pretended the source-files are in the current
# directory.  They are not.  Use $(srcdir) to make it work.
.c.tst:
	$(CC) -o $@ -DTEST $(CFLAGS) $(EXTRA_CFLAGS) $(CPP_OPTS) $*.c $Z $(LIB_ARGS)

SUFFIX_MAN = .txt # .html
CLEAN__MAN = *.txt # *.html
NROFF	= /usr/bin/mandoc

.man.txt:
	-$(RM) $@
	$(NROFF) -man $? >$@

#SUFFIX_MAN = .txt .pdf .ps .png # .html
#CLEAN__MAN = *.txt *.pdf *.ps *.png # *.html
#GROFF	= no
#
#.man.ps :
#	$(SHELL) -c "tbl $*.man | $(GROFF) -man" >$@
#
#.man.txt :
#	GROFF_NO_SGR=stupid $(SHELL) -c "tbl $*.man | $(GROFF) -Tascii -man | col -bx" >$@
#
#.ps.pdf :
#	ps2pdf $*.ps

#.man.html :
#	$(TD_CFG)/man2html.sh $* man man >$@
#
