# bfs

> अपनी फ़ाइलों के लिए चौड़ाई-प्रथम खोज।
> अधिक जानकारी: <https://manned.org/bfs>।

- एक्सटेंशन द्वारा फ़ाइलें ढूंढें:

`bfs {{रूट_पथ}} -name '{{*.ext}}'`

- एकाधिक पथ/नाम पैटर्न से मेल खाने वाली फ़ाइलें ढूंढें:

`bfs {{रूट_पथ}} -path '{{**/पथ/**/*.ext}}' -or -name '{{*पैटर्न*}}'`

- केस-असंवेदनशील मोड में, किसी दिए गए नाम से मेल खाने वाली निर्देशिकाएँ खोजें:

`bfs {{रूट_पथ}} -type d -iname '{{*lib*}}'`

- विशिष्ट पथों को छोड़कर, किसी दिए गए पैटर्न से मेल खाने वाली फ़ाइलें ढूंढें:

`bfs {{रूट_पथ}} -name '{{*.py}}' -not -path '{{*/साइट-पैकेज/*}}'`

- किसी दिए गए आकार सीमा से मेल खाने वाली फ़ाइलें ढूंढें, पुनरावर्ती गहराई को "1" तक सीमित करें:

`bfs {{रूट_पथ}} -maxdepth 1 -size {{+500k}} -size {{-10M}}`

- प्रत्येक फ़ाइल के लिए एक कमांड चलाएँ (फ़ाइल नाम तक पहुँचने के लिए कमांड के भीतर `{}` का उपयोग करें):

`bfs {{रूट_पथ}} -name '{{*.ext}}' -exec {{wc -l}} {} \;`

- आज संशोधित सभी फ़ाइलें ढूंढें और परिणामों को तर्क के रूप में एकल कमांड में पास करें:

`bfs {{रूट_पथ}} -daystart -mtime {{-1}} -exec {{tar -cvf archive.tar}} {} \+`

- खाली फ़ाइलें (0 बाइट) या निर्देशिकाएं ढूंढें और उन्हें शब्दशः हटाएं:

`bfs {{रूट_पथ}} -type {{f|d}} -empty -delete -print`
