# tar

> Arşivleme aracı.
> Dosyalar genellikle gzip veya bzip2 gibi bir sıkıştırma yöntemiyle birleştirilir.
> Daha fazla bilgi için: <https://www.gnu.org/software/tar/manual/tar.html>.

- Bir arşiv oluştur ve dosyaya yaz:

`tar cf {{hedef.tar}} {{dosya1 dosya2 ...}}`

- Bir gzip arşivi oluştur ve dosyaya yaz:

`tar czf {{hedef.tar.gz}} {{dosya1 dosya2 ...}}`

- Göreceli yolları kullanarak bir gzip arşivi oluştur:

`tar czf {{hedef.tar.gz}} {{[-C|--directory]}} {{dizin/yolu}} .`

- Sıkıştırılmış bir arşiv dosyasını geçerli dizine ayrıntılı şekilde çıkar:

`tar xvf {{kaynak.tar[.gz|.bz2|.xz]}}`

- Sıkıştırılmış bir arşiv dosyasını hedef dizine çıkar:

`tar xf {{kaynak.tar[.gz|.bz2|.xz]}} {{[-C|--directory]}} {{dizin}}`

- Sıkıştırılmış bir arşiv oluştur ve sıkıştırma yöntemini seçmek için arşiv sonekini kullan:

`tar caf {{hedef.tar.xz}} {{dosya1 dosya2 ...}}`

- Bir tar arşivinin içeriğini ayrıntılı olarak listele:

`tar tvf {{kaynak.tar}}`

- Şablonla eşleşen dosyaları arşivden çıkar:

`tar xf {{kaynak.tar}} --wildcards "{{*.html}}"`
