/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class Lists$ReverseList<T>
extends AbstractList<T> {
    public final List<T> forwardList;

    public Lists$ReverseList(List<T> forwardList) {
        this.forwardList = Ascii.checkNotNull(forwardList);
    }

    private int reverseIndex(int index) {
        int size = this.size();
        Ascii.checkElementIndex(index, size);
        return size - 1 - index;
    }

    private int reversePosition(int index) {
        int size = this.size();
        Ascii.checkPositionIndex(index, size);
        return size - index;
    }

    @Override
    public void add(int index, @Nullable T element) {
        this.forwardList.add(this.reversePosition(index), element);
    }

    @Override
    public void clear() {
        this.forwardList.clear();
    }

    @Override
    public T remove(int index) {
        return this.forwardList.remove(this.reverseIndex(index));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.subList(fromIndex, toIndex).clear();
    }

    @Override
    public T set(int index, @Nullable T element) {
        return this.forwardList.set(this.reverseIndex(index), element);
    }

    @Override
    public T get(int index) {
        return this.forwardList.get(this.reverseIndex(index));
    }

    @Override
    public int size() {
        return this.forwardList.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Ascii.checkPositionIndexes(fromIndex, toIndex, this.size());
        return Ascii.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        int start = this.reversePosition(index);
        ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
        return new ListIterator<T>(this, forwardIterator){
            private boolean canRemoveOrSet;
            private /* synthetic */ ListIterator val$forwardIterator;
            private /* synthetic */ Lists$ReverseList this$0;
            {
                this.this$0 = lists$ReverseList;
                this.val$forwardIterator = listIterator;
            }

            @Override
            public final void add(T e) {
                this.val$forwardIterator.add(e);
                this.val$forwardIterator.previous();
                this.canRemoveOrSet = false;
            }

            @Override
            public final boolean hasNext() {
                return this.val$forwardIterator.hasPrevious();
            }

            @Override
            public final boolean hasPrevious() {
                return this.val$forwardIterator.hasNext();
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.canRemoveOrSet = true;
                return this.val$forwardIterator.previous();
            }

            @Override
            public final int nextIndex() {
                return this.this$0.reversePosition(this.val$forwardIterator.nextIndex());
            }

            @Override
            public final T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.canRemoveOrSet = true;
                return this.val$forwardIterator.next();
            }

            @Override
            public final int previousIndex() {
                return this.nextIndex() - 1;
            }

            @Override
            public final void remove() {
                Ascii.checkRemove(this.canRemoveOrSet);
                this.val$forwardIterator.remove();
                this.canRemoveOrSet = false;
            }

            @Override
            public final void set(T e) {
                Ascii.checkState(this.canRemoveOrSet);
                this.val$forwardIterator.set(e);
            }
        };
    }
}

