/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Wasm is 'TP' before Qt 6.4.0 (in Qt6 series)

    if (typeof(662) == 'number' && 662 < 640) {
        var dynamicDisplayName = component.value("DisplayName");
        var dynamicDescription = component.value("Description") + "&lt;br&gt;&lt;br&gt;The release of " + dynamicDisplayName + " with Qt 6.6 is a Technology Preview.";
        dynamicDisplayName = dynamicDisplayName + " (TP)";
        component.setValue("DisplayName", dynamicDisplayName);
        component.setValue("Description", dynamicDescription);
    }

    // Wasm requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        // Linux on ARM supported from Qt 6.7 onward
        if ("662" == "dev" || 66 >= 67) {
            if (systemInfo.currentCpuArchitecture == "arm64") {
                hostDependencyStr = "qt.qt6.662.linux_gcc_arm64"
            }
            else {
                hostDependencyStr = "qt.qt6.662.linux_gcc_64"
            }
        }
        else {
            hostDependencyStr = "qt.qt6.662.gcc_64"
        }
    }
    else if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.662.clang_64"
    }
    else if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.662.win64_mingw"
    }
    component.addDependency(hostDependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    // Set path to QT to a variable
    var pathToQt = qtPathUnixSeparators("/6.6.2/wasm_multithread");

    // patch qmake (.bat)
    component.addOperation("Replace", pathToQt + qmakeScript_662(), originalQmakePath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQmakePath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", pathToQt + qtCMakeScript_662(), originalSetCmakePath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newSetCMakePath_662(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", pathToQt + qtCMakePrivateScript_662(), originalSetCmakePath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newSetCMakePath_662(), "regex");

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64") == true) {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_662());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_662());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_662());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_662());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_662());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_662());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("662" == "dev" || 66 >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_662());
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_662());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", pathToQt + targetQtConf_662(), originalHostPrefix_662(), newHostPrefix_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

    component.addOperation("Replace", pathToQt + targetQtConf_662(), originalHostData_662(), newHostData_662("multithread"));

    component.addOperation("Replace", pathToQt + targetQtConf_662(), originalHostSpec_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newHostSpec_662());

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", pathToQt + targetQtConf_662(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_662());

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", pathToQt + targetQtConf_662(), targetQtConfDocumentation_662("6.6.2"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", pathToQt + targetQtConf_662(), "\r\n");

        // Patch Qt install paths from QtBuildInternalsExtra.cmake
        component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_662(), originalHostTargetPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), qtPathWinSeparators("/6.6.2/wasm_multithread"));
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", pathToQt + targetQtConf_662(), "\n");

        // Patch Qt install paths from QtBuildInternalsExtra.cmake
        component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_662(), originalHostTargetPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), pathToQt);
    }
    component.addOperation("AppendFile", pathToQt + targetQtConf_662(), targetQtConfExamples_662("6.6.2"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", pathToQt + qtToolchainCmake_662(), originalQtHostPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQtHostPath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_662(), originalBIPrefix_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), installer.value("TargetDir"));

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", pathToQt + qtPathsScript_662(), originalQtPathsPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQtPathsPath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

    if ("662" == "dev" || 66 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_662(), originalQtHostPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQtHostPath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qmake6Script_662(), originalQmakePath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQmakePath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qtPaths6Script_662(), originalQtPathsPath_662("MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"), newQtPathsPath_662("6.6.2", "MacOS-MacOS_13-Clang-MacOS-WebAssembly-X86_64"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", pathToQt + qdeviceFile_662(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_662());

    addInitQtPatchOperation(component, platformIdentification_662(), pathToQt, pathToQt + qmakeScript_662(), "qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} WebAssembly (multi-threaded)",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", pathToQt + qmakeScript_662(),
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    var kitName = component.name + "_kit";
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "WebAssembly Qt %{Qt:Version} (multi-threaded)",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", component.name,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    component.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.6.2/wasm_multithread", "Qt-6.6.2");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", pathToQt + qconfigFile_662(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

