/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.gui;

import gmonitor.gui.RawDataElement;
import gmonitor.logdata.BinaryBlock;
import gmonitor.logdata.DataBlock;
import gmonitor.logdata.DataBlockGroupElement;
import gmonitor.logdata.DataBlockGroupTable;
import gmonitor.logdata.DataElement;
import gmonitor.logdata.DataFile;
import gmonitor.logdata.FirstMetaBlock;
import gmonitor.logdata.HostDefBlock;
import gmonitor.logdata.HostDefElement;
import gmonitor.logdata.OIDDefBlock;
import gmonitor.logdata.OIDDefElement;
import gmonitor.logdata.SecondMetaBlock;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.TreeSet;

public class DataTimeSpace {
    ArrayList files = new ArrayList();
    TreeSet hostnames = new TreeSet();
    TreeSet eventnames = new TreeSet();
    long largestGroupInterval = 1L;
    long smallestGroupInterval = Long.MAX_VALUE;
    private long COUNTMAX = 0x100000000L;
    private long MAXbps = 1500000000L;
    private final int JUST_BEFORE = 0;
    private final int ESTIMATE = 1;
    private static long savedBeginTime = -1L;

    public long getBeginDateTime() throws IOException {
        if (this.files != null && this.files.size() > 0) {
            DataFile dataFile = (DataFile)this.files.get(0);
            return dataFile.getBeginDateTime();
        }
        throw new IOException();
    }

    public long getLatestDateTime() throws IOException {
        if (this.files != null && this.files.size() > 0) {
            DataFile dataFile = (DataFile)this.files.get(this.files.size() - 1);
            return dataFile.getLatestDateTime();
        }
        throw new IOException();
    }

    public DataTimeSpace(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            DataFile dataFile = DataFile.getInstance(stringArray[i]);
            SecondMetaBlock secondMetaBlock = dataFile.getSecondMetaBlock();
            FirstMetaBlock firstMetaBlock = dataFile.getFirstMetaBlock();
            long l = firstMetaBlock.getGroupInterval();
            if (this.largestGroupInterval < l) {
                this.largestGroupInterval = l;
            }
            if (this.smallestGroupInterval > l) {
                this.smallestGroupInterval = l;
            }
            HostDefBlock hostDefBlock = secondMetaBlock.getHostDefBlock();
            int n = hostDefBlock.getCount();
            for (int j = 0; j < n; ++j) {
                HostDefElement hostDefElement = hostDefBlock.getHostDefElement(j);
                String string = hostDefElement.getNameAndNick();
                this.hostnames.add(string);
            }
            OIDDefBlock oIDDefBlock = secondMetaBlock.getOIDDefBlock();
            int n2 = oIDDefBlock.getCount();
            for (int j = 0; j < n2; ++j) {
                OIDDefElement oIDDefElement = oIDDefBlock.getOIDDefElement(j);
                String string = oIDDefElement.getNameAndNick();
                this.eventnames.add(string);
            }
            this.files.add(dataFile);
        }
        Collections.sort(this.files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHostnames() {
        String[] stringArray;
        TreeSet treeSet = this.hostnames;
        synchronized (treeSet) {
            stringArray = new String[this.hostnames.size()];
            stringArray = this.hostnames.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEvents() {
        String[] stringArray;
        TreeSet treeSet = this.eventnames;
        synchronized (treeSet) {
            stringArray = new String[this.eventnames.size()];
            stringArray = this.eventnames.toArray(stringArray);
        }
        return stringArray;
    }

    private ArrayList extract_aList(String string) {
        ArrayList<DataFile> arrayList = new ArrayList<DataFile>();
        for (int i = 0; i < this.files.size(); ++i) {
            DataFile dataFile = (DataFile)this.files.get(i);
            if (!dataFile.containsHost(string)) continue;
            arrayList.add(dataFile);
        }
        return arrayList;
    }

    private ArrayList extract_bList(ArrayList arrayList, String string) {
        ArrayList<DataFile> arrayList2 = new ArrayList<DataFile>();
        for (int i = 0; i < arrayList.size(); ++i) {
            DataFile dataFile = (DataFile)arrayList.get(i);
            if (!dataFile.containsEvent(string)) continue;
            arrayList2.add(dataFile);
        }
        Collections.sort(arrayList2);
        return arrayList2;
    }

    private DataFile extract_file(ArrayList arrayList, long l) throws IOException {
        DataFile dataFile = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            DataFile dataFile2 = (DataFile)arrayList.get(i);
            if (!dataFile2.containsDateTime(l)) continue;
            dataFile = dataFile2;
            break;
        }
        return dataFile;
    }

    private ArrayList extract_cList(ArrayList arrayList, long l, long l2) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        TreeSet<DataFile> treeSet = new TreeSet<DataFile>();
        for (int i = 1; i < arrayList.size(); ++i) {
            DataFile dataFile = (DataFile)arrayList.get(i - 1);
            DataFile dataFile2 = (DataFile)arrayList.get(i);
            long l3 = dataFile.getBeginDateTime();
            long l4 = dataFile2.getBeginDateTime();
            if (l <= l3 && l3 <= l + l2) {
                treeSet.add(dataFile);
                continue;
            }
            if (l3 > l || l >= l4) continue;
            treeSet.add(dataFile);
        }
        DataFile dataFile = (DataFile)arrayList.get(arrayList.size() - 1);
        long l5 = dataFile.getBeginDateTime();
        if (l5 <= l + l2) {
            treeSet.add(dataFile);
        }
        ArrayList<DataFile> arrayList2 = new ArrayList<DataFile>();
        arrayList2.addAll(treeSet);
        return arrayList2;
    }

    public ArrayList convertDateDataPairListToRawDataElements(ArrayList arrayList) {
        ArrayList<RawDataElement> arrayList2 = new ArrayList<RawDataElement>();
        for (int i = 0; i <= arrayList.size() - 2; i += 2) {
            Date date = (Date)arrayList.get(i);
            DataElement dataElement = (DataElement)arrayList.get(i + 1);
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setTime(date.getTime());
            rawDataElement.setValue(dataElement.getValue());
            if (dataElement.getFlag(0) && dataElement.getFlag(1)) {
                rawDataElement.setValid(true);
            }
            arrayList2.add(rawDataElement);
        }
        return arrayList2;
    }

    public ArrayList convertDateDataPairListToRawDataElements(ArrayList arrayList, boolean bl) {
        int n;
        ArrayList<RawDataElement> arrayList2 = new ArrayList<RawDataElement>();
        if (!bl) {
            return this.convertDateDataPairListToRawDataElements(arrayList);
        }
        if (arrayList.size() <= 2) {
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setValid(false);
            rawDataElement.setValue(0L);
            arrayList2.add(rawDataElement);
            return arrayList2;
        }
        Date date = null;
        DataElement dataElement = null;
        for (n = 0; n <= arrayList.size() - 4; n += 2) {
            dataElement = (DataElement)arrayList.get(n + 1);
            if (!dataElement.getFlag(0) || !dataElement.getFlag(1)) continue;
            date = (Date)arrayList.get(n);
            break;
        }
        if (n > arrayList.size() - 4) {
            return null;
        }
        for (int i = 2 + n; i <= arrayList.size() - 2; i += 2) {
            Date date2 = (Date)arrayList.get(i);
            DataElement dataElement2 = (DataElement)arrayList.get(i + 1);
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setTime(date2.getTime());
            if (!dataElement2.getFlag(0) || !dataElement2.getFlag(1)) {
                rawDataElement.setValue(0L);
                rawDataElement.setValid(false);
            } else {
                long l = date2.getTime() - date.getTime();
                long l2 = dataElement2.getValue() - dataElement.getValue();
                if (l2 < 0L) {
                    l2 = this.COUNTMAX + l2;
                }
                if ((l2 = (long)Math.rint((double)(l2 * 1000L) / (double)l)) >= 0L) {
                    rawDataElement.setValid(true);
                    rawDataElement.setValue(l2);
                } else {
                    rawDataElement.setValue(0L);
                    rawDataElement.setValid(false);
                }
                date = date2;
                dataElement = dataElement2;
            }
            arrayList2.add(rawDataElement);
        }
        return arrayList2;
    }

    public ArrayList convertDateDataPairListToRawDataElementsByUptime(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        if (arrayList.size() != arrayList2.size()) {
            return null;
        }
        ArrayList<RawDataElement> arrayList3 = new ArrayList<RawDataElement>();
        if (arrayList.size() <= 2) {
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setValid(false);
            rawDataElement.setValue(0L);
            arrayList3.add(rawDataElement);
            return arrayList3;
        }
        Date date = null;
        DataElement dataElement = null;
        DataElement dataElement2 = null;
        for (n = 0; n <= arrayList.size() - 4; n += 2) {
            dataElement = (DataElement)arrayList.get(n + 1);
            dataElement2 = (DataElement)arrayList2.get(n + 1);
            if (!dataElement.getFlag(0) || !dataElement.getFlag(1) || !dataElement2.getFlag(0) || !dataElement2.getFlag(1)) continue;
            date = (Date)arrayList.get(n);
            break;
        }
        if (n > arrayList.size() - 4) {
            return null;
        }
        for (int i = 2 + n; i <= arrayList.size() - 2; i += 2) {
            Date date2 = (Date)arrayList.get(i);
            DataElement dataElement3 = (DataElement)arrayList.get(i + 1);
            DataElement dataElement4 = (DataElement)arrayList2.get(i + 1);
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setTime(date2.getTime());
            if (!(dataElement3.getFlag(0) && dataElement3.getFlag(1) && dataElement4.getFlag(0) && dataElement4.getFlag(1))) {
                rawDataElement.setValue(0L);
                rawDataElement.setValid(false);
            } else {
                long l = dataElement4.getValue() - dataElement2.getValue();
                long l2 = dataElement3.getValue() - dataElement.getValue();
                if (l2 < 0L) {
                    l2 = this.COUNTMAX + l2;
                }
                if ((l2 = (long)Math.rint((double)(l2 * 100L) / (double)l)) >= 0L) {
                    rawDataElement.setValid(true);
                    rawDataElement.setValue(l2);
                    date = date2;
                } else {
                    rawDataElement.setValue(0L);
                    rawDataElement.setValid(false);
                }
                dataElement = dataElement3;
                dataElement2 = dataElement4;
            }
            arrayList3.add(rawDataElement);
        }
        return arrayList3;
    }

    public void initResampingMode() {
        savedBeginTime = -1L;
    }

    private ArrayList resampleDateDataPair(ArrayList arrayList, long l, int n) {
        long l2 = l * 1000L;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Date date = (Date)arrayList.get(0);
        DataElement dataElement = (DataElement)arrayList.get(1);
        long l3 = ((Date)arrayList.get(arrayList.size() - 2)).getTime() - date.getTime();
        long l4 = l3 / l2;
        long l5 = date.getTime() + l3 % l2;
        if (savedBeginTime - l2 > l5) {
            savedBeginTime = -1L;
        }
        if (savedBeginTime > 0L) {
            long l6;
            for (l6 = savedBeginTime; l5 > l6; l6 += l2) {
            }
            l5 = l6;
        }
        savedBeginTime = l5;
        int n2 = 0;
        if (n == 0) {
            int n3 = 0;
            while ((long)n3 <= l4) {
                long l7 = l5 + (long)n3 * l2;
                Date date2 = new Date(l7);
                arrayList2.add(date2);
                DataElement dataElement2 = null;
                DataElement dataElement3 = null;
                while (n2 <= arrayList.size() - 4) {
                    dataElement3 = (DataElement)arrayList.get(n2 + 1);
                    long l8 = ((Date)arrayList.get(n2 + 2)).getTime();
                    if (l7 < l8) {
                        dataElement2 = dataElement3;
                        break;
                    }
                    if (l7 == l8) {
                        dataElement2 = (DataElement)arrayList.get(n2 + 3);
                        break;
                    }
                    n2 += 2;
                }
                if (n2 <= arrayList.size() - 4) {
                    if (dataElement2 == null) {
                        dataElement2 = new DataElement(0, 0L);
                    }
                    arrayList2.add(dataElement2);
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            int n4 = 0;
            while ((long)n4 <= l4) {
                long l9 = l5 + (long)n4 * l2;
                Date date3 = new Date(l9);
                arrayList2.add(date3);
                DataElement dataElement4 = null;
                DataElement dataElement5 = null;
                while (n2 <= arrayList.size() - 4) {
                    long l10 = ((Date)arrayList.get(n2)).getTime();
                    dataElement5 = (DataElement)arrayList.get(n2 + 1);
                    long l11 = ((Date)arrayList.get(n2 + 2)).getTime();
                    long l12 = ((DataElement)arrayList.get(n2 + 3)).getValue();
                    if (l9 < l11) {
                        long l13 = l12 - dataElement5.getValue();
                        long l14 = l11 - l10;
                        long l15 = (long)Math.rint((double)l13 * ((double)(l9 - l10) / (double)l14));
                        long l16 = dataElement5.getValue() + l15;
                        dataElement4 = new DataElement(dataElement5.getFlagByte(), l16);
                        break;
                    }
                    if (l9 == l11) {
                        dataElement4 = (DataElement)arrayList.get(n2 + 3);
                        break;
                    }
                    n2 += 2;
                }
                if (n2 <= arrayList.size() - 4) {
                    if (dataElement4 == null) {
                        dataElement4 = new DataElement(0, 0L);
                    }
                    arrayList2.add(dataElement4);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        return arrayList2;
    }

    public ArrayList resampleBeforeDateDataPairListToRawDataElements(ArrayList arrayList, long l) {
        return this.resampleDateDataPair(arrayList, l, 0);
    }

    public ArrayList resampleEstimateDateDataPairListToRawDataElements(ArrayList arrayList, long l) {
        return this.resampleDateDataPair(arrayList, l, 1);
    }

    public ArrayList getMeasurementData(String string, String string2, long l, long l2) throws IOException {
        int n;
        DataBlockGroupElement[] dataBlockGroupElementArray;
        BinaryBlock binaryBlock;
        Object object;
        int n2;
        ArrayList arrayList = this.extract_aList(string);
        ArrayList arrayList2 = this.extract_bList(arrayList, string2);
        ArrayList arrayList3 = this.extract_cList(arrayList2, l, l2);
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        if (arrayList3 == null || arrayList3.size() == 0) {
            throw new IOException("File not matched, no measurement data.");
        }
        int n3 = -1;
        long l3 = 0L;
        block0: for (int i = 0; i < arrayList3.size() && n3 < 0; ++i) {
            DataFile dataFile = (DataFile)arrayList3.get(i);
            l3 = 0L;
            SecondMetaBlock secondMetaBlock = dataFile.getSecondMetaBlock();
            HostDefBlock hostDefBlock = secondMetaBlock.getHostDefBlock();
            n2 = hostDefBlock.getHostIndex(string);
            object = secondMetaBlock.getOIDDefBlock();
            int n4 = ((OIDDefBlock)object).getOIDIndex(string2);
            binaryBlock = secondMetaBlock.getDataBlockGroupTable();
            ArrayList arrayList5 = ((DataBlockGroupTable)binaryBlock).getDataBlockGroupElements();
            int n5 = arrayList5.size();
            while (dataFile.readDataBlock(l3) != null) {
                long l4 = l3 % (long)n5;
                dataBlockGroupElementArray = (DataBlockGroupElement[])arrayList5.get((int)l4);
                n = -1;
                for (int j = 0; j < dataBlockGroupElementArray.length; ++j) {
                    boolean bl = dataBlockGroupElementArray[j].isPairOfHIDandOID(n2, n4);
                    if (!bl) continue;
                    n = j;
                    break;
                }
                if (n >= 0) {
                    DataBlock dataBlock = dataFile.readDataBlock(l3);
                    if (dataBlock == null) continue block0;
                    if (dataBlock.getTime() >= l) {
                        n3 = i;
                        continue block0;
                    }
                }
                ++l3;
            }
        }
        if (n3 < 0) {
            throw new IOException("File not mathed, no starting point.");
        }
        long l5 = l3;
        long l6 = l + l2;
        for (n2 = n3; n2 < arrayList3.size(); ++n2) {
            object = (DataFile)arrayList3.get(n2);
            SecondMetaBlock secondMetaBlock = ((DataFile)object).getSecondMetaBlock();
            binaryBlock = secondMetaBlock.getHostDefBlock();
            int n6 = ((HostDefBlock)binaryBlock).getHostIndex(string);
            OIDDefBlock oIDDefBlock = secondMetaBlock.getOIDDefBlock();
            int n7 = oIDDefBlock.getOIDIndex(string2);
            DataBlockGroupTable dataBlockGroupTable = secondMetaBlock.getDataBlockGroupTable();
            dataBlockGroupElementArray = dataBlockGroupTable.getDataBlockGroupElements();
            n = dataBlockGroupElementArray.size();
            while (((DataFile)object).readDataBlock(l5) != null) {
                int n8 = (int)(l5 % (long)n);
                DataBlockGroupElement[] dataBlockGroupElementArray2 = (DataBlockGroupElement[])dataBlockGroupElementArray.get(n8);
                int n9 = -1;
                for (int i = 0; i < dataBlockGroupElementArray2.length; ++i) {
                    boolean bl = dataBlockGroupElementArray2[i].isPairOfHIDandOID(n6, n7);
                    if (!bl) continue;
                    n9 = i;
                    break;
                }
                if (n9 >= 0) {
                    DataBlock dataBlock = ((DataFile)object).readDataBlock(l5);
                    if (dataBlock == null) break;
                    long l7 = dataBlock.getTime();
                    ArrayList arrayList6 = dataBlock.getData();
                    DataElement dataElement = (DataElement)arrayList6.get(n9);
                    arrayList4.add(new Date(l7));
                    arrayList4.add(dataElement);
                    if (l7 > l6) break;
                }
                ++l5;
            }
            l5 = 0L;
        }
        return arrayList4;
    }

    public long getLargestGroupInterval() {
        return this.largestGroupInterval;
    }

    public long getSmallestGroupInterval() {
        return this.smallestGroupInterval;
    }
}

