/* gitg-history-refs-list.c generated by valac 0.28.0, the Vala compiler
 * generated from gitg-history-refs-list.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <gtk/gtk.h>
#include "libgitg-ext/libgitg-ext.h"
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include <stdio.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define GITG_HISTORY_TYPE_REF_ANIMATION (gitg_history_ref_animation_get_type ())

#define GITG_HISTORY_TYPE_REF_TYPED (gitg_history_ref_typed_get_type ())
#define GITG_HISTORY_REF_TYPED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped))
#define GITG_HISTORY_IS_REF_TYPED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_TYPED))
#define GITG_HISTORY_REF_TYPED_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTypedIface))

typedef struct _GitgHistoryRefTyped GitgHistoryRefTyped;
typedef struct _GitgHistoryRefTypedIface GitgHistoryRefTypedIface;

#define GITG_HISTORY_TYPE_REF_ROW (gitg_history_ref_row_get_type ())
#define GITG_HISTORY_REF_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow))
#define GITG_HISTORY_REF_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRowClass))
#define GITG_HISTORY_IS_REF_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_ROW))
#define GITG_HISTORY_IS_REF_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REF_ROW))
#define GITG_HISTORY_REF_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRowClass))

typedef struct _GitgHistoryRefRow GitgHistoryRefRow;
typedef struct _GitgHistoryRefRowClass GitgHistoryRefRowClass;
typedef struct _GitgHistoryRefRowPrivate GitgHistoryRefRowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block49Data Block49Data;

#define GITG_HISTORY_TYPE_REF_HEADER (gitg_history_ref_header_get_type ())
#define GITG_HISTORY_REF_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader))
#define GITG_HISTORY_REF_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeaderClass))
#define GITG_HISTORY_IS_REF_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REF_HEADER))
#define GITG_HISTORY_IS_REF_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REF_HEADER))
#define GITG_HISTORY_REF_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeaderClass))

typedef struct _GitgHistoryRefHeader GitgHistoryRefHeader;
typedef struct _GitgHistoryRefHeaderClass GitgHistoryRefHeaderClass;
typedef struct _GitgHistoryRefHeaderPrivate GitgHistoryRefHeaderPrivate;

#define GITG_HISTORY_TYPE_REFS_LIST (gitg_history_refs_list_get_type ())
#define GITG_HISTORY_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList))
#define GITG_HISTORY_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))
#define GITG_HISTORY_IS_REFS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_IS_REFS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_REFS_LIST))
#define GITG_HISTORY_REFS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListClass))

typedef struct _GitgHistoryRefsList GitgHistoryRefsList;
typedef struct _GitgHistoryRefsListClass GitgHistoryRefsListClass;
typedef struct _GitgHistoryRefsListPrivate GitgHistoryRefsListPrivate;

#define GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER (gitg_history_refs_list_remote_header_get_type ())
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeader))
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeaderClass))
#define GITG_HISTORY_REFS_LIST_IS_REMOTE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER))
#define GITG_HISTORY_REFS_LIST_IS_REMOTE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER))
#define GITG_HISTORY_REFS_LIST_REMOTE_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeaderClass))

typedef struct _GitgHistoryRefsListRemoteHeader GitgHistoryRefsListRemoteHeader;
typedef struct _GitgHistoryRefsListRemoteHeaderClass GitgHistoryRefsListRemoteHeaderClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gitg_history_refs_list_remote_header_unref0(var) ((var == NULL) ? NULL : (var = (gitg_history_refs_list_remote_header_unref (var), NULL)))
typedef struct _GitgHistoryRefsListRemoteHeaderPrivate GitgHistoryRefsListRemoteHeaderPrivate;
typedef struct _Block50Data Block50Data;

#define GITG_HISTORY_TYPE_DEFAULT_SELECTION (gitg_history_default_selection_get_type ())
typedef struct _GitgHistoryRefsListParamSpecRemoteHeader GitgHistoryRefsListParamSpecRemoteHeader;

typedef enum  {
	GITG_HISTORY_REF_ANIMATION_NONE,
	GITG_HISTORY_REF_ANIMATION_ANIMATE
} GitgHistoryRefAnimation;

struct _GitgHistoryRefTypedIface {
	GTypeInterface parent_iface;
	GitgRefType (*get_ref_type) (GitgHistoryRefTyped* self);
};

struct _GitgHistoryRefRow {
	GtkListBoxRow parent_instance;
	GitgHistoryRefRowPrivate * priv;
};

struct _GitgHistoryRefRowClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgHistoryRefRowPrivate {
	GtkImage* d_icon;
	GtkLabel* d_label;
	GtkBox* d_box;
	GtkRevealer* d_revealer;
	GitgRef* _reference;
	GtkEntry* d_editing_entry;
	guint d_idle_finish;
	GitgExtRefNameEditingDone d_edit_done_callback;
	gpointer d_edit_done_callback_target;
	GDestroyNotify d_edit_done_callback_target_destroy_notify;
};

struct _Block49Data {
	int _ref_count_;
	GitgHistoryRefRow* self;
	gboolean cancelled;
};

struct _GitgHistoryRefHeader {
	GtkListBoxRow parent_instance;
	GitgHistoryRefHeaderPrivate * priv;
};

struct _GitgHistoryRefHeaderClass {
	GtkListBoxRowClass parent_class;
};

struct _GitgHistoryRefHeaderPrivate {
	GitgRefType d_rtype;
	gboolean d_is_sub_header_remote;
	gchar* d_name;
	GitgRemote* d_remote;
	GitgProgressBin* d_progress_bin;
	GtkLabel* d_label;
	GtkImage* d_icon;
};

struct _GitgHistoryRefsList {
	GtkListBox parent_instance;
	GitgHistoryRefsListPrivate * priv;
};

struct _GitgHistoryRefsListClass {
	GtkListBoxClass parent_class;
};

struct _GitgHistoryRefsListPrivate {
	GitgRepository* d_repository;
	GeeHashMap* d_ref_map;
	GtkListBoxRow* d_selected_row;
	GitgRemote** d_remotes;
	gint d_remotes_length1;
	gint _d_remotes_size_;
	GitgHistoryRefRow* d_all_commits;
	GitgHistoryRefHeader* d_all_branches;
	GitgHistoryRefHeader* d_all_remotes;
	GitgHistoryRefHeader* d_all_tags;
	GeeHashMap* d_header_map;
	GitgExtRemoteLookup* _remote_lookup;
};

struct _GitgHistoryRefsListRemoteHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgHistoryRefsListRemoteHeaderPrivate * priv;
	GitgHistoryRefHeader* header;
	GeeHashSet* references;
};

struct _GitgHistoryRefsListRemoteHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GitgHistoryRefsListRemoteHeader *self);
};

struct _Block50Data {
	int _ref_count_;
	GitgHistoryRefsList* self;
	GitgHistoryRefRow* head;
};

typedef enum  {
	GITG_HISTORY_DEFAULT_SELECTION_CURRENT_BRANCH,
	GITG_HISTORY_DEFAULT_SELECTION_ALL_BRANCHES,
	GITG_HISTORY_DEFAULT_SELECTION_ALL_COMMITS
} GitgHistoryDefaultSelection;

struct _GitgHistoryRefsListParamSpecRemoteHeader {
	GParamSpec parent_instance;
};


static gpointer gitg_history_ref_row_parent_class = NULL;
static GitgHistoryRefTypedIface* gitg_history_ref_row_gitg_history_ref_typed_parent_iface = NULL;
static gpointer gitg_history_ref_header_parent_class = NULL;
static GitgHistoryRefTypedIface* gitg_history_ref_header_gitg_history_ref_typed_parent_iface = NULL;
static gpointer gitg_history_refs_list_parent_class = NULL;
static gpointer gitg_history_refs_list_remote_header_parent_class = NULL;

gint gitg_history_ref_type_sort_order (GitgRefType ref_type);
GType gitg_history_ref_animation_get_type (void) G_GNUC_CONST;
GType gitg_history_ref_typed_get_type (void) G_GNUC_CONST;
GitgRefType gitg_history_ref_typed_get_ref_type (GitgHistoryRefTyped* self);
GType gitg_history_ref_row_get_type (void) G_GNUC_CONST;
#define GITG_HISTORY_REF_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRowPrivate))
enum  {
	GITG_HISTORY_REF_ROW_DUMMY_PROPERTY,
	GITG_HISTORY_REF_ROW_REFERENCE,
	GITG_HISTORY_REF_ROW_REF_TYPE,
	GITG_HISTORY_REF_ROW_IS_HEAD
};
#define GITG_HISTORY_REF_ROW_version VERSION
GitgHistoryRefRow* gitg_history_ref_row_new (GitgRef* reference, GitgHistoryRefAnimation animation);
GitgHistoryRefRow* gitg_history_ref_row_construct (GType object_type, GitgRef* reference, GitgHistoryRefAnimation animation);
void gitg_history_ref_row_set_reference (GitgHistoryRefRow* self, GitgRef* value);
static gchar* gitg_history_ref_row_label_text (GitgHistoryRefRow* self);
gboolean gitg_history_ref_row_get_is_head (GitgHistoryRefRow* self);
static void gitg_history_ref_row_on_child_revealed (GitgHistoryRefRow* self, GObject* obj, GParamSpec* spec);
static void _gitg_history_ref_row_on_child_revealed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gitg_history_ref_row_real_map (GtkWidget* base);
GitgRef* gitg_history_ref_row_get_reference (GitgHistoryRefRow* self);
static gint gitg_history_ref_row_compare_type (GitgHistoryRefRow* self, GitgHistoryRefRow* other);
gint gitg_history_ref_row_compare_to (GitgHistoryRefRow* self, GitgHistoryRefRow* other);
void gitg_history_ref_row_begin_editing (GitgHistoryRefRow* self, GitgExtRefNameEditingDone done, void* done_target, GDestroyNotify done_target_destroy_notify);
static gboolean gitg_history_ref_row_on_editing_focus_out (GitgHistoryRefRow* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean gitg_history_ref_row_on_editing_key_press (GitgHistoryRefRow* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void gitg_history_ref_row_real_dispose (GObject* base);
static void gitg_history_ref_row_finish_editing (GitgHistoryRefRow* self, gboolean cancelled);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static gboolean __lambda96_ (Block49Data* _data49_);
static gboolean ___lambda96__gsource_func (gpointer self);
void gitg_history_ref_row_unreveal (GitgHistoryRefRow* self);
static void gitg_history_ref_row_finalize (GObject* obj);
static void _vala_gitg_history_ref_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_history_ref_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gitg_history_ref_header_get_type (void) G_GNUC_CONST;
#define GITG_HISTORY_REF_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeaderPrivate))
enum  {
	GITG_HISTORY_REF_HEADER_DUMMY_PROPERTY,
	GITG_HISTORY_REF_HEADER_REMOTE_STATE,
	GITG_HISTORY_REF_HEADER_REF_TYPE,
	GITG_HISTORY_REF_HEADER_REF_NAME,
	GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE,
	GITG_HISTORY_REF_HEADER_ICON_NAME
};
GitgHistoryRefHeader* gitg_history_ref_header_new (GitgRefType rtype, const gchar* name);
GitgHistoryRefHeader* gitg_history_ref_header_construct (GType object_type, GitgRefType rtype, const gchar* name);
GitgHistoryRefHeader* gitg_history_ref_header_new_remote (const gchar* name, GitgRemote* remote);
GitgHistoryRefHeader* gitg_history_ref_header_construct_remote (GType object_type, const gchar* name, GitgRemote* remote);
gint gitg_history_ref_header_compare_to (GitgHistoryRefHeader* self, GitgHistoryRefHeader* other);
void gitg_history_ref_header_set_remote_state (GitgHistoryRefHeader* self, GitgRemoteState value);
void gitg_history_ref_header_set_icon_name (GitgHistoryRefHeader* self, const gchar* value);
const gchar* gitg_history_ref_header_get_ref_name (GitgHistoryRefHeader* self);
gboolean gitg_history_ref_header_get_is_sub_header_remote (GitgHistoryRefHeader* self);
gchar* gitg_history_ref_header_get_icon_name (GitgHistoryRefHeader* self);
static void gitg_history_ref_header_finalize (GObject* obj);
static void _vala_gitg_history_ref_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_history_ref_header_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gitg_history_refs_list_get_type (void) G_GNUC_CONST;
static gpointer gitg_history_refs_list_remote_header_ref (gpointer instance);
static void gitg_history_refs_list_remote_header_unref (gpointer instance);
static GParamSpec* gitg_history_refs_list_param_spec_remote_header (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gitg_history_refs_list_value_set_remote_header (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gitg_history_refs_list_value_take_remote_header (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gitg_history_refs_list_value_get_remote_header (const GValue* value) G_GNUC_UNUSED;
static GType gitg_history_refs_list_remote_header_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GITG_HISTORY_REFS_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsListPrivate))
enum  {
	GITG_HISTORY_REFS_LIST_DUMMY_PROPERTY,
	GITG_HISTORY_REFS_LIST_REMOTE_LOOKUP,
	GITG_HISTORY_REFS_LIST_REPOSITORY,
	GITG_HISTORY_REFS_LIST_ALL,
	GITG_HISTORY_REFS_LIST_IS_HEADER,
	GITG_HISTORY_REFS_LIST_IS_ALL,
	GITG_HISTORY_REFS_LIST_SELECTION
};
static void gitg_history_refs_list_real_dispose (GObject* base);
static void gitg_history_refs_list_on_tip_updated (GitgHistoryRefsList* self, GgitRemote* remote, const gchar* refname, GgitOId* a, GgitOId* b);
static void _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated (GitgRemote* _sender, const gchar* refname, GgitOId* a, GgitOId* b, gpointer self);
static gint gitg_history_refs_list_sort_rows (GitgHistoryRefsList* self, GtkListBoxRow* row1, GtkListBoxRow* row2);
static void gitg_history_refs_list_clear (GitgHistoryRefsList* self);
static void gitg_history_refs_list_reselect_row (GitgHistoryRefsList* self, GtkListBoxRow* a);
void gitg_history_refs_list_add (GitgHistoryRefsList* self, GtkListBoxRow* row);
static GitgHistoryRefHeader* gitg_history_refs_list_add_header (GitgHistoryRefsList* self, GitgRefType ref_type, const gchar* name);
GitgRepository* gitg_history_refs_list_get_repository (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_add_ref (GitgHistoryRefsList* self, GitgRef* reference);
gboolean gitg_history_refs_list_remove_ref (GitgHistoryRefsList* self, GitgRef* reference);
static GitgHistoryRefHeader* gitg_history_refs_list_add_remote_header (GitgHistoryRefsList* self, const gchar* name);
GitgExtRemoteLookup* gitg_history_refs_list_get_remote_lookup (GitgHistoryRefsList* self);
static void _vala_array_add14 (GitgRemote*** array, int* length, int* size, GitgRemote* value);
static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_new (GitgHistoryRefHeader* h);
static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_construct (GType object_type, GitgHistoryRefHeader* h);
static GitgHistoryRefRow* gitg_history_refs_list_add_ref_row (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation);
static GitgHistoryRefRow* gitg_history_refs_list_add_ref_internal (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation);
void gitg_history_refs_list_replace_ref (GitgHistoryRefsList* self, GitgRef* old_ref, GitgRef* new_ref);
static gboolean gitg_history_refs_list_remove_ref_internal (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation);
static gboolean gitg_history_refs_list_ref_is_a_symbolic_head (GitgHistoryRefsList* self, GitgRef* reference);
static gboolean gitg_history_refs_list_select_nullable_row (GitgHistoryRefsList* self, GtkListBoxRow* row);
static void gitg_history_refs_list_scroll_to_row (GitgHistoryRefsList* self, GtkListBoxRow* row);
gboolean gitg_history_refs_list_select_all_commits (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_select_all_branches (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_select_all_remotes (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_select_all_tags (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_select_ref (GitgHistoryRefsList* self, GitgRef* reference);
static void gitg_history_refs_list_refresh (GitgHistoryRefsList* self);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gint ___lambda97_ (Block50Data* _data50_, const gchar* nm);
static gint ____lambda97__ggit_references_name_callback (const gchar* name, gpointer self);
GType gitg_history_default_selection_get_type (void) G_GNUC_CONST;
static GitgHistoryRefRow* gitg_history_refs_list_get_ref_row (GitgHistoryRefsList* self, GtkListBoxRow* row);
static GitgHistoryRefHeader* gitg_history_refs_list_get_ref_header (GitgHistoryRefsList* self, GtkListBoxRow* row);
static void gitg_history_refs_list_real_row_selected (GtkListBox* base, GtkListBoxRow* row);
static void gitg_history_refs_list_real_move_cursor (GtkListBox* base, GtkMovementStep step, gint n);
void gitg_history_refs_list_edit (GitgHistoryRefsList* self, GitgRef* reference, GitgExtRefNameEditingDone done, void* done_target, GDestroyNotify done_target_destroy_notify);
static gint gitg_history_refs_list_y_in_window (GitgHistoryRefsList* self, gint y, GdkWindow* origin);
static gboolean gitg_history_refs_list_real_button_press_event (GtkWidget* base, GdkEventButton* button);
GitgHistoryRefsList* gitg_history_refs_list_new (void);
GitgHistoryRefsList* gitg_history_refs_list_construct (GType object_type);
void gitg_history_refs_list_set_remote_lookup (GitgHistoryRefsList* self, GitgExtRemoteLookup* value);
void gitg_history_refs_list_set_repository (GitgHistoryRefsList* self, GitgRepository* value);
GeeList* gitg_history_refs_list_get_all (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_get_is_header (GitgHistoryRefsList* self);
gboolean gitg_history_refs_list_get_is_all (GitgHistoryRefsList* self);
GeeList* gitg_history_refs_list_get_selection (GitgHistoryRefsList* self);
static GObject * gitg_history_refs_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gint _gitg_history_refs_list_sort_rows_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
enum  {
	GITG_HISTORY_REFS_LIST_REMOTE_HEADER_DUMMY_PROPERTY
};
static void gitg_history_refs_list_remote_header_finalize (GitgHistoryRefsListRemoteHeader* obj);
static void gitg_history_refs_list_finalize (GObject* obj);
static void _vala_gitg_history_refs_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_history_refs_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint gitg_history_ref_type_sort_order (GitgRefType ref_type) {
	gint result = 0;
	GitgRefType _tmp0_ = 0;
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = ref_type;
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (_tmp0_) {
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REF_TYPE_NONE:
#line 377 "gitg-history-refs-list.c"
		{
#line 28 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = 0;
#line 28 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 383 "gitg-history-refs-list.c"
		}
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REF_TYPE_BRANCH:
#line 387 "gitg-history-refs-list.c"
		{
#line 30 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = 1;
#line 30 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 393 "gitg-history-refs-list.c"
		}
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REF_TYPE_REMOTE:
#line 397 "gitg-history-refs-list.c"
		{
#line 32 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = 2;
#line 32 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 403 "gitg-history-refs-list.c"
		}
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REF_TYPE_TAG:
#line 407 "gitg-history-refs-list.c"
		{
#line 34 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = 3;
#line 34 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 413 "gitg-history-refs-list.c"
		}
		default:
#line 25 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 418 "gitg-history-refs-list.c"
	}
#line 37 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = 4;
#line 37 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 424 "gitg-history-refs-list.c"
}


GType gitg_history_ref_animation_get_type (void) {
	static volatile gsize gitg_history_ref_animation_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_ref_animation_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_HISTORY_REF_ANIMATION_NONE, "GITG_HISTORY_REF_ANIMATION_NONE", "none"}, {GITG_HISTORY_REF_ANIMATION_ANIMATE, "GITG_HISTORY_REF_ANIMATION_ANIMATE", "animate"}, {0, NULL, NULL}};
		GType gitg_history_ref_animation_type_id;
		gitg_history_ref_animation_type_id = g_enum_register_static ("GitgHistoryRefAnimation", values);
		g_once_init_leave (&gitg_history_ref_animation_type_id__volatile, gitg_history_ref_animation_type_id);
	}
	return gitg_history_ref_animation_type_id__volatile;
}


GitgRefType gitg_history_ref_typed_get_ref_type (GitgHistoryRefTyped* self) {
#line 48 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return GITG_HISTORY_REF_TYPED_GET_INTERFACE (self)->get_ref_type (self);
#line 445 "gitg-history-refs-list.c"
}


static void gitg_history_ref_typed_base_init (GitgHistoryRefTypedIface * iface) {
#line 46 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	static gboolean initialized = FALSE;
#line 46 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!initialized) {
#line 46 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		initialized = TRUE;
#line 46 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_interface_install_property (iface, g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 458 "gitg-history-refs-list.c"
	}
}


GType gitg_history_ref_typed_get_type (void) {
	static volatile gsize gitg_history_ref_typed_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_ref_typed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefTypedIface), (GBaseInitFunc) gitg_history_ref_typed_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gitg_history_ref_typed_type_id;
		gitg_history_ref_typed_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgHistoryRefTyped", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gitg_history_ref_typed_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gitg_history_ref_typed_type_id__volatile, gitg_history_ref_typed_type_id);
	}
	return gitg_history_ref_typed_type_id__volatile;
}


static void _gitg_history_ref_row_on_child_revealed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 111 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_on_child_revealed ((GitgHistoryRefRow*) self, _sender, pspec);
#line 479 "gitg-history-refs-list.c"
}


GitgHistoryRefRow* gitg_history_ref_row_construct (GType object_type, GitgRef* reference, GitgHistoryRefAnimation animation) {
	GitgHistoryRefRow * self = NULL;
	GitgRef* _tmp0_ = NULL;
	GitgHistoryRefAnimation _tmp1_ = 0;
	GtkLabel* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GitgRef* _tmp11_ = NULL;
	GitgRefType _tmp16_ = 0;
	GitgRefType _tmp17_ = 0;
	GtkRevealer* _tmp22_ = NULL;
#line 80 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefRow*) g_object_new (object_type, NULL);
#line 82 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 82 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_set_reference (self, _tmp0_);
#line 84 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = animation;
#line 84 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_ == GITG_HISTORY_REF_ANIMATION_ANIMATE) {
#line 506 "gitg-history-refs-list.c"
		GtkRevealer* _tmp2_ = NULL;
#line 86 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = self->priv->d_revealer;
#line 86 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_revealer_set_transition_type (_tmp2_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
#line 512 "gitg-history-refs-list.c"
	} else {
		GtkRevealer* _tmp3_ = NULL;
#line 90 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = self->priv->d_revealer;
#line 90 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_revealer_set_reveal_child (_tmp3_, TRUE);
#line 519 "gitg-history-refs-list.c"
	}
#line 93 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_label;
#line 93 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gitg_history_ref_row_label_text (self);
#line 93 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = _tmp5_;
#line 93 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_label_set_label (_tmp4_, _tmp6_);
#line 93 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp6_);
#line 95 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_history_ref_row_get_is_head (self);
#line 95 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _tmp7_;
#line 95 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp8_) {
#line 537 "gitg-history-refs-list.c"
		GtkImage* _tmp9_ = NULL;
		GtkImage* _tmp10_ = NULL;
#line 97 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = self->priv->d_icon;
#line 97 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_set (_tmp9_, "icon-name", "object-select-symbolic", NULL);
#line 98 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = self->priv->d_icon;
#line 98 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_show ((GtkWidget*) _tmp10_);
#line 548 "gitg-history-refs-list.c"
	}
#line 101 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = reference;
#line 101 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp11_ != NULL) {
#line 554 "gitg-history-refs-list.c"
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 103 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = gtk_bin_get_child ((GtkBin*) self);
#line 103 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = gtk_bin_get_child ((GtkBin*) self);
#line 103 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = gtk_widget_get_margin_start (_tmp13_);
#line 103 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = _tmp14_;
#line 103 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_set_margin_start (_tmp13_, _tmp15_ + 12);
#line 569 "gitg-history-refs-list.c"
	}
#line 106 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp16_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self);
#line 106 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp17_ = _tmp16_;
#line 106 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp17_ == GITG_REF_TYPE_REMOTE) {
#line 577 "gitg-history-refs-list.c"
		GtkWidget* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = gtk_bin_get_child ((GtkBin*) self);
#line 108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = gtk_bin_get_child ((GtkBin*) self);
#line 108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp20_ = gtk_widget_get_margin_start (_tmp19_);
#line 108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp21_ = _tmp20_;
#line 108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_set_margin_start (_tmp19_, _tmp21_ + 12);
#line 592 "gitg-history-refs-list.c"
	}
#line 111 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp22_ = self->priv->d_revealer;
#line 111 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_connect_object ((GObject*) _tmp22_, "notify::child-revealed", (GCallback) _gitg_history_ref_row_on_child_revealed_g_object_notify, self, 0);
#line 80 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self;
#line 600 "gitg-history-refs-list.c"
}


GitgHistoryRefRow* gitg_history_ref_row_new (GitgRef* reference, GitgHistoryRefAnimation animation) {
#line 80 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return gitg_history_ref_row_construct (GITG_HISTORY_TYPE_REF_ROW, reference, animation);
#line 607 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_on_child_revealed (GitgHistoryRefRow* self, GObject* obj, GParamSpec* spec) {
	GtkRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (obj != NULL);
#line 114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (spec != NULL);
#line 116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_revealer;
#line 116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
#line 116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!_tmp2_) {
#line 629 "gitg-history-refs-list.c"
		GtkAllocation alloc = {0};
		GtkRevealer* _tmp3_ = NULL;
		GtkAllocation _tmp4_ = {0};
#line 119 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = self->priv->d_revealer;
#line 119 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_get_allocation ((GtkWidget*) _tmp3_, &_tmp4_);
#line 119 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		alloc = _tmp4_;
#line 121 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 641 "gitg-history-refs-list.c"
	}
}


static void gitg_history_ref_row_real_map (GtkWidget* base) {
	GitgHistoryRefRow * self;
	GtkRevealer* _tmp0_ = NULL;
#line 125 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefRow*) base;
#line 127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	GTK_WIDGET_CLASS (gitg_history_ref_row_parent_class)->map ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
#line 129 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_revealer;
#line 129 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
#line 657 "gitg-history-refs-list.c"
}


static gchar* gitg_history_ref_row_label_text (GitgHistoryRefRow* self) {
	gchar* result = NULL;
	GitgRef* _tmp0_ = NULL;
	GitgParsedRefName* pn = NULL;
	GitgRef* _tmp3_ = NULL;
	GitgParsedRefName* _tmp4_ = NULL;
	GitgParsedRefName* _tmp5_ = NULL;
	GitgParsedRefName* _tmp6_ = NULL;
	GitgRefType _tmp7_ = 0;
	GitgRefType _tmp8_ = 0;
	GitgParsedRefName* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 132 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_reference;
#line 134 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 680 "gitg-history-refs-list.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp1_ = _ ("All commits");
#line 136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp2_;
#line 136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 691 "gitg-history-refs-list.c"
	}
#line 139 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = self->priv->_reference;
#line 139 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gitg_ref_get_parsed_name (_tmp3_);
#line 139 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_;
#line 139 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	pn = _tmp5_;
#line 141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = pn;
#line 141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_parsed_ref_name_get_rtype (_tmp6_);
#line 141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _tmp7_;
#line 141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp8_ == GITG_REF_TYPE_REMOTE) {
#line 709 "gitg-history-refs-list.c"
		GitgParsedRefName* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = pn;
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = gitg_parsed_ref_name_get_remote_branch (_tmp9_);
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = _tmp10_;
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp11_;
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (pn);
#line 143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 725 "gitg-history-refs-list.c"
	}
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = pn;
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = gitg_parsed_ref_name_get_shortname (_tmp12_);
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp14_ = _tmp13_;
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp14_;
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (pn);
#line 146 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 739 "gitg-history-refs-list.c"
}


static gint gitg_history_ref_row_compare_type (GitgHistoryRefRow* self, GitgHistoryRefRow* other) {
	gint result = 0;
	GitgParsedRefName* pnme = NULL;
	GitgRef* _tmp0_ = NULL;
	GitgParsedRefName* _tmp1_ = NULL;
	GitgParsedRefName* _tmp2_ = NULL;
	GitgParsedRefName* pnot = NULL;
	GitgHistoryRefRow* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	GitgParsedRefName* _tmp5_ = NULL;
	GitgParsedRefName* _tmp6_ = NULL;
	GitgParsedRefName* _tmp7_ = NULL;
	GitgRefType _tmp8_ = 0;
	GitgRefType _tmp9_ = 0;
	GitgParsedRefName* _tmp10_ = NULL;
	GitgRefType _tmp11_ = 0;
	GitgRefType _tmp12_ = 0;
	GitgParsedRefName* _tmp27_ = NULL;
	GitgRefType _tmp28_ = 0;
	GitgRefType _tmp29_ = 0;
#line 172 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 172 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_reference;
#line 174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_ref_get_parsed_name (_tmp0_);
#line 174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	pnme = _tmp2_;
#line 175 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = other;
#line 175 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = _tmp3_->priv->_reference;
#line 175 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gitg_ref_get_parsed_name (_tmp4_);
#line 175 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = _tmp5_;
#line 175 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	pnot = _tmp6_;
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = pnme;
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = gitg_parsed_ref_name_get_rtype (_tmp7_);
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = _tmp8_;
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = pnot;
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = gitg_parsed_ref_name_get_rtype (_tmp10_);
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = _tmp11_;
#line 177 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp9_ != _tmp12_) {
#line 799 "gitg-history-refs-list.c"
		gint i1 = 0;
		GitgParsedRefName* _tmp13_ = NULL;
		GitgRefType _tmp14_ = 0;
		GitgRefType _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint i2 = 0;
		GitgParsedRefName* _tmp17_ = NULL;
		GitgRefType _tmp18_ = 0;
		GitgRefType _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 179 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = pnme;
#line 179 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = gitg_parsed_ref_name_get_rtype (_tmp13_);
#line 179 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = _tmp14_;
#line 179 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = gitg_history_ref_type_sort_order (_tmp15_);
#line 179 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		i1 = _tmp16_;
#line 180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp17_ = pnot;
#line 180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = gitg_parsed_ref_name_get_rtype (_tmp17_);
#line 180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = _tmp18_;
#line 180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp20_ = gitg_history_ref_type_sort_order (_tmp19_);
#line 180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		i2 = _tmp20_;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp22_ = i1;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp23_ = i2;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp22_ < _tmp23_) {
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = -1;
#line 841 "gitg-history-refs-list.c"
		} else {
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp25_ = i1;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp26_ = i2;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (_tmp25_ > _tmp26_) {
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp24_ = 1;
#line 854 "gitg-history-refs-list.c"
			} else {
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp24_ = 0;
#line 858 "gitg-history-refs-list.c"
			}
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = _tmp24_;
#line 862 "gitg-history-refs-list.c"
		}
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp21_;
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (pnot);
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (pnme);
#line 182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 872 "gitg-history-refs-list.c"
	}
#line 185 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp27_ = pnme;
#line 185 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp28_ = gitg_parsed_ref_name_get_rtype (_tmp27_);
#line 185 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp29_ = _tmp28_;
#line 185 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp29_ == GITG_REF_TYPE_REMOTE) {
#line 882 "gitg-history-refs-list.c"
		GitgParsedRefName* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		GitgParsedRefName* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp30_ = pnme;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp31_ = gitg_parsed_ref_name_get_remote_name (_tmp30_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp32_ = _tmp31_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp33_ = _tmp32_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp34_ = g_utf8_casefold (_tmp33_, (gssize) (-1));
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp35_ = _tmp34_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp36_ = pnot;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp37_ = gitg_parsed_ref_name_get_remote_name (_tmp36_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp38_ = _tmp37_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp39_ = _tmp38_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp40_ = g_utf8_casefold (_tmp39_, (gssize) (-1));
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp41_ = _tmp40_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp42_ = g_utf8_collate (_tmp35_, _tmp41_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp43_ = _tmp42_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (_tmp41_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (_tmp39_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (_tmp35_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (_tmp33_);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp43_;
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (pnot);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (pnme);
#line 187 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 941 "gitg-history-refs-list.c"
	}
#line 190 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = 0;
#line 190 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (pnot);
#line 190 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (pnme);
#line 190 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 951 "gitg-history-refs-list.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 976 "gitg-history-refs-list.c"
		gchar* _tmp4_ = NULL;
#line 924 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 984 "gitg-history-refs-list.c"
	} else {
#line 926 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 990 "gitg-history-refs-list.c"
	}
}


gint gitg_history_ref_row_compare_to (GitgHistoryRefRow* self, GitgHistoryRefRow* other) {
	gint result = 0;
	GitgRef* _tmp0_ = NULL;
	GitgHistoryRefRow* _tmp1_ = NULL;
	GitgRef* _tmp2_ = NULL;
	gint ct = 0;
	GitgHistoryRefRow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* t1 = NULL;
	gchar* _tmp6_ = NULL;
	gchar* t2 = NULL;
	GitgHistoryRefRow* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint hassep1 = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint hassep2 = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 193 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 193 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 195 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_reference;
#line 195 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 197 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = -1;
#line 197 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1037 "gitg-history-refs-list.c"
	}
#line 200 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = other;
#line 200 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_->priv->_reference;
#line 200 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_ == NULL) {
#line 202 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = 1;
#line 202 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1049 "gitg-history-refs-list.c"
	}
#line 205 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = other;
#line 205 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gitg_history_ref_row_compare_type (self, _tmp3_);
#line 205 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ct = _tmp4_;
#line 207 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = ct;
#line 207 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp5_ != 0) {
#line 209 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = ct;
#line 209 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1065 "gitg-history-refs-list.c"
	}
#line 212 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gitg_history_ref_row_label_text (self);
#line 212 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	t1 = _tmp6_;
#line 213 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = other;
#line 213 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = gitg_history_ref_row_label_text (_tmp7_);
#line 213 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	t2 = _tmp8_;
#line 215 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = t1;
#line 215 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = string_index_of_char (_tmp9_, (gunichar) '/', 0);
#line 215 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	hassep1 = _tmp10_;
#line 216 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = t2;
#line 216 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = string_index_of_char (_tmp11_, (gunichar) '/', 0);
#line 216 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	hassep2 = _tmp12_;
#line 218 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = hassep1;
#line 218 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp14_ = hassep2;
#line 218 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if ((_tmp13_ >= 0) != (_tmp14_ >= 0)) {
#line 1095 "gitg-history-refs-list.c"
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = hassep1;
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp16_ >= 0) {
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = 1;
#line 1104 "gitg-history-refs-list.c"
		} else {
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = -1;
#line 1108 "gitg-history-refs-list.c"
		}
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp15_;
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (t2);
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (t1);
#line 220 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1118 "gitg-history-refs-list.c"
	}
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp17_ = t1;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp18_ = g_utf8_casefold (_tmp17_, (gssize) (-1));
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp19_ = _tmp18_;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp20_ = t2;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) (-1));
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp22_ = _tmp21_;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp23_ = g_utf8_collate (_tmp19_, _tmp22_);
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp24_ = _tmp23_;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp22_);
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp19_);
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp24_;
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (t2);
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (t1);
#line 223 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1148 "gitg-history-refs-list.c"
}


static gboolean _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = gitg_history_ref_row_on_editing_focus_out ((GitgHistoryRefRow*) self, _sender, event);
#line 248 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1157 "gitg-history-refs-list.c"
}


static gboolean _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gitg_history_ref_row_on_editing_key_press ((GitgHistoryRefRow*) self, _sender, event);
#line 249 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1166 "gitg-history-refs-list.c"
}


void gitg_history_ref_row_begin_editing (GitgHistoryRefRow* self, GitgExtRefNameEditingDone done, void* done_target, GDestroyNotify done_target_destroy_notify) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	GtkEntry* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GitgExtRefNameEditingDone _tmp9_ = NULL;
	void* _tmp9__target = NULL;
	GDestroyNotify _tmp9__target_destroy_notify = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GtkEntry* _tmp15_ = NULL;
	GtkEntry* _tmp16_ = NULL;
#line 226 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 228 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_editing_entry;
#line 228 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ != NULL) {
#line 230 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
#line 230 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done = NULL;
#line 230 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done_target = NULL;
#line 230 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done_target_destroy_notify = NULL;
#line 230 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 1206 "gitg-history-refs-list.c"
	}
#line 233 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = (GtkEntry*) gtk_entry_new ();
#line 233 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_ref_sink (_tmp1_);
#line 233 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_editing_entry);
#line 233 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_editing_entry = _tmp1_;
#line 234 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = self->priv->d_editing_entry;
#line 234 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_entry_set_width_chars (_tmp2_, 1);
#line 235 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = self->priv->d_editing_entry;
#line 235 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
#line 235 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_style_context_add_class (_tmp4_, "ref_editing_entry");
#line 236 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = self->priv->d_editing_entry;
#line 236 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 238 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = self->priv->d_editing_entry;
#line 238 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_history_ref_row_label_text (self);
#line 238 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _tmp7_;
#line 238 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_entry_set_text (_tmp6_, _tmp8_);
#line 238 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp8_);
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = done;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9__target = done_target;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9__target_destroy_notify = done_target_destroy_notify;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target_destroy_notify = NULL;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback = NULL;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target = NULL;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback = _tmp9_;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target = _tmp9__target;
#line 240 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target_destroy_notify = _tmp9__target_destroy_notify;
#line 242 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = self->priv->d_label;
#line 242 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_hide ((GtkWidget*) _tmp10_);
#line 243 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = self->priv->d_box;
#line 243 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = self->priv->d_editing_entry;
#line 243 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_box_pack_start (_tmp11_, (GtkWidget*) _tmp12_, TRUE, TRUE, (guint) 0);
#line 245 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = self->priv->d_editing_entry;
#line 245 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp13_);
#line 246 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp14_ = self->priv->d_editing_entry;
#line 246 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_editable_select_region ((GtkEditable*) _tmp14_, 0, -1);
#line 248 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp15_ = self->priv->d_editing_entry;
#line 248 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_connect_object ((GtkWidget*) _tmp15_, "focus-out-event", (GCallback) _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event, self, 0);
#line 249 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp16_ = self->priv->d_editing_entry;
#line 249 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_connect_object ((GtkWidget*) _tmp16_, "key-press-event", (GCallback) _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event, self, 0);
#line 226 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
#line 226 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done = NULL;
#line 226 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target = NULL;
#line 226 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target_destroy_notify = NULL;
#line 1296 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_real_dispose (GObject* base) {
	GitgHistoryRefRow * self;
	guint _tmp0_ = 0U;
#line 252 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefRow*) base;
#line 254 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_idle_finish;
#line 254 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 1309 "gitg-history-refs-list.c"
		guint _tmp1_ = 0U;
#line 256 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp1_ = self->priv->d_idle_finish;
#line 256 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_source_remove (_tmp1_);
#line 257 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self->priv->d_idle_finish = (guint) 0;
#line 1317 "gitg-history-refs-list.c"
	}
#line 260 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (gitg_history_ref_row_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
#line 1321 "gitg-history-refs-list.c"
}


static Block49Data* block49_data_ref (Block49Data* _data49_) {
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_atomic_int_inc (&_data49_->_ref_count_);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return _data49_;
#line 1330 "gitg-history-refs-list.c"
}


static void block49_data_unref (void * _userdata_) {
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
#line 1339 "gitg-history-refs-list.c"
		GitgHistoryRefRow* self;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self = _data49_->self;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_slice_free (Block49Data, _data49_);
#line 1347 "gitg-history-refs-list.c"
	}
}


static gboolean __lambda96_ (Block49Data* _data49_) {
	GitgHistoryRefRow* self;
	gboolean result = FALSE;
	gchar* new_text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GitgExtRefNameEditingDone _tmp6_ = NULL;
	void* _tmp6__target = NULL;
	gboolean _tmp7_ = FALSE;
#line 273 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = _data49_->self;
#line 274 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_idle_finish = (guint) 0;
#line 276 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_editing_entry;
#line 276 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 276 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 276 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 276 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	new_text = _tmp3_;
#line 278 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_editing_entry;
#line 278 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 279 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_editing_entry);
#line 279 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_editing_entry = NULL;
#line 281 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = self->priv->d_label;
#line 281 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 283 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = self->priv->d_edit_done_callback;
#line 283 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6__target = self->priv->d_edit_done_callback_target;
#line 283 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = _data49_->cancelled;
#line 283 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ (new_text, _tmp7_, _tmp6__target);
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback = NULL;
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target = NULL;
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback = NULL;
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target = NULL;
#line 284 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
#line 285 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 285 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (new_text);
#line 285 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1419 "gitg-history-refs-list.c"
}


static gboolean ___lambda96__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda96_ (self);
#line 273 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1428 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_finish_editing (GitgHistoryRefRow* self, gboolean cancelled) {
	Block49Data* _data49_;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	GtkEntry* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkEntry* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data49_ = g_slice_new0 (Block49Data);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data49_->_ref_count_ = 1;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data49_->self = g_object_ref (self);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = cancelled;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data49_->cancelled = _tmp0_;
#line 265 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = self->priv->d_idle_finish;
#line 265 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 267 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		block49_data_unref (_data49_);
#line 267 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_data49_ = NULL;
#line 267 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 1463 "gitg-history-refs-list.c"
	}
#line 270 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = self->priv->d_editing_entry;
#line 270 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_parse_name ("focus-out-event", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
#line 270 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gitg_history_ref_row_on_editing_focus_out_gtk_widget_focus_out_event, self);
#line 271 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_editing_entry;
#line 271 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp5_, NULL, FALSE);
#line 271 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gitg_history_ref_row_on_editing_key_press_gtk_widget_key_press_event, self);
#line 273 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda96__gsource_func, block49_data_ref (_data49_), block49_data_unref);
#line 273 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_idle_finish = _tmp6_;
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	block49_data_unref (_data49_);
#line 263 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data49_ = NULL;
#line 1485 "gitg-history-refs-list.c"
}


static gboolean gitg_history_ref_row_on_editing_focus_out (GitgHistoryRefRow* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 289 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 289 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 289 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 291 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_finish_editing (self, FALSE);
#line 292 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 292 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1503 "gitg-history-refs-list.c"
}


static gboolean gitg_history_ref_row_on_editing_key_press (GitgHistoryRefRow* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 295 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 295 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 295 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 297 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = event;
#line 297 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _tmp0_->keyval;
#line 297 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_ == ((guint) GDK_KEY_Escape)) {
#line 299 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_ref_row_finish_editing (self, TRUE);
#line 300 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = TRUE;
#line 300 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1529 "gitg-history-refs-list.c"
	} else {
		gboolean _tmp2_ = FALSE;
		GdkEventKey* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 302 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = event;
#line 302 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = _tmp3_->keyval;
#line 302 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp4_ == ((guint) GDK_KEY_KP_Enter)) {
#line 302 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp2_ = TRUE;
#line 1542 "gitg-history-refs-list.c"
		} else {
			GdkEventKey* _tmp5_ = NULL;
			guint _tmp6_ = 0U;
#line 303 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp5_ = event;
#line 303 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp6_ = _tmp5_->keyval;
#line 303 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp2_ = _tmp6_ == ((guint) GDK_KEY_Return);
#line 1552 "gitg-history-refs-list.c"
		}
#line 302 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp2_) {
#line 305 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_history_ref_row_finish_editing (self, FALSE);
#line 306 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = TRUE;
#line 306 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 1562 "gitg-history-refs-list.c"
		}
	}
#line 309 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 309 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1569 "gitg-history-refs-list.c"
}


void gitg_history_ref_row_unreveal (GitgHistoryRefRow* self) {
	GtkRevealer* _tmp0_ = NULL;
	GtkRevealer* _tmp1_ = NULL;
#line 312 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_revealer;
#line 314 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_revealer_set_transition_type (_tmp0_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
#line 315 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = self->priv->d_revealer;
#line 315 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
#line 1586 "gitg-history-refs-list.c"
}


GitgRef* gitg_history_ref_row_get_reference (GitgHistoryRefRow* self) {
	GitgRef* result;
	GitgRef* _tmp0_ = NULL;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_reference;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1601 "gitg-history-refs-list.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self ? g_object_ref (self) : NULL;
#line 1608 "gitg-history-refs-list.c"
}


void gitg_history_ref_row_set_reference (GitgHistoryRefRow* self, GitgRef* value) {
	GitgRef* _tmp0_ = NULL;
	GitgRef* _tmp1_ = NULL;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = value;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->_reference);
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->_reference = _tmp1_;
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject *) self, "reference");
#line 1627 "gitg-history-refs-list.c"
}


static GitgRefType gitg_history_ref_row_real_get_ref_type (GitgHistoryRefTyped* base) {
	GitgRefType result;
	GitgHistoryRefRow* self;
	GitgRefType _tmp0_ = 0;
	GitgRef* _tmp1_ = NULL;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefRow*) base;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = self->priv->_reference;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_ != NULL) {
#line 1642 "gitg-history-refs-list.c"
		GitgRef* _tmp2_ = NULL;
		GitgParsedRefName* _tmp3_ = NULL;
		GitgParsedRefName* _tmp4_ = NULL;
		GitgParsedRefName* _tmp5_ = NULL;
		GitgRefType _tmp6_ = 0;
		GitgRefType _tmp7_ = 0;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = self->priv->_reference;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = gitg_ref_get_parsed_name (_tmp2_);
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = _tmp3_;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = _tmp4_;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = gitg_parsed_ref_name_get_rtype (_tmp5_);
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = _tmp6_;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp0_ = _tmp7_;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp5_);
#line 1665 "gitg-history-refs-list.c"
	} else {
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp0_ = GITG_REF_TYPE_NONE;
#line 1669 "gitg-history-refs-list.c"
	}
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 77 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1675 "gitg-history-refs-list.c"
}


gboolean gitg_history_ref_row_get_is_head (GitgHistoryRefRow* self) {
	gboolean result;
	GitgRef* _tmp0_ = NULL;
	GgitBranch* branch = NULL;
	GitgRef* _tmp1_ = NULL;
	GgitBranch* _tmp2_ = NULL;
	GgitBranch* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 153 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_reference;
#line 153 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = FALSE;
#line 155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 1697 "gitg-history-refs-list.c"
	}
#line 158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = self->priv->_reference;
#line 158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ggit_branch_get_type ()) ? ((GgitBranch*) _tmp1_) : NULL);
#line 158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	branch = _tmp2_;
#line 160 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = branch;
#line 160 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp3_ != NULL) {
#line 1709 "gitg-history-refs-list.c"
		{
			gboolean _tmp4_ = FALSE;
			GgitBranch* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp5_ = branch;
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp6_ = ggit_branch_is_head (_tmp5_, &_inner_error_);
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp4_ = _tmp6_;
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1722 "gitg-history-refs-list.c"
				goto __catch78_g_error;
			}
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp4_;
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (branch);
#line 164 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 1731 "gitg-history-refs-list.c"
		}
		goto __finally78;
		__catch78_g_error:
		{
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			g_clear_error (&_inner_error_);
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_inner_error_ = NULL;
#line 165 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = FALSE;
#line 165 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (branch);
#line 165 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 1746 "gitg-history-refs-list.c"
		}
		__finally78:
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (branch);
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return FALSE;
#line 1757 "gitg-history-refs-list.c"
	}
#line 168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (branch);
#line 168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 1765 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_class_init (GitgHistoryRefRowClass * klass) {
	gint GitgHistoryRefRow_private_offset;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_parent_class = g_type_class_peek_parent (klass);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_type_class_add_private (klass, sizeof (GitgHistoryRefRowPrivate));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GtkWidgetClass *) klass)->map = gitg_history_ref_row_real_map;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GObjectClass *) klass)->dispose = gitg_history_ref_row_real_dispose;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_ref_row_get_property;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_ref_row_set_property;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_history_ref_row_finalize;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_REFERENCE, g_param_spec_object ("reference", "reference", "reference", GITG_TYPE_REF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_REF_TYPE, g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_ROW_IS_HEAD, g_param_spec_boolean ("is-head", "is-head", "is-head", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	GitgHistoryRefRow_private_offset = g_type_class_get_instance_private_offset (klass);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-history-ref-row.ui");
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_icon", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_icon));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_label", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_label));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_box", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_box));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_revealer", FALSE, GitgHistoryRefRow_private_offset + G_STRUCT_OFFSET (GitgHistoryRefRowPrivate, d_revealer));
#line 1803 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_gitg_history_ref_typed_interface_init (GitgHistoryRefTypedIface * iface) {
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_gitg_history_ref_typed_parent_iface = g_type_interface_peek_parent (iface);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	iface->get_ref_type = gitg_history_ref_row_real_get_ref_type;
#line 1812 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_instance_init (GitgHistoryRefRow * self) {
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv = GITG_HISTORY_REF_ROW_GET_PRIVATE (self);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1821 "gitg-history-refs-list.c"
}


static void gitg_history_ref_row_finalize (GObject* obj) {
	GitgHistoryRefRow * self;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
#line 57 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_icon);
#line 60 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_label);
#line 63 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_box);
#line 66 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_revealer);
#line 68 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->_reference);
#line 70 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_editing_entry);
#line 73 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(self->priv->d_edit_done_callback_target_destroy_notify == NULL) ? NULL : (self->priv->d_edit_done_callback_target_destroy_notify (self->priv->d_edit_done_callback_target), NULL);
#line 73 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback = NULL;
#line 73 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target = NULL;
#line 73 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_edit_done_callback_target_destroy_notify = NULL;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (gitg_history_ref_row_parent_class)->finalize (obj);
#line 1851 "gitg-history-refs-list.c"
}


GType gitg_history_ref_row_get_type (void) {
	static volatile gsize gitg_history_ref_row_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_ref_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_ref_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefRow), 0, (GInstanceInitFunc) gitg_history_ref_row_instance_init, NULL };
		static const GInterfaceInfo gitg_history_ref_typed_info = { (GInterfaceInitFunc) gitg_history_ref_row_gitg_history_ref_typed_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gitg_history_ref_row_type_id;
		gitg_history_ref_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgHistoryRefRow", &g_define_type_info, 0);
		g_type_add_interface_static (gitg_history_ref_row_type_id, GITG_HISTORY_TYPE_REF_TYPED, &gitg_history_ref_typed_info);
		g_once_init_leave (&gitg_history_ref_row_type_id__volatile, gitg_history_ref_row_type_id);
	}
	return gitg_history_ref_row_type_id__volatile;
}


static void _vala_gitg_history_ref_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgHistoryRefRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_ROW_REFERENCE:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_object (value, gitg_history_ref_row_get_reference (self));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_ROW_REF_TYPE:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_enum (value, gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_ROW_IS_HEAD:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_boolean (value, gitg_history_ref_row_get_is_head (self));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 1892 "gitg-history-refs-list.c"
		default:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 1898 "gitg-history-refs-list.c"
	}
}


static void _vala_gitg_history_ref_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgHistoryRefRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_ROW, GitgHistoryRefRow);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_ROW_REFERENCE:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_ref_row_set_reference (self, g_value_get_object (value));
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 1914 "gitg-history-refs-list.c"
		default:
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 52 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 1920 "gitg-history-refs-list.c"
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1314 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1315 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = self;
#line 1315 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1933 "gitg-history-refs-list.c"
}


GitgHistoryRefHeader* gitg_history_ref_header_construct (GType object_type, GitgRefType rtype, const gchar* name) {
	GitgHistoryRefHeader * self = NULL;
	gchar* escaped = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GitgRefType _tmp8_ = 0;
#line 369 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 369 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefHeader*) g_object_new (object_type, NULL);
#line 371 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = name;
#line 371 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = g_markup_escape_text (_tmp0_, (gssize) (-1));
#line 371 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	escaped = _tmp1_;
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = self->priv->d_label;
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = string_to_string (escaped);
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = g_strconcat ("<b>", _tmp3_, "</b>", NULL);
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_;
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_label_set_markup (_tmp2_, _tmp5_);
#line 373 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp5_);
#line 375 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = name;
#line 375 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 375 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (self->priv->d_name);
#line 375 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_name = _tmp7_;
#line 376 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = rtype;
#line 376 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_rtype = _tmp8_;
#line 369 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (escaped);
#line 369 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self;
#line 1987 "gitg-history-refs-list.c"
}


GitgHistoryRefHeader* gitg_history_ref_header_new (GitgRefType rtype, const gchar* name) {
#line 369 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return gitg_history_ref_header_construct (GITG_HISTORY_TYPE_REF_HEADER, rtype, name);
#line 1994 "gitg-history-refs-list.c"
}


GitgHistoryRefHeader* gitg_history_ref_header_construct_remote (GType object_type, const gchar* name, GitgRemote* remote) {
	GitgHistoryRefHeader * self = NULL;
	const gchar* _tmp0_ = NULL;
	GitgRemote* _tmp1_ = NULL;
	GitgRemote* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GitgRemote* _tmp7_ = NULL;
#line 379 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 381 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = name;
#line 381 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefHeader*) gitg_history_ref_header_construct (object_type, GITG_REF_TYPE_REMOTE, _tmp0_);
#line 383 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = remote;
#line 383 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 383 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_remote);
#line 383 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remote = _tmp2_;
#line 384 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_is_sub_header_remote = TRUE;
#line 385 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = self->priv->d_label;
#line 385 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_label;
#line 385 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gtk_widget_get_margin_start ((GtkWidget*) _tmp4_);
#line 385 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = _tmp5_;
#line 385 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, _tmp6_ + 12);
#line 387 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = self->priv->d_remote;
#line 387 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp7_ != NULL) {
#line 2038 "gitg-history-refs-list.c"
		GitgRemote* _tmp8_ = NULL;
		GitgRemote* _tmp9_ = NULL;
		GitgProgressBin* _tmp10_ = NULL;
#line 389 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = self->priv->d_remote;
#line 389 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_bind_property_with_closures ((GObject*) _tmp8_, "state", (GObject*) self, "remote_state", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 390 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = self->priv->d_remote;
#line 390 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = self->priv->d_progress_bin;
#line 390 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_bind_property_with_closures ((GObject*) _tmp9_, "transfer-progress", (GObject*) _tmp10_, "fraction", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 2052 "gitg-history-refs-list.c"
	}
#line 379 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self;
#line 2056 "gitg-history-refs-list.c"
}


GitgHistoryRefHeader* gitg_history_ref_header_new_remote (const gchar* name, GitgRemote* remote) {
#line 379 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return gitg_history_ref_header_construct_remote (GITG_HISTORY_TYPE_REF_HEADER, name, remote);
#line 2063 "gitg-history-refs-list.c"
}


gint gitg_history_ref_header_compare_to (GitgHistoryRefHeader* self, GitgHistoryRefHeader* other) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GitgHistoryRefHeader* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GitgHistoryRefHeader* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 399 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 399 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 402 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_is_sub_header_remote;
#line 402 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = other;
#line 402 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_->priv->d_is_sub_header_remote;
#line 402 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ != _tmp2_) {
#line 2093 "gitg-history-refs-list.c"
		gint _tmp3_ = 0;
		gboolean _tmp4_ = FALSE;
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = self->priv->d_is_sub_header_remote;
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp4_) {
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp3_ = 1;
#line 2102 "gitg-history-refs-list.c"
		} else {
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp3_ = -1;
#line 2106 "gitg-history-refs-list.c"
		}
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp3_;
#line 404 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 2112 "gitg-history-refs-list.c"
	}
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = self->priv->d_name;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) (-1));
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = _tmp6_;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = other;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = _tmp8_->priv->d_name;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) (-1));
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = _tmp10_;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = g_utf8_collate (_tmp7_, _tmp11_);
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = _tmp12_;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp11_);
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (_tmp7_);
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp13_;
#line 407 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 2140 "gitg-history-refs-list.c"
}


void gitg_history_ref_header_set_remote_state (GitgHistoryRefHeader* self, GitgRemoteState value) {
	GitgRemoteState _tmp0_ = 0;
#line 328 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = value;
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (_tmp0_) {
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REMOTE_STATE_DISCONNECTED:
#line 2154 "gitg-history-refs-list.c"
		{
#line 333 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_history_ref_header_set_icon_name (self, NULL);
#line 334 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 2160 "gitg-history-refs-list.c"
		}
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REMOTE_STATE_CONNECTING:
#line 2164 "gitg-history-refs-list.c"
		{
#line 336 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_history_ref_header_set_icon_name (self, "network-wireless-acquiring-symbolic");
#line 337 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 2170 "gitg-history-refs-list.c"
		}
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REMOTE_STATE_CONNECTED:
#line 2174 "gitg-history-refs-list.c"
		{
#line 339 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_history_ref_header_set_icon_name (self, "network-idle-symbolic");
#line 340 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 2180 "gitg-history-refs-list.c"
		}
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_REMOTE_STATE_TRANSFERRING:
#line 2184 "gitg-history-refs-list.c"
		{
#line 342 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_history_ref_header_set_icon_name (self, "network-transmit-receive-symbolic");
#line 343 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 2190 "gitg-history-refs-list.c"
		}
		default:
#line 330 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 2195 "gitg-history-refs-list.c"
	}
#line 328 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject *) self, "remote-state");
#line 2199 "gitg-history-refs-list.c"
}


static GitgRefType gitg_history_ref_header_real_get_ref_type (GitgHistoryRefTyped* base) {
	GitgRefType result;
	GitgHistoryRefHeader* self;
	GitgRefType _tmp0_ = 0;
#line 361 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefHeader*) base;
#line 361 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_rtype;
#line 361 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 361 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 2215 "gitg-history-refs-list.c"
}


const gchar* gitg_history_ref_header_get_ref_name (GitgHistoryRefHeader* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 366 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 366 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_name;
#line 366 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 366 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 2230 "gitg-history-refs-list.c"
}


gboolean gitg_history_ref_header_get_is_sub_header_remote (GitgHistoryRefHeader* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 396 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 396 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_is_sub_header_remote;
#line 396 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 396 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 2245 "gitg-history-refs-list.c"
}


gchar* gitg_history_ref_header_get_icon_name (GitgHistoryRefHeader* self) {
	gchar* result;
	GtkImage* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_icon;
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_get (_tmp0_, "icon-name", &_tmp1_, NULL);
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp2_;
#line 412 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 2266 "gitg-history-refs-list.c"
}


void gitg_history_ref_header_set_icon_name (GitgHistoryRefHeader* self, const gchar* value) {
	GtkImage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 413 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_icon;
#line 415 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = value;
#line 415 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_set (_tmp0_, "icon-name", _tmp1_, NULL);
#line 416 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = self->priv->d_icon;
#line 416 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = value;
#line 416 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ != NULL);
#line 413 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject *) self, "icon-name");
#line 2291 "gitg-history-refs-list.c"
}


static void gitg_history_ref_header_class_init (GitgHistoryRefHeaderClass * klass) {
	gint GitgHistoryRefHeader_private_offset;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_header_parent_class = g_type_class_peek_parent (klass);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_type_class_add_private (klass, sizeof (GitgHistoryRefHeaderPrivate));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_ref_header_get_property;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_ref_header_set_property;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_history_ref_header_finalize;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REMOTE_STATE, g_param_spec_enum ("remote-state", "remote-state", "remote-state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REF_TYPE, g_param_spec_enum ("ref-type", "ref-type", "ref-type", GITG_TYPE_REF_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_REF_NAME, g_param_spec_string ("ref-name", "ref-name", "ref-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE, g_param_spec_boolean ("is-sub-header-remote", "is-sub-header-remote", "is-sub-header-remote", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REF_HEADER_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	GitgHistoryRefHeader_private_offset = g_type_class_get_instance_private_offset (klass);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-history-ref-header.ui");
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_progress_bin", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_progress_bin));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_label", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_label));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "d_icon", FALSE, GitgHistoryRefHeader_private_offset + G_STRUCT_OFFSET (GitgHistoryRefHeaderPrivate, d_icon));
#line 2327 "gitg-history-refs-list.c"
}


static void gitg_history_ref_header_gitg_history_ref_typed_interface_init (GitgHistoryRefTypedIface * iface) {
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_header_gitg_history_ref_typed_parent_iface = g_type_interface_peek_parent (iface);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	iface->get_ref_type = gitg_history_ref_header_real_get_ref_type;
#line 2336 "gitg-history-refs-list.c"
}


static void gitg_history_ref_header_instance_init (GitgHistoryRefHeader * self) {
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv = GITG_HISTORY_REF_HEADER_GET_PRIVATE (self);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 2345 "gitg-history-refs-list.c"
}


static void gitg_history_ref_header_finalize (GObject* obj) {
	GitgHistoryRefHeader * self;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
#line 324 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (self->priv->d_name);
#line 348 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_remote);
#line 351 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_progress_bin);
#line 354 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_label);
#line 357 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_icon);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (gitg_history_ref_header_parent_class)->finalize (obj);
#line 2365 "gitg-history-refs-list.c"
}


GType gitg_history_ref_header_get_type (void) {
	static volatile gsize gitg_history_ref_header_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_ref_header_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_ref_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefHeader), 0, (GInstanceInitFunc) gitg_history_ref_header_instance_init, NULL };
		static const GInterfaceInfo gitg_history_ref_typed_info = { (GInterfaceInitFunc) gitg_history_ref_header_gitg_history_ref_typed_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gitg_history_ref_header_type_id;
		gitg_history_ref_header_type_id = g_type_register_static (gtk_list_box_row_get_type (), "GitgHistoryRefHeader", &g_define_type_info, 0);
		g_type_add_interface_static (gitg_history_ref_header_type_id, GITG_HISTORY_TYPE_REF_TYPED, &gitg_history_ref_typed_info);
		g_once_init_leave (&gitg_history_ref_header_type_id__volatile, gitg_history_ref_header_type_id);
	}
	return gitg_history_ref_header_type_id__volatile;
}


static void _vala_gitg_history_ref_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgHistoryRefHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_REF_TYPE:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_enum (value, gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) self));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_REF_NAME:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_string (value, gitg_history_ref_header_get_ref_name (self));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_IS_SUB_HEADER_REMOTE:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_boolean (value, gitg_history_ref_header_get_is_sub_header_remote (self));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_ICON_NAME:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_take_string (value, gitg_history_ref_header_get_icon_name (self));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 2412 "gitg-history-refs-list.c"
		default:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 2418 "gitg-history-refs-list.c"
	}
}


static void _vala_gitg_history_ref_header_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgHistoryRefHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REF_HEADER, GitgHistoryRefHeader);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_REMOTE_STATE:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_ref_header_set_remote_state (self, g_value_get_enum (value));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REF_HEADER_ICON_NAME:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_ref_header_set_icon_name (self, g_value_get_string (value));
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 2440 "gitg-history-refs-list.c"
		default:
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 320 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 2446 "gitg-history-refs-list.c"
	}
}


static void _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated (GitgRemote* _sender, const gchar* refname, GgitOId* a, GgitOId* b, gpointer self) {
#line 467 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_on_tip_updated ((GitgHistoryRefsList*) self, _sender, refname, a, b);
#line 2454 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_real_dispose (GObject* base) {
	GitgHistoryRefsList * self;
	GitgRemote** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GitgRemote** _tmp4_ = NULL;
#line 463 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsList*) base;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_remotes;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0__length1 = self->priv->d_remotes_length1;
#line 2469 "gitg-history-refs-list.c"
	{
		GitgRemote** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote_collection = _tmp0_;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote_collection_length1 = _tmp0__length1;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		for (remote_it = 0; remote_it < _tmp0__length1; remote_it = remote_it + 1) {
#line 2481 "gitg-history-refs-list.c"
			GitgRemote* _tmp1_ = NULL;
			GitgRemote* remote = NULL;
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp1_ = _g_object_ref0 (remote_collection[remote_it]);
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			remote = _tmp1_;
#line 2488 "gitg-history-refs-list.c"
			{
				GitgRemote* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
#line 467 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp2_ = remote;
#line 467 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				g_signal_parse_name ("tip-updated", GITG_TYPE_REMOTE, &_tmp3_, NULL, FALSE);
#line 467 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self);
#line 465 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (remote);
#line 2500 "gitg-history-refs-list.c"
			}
		}
	}
#line 470 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = g_new0 (GitgRemote*, 0 + 1);
#line 470 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
#line 470 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = _tmp4_;
#line 470 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes_length1 = 0;
#line 470 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
#line 472 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (gitg_history_refs_list_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox));
#line 2516 "gitg-history-refs-list.c"
}


static gint gitg_history_refs_list_sort_rows (GitgHistoryRefsList* self, GtkListBoxRow* row1, GtkListBoxRow* row2) {
	gint result = 0;
	GitgRefType r1 = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgRefType _tmp1_ = 0;
	GitgRefType _tmp2_ = 0;
	GitgRefType r2 = 0;
	GtkListBoxRow* _tmp3_ = NULL;
	GitgRefType _tmp4_ = 0;
	GitgRefType _tmp5_ = 0;
	gint rs1 = 0;
	GitgRefType _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint rs2 = 0;
	GitgRefType _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GitgHistoryRefHeader* head1 = NULL;
	GtkListBoxRow* _tmp15_ = NULL;
	GitgHistoryRefHeader* _tmp16_ = NULL;
	GitgHistoryRefRow* ref1 = NULL;
	GtkListBoxRow* _tmp17_ = NULL;
	GitgHistoryRefRow* _tmp18_ = NULL;
	GitgHistoryRefHeader* head2 = NULL;
	GtkListBoxRow* _tmp19_ = NULL;
	GitgHistoryRefHeader* _tmp20_ = NULL;
	GitgHistoryRefRow* ref2 = NULL;
	GtkListBoxRow* _tmp21_ = NULL;
	GitgHistoryRefRow* _tmp22_ = NULL;
	GitgHistoryRefHeader* _tmp23_ = NULL;
	GitgHistoryRefHeader* _tmp24_ = NULL;
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (row1 != NULL, 0);
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (row2 != NULL, 0);
#line 487 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = row1;
#line 487 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_ref_typed_get_ref_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped));
#line 487 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 487 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	r1 = _tmp2_;
#line 488 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = row2;
#line 488 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gitg_history_ref_typed_get_ref_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GITG_HISTORY_TYPE_REF_TYPED, GitgHistoryRefTyped));
#line 488 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_;
#line 488 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	r2 = _tmp5_;
#line 491 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = r1;
#line 491 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_history_ref_type_sort_order (_tmp6_);
#line 491 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	rs1 = _tmp7_;
#line 492 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = r2;
#line 492 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = gitg_history_ref_type_sort_order (_tmp8_);
#line 492 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	rs2 = _tmp9_;
#line 494 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = rs1;
#line 494 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = rs2;
#line 494 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp10_ != _tmp11_) {
#line 2592 "gitg-history-refs-list.c"
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = rs1;
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = rs2;
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp13_ < _tmp14_) {
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp12_ = -1;
#line 2604 "gitg-history-refs-list.c"
		} else {
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp12_ = 1;
#line 2608 "gitg-history-refs-list.c"
		}
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp12_;
#line 496 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 2614 "gitg-history-refs-list.c"
	}
#line 499 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp15_ = row1;
#line 499 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp15_) : NULL);
#line 499 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	head1 = _tmp16_;
#line 500 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp17_ = row1;
#line 500 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GITG_HISTORY_TYPE_REF_ROW) ? ((GitgHistoryRefRow*) _tmp17_) : NULL);
#line 500 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ref1 = _tmp18_;
#line 502 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp19_ = row2;
#line 502 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp19_) : NULL);
#line 502 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	head2 = _tmp20_;
#line 503 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp21_ = row2;
#line 503 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GITG_HISTORY_TYPE_REF_ROW) ? ((GitgHistoryRefRow*) _tmp21_) : NULL);
#line 503 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ref2 = _tmp22_;
#line 505 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp23_ = head1;
#line 505 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp24_ = head2;
#line 505 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if ((_tmp23_ == NULL) != (_tmp24_ == NULL)) {
#line 2646 "gitg-history-refs-list.c"
		GitgHistoryRefHeader* _tmp25_ = NULL;
		GitgHistoryRefHeader* _tmp26_ = NULL;
		GitgHistoryRefHeader* head = NULL;
		GitgHistoryRefHeader* _tmp29_ = NULL;
		GitgHistoryRefHeader* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp26_ = head1;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp26_ != NULL) {
#line 2658 "gitg-history-refs-list.c"
			GitgHistoryRefHeader* _tmp27_ = NULL;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp27_ = head1;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp25_ = _tmp27_;
#line 2664 "gitg-history-refs-list.c"
		} else {
			GitgHistoryRefHeader* _tmp28_ = NULL;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp28_ = head2;
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp25_ = _tmp28_;
#line 2671 "gitg-history-refs-list.c"
		}
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp29_ = _g_object_ref0 (_tmp25_);
#line 507 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		head = _tmp29_;
#line 510 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp30_ = head;
#line 510 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp31_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp30_);
#line 510 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp32_ = _tmp31_;
#line 510 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp32_) {
#line 2685 "gitg-history-refs-list.c"
			GitgHistoryRefRow* _tmp33_ = NULL;
			GitgHistoryRefHeader* _tmp34_ = NULL;
			GitgHistoryRefRow* rref = NULL;
			GitgHistoryRefRow* _tmp37_ = NULL;
			gint cmp = 0;
			GitgHistoryRefHeader* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			GitgHistoryRefRow* _tmp43_ = NULL;
			GitgRef* _tmp44_ = NULL;
			GitgRef* _tmp45_ = NULL;
			GitgParsedRefName* _tmp46_ = NULL;
			GitgParsedRefName* _tmp47_ = NULL;
			GitgParsedRefName* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gint _tmp54_ = 0;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			GitgHistoryRefHeader* _tmp57_ = NULL;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp34_ = head1;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (_tmp34_ != NULL) {
#line 2715 "gitg-history-refs-list.c"
				GitgHistoryRefRow* _tmp35_ = NULL;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp35_ = ref2;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp33_ = _tmp35_;
#line 2721 "gitg-history-refs-list.c"
			} else {
				GitgHistoryRefRow* _tmp36_ = NULL;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp36_ = ref1;
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp33_ = _tmp36_;
#line 2728 "gitg-history-refs-list.c"
			}
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp37_ = _g_object_ref0 (_tmp33_);
#line 513 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			rref = _tmp37_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp38_ = head;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp39_ = gitg_history_ref_header_get_ref_name (_tmp38_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp40_ = _tmp39_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp41_ = g_utf8_casefold (_tmp40_, (gssize) (-1));
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp42_ = _tmp41_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp43_ = rref;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp44_ = gitg_history_ref_row_get_reference (_tmp43_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp45_ = _tmp44_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp46_ = gitg_ref_get_parsed_name (_tmp45_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp47_ = _tmp46_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp48_ = _tmp47_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp49_ = gitg_parsed_ref_name_get_remote_name (_tmp48_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp50_ = _tmp49_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp51_ = _tmp50_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp52_ = g_utf8_casefold (_tmp51_, (gssize) (-1));
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp53_ = _tmp52_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp54_ = g_utf8_collate (_tmp42_, _tmp53_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp55_ = _tmp54_;
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_free0 (_tmp53_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_free0 (_tmp51_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_tmp48_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_free0 (_tmp42_);
#line 514 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			cmp = _tmp55_;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp57_ = head1;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (_tmp57_ != NULL) {
#line 2784 "gitg-history-refs-list.c"
				gint _tmp58_ = 0;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp58_ = cmp;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp56_ = _tmp58_;
#line 2790 "gitg-history-refs-list.c"
			} else {
				gint _tmp59_ = 0;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp59_ = cmp;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp56_ = -_tmp59_;
#line 2797 "gitg-history-refs-list.c"
			}
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp56_;
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (rref);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref2);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head2);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref1);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head1);
#line 516 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 2815 "gitg-history-refs-list.c"
		} else {
			gint _tmp60_ = 0;
			GitgHistoryRefHeader* _tmp61_ = NULL;
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp61_ = head1;
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (_tmp61_ != NULL) {
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp60_ = -1;
#line 2825 "gitg-history-refs-list.c"
			} else {
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp60_ = 1;
#line 2829 "gitg-history-refs-list.c"
			}
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp60_;
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head);
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref2);
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head2);
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref1);
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head1);
#line 520 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 2845 "gitg-history-refs-list.c"
		}
#line 505 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (head);
#line 2849 "gitg-history-refs-list.c"
	} else {
		gboolean _tmp62_ = FALSE;
		GitgHistoryRefHeader* _tmp63_ = NULL;
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp63_ = head1;
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp63_ != NULL) {
#line 2857 "gitg-history-refs-list.c"
			GitgHistoryRefHeader* _tmp64_ = NULL;
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp64_ = head2;
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp62_ = _tmp64_ != NULL;
#line 2863 "gitg-history-refs-list.c"
		} else {
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp62_ = FALSE;
#line 2867 "gitg-history-refs-list.c"
		}
#line 523 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp62_) {
#line 2871 "gitg-history-refs-list.c"
			GitgHistoryRefHeader* _tmp65_ = NULL;
			GitgHistoryRefHeader* _tmp66_ = NULL;
			gint _tmp67_ = 0;
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp65_ = head1;
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp66_ = head2;
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp67_ = gitg_history_ref_header_compare_to (_tmp65_, _tmp66_);
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp67_;
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref2);
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head2);
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref1);
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head1);
#line 525 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 2893 "gitg-history-refs-list.c"
		} else {
			GitgHistoryRefRow* _tmp68_ = NULL;
			GitgHistoryRefRow* _tmp69_ = NULL;
			gint _tmp70_ = 0;
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp68_ = ref1;
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp69_ = ref2;
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp70_ = gitg_history_ref_row_compare_to (_tmp68_, _tmp69_);
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp70_;
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref2);
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head2);
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref1);
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (head1);
#line 529 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 2916 "gitg-history-refs-list.c"
		}
	}
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ref2);
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (head2);
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ref1);
#line 485 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (head1);
#line 2927 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_clear (GitgHistoryRefsList* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GitgRemote** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GitgRemote** _tmp8_ = NULL;
#line 533 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 535 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_commits);
#line 535 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_commits = NULL;
#line 536 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_branches);
#line 536 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_branches = NULL;
#line 537 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_remotes);
#line 537 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_remotes = NULL;
#line 538 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_tags);
#line 538 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_tags = NULL;
#line 540 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, (GBoxedCopyFunc) gitg_history_refs_list_remote_header_ref, gitg_history_refs_list_remote_header_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 540 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_header_map);
#line 540 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_header_map = _tmp0_;
#line 541 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gee_hash_map_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, GITG_HISTORY_TYPE_REF_ROW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 541 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_ref_map);
#line 541 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_ref_map = _tmp1_;
#line 543 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gtk_container_get_children ((GtkContainer*) self);
#line 2970 "gitg-history-refs-list.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 543 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		child_collection = _tmp2_;
#line 543 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 2978 "gitg-history-refs-list.c"
			GtkWidget* child = NULL;
#line 543 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			child = (GtkWidget*) child_it->data;
#line 2982 "gitg-history-refs-list.c"
			{
				GtkWidget* _tmp3_ = NULL;
#line 545 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp3_ = child;
#line 545 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				gtk_widget_destroy (_tmp3_);
#line 2989 "gitg-history-refs-list.c"
			}
		}
#line 543 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_list_free0 (child_collection);
#line 2994 "gitg-history-refs-list.c"
	}
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_remotes;
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4__length1 = self->priv->d_remotes_length1;
#line 3000 "gitg-history-refs-list.c"
	{
		GitgRemote** remote_collection = NULL;
		gint remote_collection_length1 = 0;
		gint _remote_collection_size_ = 0;
		gint remote_it = 0;
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote_collection = _tmp4_;
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote_collection_length1 = _tmp4__length1;
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		for (remote_it = 0; remote_it < _tmp4__length1; remote_it = remote_it + 1) {
#line 3012 "gitg-history-refs-list.c"
			GitgRemote* _tmp5_ = NULL;
			GitgRemote* remote = NULL;
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp5_ = _g_object_ref0 (remote_collection[remote_it]);
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			remote = _tmp5_;
#line 3019 "gitg-history-refs-list.c"
			{
				GitgRemote* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
#line 550 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp6_ = remote;
#line 550 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				g_signal_parse_name ("tip-updated", GITG_TYPE_REMOTE, &_tmp7_, NULL, FALSE);
#line 550 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self);
#line 548 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (remote);
#line 3031 "gitg-history-refs-list.c"
			}
		}
	}
#line 553 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = g_new0 (GitgRemote*, 0 + 1);
#line 553 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
#line 553 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = _tmp8_;
#line 553 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes_length1 = 0;
#line 553 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
#line 3045 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_reselect_row (GitgHistoryRefsList* self, GtkListBoxRow* a) {
	GtkListBoxRow* _tmp0_ = NULL;
	GitgHistoryRefHeader* ah = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GitgHistoryRefHeader* _tmp2_ = NULL;
	GitgHistoryRefHeader* bh = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GitgHistoryRefHeader* _tmp4_ = NULL;
	GitgHistoryRefHeader* _tmp5_ = NULL;
	GitgHistoryRefHeader* _tmp6_ = NULL;
	GitgHistoryRefHeader* _tmp7_ = NULL;
	GitgHistoryRefRow* ar = NULL;
	GtkListBoxRow* _tmp22_ = NULL;
	GitgHistoryRefRow* _tmp23_ = NULL;
	GitgHistoryRefRow* br = NULL;
	GtkListBoxRow* _tmp24_ = NULL;
	GitgHistoryRefRow* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GitgHistoryRefRow* _tmp27_ = NULL;
	GitgRef* _tmp28_ = NULL;
	GitgRef* _tmp29_ = NULL;
	gboolean _tmp34_ = FALSE;
	GitgHistoryRefRow* _tmp35_ = NULL;
	GitgRef* _tmp36_ = NULL;
	GitgRef* _tmp37_ = NULL;
	GitgHistoryRefRow* _tmp41_ = NULL;
	GitgRef* _tmp42_ = NULL;
	GitgRef* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GitgHistoryRefRow* _tmp45_ = NULL;
	GitgRef* _tmp46_ = NULL;
	GitgRef* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (a != NULL);
#line 558 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_selected_row;
#line 558 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 560 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 3092 "gitg-history-refs-list.c"
	}
#line 563 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = a;
#line 563 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp1_) : NULL);
#line 563 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ah = _tmp2_;
#line 564 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = self->priv->d_selected_row;
#line 564 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp3_) : NULL);
#line 564 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	bh = _tmp4_;
#line 566 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = ah;
#line 566 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = bh;
#line 566 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if ((_tmp5_ != NULL) != (_tmp6_ != NULL)) {
#line 568 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (bh);
#line 568 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ah);
#line 568 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 3118 "gitg-history-refs-list.c"
	}
#line 571 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = ah;
#line 571 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp7_ != NULL) {
#line 3124 "gitg-history-refs-list.c"
		gboolean _tmp8_ = FALSE;
		GitgHistoryRefHeader* _tmp9_ = NULL;
		GitgRefType _tmp10_ = 0;
		GitgRefType _tmp11_ = 0;
		GitgHistoryRefHeader* _tmp12_ = NULL;
		GitgRefType _tmp13_ = 0;
		GitgRefType _tmp14_ = 0;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = ah;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp9_);
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = _tmp10_;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = bh;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp12_);
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = _tmp13_;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp11_ == _tmp14_) {
#line 3146 "gitg-history-refs-list.c"
			GitgHistoryRefHeader* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GitgHistoryRefHeader* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = ah;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp16_ = gitg_history_ref_header_get_ref_name (_tmp15_);
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp17_ = _tmp16_;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp18_ = bh;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp19_ = gitg_history_ref_header_get_ref_name (_tmp18_);
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp20_ = _tmp19_;
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp8_ = g_strcmp0 (_tmp17_, _tmp20_) == 0;
#line 3167 "gitg-history-refs-list.c"
		} else {
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp8_ = FALSE;
#line 3171 "gitg-history-refs-list.c"
		}
#line 573 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp8_) {
#line 3175 "gitg-history-refs-list.c"
			GtkListBoxRow* _tmp21_ = NULL;
#line 575 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = a;
#line 575 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gtk_list_box_select_row ((GtkListBox*) self, _tmp21_);
#line 576 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (self->priv->d_selected_row);
#line 576 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			self->priv->d_selected_row = NULL;
#line 3185 "gitg-history-refs-list.c"
		}
#line 579 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (bh);
#line 579 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ah);
#line 579 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 3193 "gitg-history-refs-list.c"
	}
#line 582 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp22_ = a;
#line 582 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GITG_HISTORY_TYPE_REF_ROW) ? ((GitgHistoryRefRow*) _tmp22_) : NULL);
#line 582 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ar = _tmp23_;
#line 583 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp24_ = self->priv->d_selected_row;
#line 583 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GITG_HISTORY_TYPE_REF_ROW) ? ((GitgHistoryRefRow*) _tmp24_) : NULL);
#line 583 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	br = _tmp25_;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp27_ = ar;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp28_ = gitg_history_ref_row_get_reference (_tmp27_);
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp29_ = _tmp28_;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp29_ == NULL) {
#line 3215 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp30_ = NULL;
		GitgRef* _tmp31_ = NULL;
		GitgRef* _tmp32_ = NULL;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp30_ = br;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp31_ = gitg_history_ref_row_get_reference (_tmp30_);
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp32_ = _tmp31_;
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp26_ = _tmp32_ == NULL;
#line 3227 "gitg-history-refs-list.c"
	} else {
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp26_ = FALSE;
#line 3231 "gitg-history-refs-list.c"
	}
#line 585 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp26_) {
#line 3235 "gitg-history-refs-list.c"
		GtkListBoxRow* _tmp33_ = NULL;
#line 587 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp33_ = a;
#line 587 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_list_box_select_row ((GtkListBox*) self, _tmp33_);
#line 588 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self->priv->d_selected_row);
#line 588 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self->priv->d_selected_row = NULL;
#line 589 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (br);
#line 589 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ar);
#line 589 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (bh);
#line 589 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ah);
#line 589 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 3255 "gitg-history-refs-list.c"
	}
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp35_ = ar;
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp36_ = gitg_history_ref_row_get_reference (_tmp35_);
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp37_ = _tmp36_;
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp37_ == NULL) {
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp34_ = TRUE;
#line 3267 "gitg-history-refs-list.c"
	} else {
		GitgHistoryRefRow* _tmp38_ = NULL;
		GitgRef* _tmp39_ = NULL;
		GitgRef* _tmp40_ = NULL;
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp38_ = br;
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp39_ = gitg_history_ref_row_get_reference (_tmp38_);
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp40_ = _tmp39_;
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp34_ = _tmp40_ == NULL;
#line 3280 "gitg-history-refs-list.c"
	}
#line 592 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp34_) {
#line 594 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (br);
#line 594 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ar);
#line 594 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (bh);
#line 594 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ah);
#line 594 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 3294 "gitg-history-refs-list.c"
	}
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp41_ = ar;
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp42_ = gitg_history_ref_row_get_reference (_tmp41_);
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp43_ = _tmp42_;
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp44_ = ggit_ref_get_name ((GgitRef*) _tmp43_);
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp45_ = br;
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp46_ = gitg_history_ref_row_get_reference (_tmp45_);
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp47_ = _tmp46_;
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp48_ = ggit_ref_get_name ((GgitRef*) _tmp47_);
#line 597 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (g_strcmp0 (_tmp44_, _tmp48_) == 0) {
#line 3314 "gitg-history-refs-list.c"
		GtkListBoxRow* _tmp49_ = NULL;
#line 599 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp49_ = a;
#line 599 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_list_box_select_row ((GtkListBox*) self, _tmp49_);
#line 600 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self->priv->d_selected_row);
#line 600 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self->priv->d_selected_row = NULL;
#line 3324 "gitg-history-refs-list.c"
	}
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (br);
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ar);
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (bh);
#line 556 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ah);
#line 3334 "gitg-history-refs-list.c"
}


void gitg_history_refs_list_add (GitgHistoryRefsList* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
#line 604 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 604 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (row != NULL);
#line 606 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = row;
#line 606 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	GTK_CONTAINER_CLASS (gitg_history_refs_list_parent_class)->add ((GtkContainer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), (GtkWidget*) _tmp0_);
#line 607 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = row;
#line 607 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_reselect_row (self, _tmp1_);
#line 3353 "gitg-history-refs-list.c"
}


static GitgHistoryRefHeader* gitg_history_refs_list_add_header (GitgHistoryRefsList* self, GitgRefType ref_type, const gchar* name) {
	GitgHistoryRefHeader* result = NULL;
	GitgHistoryRefHeader* header = NULL;
	GitgRefType _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	GitgHistoryRefHeader* _tmp2_ = NULL;
#line 610 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 610 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 612 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = ref_type;
#line 612 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = name;
#line 612 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gitg_history_ref_header_new (_tmp0_, _tmp1_);
#line 612 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_ref_sink (_tmp2_);
#line 612 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	header = _tmp2_;
#line 613 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_show ((GtkWidget*) header);
#line 615 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_add (self, (GtkListBoxRow*) header);
#line 616 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = header;
#line 616 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 3385 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_on_tip_updated (GitgHistoryRefsList* self, GgitRemote* remote, const gchar* refname, GgitOId* a, GgitOId* b) {
	GgitOId* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 619 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 619 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (remote != NULL);
#line 619 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (refname != NULL);
#line 619 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (a != NULL);
#line 619 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (b != NULL);
#line 624 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = a;
#line 624 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = ggit_oid_is_zero (_tmp0_);
#line 624 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_) {
#line 3409 "gitg-history-refs-list.c"
		GitgRef* reference = NULL;
		GitgRepository* _tmp2_ = NULL;
		GitgRepository* _tmp3_ = NULL;
		GitgRef* _tmp14_ = NULL;
#line 628 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = gitg_history_refs_list_get_repository (self);
#line 628 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = _tmp2_;
#line 628 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_repository_clear_refs_cache (_tmp3_);
#line 3420 "gitg-history-refs-list.c"
		{
			GitgRef* _tmp4_ = NULL;
			GitgRepository* _tmp5_ = NULL;
			GitgRepository* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GitgRef* _tmp8_ = NULL;
			GitgRef* _tmp9_ = NULL;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp5_ = gitg_history_refs_list_get_repository (self);
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp6_ = _tmp5_;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp7_ = refname;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp8_ = gitg_repository_lookup_reference (_tmp6_, _tmp7_, &_inner_error_);
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp4_ = _tmp8_;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3440 "gitg-history-refs-list.c"
				goto __catch79_g_error;
			}
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp9_ = _tmp4_;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp4_ = NULL;
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (reference);
#line 632 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			reference = _tmp9_;
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_tmp4_);
#line 3453 "gitg-history-refs-list.c"
		}
		goto __finally79;
		__catch79_g_error:
		{
			GError* e = NULL;
			FILE* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			e = _inner_error_;
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_inner_error_ = NULL;
#line 636 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp10_ = stderr;
#line 636 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp11_ = refname;
#line 636 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp12_ = e;
#line 636 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = _tmp12_->message;
#line 636 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			fprintf (_tmp10_, "Failed to lookup new reference '%s': %s\n", _tmp11_, _tmp13_);
#line 637 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_error_free0 (e);
#line 637 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (reference);
#line 637 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return;
#line 3483 "gitg-history-refs-list.c"
		}
		__finally79:
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (reference);
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			g_clear_error (&_inner_error_);
#line 630 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return;
#line 3496 "gitg-history-refs-list.c"
		}
#line 640 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = reference;
#line 640 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_add_ref (self, _tmp14_);
#line 624 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (reference);
#line 3504 "gitg-history-refs-list.c"
	} else {
		GgitOId* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 642 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = b;
#line 642 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = ggit_oid_is_zero (_tmp15_);
#line 642 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp16_) {
#line 3514 "gitg-history-refs-list.c"
			{
				GeeIterator* _reference_it = NULL;
				GeeHashMap* _tmp17_ = NULL;
				GeeSet* _tmp18_ = NULL;
				GeeSet* _tmp19_ = NULL;
				GeeSet* _tmp20_ = NULL;
				GeeIterator* _tmp21_ = NULL;
				GeeIterator* _tmp22_ = NULL;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp17_ = self->priv->d_ref_map;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp18_ = gee_abstract_map_get_keys ((GeeMap*) _tmp17_);
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp19_ = _tmp18_;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp20_ = _tmp19_;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp22_ = _tmp21_;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (_tmp20_);
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_reference_it = _tmp22_;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				while (TRUE) {
#line 3541 "gitg-history-refs-list.c"
					GeeIterator* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					GitgRef* reference = NULL;
					GeeIterator* _tmp25_ = NULL;
					gpointer _tmp26_ = NULL;
					GitgRef* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp23_ = _reference_it;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp24_ = gee_iterator_next (_tmp23_);
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					if (!_tmp24_) {
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						break;
#line 3558 "gitg-history-refs-list.c"
					}
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp25_ = _reference_it;
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp26_ = gee_iterator_get (_tmp25_);
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					reference = (GitgRef*) _tmp26_;
#line 647 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp27_ = reference;
#line 647 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp28_ = ggit_ref_get_name ((GgitRef*) _tmp27_);
#line 647 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp29_ = refname;
#line 647 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					if (g_strcmp0 (_tmp28_, _tmp29_) == 0) {
#line 3574 "gitg-history-refs-list.c"
						GitgRepository* _tmp30_ = NULL;
						GitgRepository* _tmp31_ = NULL;
						GitgRef* _tmp32_ = NULL;
#line 649 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp30_ = gitg_history_refs_list_get_repository (self);
#line 649 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp31_ = _tmp30_;
#line 649 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						gitg_repository_clear_refs_cache (_tmp31_);
#line 650 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp32_ = reference;
#line 650 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						gitg_history_refs_list_remove_ref (self, _tmp32_);
#line 651 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_g_object_unref0 (reference);
#line 651 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						break;
#line 3592 "gitg-history-refs-list.c"
					}
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_g_object_unref0 (reference);
#line 3596 "gitg-history-refs-list.c"
				}
#line 645 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (_reference_it);
#line 3600 "gitg-history-refs-list.c"
			}
		} else {
			GitgRepository* _tmp33_ = NULL;
			GitgRepository* _tmp34_ = NULL;
#line 658 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp33_ = gitg_history_refs_list_get_repository (self);
#line 658 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp34_ = _tmp33_;
#line 658 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gitg_repository_clear_refs_cache (_tmp34_);
#line 659 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			g_signal_emit_by_name (self, "changed");
#line 3613 "gitg-history-refs-list.c"
		}
	}
}


static void _vala_array_add14 (GitgRemote*** array, int* length, int* size, GitgRemote* value) {
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if ((*length) == (*size)) {
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		*array = g_renew (GitgRemote*, *array, (*size) + 1);
#line 3626 "gitg-history-refs-list.c"
	}
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(*array)[(*length)++] = value;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(*array)[*length] = NULL;
#line 3632 "gitg-history-refs-list.c"
}


static GitgHistoryRefHeader* gitg_history_refs_list_add_remote_header (GitgHistoryRefsList* self, const gchar* name) {
	GitgHistoryRefHeader* result = NULL;
	GitgRemote* remote = NULL;
	GitgExtRemoteLookup* _tmp0_ = NULL;
	GitgRemote* _tmp4_ = NULL;
	GitgHistoryRefHeader* header = NULL;
	const gchar* _tmp9_ = NULL;
	GitgRemote* _tmp10_ = NULL;
	GitgHistoryRefHeader* _tmp11_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GitgHistoryRefsListRemoteHeader* _tmp14_ = NULL;
	GitgHistoryRefsListRemoteHeader* _tmp15_ = NULL;
#line 663 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 663 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 665 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	remote = NULL;
#line 667 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_remote_lookup;
#line 667 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ != NULL) {
#line 3659 "gitg-history-refs-list.c"
		GitgExtRemoteLookup* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GitgRemote* _tmp3_ = NULL;
#line 669 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp1_ = self->priv->_remote_lookup;
#line 669 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = name;
#line 669 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = gitg_ext_remote_lookup_lookup (_tmp1_, _tmp2_);
#line 669 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (remote);
#line 669 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote = _tmp3_;
#line 3673 "gitg-history-refs-list.c"
	}
#line 672 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = remote;
#line 672 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp4_ != NULL) {
#line 3679 "gitg-history-refs-list.c"
		GitgRemote** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		GitgRemote* _tmp6_ = NULL;
		GitgRemote* _tmp7_ = NULL;
		GitgRemote* _tmp8_ = NULL;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = self->priv->d_remotes;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5__length1 = self->priv->d_remotes_length1;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = remote;
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 674 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_vala_array_add14 (&self->priv->d_remotes, &self->priv->d_remotes_length1, &self->priv->_d_remotes_size_, _tmp7_);
#line 675 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = remote;
#line 675 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_signal_connect_object (_tmp8_, "tip-updated", (GCallback) _gitg_history_refs_list_on_tip_updated_gitg_remote_tip_updated, self, 0);
#line 3699 "gitg-history-refs-list.c"
	}
#line 678 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = name;
#line 678 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = remote;
#line 678 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = gitg_history_ref_header_new_remote (_tmp9_, _tmp10_);
#line 678 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_ref_sink (_tmp11_);
#line 678 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	header = _tmp11_;
#line 679 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_show ((GtkWidget*) header);
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = self->priv->d_header_map;
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = name;
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp14_ = gitg_history_refs_list_remote_header_new (header);
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp15_ = _tmp14_;
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp15_);
#line 681 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_gitg_history_refs_list_remote_header_unref0 (_tmp15_);
#line 682 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_add (self, (GtkListBoxRow*) header);
#line 684 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = header;
#line 684 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (remote);
#line 684 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 3733 "gitg-history-refs-list.c"
}


static GitgHistoryRefRow* gitg_history_refs_list_add_ref_row (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation) {
	GitgHistoryRefRow* result = NULL;
	GitgHistoryRefRow* row = NULL;
	GitgRef* _tmp0_ = NULL;
	GitgHistoryRefAnimation _tmp1_ = 0;
	GitgHistoryRefRow* _tmp2_ = NULL;
	GitgHistoryRefRow* _tmp3_ = NULL;
	GitgHistoryRefRow* _tmp4_ = NULL;
	GitgRef* _tmp5_ = NULL;
#line 687 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 689 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 689 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = animation;
#line 689 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gitg_history_ref_row_new (_tmp0_, _tmp1_);
#line 689 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_ref_sink (_tmp2_);
#line 689 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = _tmp2_;
#line 690 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = row;
#line 690 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp3_);
#line 692 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = row;
#line 692 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_add (self, (GtkListBoxRow*) _tmp4_);
#line 694 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = reference;
#line 694 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp5_ != NULL) {
#line 3770 "gitg-history-refs-list.c"
		GeeHashMap* _tmp6_ = NULL;
		GitgRef* _tmp7_ = NULL;
		GitgHistoryRefRow* _tmp8_ = NULL;
#line 696 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = self->priv->d_ref_map;
#line 696 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = reference;
#line 696 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = row;
#line 696 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
#line 3782 "gitg-history-refs-list.c"
	}
#line 699 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = row;
#line 699 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 3788 "gitg-history-refs-list.c"
}


static GitgHistoryRefRow* gitg_history_refs_list_add_ref_internal (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation) {
	GitgHistoryRefRow* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GitgRef* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgRef* _tmp3_ = NULL;
	GitgParsedRefName* _tmp4_ = NULL;
	GitgParsedRefName* _tmp5_ = NULL;
	GitgParsedRefName* _tmp6_ = NULL;
	GitgRefType _tmp7_ = 0;
	GitgRefType _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	GitgRef* _tmp29_ = NULL;
	GitgHistoryRefAnimation _tmp30_ = 0;
	GitgHistoryRefRow* _tmp31_ = NULL;
#line 702 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 702 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, NULL);
#line 704 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_ref_map;
#line 704 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = reference;
#line 704 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 704 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_) {
#line 706 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = NULL;
#line 706 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 3823 "gitg-history-refs-list.c"
	}
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = reference;
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gitg_ref_get_parsed_name (_tmp3_);
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_;
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = _tmp5_;
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_parsed_ref_name_get_rtype (_tmp6_);
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _tmp7_;
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = _tmp8_ == GITG_REF_TYPE_REMOTE;
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (_tmp6_);
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp9_) {
#line 3843 "gitg-history-refs-list.c"
		gchar* remote = NULL;
		GitgRef* _tmp10_ = NULL;
		GitgParsedRefName* _tmp11_ = NULL;
		GitgParsedRefName* _tmp12_ = NULL;
		GitgParsedRefName* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GeeHashMap* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GeeHashMap* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gpointer _tmp25_ = NULL;
		GitgHistoryRefsListRemoteHeader* _tmp26_ = NULL;
		GeeHashSet* _tmp27_ = NULL;
		GitgRef* _tmp28_ = NULL;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = reference;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = gitg_ref_get_parsed_name (_tmp10_);
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = _tmp11_;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = _tmp12_;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = gitg_parsed_ref_name_get_remote_name (_tmp13_);
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = _tmp14_;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = _tmp15_;
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp13_);
#line 711 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote = _tmp16_;
#line 713 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp17_ = self->priv->d_header_map;
#line 713 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = remote;
#line 713 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
#line 713 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (!_tmp19_) {
#line 3887 "gitg-history-refs-list.c"
			const gchar* _tmp20_ = NULL;
			GitgHistoryRefHeader* _tmp21_ = NULL;
			GitgHistoryRefHeader* _tmp22_ = NULL;
#line 715 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp20_ = remote;
#line 715 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = gitg_history_refs_list_add_remote_header (self, _tmp20_);
#line 715 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp22_ = _tmp21_;
#line 715 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_tmp22_);
#line 3899 "gitg-history-refs-list.c"
		}
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp23_ = self->priv->d_header_map;
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp24_ = remote;
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp26_ = (GitgHistoryRefsListRemoteHeader*) _tmp25_;
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp27_ = _tmp26_->references;
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp28_ = reference;
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
#line 718 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_gitg_history_refs_list_remote_header_unref0 (_tmp26_);
#line 709 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (remote);
#line 3919 "gitg-history-refs-list.c"
	}
#line 721 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp29_ = reference;
#line 721 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp30_ = animation;
#line 721 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp31_ = gitg_history_refs_list_add_ref_row (self, _tmp29_, _tmp30_);
#line 721 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp31_;
#line 721 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 3931 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_add_ref (GitgHistoryRefsList* self, GitgRef* reference) {
	gboolean result = FALSE;
	GitgRef* _tmp0_ = NULL;
	GitgHistoryRefRow* _tmp1_ = NULL;
	GitgHistoryRefRow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 724 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 724 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, FALSE);
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_add_ref_internal (self, _tmp0_, GITG_HISTORY_REF_ANIMATION_ANIMATE);
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _tmp1_;
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (_tmp2_);
#line 726 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp3_) {
#line 728 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_signal_emit_by_name (self, "changed");
#line 729 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = TRUE;
#line 729 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 3963 "gitg-history-refs-list.c"
	}
#line 732 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 732 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 3969 "gitg-history-refs-list.c"
}


void gitg_history_refs_list_replace_ref (GitgHistoryRefsList* self, GitgRef* old_ref, GitgRef* new_ref) {
	gboolean select = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GitgRef* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean removed = FALSE;
	GitgRef* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GitgHistoryRefRow* newrow = NULL;
	GitgRef* _tmp10_ = NULL;
	GitgHistoryRefRow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 735 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 735 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (old_ref != NULL);
#line 735 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (new_ref != NULL);
#line 737 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	select = FALSE;
#line 739 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_ref_map;
#line 739 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = old_ref;
#line 739 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 739 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_) {
#line 4003 "gitg-history-refs-list.c"
		GtkListBoxRow* _tmp3_ = NULL;
		GeeHashMap* _tmp4_ = NULL;
		GitgRef* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		GitgHistoryRefRow* _tmp7_ = NULL;
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = self->priv->d_ref_map;
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = old_ref;
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = (GitgHistoryRefRow*) _tmp6_;
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		select = _tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_list_box_row_get_type (), GtkListBoxRow);
#line 741 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp7_);
#line 4023 "gitg-history-refs-list.c"
	}
#line 744 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = old_ref;
#line 744 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = gitg_history_refs_list_remove_ref_internal (self, _tmp8_, GITG_HISTORY_REF_ANIMATION_ANIMATE);
#line 744 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	removed = _tmp9_;
#line 745 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = new_ref;
#line 745 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = gitg_history_refs_list_add_ref_internal (self, _tmp10_, GITG_HISTORY_REF_ANIMATION_ANIMATE);
#line 745 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	newrow = _tmp11_;
#line 747 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = select;
#line 747 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp12_) {
#line 4041 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp13_ = NULL;
#line 749 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = newrow;
#line 749 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp13_);
#line 4047 "gitg-history-refs-list.c"
	}
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp15_ = removed;
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp15_) {
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = TRUE;
#line 4055 "gitg-history-refs-list.c"
	} else {
		GitgHistoryRefRow* _tmp16_ = NULL;
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = newrow;
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = _tmp16_ != NULL;
#line 4062 "gitg-history-refs-list.c"
	}
#line 752 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp14_) {
#line 754 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_signal_emit_by_name (self, "changed");
#line 4068 "gitg-history-refs-list.c"
	}
#line 735 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (newrow);
#line 4072 "gitg-history-refs-list.c"
}


static gboolean gitg_history_refs_list_ref_is_a_symbolic_head (GitgHistoryRefsList* self, GitgRef* reference) {
	gboolean result = FALSE;
	GitgRef* _tmp0_ = NULL;
	GgitRefType _tmp1_ = 0;
	gchar* name = NULL;
	GitgRef* _tmp2_ = NULL;
	GitgParsedRefName* _tmp3_ = NULL;
	GitgParsedRefName* _tmp4_ = NULL;
	GitgParsedRefName* _tmp5_ = NULL;
	GitgRefType _tmp6_ = 0;
	GitgRefType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp21_ = NULL;
#line 759 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 759 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, FALSE);
#line 761 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 761 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = ggit_ref_get_reference_type ((GgitRef*) _tmp0_);
#line 761 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_ != GGIT_REF_SYMBOLIC) {
#line 763 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = FALSE;
#line 763 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4103 "gitg-history-refs-list.c"
	}
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = reference;
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = gitg_ref_get_parsed_name (_tmp2_);
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = _tmp3_;
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_;
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gitg_parsed_ref_name_get_rtype (_tmp5_);
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = _tmp6_;
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _tmp7_ == GITG_REF_TYPE_REMOTE;
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (_tmp5_);
#line 768 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp8_) {
#line 4123 "gitg-history-refs-list.c"
		GitgRef* _tmp9_ = NULL;
		GitgParsedRefName* _tmp10_ = NULL;
		GitgParsedRefName* _tmp11_ = NULL;
		GitgParsedRefName* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = reference;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = gitg_ref_get_parsed_name (_tmp9_);
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = _tmp10_;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = _tmp11_;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = gitg_parsed_ref_name_get_remote_branch (_tmp12_);
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = _tmp13_;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (name);
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		name = _tmp14_;
#line 770 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp12_);
#line 4148 "gitg-history-refs-list.c"
	} else {
		GitgRef* _tmp15_ = NULL;
		GitgParsedRefName* _tmp16_ = NULL;
		GitgParsedRefName* _tmp17_ = NULL;
		GitgParsedRefName* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = reference;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = gitg_ref_get_parsed_name (_tmp15_);
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp17_ = _tmp16_;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = _tmp17_;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = gitg_parsed_ref_name_get_shortname (_tmp18_);
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp20_ = _tmp19_;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (name);
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		name = _tmp20_;
#line 774 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp18_);
#line 4174 "gitg-history-refs-list.c"
	}
#line 777 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp21_ = name;
#line 777 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = g_strcmp0 (_tmp21_, "HEAD") == 0;
#line 777 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (name);
#line 777 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4184 "gitg-history-refs-list.c"
}


static gboolean gitg_history_refs_list_remove_ref_internal (GitgHistoryRefsList* self, GitgRef* reference, GitgHistoryRefAnimation animation) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GitgRef* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgHistoryRefRow* row = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GitgRef* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GitgHistoryRefAnimation _tmp6_ = 0;
	GeeHashMap* _tmp9_ = NULL;
	GitgRef* _tmp10_ = NULL;
	GitgRef* _tmp11_ = NULL;
	GitgParsedRefName* _tmp12_ = NULL;
	GitgParsedRefName* _tmp13_ = NULL;
	GitgParsedRefName* _tmp14_ = NULL;
	GitgRefType _tmp15_ = 0;
	GitgRefType _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
#line 780 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 780 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, FALSE);
#line 782 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_ref_map;
#line 782 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = reference;
#line 782 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 782 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!_tmp2_) {
#line 784 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = FALSE;
#line 784 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4223 "gitg-history-refs-list.c"
	}
#line 787 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = self->priv->d_ref_map;
#line 787 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = reference;
#line 787 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 787 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = (GitgHistoryRefRow*) _tmp5_;
#line 789 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = animation;
#line 789 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp6_ == GITG_HISTORY_REF_ANIMATION_NONE) {
#line 4237 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp7_ = NULL;
#line 791 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = row;
#line 791 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp7_);
#line 4243 "gitg-history-refs-list.c"
	} else {
		GitgHistoryRefRow* _tmp8_ = NULL;
#line 795 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = row;
#line 795 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_ref_row_unreveal (_tmp8_);
#line 4250 "gitg-history-refs-list.c"
	}
#line 798 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = self->priv->d_ref_map;
#line 798 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = reference;
#line 798 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = reference;
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp12_ = gitg_ref_get_parsed_name (_tmp11_);
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp13_ = _tmp12_;
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp14_ = _tmp13_;
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp15_ = gitg_parsed_ref_name_get_rtype (_tmp14_);
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp16_ = _tmp15_;
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp17_ = _tmp16_ == GITG_REF_TYPE_REMOTE;
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (_tmp14_);
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp17_) {
#line 4276 "gitg-history-refs-list.c"
		gchar* remote = NULL;
		GitgRef* _tmp18_ = NULL;
		GitgParsedRefName* _tmp19_ = NULL;
		GitgParsedRefName* _tmp20_ = NULL;
		GitgParsedRefName* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GitgHistoryRefsListRemoteHeader* remote_header = NULL;
		GeeHashMap* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gpointer _tmp27_ = NULL;
		GitgHistoryRefsListRemoteHeader* _tmp28_ = NULL;
		GeeHashSet* _tmp29_ = NULL;
		GitgRef* _tmp30_ = NULL;
		GitgHistoryRefsListRemoteHeader* _tmp31_ = NULL;
		GeeHashSet* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = reference;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = gitg_ref_get_parsed_name (_tmp18_);
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp20_ = _tmp19_;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp21_ = _tmp20_;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp22_ = gitg_parsed_ref_name_get_remote_name (_tmp21_);
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp23_ = _tmp22_;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp24_ = _tmp23_;
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp21_);
#line 802 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote = _tmp24_;
#line 803 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp25_ = self->priv->d_header_map;
#line 803 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp26_ = remote;
#line 803 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
#line 803 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		remote_header = (GitgHistoryRefsListRemoteHeader*) _tmp27_;
#line 805 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp28_ = remote_header;
#line 805 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp29_ = _tmp28_->references;
#line 805 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp30_ = reference;
#line 805 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp29_, _tmp30_);
#line 807 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp31_ = remote_header;
#line 807 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp32_ = _tmp31_->references;
#line 807 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _tmp32_);
#line 807 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp34_ = _tmp33_;
#line 807 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp34_) {
#line 4340 "gitg-history-refs-list.c"
			GitgHistoryRefsListRemoteHeader* _tmp35_ = NULL;
			GitgHistoryRefHeader* _tmp36_ = NULL;
			GeeHashMap* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
#line 809 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp35_ = remote_header;
#line 809 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp36_ = _tmp35_->header;
#line 809 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp36_);
#line 810 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp37_ = self->priv->d_header_map;
#line 810 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp38_ = remote;
#line 810 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp37_, _tmp38_, NULL);
#line 4357 "gitg-history-refs-list.c"
		}
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_gitg_history_refs_list_remote_header_unref0 (remote_header);
#line 800 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_free0 (remote);
#line 4363 "gitg-history-refs-list.c"
	}
#line 814 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = TRUE;
#line 814 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 814 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4371 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_remove_ref (GitgHistoryRefsList* self, GitgRef* reference) {
	gboolean result = FALSE;
	GitgRef* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 817 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 817 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, FALSE);
#line 819 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 819 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_remove_ref_internal (self, _tmp0_, GITG_HISTORY_REF_ANIMATION_NONE);
#line 819 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp1_) {
#line 821 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_signal_emit_by_name (self, "changed");
#line 822 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = TRUE;
#line 822 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4395 "gitg-history-refs-list.c"
	}
#line 825 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 825 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4401 "gitg-history-refs-list.c"
}


static gboolean gitg_history_refs_list_select_nullable_row (GitgHistoryRefsList* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
#line 828 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 830 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = row;
#line 830 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 832 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = FALSE;
#line 832 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4420 "gitg-history-refs-list.c"
	}
#line 835 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = row;
#line 835 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_list_box_select_row ((GtkListBox*) self, _tmp1_);
#line 836 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = row;
#line 836 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_scroll_to_row (self, _tmp2_);
#line 838 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = TRUE;
#line 838 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4434 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_select_all_commits (GitgHistoryRefsList* self) {
	gboolean result = FALSE;
	GitgHistoryRefRow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 841 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 843 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_all_commits;
#line 843 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
#line 843 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp1_;
#line 843 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4452 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_select_all_branches (GitgHistoryRefsList* self) {
	gboolean result = FALSE;
	GitgHistoryRefHeader* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 846 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 848 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_all_branches;
#line 848 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
#line 848 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp1_;
#line 848 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4470 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_select_all_remotes (GitgHistoryRefsList* self) {
	gboolean result = FALSE;
	GitgHistoryRefHeader* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 851 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 853 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_all_remotes;
#line 853 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
#line 853 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp1_;
#line 853 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4488 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_select_all_tags (GitgHistoryRefsList* self) {
	gboolean result = FALSE;
	GitgHistoryRefHeader* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 856 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 858 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_all_tags;
#line 858 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gitg_history_refs_list_select_nullable_row (self, (GtkListBoxRow*) _tmp0_);
#line 858 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp1_;
#line 858 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4506 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_select_ref (GitgHistoryRefsList* self, GitgRef* reference) {
	gboolean result = FALSE;
	gchar* refname = NULL;
	GitgRef* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 861 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 861 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (reference != NULL, FALSE);
#line 865 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = reference;
#line 865 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = ggit_ref_get_name ((GgitRef*) _tmp0_);
#line 865 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 865 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	refname = _tmp2_;
#line 4528 "gitg-history-refs-list.c"
	{
		GeeIterator* _ourref_it = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = self->priv->d_ref_map;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = gee_abstract_map_get_keys ((GeeMap*) _tmp3_);
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = _tmp4_;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = _tmp5_;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = _tmp7_;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp6_);
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_ourref_it = _tmp8_;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		while (TRUE) {
#line 4555 "gitg-history-refs-list.c"
			GeeIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			GitgRef* ourref = NULL;
			GeeIterator* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			GitgRef* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp9_ = _ourref_it;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp10_ = gee_iterator_next (_tmp9_);
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (!_tmp10_) {
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				break;
#line 4572 "gitg-history-refs-list.c"
			}
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp11_ = _ourref_it;
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp12_ = gee_iterator_get (_tmp11_);
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			ourref = (GitgRef*) _tmp12_;
#line 869 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = ourref;
#line 869 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp14_ = ggit_ref_get_name ((GgitRef*) _tmp13_);
#line 869 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = refname;
#line 869 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
#line 4588 "gitg-history-refs-list.c"
				GitgHistoryRefRow* row = NULL;
				GeeHashMap* _tmp16_ = NULL;
				GitgRef* _tmp17_ = NULL;
				gpointer _tmp18_ = NULL;
				GitgHistoryRefRow* _tmp19_ = NULL;
				GitgHistoryRefRow* _tmp20_ = NULL;
#line 871 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp16_ = self->priv->d_ref_map;
#line 871 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp17_ = ourref;
#line 871 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
#line 871 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				row = (GitgHistoryRefRow*) _tmp18_;
#line 873 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp19_ = row;
#line 873 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp19_);
#line 874 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp20_ = row;
#line 874 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				gitg_history_refs_list_scroll_to_row (self, (GtkListBoxRow*) _tmp20_);
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				result = TRUE;
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (row);
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (ourref);
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (_ourref_it);
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_free0 (refname);
#line 875 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				return result;
#line 4623 "gitg-history-refs-list.c"
			}
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ourref);
#line 4627 "gitg-history-refs-list.c"
		}
#line 867 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_ourref_it);
#line 4631 "gitg-history-refs-list.c"
	}
#line 879 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = FALSE;
#line 879 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_free0 (refname);
#line 879 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4639 "gitg-history-refs-list.c"
}


static Block50Data* block50_data_ref (Block50Data* _data50_) {
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_atomic_int_inc (&_data50_->_ref_count_);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return _data50_;
#line 4648 "gitg-history-refs-list.c"
}


static void block50_data_unref (void * _userdata_) {
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
#line 4657 "gitg-history-refs-list.c"
		GitgHistoryRefsList* self;
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self = _data50_->self;
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_data50_->head);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_slice_free (Block50Data, _data50_);
#line 4667 "gitg-history-refs-list.c"
	}
}


static gint ___lambda97_ (Block50Data* _data50_, const gchar* nm) {
	GitgHistoryRefsList* self;
	gint result = 0;
	GitgRef* r = NULL;
	GitgRef* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GitgHistoryRefRow* row = NULL;
	GitgRef* _tmp7_ = NULL;
	GitgHistoryRefRow* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GitgHistoryRefRow* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = _data50_->self;
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (nm != NULL, 0);
#line 4688 "gitg-history-refs-list.c"
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
		GitgRef* _tmp4_ = NULL;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp1_ = self->priv->d_repository;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = nm;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = gitg_repository_lookup_reference (_tmp1_, _tmp2_, &_inner_error_);
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp0_ = _tmp3_;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4705 "gitg-history-refs-list.c"
			goto __catch82_g_error;
		}
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = _tmp0_;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp0_ = NULL;
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (r);
#line 920 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		r = _tmp4_;
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_tmp0_);
#line 4718 "gitg-history-refs-list.c"
	}
	goto __finally82;
	__catch82_g_error:
	{
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_inner_error_ = NULL;
#line 921 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = 0;
#line 921 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (r);
#line 921 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4733 "gitg-history-refs-list.c"
	}
	__finally82:
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (r);
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 918 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return 0;
#line 4746 "gitg-history-refs-list.c"
	}
#line 925 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = r;
#line 925 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gitg_history_refs_list_ref_is_a_symbolic_head (self, _tmp5_);
#line 925 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp6_) {
#line 927 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = 0;
#line 927 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (r);
#line 927 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 4760 "gitg-history-refs-list.c"
	}
#line 930 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = r;
#line 930 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = gitg_history_refs_list_add_ref_internal (self, _tmp7_, GITG_HISTORY_REF_ANIMATION_NONE);
#line 930 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = _tmp8_;
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = row;
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp10_ != NULL) {
#line 4772 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = row;
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = gitg_history_ref_row_get_is_head (_tmp11_);
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = _tmp12_;
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = _tmp13_;
#line 4784 "gitg-history-refs-list.c"
	} else {
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = FALSE;
#line 4788 "gitg-history-refs-list.c"
	}
#line 932 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp9_) {
#line 4792 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp14_ = NULL;
		GitgHistoryRefRow* _tmp15_ = NULL;
#line 934 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = row;
#line 934 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 934 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (_data50_->head);
#line 934 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_data50_->head = _tmp15_;
#line 4803 "gitg-history-refs-list.c"
	}
#line 936 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = 0;
#line 936 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 936 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (r);
#line 936 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4813 "gitg-history-refs-list.c"
}


static gint ____lambda97__ggit_references_name_callback (const gchar* name, gpointer self) {
	gint result;
	result = ___lambda97_ (self, name);
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 4822 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_refresh (GitgHistoryRefsList* self) {
	Block50Data* _data50_;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GitgRepository* _tmp2_ = NULL;
	GitgHistoryRefRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GitgHistoryRefHeader* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GitgHistoryRefHeader* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GitgHistoryRefHeader* _tmp9_ = NULL;
	GtkListBoxRow* sel = NULL;
	GtkListBoxRow* _tmp18_ = NULL;
	GtkListBoxRow* _tmp19_ = NULL;
	GtkListBoxRow* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data50_ = g_slice_new0 (Block50Data);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data50_->_ref_count_ = 1;
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data50_->self = g_object_ref (self);
#line 884 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_freeze_notify ((GObject*) self);
#line 886 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 886 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 886 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_selected_row);
#line 886 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_selected_row = _tmp1_;
#line 888 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_clear (self);
#line 890 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = self->priv->d_repository;
#line 890 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_ == NULL) {
#line 892 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self->priv->d_selected_row);
#line 892 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self->priv->d_selected_row = NULL;
#line 893 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_thaw_notify ((GObject*) self);
#line 894 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		block50_data_unref (_data50_);
#line 894 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_data50_ = NULL;
#line 894 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 4879 "gitg-history-refs-list.c"
	}
#line 897 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = gitg_history_refs_list_add_ref_row (self, NULL, GITG_HISTORY_REF_ANIMATION_NONE);
#line 897 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_commits);
#line 897 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_commits = _tmp3_;
#line 898 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = _ ("Branches");
#line 898 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_BRANCH, _tmp4_);
#line 898 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_branches);
#line 898 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_branches = _tmp5_;
#line 899 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = _ ("Remotes");
#line 899 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_REMOTE, _tmp6_);
#line 899 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_remotes);
#line 899 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_remotes = _tmp7_;
#line 900 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = _ ("Tags");
#line 900 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = gitg_history_refs_list_add_header (self, GITG_REF_TYPE_TAG, _tmp8_);
#line 900 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_tags);
#line 900 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_all_tags = _tmp9_;
#line 902 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data50_->head = NULL;
#line 4913 "gitg-history-refs-list.c"
	{
		gboolean _tmp10_ = FALSE;
		GitgRepository* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = self->priv->d_repository;
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = ggit_repository_is_head_detached ((GgitRepository*) _tmp11_, &_inner_error_);
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = _tmp12_;
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4926 "gitg-history-refs-list.c"
			goto __catch80_g_error;
		}
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp10_) {
#line 4931 "gitg-history-refs-list.c"
			GitgRef* _tmp13_ = NULL;
			GitgRepository* _tmp14_ = NULL;
			GitgRef* _tmp15_ = NULL;
			GitgHistoryRefRow* _tmp16_ = NULL;
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp14_ = self->priv->d_repository;
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = gitg_repository_lookup_reference (_tmp14_, "HEAD", &_inner_error_);
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = _tmp15_;
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4944 "gitg-history-refs-list.c"
				goto __catch80_g_error;
			}
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp16_ = gitg_history_refs_list_add_ref_internal (self, _tmp13_, GITG_HISTORY_REF_ANIMATION_NONE);
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_data50_->head);
#line 908 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_data50_->head = _tmp16_;
#line 906 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_tmp13_);
#line 4955 "gitg-history-refs-list.c"
		}
	}
	goto __finally80;
	__catch80_g_error:
	{
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_inner_error_ = NULL;
#line 4965 "gitg-history-refs-list.c"
	}
	__finally80:
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		block50_data_unref (_data50_);
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_data50_ = NULL;
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 904 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 4980 "gitg-history-refs-list.c"
	}
	{
		GitgRepository* _tmp17_ = NULL;
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp17_ = self->priv->d_repository;
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		ggit_repository_references_foreach_name ((GgitRepository*) _tmp17_, ____lambda97__ggit_references_name_callback, _data50_, &_inner_error_);
#line 915 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4990 "gitg-history-refs-list.c"
			goto __catch81_g_error;
		}
	}
	goto __finally81;
	__catch81_g_error:
	{
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_inner_error_ = NULL;
#line 5001 "gitg-history-refs-list.c"
	}
	__finally81:
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		block50_data_unref (_data50_);
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_data50_ = NULL;
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 913 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 5016 "gitg-history-refs-list.c"
	}
#line 940 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_selected_row);
#line 940 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_selected_row = NULL;
#line 942 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp18_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 942 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 942 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	sel = _tmp19_;
#line 944 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp20_ = sel;
#line 944 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp20_ == NULL) {
#line 5032 "gitg-history-refs-list.c"
		GSettings* settings = NULL;
		GSettings* _tmp21_ = NULL;
		GitgHistoryDefaultSelection default_selection = 0;
		GSettings* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		GtkListBoxRow* srow = NULL;
		GitgHistoryDefaultSelection _tmp24_ = 0;
		GtkListBoxRow* _tmp31_ = NULL;
#line 946 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp21_ = g_settings_new ("org.gnome.gitg.preferences.history");
#line 946 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		settings = _tmp21_;
#line 947 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp22_ = settings;
#line 947 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp23_ = g_settings_get_enum (_tmp22_, "default-selection");
#line 947 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		default_selection = (GitgHistoryDefaultSelection) _tmp23_;
#line 948 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		srow = NULL;
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp24_ = default_selection;
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		switch (_tmp24_) {
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			case GITG_HISTORY_DEFAULT_SELECTION_CURRENT_BRANCH:
#line 5059 "gitg-history-refs-list.c"
			{
				GitgHistoryRefRow* _tmp25_ = NULL;
				GtkListBoxRow* _tmp26_ = NULL;
#line 953 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp25_ = _data50_->head;
#line 953 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp26_ = _g_object_ref0 ((GtkListBoxRow*) _tmp25_);
#line 953 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (srow);
#line 953 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				srow = _tmp26_;
#line 954 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				break;
#line 5073 "gitg-history-refs-list.c"
			}
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			case GITG_HISTORY_DEFAULT_SELECTION_ALL_BRANCHES:
#line 5077 "gitg-history-refs-list.c"
			{
				GitgHistoryRefHeader* _tmp27_ = NULL;
				GtkListBoxRow* _tmp28_ = NULL;
#line 956 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp27_ = self->priv->d_all_branches;
#line 956 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp28_ = _g_object_ref0 ((GtkListBoxRow*) _tmp27_);
#line 956 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (srow);
#line 956 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				srow = _tmp28_;
#line 957 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				break;
#line 5091 "gitg-history-refs-list.c"
			}
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			case GITG_HISTORY_DEFAULT_SELECTION_ALL_COMMITS:
#line 5095 "gitg-history-refs-list.c"
			{
				GitgHistoryRefRow* _tmp29_ = NULL;
				GtkListBoxRow* _tmp30_ = NULL;
#line 959 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp29_ = self->priv->d_all_commits;
#line 959 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp30_ = _g_object_ref0 ((GtkListBoxRow*) _tmp29_);
#line 959 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (srow);
#line 959 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				srow = _tmp30_;
#line 960 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				break;
#line 5109 "gitg-history-refs-list.c"
			}
			default:
#line 950 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 5114 "gitg-history-refs-list.c"
		}
#line 963 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp31_ = srow;
#line 963 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp31_ != NULL) {
#line 5120 "gitg-history-refs-list.c"
			GtkListBoxRow* _tmp32_ = NULL;
#line 966 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp32_ = srow;
#line 966 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gtk_list_box_select_row ((GtkListBox*) self, _tmp32_);
#line 5126 "gitg-history-refs-list.c"
		} else {
			GitgHistoryRefRow* _tmp33_ = NULL;
#line 971 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp33_ = self->priv->d_all_commits;
#line 971 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp33_);
#line 5133 "gitg-history-refs-list.c"
		}
#line 944 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (srow);
#line 944 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (settings);
#line 5139 "gitg-history-refs-list.c"
	}
#line 975 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_thaw_notify ((GObject*) self);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (sel);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	block50_data_unref (_data50_);
#line 882 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_data50_ = NULL;
#line 5149 "gitg-history-refs-list.c"
}


static GitgHistoryRefRow* gitg_history_refs_list_get_ref_row (GitgHistoryRefsList* self, GtkListBoxRow* row) {
	GitgHistoryRefRow* result = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GitgHistoryRefRow* _tmp2_ = NULL;
#line 978 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 980 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = row;
#line 980 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ == NULL) {
#line 982 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = NULL;
#line 982 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 5168 "gitg-history-refs-list.c"
	}
#line 985 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = row;
#line 985 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GITG_HISTORY_TYPE_REF_ROW) ? ((GitgHistoryRefRow*) _tmp1_) : NULL);
#line 985 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp2_;
#line 985 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5178 "gitg-history-refs-list.c"
}


static GitgHistoryRefHeader* gitg_history_refs_list_get_ref_header (GitgHistoryRefsList* self, GtkListBoxRow* row) {
	GitgHistoryRefHeader* result = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GitgHistoryRefHeader* _tmp1_ = NULL;
#line 988 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 988 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (row != NULL, NULL);
#line 990 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = row;
#line 990 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp0_) : NULL);
#line 990 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp1_;
#line 990 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5198 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_real_row_selected (GtkListBox* base, GtkListBoxRow* row) {
	GitgHistoryRefsList * self;
#line 1106 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsList*) base;
#line 1108 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject*) self, "selection");
#line 5208 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_real_move_cursor (GtkListBox* base, GtkMovementStep step, gint n) {
	GitgHistoryRefsList * self;
	GtkListBoxRow* selrow = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkMovementStep _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkListBoxRow* _tmp4_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
#line 1111 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsList*) base;
#line 1113 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1113 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1113 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	selrow = _tmp1_;
#line 1114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = step;
#line 1114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = n;
#line 1114 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	GTK_LIST_BOX_CLASS (gitg_history_refs_list_parent_class)->move_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp2_, _tmp3_);
#line 1116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = selrow;
#line 1116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1116 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp4_ != _tmp5_) {
#line 1118 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_object_notify ((GObject*) self, "selection");
#line 5243 "gitg-history-refs-list.c"
	}
#line 1111 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (selrow);
#line 5247 "gitg-history-refs-list.c"
}


void gitg_history_refs_list_edit (GitgHistoryRefsList* self, GitgRef* reference, GitgExtRefNameEditingDone done, void* done_target, GDestroyNotify done_target_destroy_notify) {
	GeeHashMap* _tmp0_ = NULL;
	GitgRef* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgHistoryRefRow* row = NULL;
	GeeHashMap* _tmp4_ = NULL;
	GitgRef* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	GitgHistoryRefRow* _tmp7_ = NULL;
	GitgExtRefNameEditingDone _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GDestroyNotify _tmp8__target_destroy_notify = NULL;
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (reference != NULL);
#line 1124 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_ref_map;
#line 1124 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = reference;
#line 1124 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 1124 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!_tmp2_) {
#line 5275 "gitg-history-refs-list.c"
		GitgExtRefNameEditingDone _tmp3_ = NULL;
		void* _tmp3__target = NULL;
#line 1126 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = done;
#line 1126 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3__target = done_target;
#line 1126 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ ("", TRUE, _tmp3__target);
#line 1127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
#line 1127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done = NULL;
#line 1127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done_target = NULL;
#line 1127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		done_target_destroy_notify = NULL;
#line 1127 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return;
#line 5294 "gitg-history-refs-list.c"
	}
#line 1130 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = self->priv->d_ref_map;
#line 1130 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = reference;
#line 1130 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 1130 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = (GitgHistoryRefRow*) _tmp6_;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = row;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = done;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8__target = done_target;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8__target_destroy_notify = done_target_destroy_notify;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target_destroy_notify = NULL;
#line 1131 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_ref_row_begin_editing (_tmp7_, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	(done_target_destroy_notify == NULL) ? NULL : (done_target_destroy_notify (done_target), NULL);
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done = NULL;
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target = NULL;
#line 1122 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	done_target_destroy_notify = NULL;
#line 5326 "gitg-history-refs-list.c"
}


static gint gitg_history_refs_list_y_in_window (GitgHistoryRefsList* self, gint y, GdkWindow* origin) {
	gint result = 0;
	gint _tmp9_ = 0;
#line 1134 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1134 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (origin != NULL, 0);
#line 1136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	while (TRUE) {
#line 5339 "gitg-history-refs-list.c"
		GdkWindow* _tmp0_ = NULL;
		GdkWindow* _tmp1_ = NULL;
		gint wx = 0;
		gint wy = 0;
		GdkWindow* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkWindow* _tmp7_ = NULL;
		GdkWindow* _tmp8_ = NULL;
#line 1136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp0_ = origin;
#line 1136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 1136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (!(_tmp0_ != _tmp1_)) {
#line 1136 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			break;
#line 5359 "gitg-history-refs-list.c"
		}
#line 1141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = origin;
#line 1141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gdk_window_get_position (_tmp2_, &_tmp3_, &_tmp4_);
#line 1141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		wx = _tmp3_;
#line 1141 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		wy = _tmp4_;
#line 1143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = y;
#line 1143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp6_ = wy;
#line 1143 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		y = _tmp5_ + _tmp6_;
#line 1145 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = origin;
#line 1145 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = gdk_window_get_parent (_tmp7_);
#line 1145 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		origin = _tmp8_;
#line 5381 "gitg-history-refs-list.c"
	}
#line 1148 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = y;
#line 1148 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp9_;
#line 1148 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5389 "gitg-history-refs-list.c"
}


static gboolean gitg_history_refs_list_real_button_press_event (GtkWidget* base, GdkEventButton* button) {
	GitgHistoryRefsList * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint y = 0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	GdkEventButton* _tmp4_ = NULL;
	GdkWindow* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GtkListBoxRow* row = NULL;
	gint _tmp7_ = 0;
	GtkListBoxRow* _tmp8_ = NULL;
	GtkListBoxRow* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkListBoxRow* _tmp11_ = NULL;
#line 1151 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsList*) base;
#line 1151 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (button != NULL, FALSE);
#line 1153 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = button;
#line 1153 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = GTK_WIDGET_CLASS (gitg_history_refs_list_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp0_);
#line 1153 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ret = _tmp1_;
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = button;
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = _tmp2_->y;
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = button;
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = _tmp4_->window;
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gitg_history_refs_list_y_in_window (self, (gint) _tmp3_, _tmp5_);
#line 1155 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	y = _tmp6_;
#line 1156 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = y;
#line 1156 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, _tmp7_);
#line 1156 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 1156 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = _tmp9_;
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp11_ = row;
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp11_ != NULL) {
#line 5445 "gitg-history-refs-list.c"
		GtkListBoxRow* _tmp12_ = NULL;
		GtkListBoxRow* _tmp13_ = NULL;
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = row;
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = _tmp12_ != _tmp13_;
#line 5454 "gitg-history-refs-list.c"
	} else {
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = FALSE;
#line 5458 "gitg-history-refs-list.c"
	}
#line 1158 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp10_) {
#line 5462 "gitg-history-refs-list.c"
		GtkListBoxRow* _tmp14_ = NULL;
#line 1160 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = row;
#line 1160 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_list_box_select_row ((GtkListBox*) self, _tmp14_);
#line 5468 "gitg-history-refs-list.c"
	}
#line 1163 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = ret;
#line 1163 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 1163 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5476 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_scroll_to_row (GitgHistoryRefsList* self, GtkListBoxRow* row) {
	GtkAdjustment* adj = NULL;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAllocation alloc = {0};
	GtkListBoxRow* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	gdouble v = 0.0;
	GtkAdjustment* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble s = 0.0;
	GtkAdjustment* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
#line 1166 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 1166 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (row != NULL);
#line 1168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_adjustment ((GtkListBox*) self);
#line 1168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1168 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	adj = _tmp1_;
#line 1171 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = row;
#line 1171 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp2_, &_tmp3_);
#line 1171 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	alloc = _tmp3_;
#line 1173 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = adj;
#line 1173 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = gtk_adjustment_get_value (_tmp4_);
#line 1173 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	v = _tmp5_;
#line 1174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = adj;
#line 1174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gtk_adjustment_get_page_size (_tmp6_);
#line 1174 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	s = _tmp7_;
#line 1176 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = alloc;
#line 1176 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp9_ = _tmp8_.y;
#line 1176 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp10_ = v;
#line 1176 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (((gdouble) _tmp9_) < _tmp10_) {
#line 5532 "gitg-history-refs-list.c"
		GtkAdjustment* _tmp11_ = NULL;
		GtkAllocation _tmp12_ = {0};
		gint _tmp13_ = 0;
#line 1178 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = adj;
#line 1178 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp12_ = alloc;
#line 1178 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp13_ = _tmp12_.y;
#line 1178 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gtk_adjustment_set_value (_tmp11_, (gdouble) _tmp13_);
#line 5544 "gitg-history-refs-list.c"
	} else {
		GtkAllocation _tmp14_ = {0};
		gint _tmp15_ = 0;
		GtkAllocation _tmp16_ = {0};
		gint _tmp17_ = 0;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = alloc;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp15_ = _tmp14_.y;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp16_ = alloc;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp17_ = _tmp16_.height;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = v;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = s;
#line 1180 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (((gdouble) (_tmp15_ + _tmp17_)) > (_tmp18_ + _tmp19_)) {
#line 5566 "gitg-history-refs-list.c"
			GtkAdjustment* _tmp20_ = NULL;
			GtkAllocation _tmp21_ = {0};
			gint _tmp22_ = 0;
			GtkAllocation _tmp23_ = {0};
			gint _tmp24_ = 0;
			gdouble _tmp25_ = 0.0;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp20_ = adj;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = alloc;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp22_ = _tmp21_.y;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp23_ = alloc;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp24_ = _tmp23_.height;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp25_ = s;
#line 1182 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gtk_adjustment_set_value (_tmp20_, (_tmp22_ + _tmp24_) - _tmp25_);
#line 5587 "gitg-history-refs-list.c"
		}
	}
#line 1166 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (adj);
#line 5592 "gitg-history-refs-list.c"
}


GitgHistoryRefsList* gitg_history_refs_list_construct (GType object_type) {
	GitgHistoryRefsList * self = NULL;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsList*) g_object_new (object_type, NULL);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self;
#line 5602 "gitg-history-refs-list.c"
}


GitgHistoryRefsList* gitg_history_refs_list_new (void) {
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return gitg_history_refs_list_construct (GITG_HISTORY_TYPE_REFS_LIST);
#line 5609 "gitg-history-refs-list.c"
}


GitgExtRemoteLookup* gitg_history_refs_list_get_remote_lookup (GitgHistoryRefsList* self) {
	GitgExtRemoteLookup* result;
	GitgExtRemoteLookup* _tmp0_ = NULL;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->_remote_lookup;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5624 "gitg-history-refs-list.c"
}


void gitg_history_refs_list_set_remote_lookup (GitgHistoryRefsList* self, GitgExtRemoteLookup* value) {
	GitgExtRemoteLookup* _tmp0_ = NULL;
	GitgExtRemoteLookup* _tmp1_ = NULL;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = value;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->_remote_lookup);
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->_remote_lookup = _tmp1_;
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject *) self, "remote-lookup");
#line 5643 "gitg-history-refs-list.c"
}


GitgRepository* gitg_history_refs_list_get_repository (GitgHistoryRefsList* self) {
	GitgRepository* result;
	GitgRepository* _tmp0_ = NULL;
#line 452 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 452 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_repository;
#line 452 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp0_;
#line 452 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5658 "gitg-history-refs-list.c"
}


void gitg_history_refs_list_set_repository (GitgHistoryRefsList* self, GitgRepository* value) {
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
#line 453 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = self->priv->d_repository;
#line 455 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = value;
#line 455 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp0_ != _tmp1_) {
#line 5673 "gitg-history-refs-list.c"
		GitgRepository* _tmp2_ = NULL;
		GitgRepository* _tmp3_ = NULL;
#line 457 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp2_ = value;
#line 457 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 457 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (self->priv->d_repository);
#line 457 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		self->priv->d_repository = _tmp3_;
#line 458 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_refresh (self);
#line 5686 "gitg-history-refs-list.c"
	}
#line 453 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_notify ((GObject *) self, "repository");
#line 5690 "gitg-history-refs-list.c"
}


GeeList* gitg_history_refs_list_get_all (GitgHistoryRefsList* self) {
	GeeList* result;
	GeeLinkedList* ret = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 995 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 997 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gee_linked_list_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 997 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ret = _tmp0_;
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) self);
#line 5708 "gitg-history-refs-list.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		child_collection = _tmp1_;
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 5716 "gitg-history-refs-list.c"
			GtkWidget* child = NULL;
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			child = (GtkWidget*) child_it->data;
#line 5720 "gitg-history-refs-list.c"
			{
				GitgHistoryRefRow* r = NULL;
				GtkWidget* _tmp2_ = NULL;
				GitgHistoryRefRow* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GitgHistoryRefRow* _tmp5_ = NULL;
#line 1001 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp2_ = child;
#line 1001 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp3_ = gitg_history_refs_list_get_ref_row (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp2_) : NULL);
#line 1001 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				r = _tmp3_;
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_tmp5_ = r;
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				if (_tmp5_ != NULL) {
#line 5737 "gitg-history-refs-list.c"
					GitgHistoryRefRow* _tmp6_ = NULL;
					GitgRef* _tmp7_ = NULL;
					GitgRef* _tmp8_ = NULL;
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp6_ = r;
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp7_ = gitg_history_ref_row_get_reference (_tmp6_);
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp8_ = _tmp7_;
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp4_ = _tmp8_ != NULL;
#line 5749 "gitg-history-refs-list.c"
				} else {
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp4_ = FALSE;
#line 5753 "gitg-history-refs-list.c"
				}
#line 1003 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				if (_tmp4_) {
#line 5757 "gitg-history-refs-list.c"
					GeeLinkedList* _tmp9_ = NULL;
					GitgHistoryRefRow* _tmp10_ = NULL;
					GitgRef* _tmp11_ = NULL;
					GitgRef* _tmp12_ = NULL;
#line 1005 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp9_ = ret;
#line 1005 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp10_ = r;
#line 1005 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp11_ = gitg_history_ref_row_get_reference (_tmp10_);
#line 1005 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp12_ = _tmp11_;
#line 1005 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
#line 5772 "gitg-history-refs-list.c"
				}
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				_g_object_unref0 (r);
#line 5776 "gitg-history-refs-list.c"
			}
		}
#line 999 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_list_free0 (child_collection);
#line 5781 "gitg-history-refs-list.c"
	}
	{
		gboolean _tmp13_ = FALSE;
		GitgRepository* _tmp14_ = NULL;
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp14_ = self->priv->d_repository;
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp14_ != NULL) {
#line 5790 "gitg-history-refs-list.c"
			gboolean _tmp15_ = FALSE;
			GitgRepository* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp16_ = self->priv->d_repository;
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp17_ = ggit_repository_is_head_detached ((GgitRepository*) _tmp16_, &_inner_error_);
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = _tmp17_;
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5802 "gitg-history-refs-list.c"
				goto __catch83_g_error;
			}
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = _tmp15_;
#line 5807 "gitg-history-refs-list.c"
		} else {
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = FALSE;
#line 5811 "gitg-history-refs-list.c"
		}
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp13_) {
#line 5815 "gitg-history-refs-list.c"
			GitgRef* _tmp18_ = NULL;
			GitgRepository* _tmp19_ = NULL;
			GitgRef* _tmp20_ = NULL;
			GeeLinkedList* _tmp21_ = NULL;
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp19_ = self->priv->d_repository;
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp20_ = gitg_repository_get_head (_tmp19_, &_inner_error_);
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp18_ = _tmp20_;
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5828 "gitg-history-refs-list.c"
				goto __catch83_g_error;
			}
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp21_ = ret;
#line 1013 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp18_);
#line 1011 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (_tmp18_);
#line 5837 "gitg-history-refs-list.c"
		}
	}
	goto __finally83;
	__catch83_g_error:
	{
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_inner_error_ = NULL;
#line 5847 "gitg-history-refs-list.c"
	}
	__finally83:
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ret);
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_clear_error (&_inner_error_);
#line 1009 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return NULL;
#line 5860 "gitg-history-refs-list.c"
	}
#line 1017 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = (GeeList*) ret;
#line 1017 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5866 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_get_is_header (GitgHistoryRefsList* self) {
	gboolean result;
	GtkListBoxRow* _tmp0_ = NULL;
#line 1023 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1023 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1023 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GITG_HISTORY_TYPE_REF_HEADER) ? ((GitgHistoryRefHeader*) _tmp0_) : NULL) != NULL;
#line 1023 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5881 "gitg-history-refs-list.c"
}


gboolean gitg_history_refs_list_get_is_all (GitgHistoryRefsList* self) {
	gboolean result;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GitgHistoryRefRow* ref_row = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	GitgHistoryRefRow* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GitgHistoryRefRow* _tmp6_ = NULL;
#line 1028 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1030 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1030 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1030 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = _tmp1_;
#line 1032 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = row;
#line 1032 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_ == NULL) {
#line 1034 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = TRUE;
#line 1034 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (row);
#line 1034 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 5914 "gitg-history-refs-list.c"
	}
#line 1037 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp3_ = row;
#line 1037 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp4_ = gitg_history_refs_list_get_ref_row (self, _tmp3_);
#line 1037 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ref_row = _tmp4_;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = ref_row;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp6_ != NULL) {
#line 5926 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp7_ = NULL;
		GitgRef* _tmp8_ = NULL;
		GitgRef* _tmp9_ = NULL;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp7_ = ref_row;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp8_ = gitg_history_ref_row_get_reference (_tmp7_);
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = _tmp8_;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = _tmp9_ == NULL;
#line 5938 "gitg-history-refs-list.c"
	} else {
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp5_ = FALSE;
#line 5942 "gitg-history-refs-list.c"
	}
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = _tmp5_;
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ref_row);
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 1039 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 5952 "gitg-history-refs-list.c"
}


GeeList* gitg_history_refs_list_get_selection (GitgHistoryRefsList* self) {
	GeeList* result;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GitgHistoryRefRow* ref_row = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	GitgHistoryRefRow* _tmp6_ = NULL;
	GeeLinkedList* ret = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GitgHistoryRefRow* _tmp8_ = NULL;
#line 1045 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1047 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
#line 1047 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1047 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	row = _tmp1_;
#line 1049 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = row;
#line 1049 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp2_ == NULL) {
#line 5980 "gitg-history-refs-list.c"
		GeeList* _tmp3_ = NULL;
		GeeList* _tmp4_ = NULL;
#line 1051 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp3_ = gitg_history_refs_list_get_all (self);
#line 1051 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp4_ = _tmp3_;
#line 1051 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		result = _tmp4_;
#line 1051 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (row);
#line 1051 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return result;
#line 5993 "gitg-history-refs-list.c"
	}
#line 1054 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp5_ = row;
#line 1054 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp6_ = gitg_history_refs_list_get_ref_row (self, _tmp5_);
#line 1054 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ref_row = _tmp6_;
#line 1055 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp7_ = gee_linked_list_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 1055 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	ret = _tmp7_;
#line 1057 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp8_ = ref_row;
#line 1057 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (_tmp8_ != NULL) {
#line 6009 "gitg-history-refs-list.c"
		GitgHistoryRefRow* _tmp9_ = NULL;
		GitgRef* _tmp10_ = NULL;
		GitgRef* _tmp11_ = NULL;
#line 1059 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp9_ = ref_row;
#line 1059 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp10_ = gitg_history_ref_row_get_reference (_tmp9_);
#line 1059 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp11_ = _tmp10_;
#line 1059 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (_tmp11_ == NULL) {
#line 6021 "gitg-history-refs-list.c"
			GeeList* _tmp12_ = NULL;
			GeeList* _tmp13_ = NULL;
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp12_ = gitg_history_refs_list_get_all (self);
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp13_ = _tmp12_;
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			result = _tmp13_;
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ret);
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (ref_row);
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_object_unref0 (row);
#line 1061 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return result;
#line 6038 "gitg-history-refs-list.c"
		} else {
			GeeLinkedList* _tmp14_ = NULL;
			GitgHistoryRefRow* _tmp15_ = NULL;
			GitgRef* _tmp16_ = NULL;
			GitgRef* _tmp17_ = NULL;
#line 1065 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp14_ = ret;
#line 1065 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp15_ = ref_row;
#line 1065 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp16_ = gitg_history_ref_row_get_reference (_tmp15_);
#line 1065 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_tmp17_ = _tmp16_;
#line 1065 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
#line 6054 "gitg-history-refs-list.c"
		}
	} else {
		GitgHistoryRefHeader* ref_header = NULL;
		GtkListBoxRow* _tmp18_ = NULL;
		GitgHistoryRefHeader* _tmp19_ = NULL;
		gboolean found = FALSE;
		GList* _tmp20_ = NULL;
#line 1070 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp18_ = row;
#line 1070 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp19_ = gitg_history_refs_list_get_ref_header (self, _tmp18_);
#line 1070 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		ref_header = _tmp19_;
#line 1071 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		found = FALSE;
#line 1073 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_tmp20_ = gtk_container_get_children ((GtkContainer*) self);
#line 6072 "gitg-history-refs-list.c"
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
#line 1073 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			child_collection = _tmp20_;
#line 1073 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 6080 "gitg-history-refs-list.c"
				GtkWidget* child = NULL;
#line 1073 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
				child = (GtkWidget*) child_it->data;
#line 6084 "gitg-history-refs-list.c"
				{
					gboolean _tmp21_ = FALSE;
#line 1075 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					_tmp21_ = found;
#line 1075 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
					if (_tmp21_) {
#line 6091 "gitg-history-refs-list.c"
						GtkListBoxRow* nrow = NULL;
						GtkWidget* _tmp22_ = NULL;
						GtkListBoxRow* _tmp23_ = NULL;
						GitgHistoryRefRow* nref_row = NULL;
						GtkListBoxRow* _tmp24_ = NULL;
						GitgHistoryRefRow* _tmp25_ = NULL;
						GitgHistoryRefRow* _tmp26_ = NULL;
#line 1077 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp22_ = child;
#line 1077 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp22_) : NULL);
#line 1077 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						nrow = _tmp23_;
#line 1078 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp24_ = nrow;
#line 1078 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp25_ = gitg_history_refs_list_get_ref_row (self, _tmp24_);
#line 1078 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						nref_row = _tmp25_;
#line 1080 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp26_ = nref_row;
#line 1080 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						if (_tmp26_ == NULL) {
#line 6115 "gitg-history-refs-list.c"
							GitgHistoryRefHeader* nref_header = NULL;
							GtkListBoxRow* _tmp27_ = NULL;
							GitgHistoryRefHeader* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							GitgHistoryRefHeader* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
							gboolean _tmp32_ = FALSE;
#line 1082 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp27_ = nrow;
#line 1082 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp28_ = gitg_history_refs_list_get_ref_header (self, _tmp27_);
#line 1082 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							nref_header = _tmp28_;
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp30_ = ref_header;
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp31_ = gitg_history_ref_header_get_is_sub_header_remote (_tmp30_);
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp32_ = _tmp31_;
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							if (_tmp32_) {
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp29_ = TRUE;
#line 6139 "gitg-history-refs-list.c"
							} else {
								GitgHistoryRefHeader* _tmp33_ = NULL;
								GitgRefType _tmp34_ = 0;
								GitgRefType _tmp35_ = 0;
								GitgHistoryRefHeader* _tmp36_ = NULL;
								GitgRefType _tmp37_ = 0;
								GitgRefType _tmp38_ = 0;
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp33_ = nref_header;
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp34_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp33_);
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp35_ = _tmp34_;
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp36_ = ref_header;
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp37_ = gitg_history_ref_typed_get_ref_type ((GitgHistoryRefTyped*) _tmp36_);
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp38_ = _tmp37_;
#line 1085 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_tmp29_ = _tmp35_ != _tmp38_;
#line 6161 "gitg-history-refs-list.c"
							}
#line 1084 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							if (_tmp29_) {
#line 1087 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_g_object_unref0 (nref_header);
#line 1087 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_g_object_unref0 (nref_row);
#line 1087 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								_g_object_unref0 (nrow);
#line 1087 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
								break;
#line 6173 "gitg-history-refs-list.c"
							}
#line 1080 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_g_object_unref0 (nref_header);
#line 6177 "gitg-history-refs-list.c"
						} else {
							GeeLinkedList* _tmp39_ = NULL;
							GitgHistoryRefRow* _tmp40_ = NULL;
							GitgRef* _tmp41_ = NULL;
							GitgRef* _tmp42_ = NULL;
#line 1092 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp39_ = ret;
#line 1092 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp40_ = nref_row;
#line 1092 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp41_ = gitg_history_ref_row_get_reference (_tmp40_);
#line 1092 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							_tmp42_ = _tmp41_;
#line 1092 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp42_);
#line 6193 "gitg-history-refs-list.c"
						}
#line 1075 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_g_object_unref0 (nref_row);
#line 1075 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_g_object_unref0 (nrow);
#line 6199 "gitg-history-refs-list.c"
					} else {
						GtkWidget* _tmp43_ = NULL;
						GtkListBoxRow* _tmp44_ = NULL;
#line 1095 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp43_ = child;
#line 1095 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						_tmp44_ = row;
#line 1095 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
						if (_tmp43_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget)) {
#line 1097 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
							found = TRUE;
#line 6211 "gitg-history-refs-list.c"
						}
					}
				}
			}
#line 1073 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			_g_list_free0 (child_collection);
#line 6218 "gitg-history-refs-list.c"
		}
#line 1057 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		_g_object_unref0 (ref_header);
#line 6222 "gitg-history-refs-list.c"
	}
#line 1102 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	result = (GeeList*) ret;
#line 1102 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (ref_row);
#line 1102 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (row);
#line 1102 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 6232 "gitg-history-refs-list.c"
}


static gint _gitg_history_refs_list_sort_rows_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = gitg_history_refs_list_sort_rows ((GitgHistoryRefsList*) self, row1, row2);
#line 482 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return result;
#line 6241 "gitg-history-refs-list.c"
}


static GObject * gitg_history_refs_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgHistoryRefsList * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GitgRemote** _tmp2_ = NULL;
#line 475 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	parent_class = G_OBJECT_CLASS (gitg_history_refs_list_parent_class);
#line 475 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 475 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
#line 477 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, (GBoxedCopyFunc) gitg_history_refs_list_remote_header_ref, gitg_history_refs_list_remote_header_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 477 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_header_map);
#line 477 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_header_map = _tmp0_;
#line 478 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = gee_hash_map_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, GITG_HISTORY_TYPE_REF_ROW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 478 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_ref_map);
#line 478 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_ref_map = _tmp1_;
#line 479 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_BROWSE);
#line 480 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = g_new0 (GitgRemote*, 0 + 1);
#line 480 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
#line 480 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = _tmp2_;
#line 480 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes_length1 = 0;
#line 480 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->_d_remotes_size_ = self->priv->d_remotes_length1;
#line 482 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gtk_list_box_set_sort_func ((GtkListBox*) self, _gitg_history_refs_list_sort_rows_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
#line 475 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return obj;
#line 6286 "gitg-history-refs-list.c"
}


static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_construct (GType object_type, GitgHistoryRefHeader* h) {
	GitgHistoryRefsListRemoteHeader* self = NULL;
	GitgHistoryRefHeader* _tmp0_ = NULL;
	GitgHistoryRefHeader* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
#line 439 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (h != NULL, NULL);
#line 439 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = (GitgHistoryRefsListRemoteHeader*) g_type_create_instance (object_type);
#line 441 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp0_ = h;
#line 441 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 441 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->header);
#line 441 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->header = _tmp1_;
#line 442 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_tmp2_ = gee_hash_set_new (GITG_TYPE_REF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 442 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->references);
#line 442 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->references = _tmp2_;
#line 439 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return self;
#line 6315 "gitg-history-refs-list.c"
}


static GitgHistoryRefsListRemoteHeader* gitg_history_refs_list_remote_header_new (GitgHistoryRefHeader* h) {
#line 439 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return gitg_history_refs_list_remote_header_construct (GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, h);
#line 6322 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_value_remote_header_init (GValue* value) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	value->data[0].v_pointer = NULL;
#line 6329 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_value_remote_header_free_value (GValue* value) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (value->data[0].v_pointer) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_remote_header_unref (value->data[0].v_pointer);
#line 6338 "gitg-history-refs-list.c"
	}
}


static void gitg_history_refs_list_value_remote_header_copy_value (const GValue* src_value, GValue* dest_value) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (src_value->data[0].v_pointer) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		dest_value->data[0].v_pointer = gitg_history_refs_list_remote_header_ref (src_value->data[0].v_pointer);
#line 6348 "gitg-history-refs-list.c"
	} else {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6352 "gitg-history-refs-list.c"
	}
}


static gpointer gitg_history_refs_list_value_remote_header_peek_pointer (const GValue* value) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return value->data[0].v_pointer;
#line 6360 "gitg-history-refs-list.c"
}


static gchar* gitg_history_refs_list_value_remote_header_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (collect_values[0].v_pointer) {
#line 6367 "gitg-history-refs-list.c"
		GitgHistoryRefsListRemoteHeader* object;
		object = collect_values[0].v_pointer;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		if (object->parent_instance.g_class == NULL) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6374 "gitg-history-refs-list.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6378 "gitg-history-refs-list.c"
		}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = gitg_history_refs_list_remote_header_ref (object);
#line 6382 "gitg-history-refs-list.c"
	} else {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = NULL;
#line 6386 "gitg-history-refs-list.c"
	}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return NULL;
#line 6390 "gitg-history-refs-list.c"
}


static gchar* gitg_history_refs_list_value_remote_header_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgHistoryRefsListRemoteHeader** object_p;
	object_p = collect_values[0].v_pointer;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!object_p) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6401 "gitg-history-refs-list.c"
	}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (!value->data[0].v_pointer) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		*object_p = NULL;
#line 6407 "gitg-history-refs-list.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		*object_p = value->data[0].v_pointer;
#line 6411 "gitg-history-refs-list.c"
	} else {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		*object_p = gitg_history_refs_list_remote_header_ref (value->data[0].v_pointer);
#line 6415 "gitg-history-refs-list.c"
	}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return NULL;
#line 6419 "gitg-history-refs-list.c"
}


static GParamSpec* gitg_history_refs_list_param_spec_remote_header (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgHistoryRefsListParamSpecRemoteHeader* spec;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER), NULL);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return G_PARAM_SPEC (spec);
#line 6433 "gitg-history-refs-list.c"
}


static gpointer gitg_history_refs_list_value_get_remote_header (const GValue* value) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER), NULL);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return value->data[0].v_pointer;
#line 6442 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_value_set_remote_header (GValue* value, gpointer v_object) {
	GitgHistoryRefsListRemoteHeader* old;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	old = value->data[0].v_pointer;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (v_object) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = v_object;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_remote_header_ref (value->data[0].v_pointer);
#line 6462 "gitg-history-refs-list.c"
	} else {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = NULL;
#line 6466 "gitg-history-refs-list.c"
	}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (old) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_remote_header_unref (old);
#line 6472 "gitg-history-refs-list.c"
	}
}


static void gitg_history_refs_list_value_take_remote_header (GValue* value, gpointer v_object) {
	GitgHistoryRefsListRemoteHeader* old;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	old = value->data[0].v_pointer;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (v_object) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = v_object;
#line 6491 "gitg-history-refs-list.c"
	} else {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		value->data[0].v_pointer = NULL;
#line 6495 "gitg-history-refs-list.c"
	}
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (old) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_remote_header_unref (old);
#line 6501 "gitg-history-refs-list.c"
	}
}


static void gitg_history_refs_list_remote_header_class_init (GitgHistoryRefsListRemoteHeaderClass * klass) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_remote_header_parent_class = g_type_class_peek_parent (klass);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GitgHistoryRefsListRemoteHeaderClass *) klass)->finalize = gitg_history_refs_list_remote_header_finalize;
#line 6511 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_remote_header_instance_init (GitgHistoryRefsListRemoteHeader * self) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->ref_count = 1;
#line 6518 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_remote_header_finalize (GitgHistoryRefsListRemoteHeader* obj) {
	GitgHistoryRefsListRemoteHeader * self;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_REFS_LIST_TYPE_REMOTE_HEADER, GitgHistoryRefsListRemoteHeader);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_handlers_destroy (self);
#line 436 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->header);
#line 437 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->references);
#line 6532 "gitg-history-refs-list.c"
}


static GType gitg_history_refs_list_remote_header_get_type (void) {
	static volatile gsize gitg_history_refs_list_remote_header_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_refs_list_remote_header_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_history_refs_list_value_remote_header_init, gitg_history_refs_list_value_remote_header_free_value, gitg_history_refs_list_value_remote_header_copy_value, gitg_history_refs_list_value_remote_header_peek_pointer, "p", gitg_history_refs_list_value_remote_header_collect_value, "p", gitg_history_refs_list_value_remote_header_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefsListRemoteHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_refs_list_remote_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefsListRemoteHeader), 0, (GInstanceInitFunc) gitg_history_refs_list_remote_header_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_history_refs_list_remote_header_type_id;
		gitg_history_refs_list_remote_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgHistoryRefsListRemoteHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_history_refs_list_remote_header_type_id__volatile, gitg_history_refs_list_remote_header_type_id);
	}
	return gitg_history_refs_list_remote_header_type_id__volatile;
}


static gpointer gitg_history_refs_list_remote_header_ref (gpointer instance) {
	GitgHistoryRefsListRemoteHeader* self;
	self = instance;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_atomic_int_inc (&self->ref_count);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	return instance;
#line 6557 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_remote_header_unref (gpointer instance) {
	GitgHistoryRefsListRemoteHeader* self;
	self = instance;
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		GITG_HISTORY_REFS_LIST_REMOTE_HEADER_GET_CLASS (self)->finalize (self);
#line 434 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6570 "gitg-history-refs-list.c"
	}
}


static void gitg_history_refs_list_class_init (GitgHistoryRefsListClass * klass) {
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	gitg_history_refs_list_parent_class = g_type_class_peek_parent (klass);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_type_class_add_private (klass, sizeof (GitgHistoryRefsListPrivate));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GObjectClass *) klass)->dispose = gitg_history_refs_list_real_dispose;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GtkListBoxClass *) klass)->row_selected = gitg_history_refs_list_real_row_selected;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GtkListBoxClass *) klass)->move_cursor = gitg_history_refs_list_real_move_cursor;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	((GtkWidgetClass *) klass)->button_press_event = gitg_history_refs_list_real_button_press_event;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_history_refs_list_get_property;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_history_refs_list_set_property;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_history_refs_list_constructor;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_history_refs_list_finalize;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REMOTE_LOOKUP, g_param_spec_object ("remote-lookup", "remote-lookup", "remote-lookup", GITG_EXT_TYPE_REMOTE_LOOKUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_REPOSITORY, g_param_spec_object ("repository", "repository", "repository", GITG_TYPE_REPOSITORY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_ALL, g_param_spec_object ("all", "all", "all", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_IS_HEADER, g_param_spec_boolean ("is-header", "is-header", "is-header", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_IS_ALL, g_param_spec_boolean ("is-all", "is-all", "is-all", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HISTORY_REFS_LIST_SELECTION, g_param_spec_object ("selection", "selection", "selection", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	g_signal_new ("changed", GITG_HISTORY_TYPE_REFS_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6610 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_instance_init (GitgHistoryRefsList * self) {
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv = GITG_HISTORY_REFS_LIST_GET_PRIVATE (self);
#line 6617 "gitg-history-refs-list.c"
}


static void gitg_history_refs_list_finalize (GObject* obj) {
	GitgHistoryRefsList * self;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
#line 423 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_repository);
#line 424 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_ref_map);
#line 425 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_selected_row);
#line 426 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	self->priv->d_remotes = (_vala_array_free (self->priv->d_remotes, self->priv->d_remotes_length1, (GDestroyNotify) g_object_unref), NULL);
#line 427 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_commits);
#line 428 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_branches);
#line 429 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_remotes);
#line 430 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_all_tags);
#line 446 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->d_header_map);
#line 448 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	_g_object_unref0 (self->priv->_remote_lookup);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	G_OBJECT_CLASS (gitg_history_refs_list_parent_class)->finalize (obj);
#line 6647 "gitg-history-refs-list.c"
}


GType gitg_history_refs_list_get_type (void) {
	static volatile gsize gitg_history_refs_list_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_history_refs_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgHistoryRefsListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_history_refs_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHistoryRefsList), 0, (GInstanceInitFunc) gitg_history_refs_list_instance_init, NULL };
		GType gitg_history_refs_list_type_id;
		gitg_history_refs_list_type_id = g_type_register_static (gtk_list_box_get_type (), "GitgHistoryRefsList", &g_define_type_info, 0);
		g_once_init_leave (&gitg_history_refs_list_type_id__volatile, gitg_history_refs_list_type_id);
	}
	return gitg_history_refs_list_type_id__volatile;
}


static void _vala_gitg_history_refs_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgHistoryRefsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_REMOTE_LOOKUP:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_object (value, gitg_history_refs_list_get_remote_lookup (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_REPOSITORY:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_object (value, gitg_history_refs_list_get_repository (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_ALL:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_take_object (value, gitg_history_refs_list_get_all (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_IS_HEADER:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_boolean (value, gitg_history_refs_list_get_is_header (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_IS_ALL:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_set_boolean (value, gitg_history_refs_list_get_is_all (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_SELECTION:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		g_value_take_object (value, gitg_history_refs_list_get_selection (self));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 6704 "gitg-history-refs-list.c"
		default:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 6710 "gitg-history-refs-list.c"
	}
}


static void _vala_gitg_history_refs_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgHistoryRefsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_HISTORY_TYPE_REFS_LIST, GitgHistoryRefsList);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
	switch (property_id) {
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_REMOTE_LOOKUP:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_set_remote_lookup (self, g_value_get_object (value));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		case GITG_HISTORY_REFS_LIST_REPOSITORY:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		gitg_history_refs_list_set_repository (self, g_value_get_object (value));
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 6732 "gitg-history-refs-list.c"
		default:
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 421 "/home/jesse/devel/gitg/gitg/history/gitg-history-refs-list.vala"
		break;
#line 6738 "gitg-history-refs-list.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



