-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc.ads,v $
--  Description     : Ada Database Objects Toplevel package                  --
--  Author          : <a>Michael Erdmann</a>                                 --
--  Created         : 18.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: <d>$Date: 2002/02/23 17:31:10 $
--  Version         : $Revision: 1.2 $
--  Status          : $State: Exp $</d>
--                                                                           --
--  Copyright (C) 2001 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--  <p>                                                                      --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is the top level package of the ADO objects. It contains the basic  --
--  reference types for connections, statements and resultsets. </p>         --
--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
package GNU.DB.ADBC is

   Default_Database : constant String := "";
   Default_Password : constant String := "";

   Null_ID_Value    : constant Natural := 0;

   type Connection_ID is new Natural range Null_ID_Value..20;
   type Statement_ID  is new Natural range Null_ID_Value..256;
   type Resultset_ID  is new Natural range Null_ID_Value..256;

   --<?>This is a common exception used by all modules if some kind of
   --   missue in the interface has taken place.</?>
   Usage_Error      : exception      ;

end GNU.DB.ADBC;

