/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableListMultimapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testBuilderOrderKeysAndValuesBy() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderOrderKeysAndValuesBy();
}

public void testBuilderOrderKeysBy() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderOrderKeysBy();
}

public void testBuilderOrderKeysByDuplicates() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderOrderKeysByDuplicates();
}

public void testBuilderOrderValuesBy() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderOrderValuesBy();
}

public void testBuilderPutAllIterable() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutAllIterable();
}

public void testBuilderPutAllMultimap() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutAllMultimap();
}

public void testBuilderPutAllMultimapWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutAllMultimapWithDuplicates();
}

public void testBuilderPutAllVarargs() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutAllVarargs();
}

public void testBuilderPutAllWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutAllWithDuplicates();
}

public void testBuilderPutNullKey() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutNullKey();
}

public void testBuilderPutNullValue() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutNullValue();
}

public void testBuilderPutWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilderPutWithDuplicates();
}

public void testBuilder_withImmutableEntry() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilder_withImmutableEntry();
}

public void testBuilder_withImmutableEntryAndNullContents() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilder_withImmutableEntryAndNullContents();
}

public void testBuilder_withMutableEntry() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testBuilder_withMutableEntry();
}

public void testCopyOf() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOf();
}

public void testCopyOfEmpty() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOfEmpty();
}

public void testCopyOfImmutableListMultimap() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOfImmutableListMultimap();
}

public void testCopyOfNullKey() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOfNullKey();
}

public void testCopyOfNullValue() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOfNullValue();
}

public void testCopyOfWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testCopyOfWithDuplicates();
}

public void testEmptyMultimapReads() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testEmptyMultimapReads();
}

public void testEmptyMultimapWrites() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testEmptyMultimapWrites();
}

public void testInverse() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testInverse();
}

public void testInverseMinimizesWork() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testInverseMinimizesWork();
}

public void testMultimapEquals() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testMultimapEquals();
}

public void testMultimapReads() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testMultimapReads();
}

public void testMultimapWrites() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testMultimapWrites();
}

public void testOf() throws Exception {
  com.google.common.collect.ImmutableListMultimapTest testCase = new com.google.common.collect.ImmutableListMultimapTest();
  testCase.testOf();
}
}
