//
// C++ Interface: inputdir
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef INPUTDIR_H
#define INPUTDIR_H

#include "iconload.h"
#include "ui_inputdir.h"
#include <QtGui/QDialog>
#include <QResizeEvent>
#include <QKeyEvent>

#include <kurl.h>
#include <krun.h>
#include <kfiledialog.h>
#include <klocale.h>


/**
 * This is the main view class for gwenrename.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Spiros Georgaras <sng@hellug.gr>
 * @version 1.1
 */

class inpDir : public QDialog, public Ui::InputDir
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
     inpDir(QDialog * parent = 0);
     inpDir(QDialog * parent , iconload * ic);
		 
    /**
     * Destructor
     */
    virtual ~inpDir();
		QString selectedFolder();
private:
    Ui::InputDir inputdir;
		int numOfHistoryItems;
		QString res;
		
		void readHistory();
		void writeHistory();
		virtual void keyPressEvent( QKeyEvent *e );
		virtual void resizeEvent ( QResizeEvent *e );
		
// signals:
//     /**
//      * Use this signal to change the content of the statusbar
//      */
//     void signalChangeStatusbar(const QString& text);
// 
//     /**
//      * Use this signal to change the content of the caption
//      */
//     void signalChangeCaption(const QString& text);
// 
private slots:
		void buttonOkClicked();
		void openDirSelectionDialog();
		void textHasChanged( const QString &  );
		void showHelp();
};

#endif // INPUTDIR_H
