/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.dvb.ui.DVBAlphaComposite;
import org.dvb.ui.DVBGraphics;
import org.dvb.ui.UnsupportedDrawingOperationException;
import org.videolan.Logger;

public class DVBGraphicsImpl
extends DVBGraphics {
    private Graphics2D gfx;

    protected DVBGraphicsImpl(Graphics2D gfx) {
        this.gfx = gfx;
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.gfx.clearRect(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.gfx.clipRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.gfx.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public Graphics create() {
        return this.gfx.create();
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return this.gfx.create(x, y, width, height);
    }

    @Override
    public void dispose() {
        this.gfx.dispose();
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.gfx.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gfx.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.gfx.drawBytes(data, offset, length, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.gfx.drawChars(data, offset, length, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.gfx.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.gfx.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.gfx.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.gfx.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.gfx.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.gfx.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gfx.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gfx.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.gfx.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.gfx.drawPolygon(p);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.gfx.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.gfx.drawRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gfx.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.gfx.drawString(iterator, x, y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.gfx.drawString(str, x, y);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.gfx.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gfx.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gfx.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.gfx.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.gfx.fillPolygon(p);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.gfx.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gfx.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Shape getClip() {
        return this.gfx.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.gfx.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.gfx.getClipBounds(r);
    }

    @Override
    public Rectangle getClipRect() {
        return this.gfx.getClipRect();
    }

    @Override
    public Color getColor() {
        return this.gfx.getColor();
    }

    @Override
    public Font getFont() {
        return this.gfx.getFont();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.gfx.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.gfx.getFontMetrics(f);
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        return this.gfx.hitClip(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.gfx.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this.gfx.setClip(clip);
    }

    @Override
    public void setColor(Color c) {
        this.gfx.setColor(c);
    }

    @Override
    public void setFont(Font font) {
        this.gfx.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.gfx.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.gfx.setXORMode(c1);
    }

    @Override
    public void translate(int x, int y) {
        this.gfx.translate(x, y);
    }

    @Override
    public int[] getAvailableCompositeRules() {
        int[] rules = new int[]{1, 2, 3};
        return rules;
    }

    @Override
    public DVBAlphaComposite getDVBComposite() {
        Composite comp = this.gfx.getComposite();
        if (!(comp instanceof AlphaComposite)) {
            return null;
        }
        return DVBAlphaComposite.getInstance(((AlphaComposite)comp).getRule(), ((AlphaComposite)comp).getAlpha());
    }

    @Override
    public void setDVBComposite(DVBAlphaComposite comp) throws UnsupportedDrawingOperationException {
        if (comp.getRule() < 1 || comp.getRule() > 3) {
            Logger.getLogger("DVBGraphics").error("setDVBComposite() FAILED: unsupported rule " + comp.getRule());
            throw new UnsupportedDrawingOperationException("Unsupported composition rule: " + comp.getRule());
        }
        this.gfx.setComposite(AlphaComposite.getInstance(comp.getRule(), comp.getAlpha()));
    }

    public void addRenderingHints(Map hints) {
        this.gfx.addRenderingHints(hints);
    }

    @Override
    public void clip(Shape s) {
        this.gfx.clip(s);
    }

    @Override
    public void draw(Shape s) {
        this.gfx.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.gfx.drawGlyphVector(g, x, y);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.gfx.drawImage(img, op, x, y);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.gfx.drawImage(img, xform, obs);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.gfx.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.gfx.drawRenderedImage(img, xform);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.gfx.drawString(iterator, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.gfx.drawString(str, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.gfx.fill(s);
    }

    @Override
    public Color getBackground() {
        return this.gfx.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.gfx.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.gfx.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.gfx.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.gfx.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.gfx.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.gfx.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.gfx.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.gfx.getTransform();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.gfx.hit(rect, s, onStroke);
    }

    @Override
    public void rotate(double theta) {
        this.gfx.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.gfx.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.gfx.scale(sx, sy);
    }

    @Override
    public void setBackground(Color color) {
        this.gfx.setBackground(color);
    }

    @Override
    public void setComposite(Composite comp) {
        this.gfx.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.gfx.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.gfx.setRenderingHint(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.gfx.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.gfx.setStroke(s);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.gfx.setTransform(Tx);
    }

    @Override
    public void shear(double shx, double shy) {
        this.gfx.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.gfx.transform(Tx);
    }

    @Override
    public void translate(double tx, double ty) {
        this.gfx.translate(tx, ty);
    }
}

