/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.matcher;

import org.apache.commons.text.matcher.AbstractStringMatcher;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringMatcherOnCharArrayTest {
    private static final char[] INPUT1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] INPUT2 = "abcdef".toCharArray();
    private static final int INPUT2_LENGTH = INPUT2.length;

    private void checkAndMatcher_char(StringMatcher matcher) {
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH)).isEqualTo(3);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2)).isEqualTo(3);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5)).isEqualTo(0);
    }

    @Test
    public void testAndMatcher_char() {
        StringMatcher matcher1 = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{StringMatcherFactory.INSTANCE.charMatcher('c'), StringMatcherFactory.INSTANCE.stringMatcher("de")});
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)matcher1.size());
        this.checkAndMatcher_char(matcher1);
        StringMatcher matcher2 = StringMatcherFactory.INSTANCE.andMatcher(new StringMatcher[]{null, StringMatcherFactory.INSTANCE.charMatcher('c'), null, StringMatcherFactory.INSTANCE.stringMatcher("de"), null});
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)matcher2.size());
        this.checkAndMatcher_char(matcher2);
    }

    @Test
    public void testCharMatcher_char() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charMatcher('c');
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5)).isEqualTo(0);
    }

    @Test
    public void testCharSetMatcher_charArray() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace".toCharArray());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher(new char[0])).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher((char[])null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((boolean)(StringMatcherFactory.INSTANCE.charSetMatcher("a".toCharArray()) instanceof AbstractStringMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testCharSetMatcher_String() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.charSetMatcher("ace");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher("")).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.charSetMatcher((String)null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((boolean)(StringMatcherFactory.INSTANCE.charSetMatcher("a") instanceof AbstractStringMatcher.CharMatcher)).isTrue();
    }

    @Test
    public void testCommaMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.commaMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 0, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 1, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 1)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2)).isEqualTo(0);
    }

    @Test
    public void testDoubleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.doubleQuoteMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.doubleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12)).isEqualTo(1);
    }

    @Test
    public void testMatcherIndices() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.stringMatcher("bc");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)matcher.size());
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 1, INPUT2_LENGTH)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, 3)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, 2)).isEqualTo(0);
    }

    @Test
    public void testNoneMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.noneMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.noneMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 0, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 1, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 1)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12)).isEqualTo(0);
    }

    @Test
    public void testQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.quoteMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.quoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12)).isEqualTo(1);
    }

    @Test
    public void testSingleQuoteMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.singleQuoteMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.singleQuoteMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 11)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 12)).isEqualTo(0);
    }

    @Test
    public void testSpaceMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.spaceMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.spaceMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6)).isEqualTo(0);
    }

    @Test
    public void testSplitMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.splitMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.splitMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10)).isEqualTo(0);
    }

    private void testStringMatcher_String(StringMatcher matcher) {
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)matcher.size());
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1, 0, INPUT2_LENGTH)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5, 0, INPUT2_LENGTH)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 0)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 1)).isEqualTo(2);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 3)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT2, 5)).isEqualTo(0);
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.stringMatcher("")).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.stringMatcher((String)null)).isSameAs((Object)StringMatcherFactory.INSTANCE.noneMatcher());
    }

    @Test
    public void testStringMatcher_String_fromChars() {
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'b', 'c'}));
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher(new char[]{'b', 'c'}));
    }

    @Test
    public void testStringMatcher_String_fromString() {
        this.testStringMatcher_String(StringMatcherFactory.INSTANCE.stringMatcher("bc"));
    }

    @Test
    public void testTabMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.tabMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.tabMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4)).isEqualTo(0);
    }

    @Test
    public void testTrimMatcher() {
        StringMatcher matcher = StringMatcherFactory.INSTANCE.trimMatcher();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)matcher.size());
        Assertions.assertThat((Object)StringMatcherFactory.INSTANCE.trimMatcher()).isSameAs((Object)matcher);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6, 0, INPUT1.length)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10, 0, INPUT1.length)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 2)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 3)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 4)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 5)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 6)).isEqualTo(0);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 7)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 8)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 9)).isEqualTo(1);
        Assertions.assertThat((int)matcher.isMatch(INPUT1, 10)).isEqualTo(1);
    }
}

